/*
 * Copyright (c) 2004-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 */


#define ZEROCONF_DISABLED   0
#define ZEROCONF_PROBING    1
#define ZEROCONF_ANNOUNCING 2
#define ZEROCONF_RUNNING    3
#define ZEROCONF_NUM_STATES 4

struct zc_config {
    int zc_fd;

    int zc_state;
    
    time_t zc_timeout;

    int zc_count;
    
    unsigned char zc_addr[4];

    unsigned char zc_hw_addr[6];
};

int zc_arp_socket(const char* inf);

void zc_handle_input(struct zc_config* zc, time_t now);

void zc_handle_timer(struct zc_config* zc, time_t now);

void zc_init(struct zc_config* zc, const unsigned char* hw_addr);

void zc_reset(struct zc_config* zc);

void zc_start_probing(struct zc_config* zc, time_t now);

void zc_send_arp_probe(struct zc_config* zc);

void zc_send_arp_announce(struct zc_config* zc);
