/*
 * Copyright (c) 2011-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 */


#define DBG_SYSLOG

#ifdef DBG_SYSLOG

#include <syslog.h>

#define LOG_SONOS_STDOUT        0x8000

#ifdef __cplusplus
extern "C" {
#endif

void setmaxlogsize(int size);

void __syslog_chk(int level, int flag, const char *format, ...)
    __attribute__ ((__format__ (__printf__, 3, 4)));

#ifdef __cplusplus
}
#endif

#else

#define openlog(...)
#define closelog(...)
#define setlogmask(...)
#define setmaxlogsize(...)
#define syslog(...)
#define vsyslog(...)

#endif
