/*
 * Copyright (c) 2019-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 */

#include <sys/time.h>
#include <linux/version.h>
#include "sonos_time.h"


#if !defined(SONOS_ARCH_ATTR_LACKS_NTP_DAEMON) && !defined(SONOS_ARCH_ATTR_IS_CONTROLLER)


void sonosClockGetTime(clockid_t clk_id, struct timeval* tv)
{
    clock_gettime(clk_id, (struct timespec *)tv);
    tv->tv_usec = tv->tv_usec / 1000;
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 39)
void sonosGetBootTimeval(struct timeval* tv) { sonosClockGetTime(CLOCK_BOOTTIME, tv);  }
#else
void sonosGetBootTimeval(struct timeval* tv) { sonosClockGetTime(CLOCK_MONOTONIC, tv); }
#endif

time_t sonosGetBootTime()
{
    struct timeval tv;
    sonosGetBootTimeval(&tv);
    return tv.tv_sec;
}

#else


void sonosGetBootTimeval(struct timeval* tv) { (void) gettimeofday(tv, NULL); }
time_t sonosGetBootTime() { return time(NULL); }

#endif
