/*
 * sound/soc/amlogic/auge/pdm_hw_coeff.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

/* LPF coefficent
 * For filter 1 and filter 3, it's only relative with coefficent mode
 * For filter 2, it's only relative with osr and hcic stage number
 */

static const int lpf2_osr64[]  = {
	0x00050a, 0xfff004, 0x0002c1, 0x003c12, 0xffa818,
	0xffc87d, 0x010aef, 0xff5223, 0xfebd93, 0x028f41,
	0xff5c0e, 0xfc63f8, 0x055f81, 0x000000, 0xf478a0,
	0x11c5e3, 0x2ea74d, 0x11c5e3, 0xf478a0, 0x000000,
	0x055f81, 0xfc63f8, 0xff5c0e, 0x028f41, 0xfebd93,
	0xff5223, 0x010aef, 0xffc87d, 0xffa818, 0x003c12,
	0x0002c1, 0xfff004, 0x00050a,
};

static const int lpf2_osr96[]  = {
	0x00050a, 0xfff004, 0x0002c1, 0x003c12, 0xffa818,
	0xffc87d, 0x010aef, 0xff5223, 0xfebd93, 0x028f41,
	0xff5c0e, 0xfc63f8, 0x055f81, 0x000000, 0xf478a0,
	0x11c5e3, 0x2ea74d, 0x11c5e3, 0xf478a0, 0x000000,
	0x055f81, 0xfc63f8, 0xff5c0e, 0x028f41, 0xfebd93,
	0xff5223, 0x010aef, 0xffc87d, 0xffa818, 0x003c12,
	0x0002c1, 0xfff004, 0x00050a
};

static const int lpf2_osr128[]  = {
	0x00050b, 0xfff002, 0x0002c6, 0x003c15, 0xffa7fc,
	0xffc899, 0x010b29, 0xff518f, 0xfebd98, 0x02909c,
	0xff5ab8, 0xfc6254, 0x0563b2, 0x000000, 0xf46f16,
	0x11c6a2, 0x2eb45a, 0x11c6a2, 0xf46f16, 0x000000,
	0x0563b2, 0xfc6254, 0xff5ab8, 0x02909c, 0xfebd98,
	0xff518f, 0x010b29, 0xffc899, 0xffa7fc, 0x003c15,
	0x0002c6, 0xfff002, 0x00050b
};

static const int lpf2_osr192[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f7,
	0xffc89f, 0x010b35, 0xff516f, 0xfebd9a, 0x0290e8,
	0xff5a6d, 0xfc61f8, 0x05649b, 0x000000, 0xf46d02,
	0x11c6cc, 0x2eb731, 0x11c6cc, 0xf46d02, 0x000000,
	0x05649b, 0xfc61f8, 0xff5a6d, 0x0290e8, 0xfebd9a,
	0xff516f, 0x010b35, 0xffc89f, 0xffa7f7, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf2_osr256[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f6,
	0xffc8a0, 0x010b37, 0xff516a, 0xfebd9a, 0x0290f4,
	0xff5a62, 0xfc61ea, 0x0564bf, 0x000000, 0xf46cb0,
	0x11c6d2, 0x2eb7a1, 0x11c6d2, 0xf46cb0, 0x000000,
	0x0564bf, 0xfc61ea, 0xff5a62, 0x0290f4, 0xfebd9a,
	0xff516a, 0x010b37, 0xffc8a0, 0xffa7f6, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf2_osr384[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f6,
	0xffc8a0, 0x010b37, 0xff516a, 0xfebd9a, 0x0290f4,
	0xff5a62, 0xfc61ea, 0x0564bf, 0x000000, 0xf46cb0,
	0x11c6d2, 0x2eb7a1, 0x11c6d2, 0xf46cb0, 0x000000,
	0x0564bf, 0xfc61ea, 0xff5a62, 0x0290f4, 0xfebd9a,
	0xff516a, 0x010b37, 0xffc8a0, 0xffa7f6, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf1_mode0[] = {
	0x000006, 0x000002, 0xffffeb, 0xffffbe, 0xffff8a,
	0xffff76, 0xffffb4, 0x00006b, 0x000187, 0x0002a7,
	0x00031d, 0x00022c, 0xffff6b, 0xfffb35, 0xfff6e7,
	0xfff4aa, 0xfff6b8, 0xfffe3f, 0x000a43, 0x00172a,
	0x001f54, 0x001cfd, 0x000ce4, 0xfff0d0, 0xffd098,
	0xffb8cd, 0xffb6b8, 0xffd2b1, 0x000adb, 0x0050ad,
	0x008b46, 0x009ee9, 0x0077e0, 0x001506, 0xff8d7a,
	0xff0dc4, 0xfecb6c, 0xfef1b8, 0xff8da0, 0x0080db,
	0x0182b7, 0x0231a8, 0x023283, 0x0154bd, 0xffaf64,
	0xfdab1a, 0xfbf20a, 0xfb46e9, 0xfc4cb4, 0xff4f72,
	0x041fa5, 0x0a0e12, 0x100c37, 0x14eab3, 0x17a4fe,
	0x17a4fe, 0x14eab3, 0x100c37, 0x0a0e12, 0x041fa5,
	0xff4f72, 0xfc4cb4, 0xfb46e9, 0xfbf20a, 0xfdab1a,
	0xffaf64, 0x0154bd, 0x023283, 0x0231a8, 0x0182b7,
	0x0080db, 0xff8da0, 0xfef1b8, 0xfecb6c, 0xff0dc4,
	0xff8d7a, 0x001506, 0x0077e0, 0x009ee9, 0x008b46,
	0x0050ad, 0x000adb, 0xffd2b1, 0xffb6b8, 0xffb8cd,
	0xffd098, 0xfff0d0, 0x000ce4, 0x001cfd, 0x001f54,
	0x00172a, 0x000a43, 0xfffe3f, 0xfff6b8, 0xfff4aa,
	0xfff6e7, 0xfffb35, 0xffff6b, 0x00022c, 0x00031d,
	0x0002a7, 0x000187, 0x00006b, 0xffffb4, 0xffff76,
	0xffff8a, 0xffffbe, 0xffffeb, 0x000002, 0x000006,
};

static const int lpf3_mode0[] = {
	0x000007, 0x000000, 0xffffe8, 0x000000, 0x000038,
	0x000000, 0xffff94, 0x000000, 0x0000c0, 0x000000,
	0xfffec1, 0x000000, 0x0001f7, 0x000000, 0xfffd05,
	0x000000, 0x000460, 0x000000, 0xfff9c1, 0x000000,
	0x0008b7, 0x000000, 0xfff416, 0x000000, 0x000fff,
	0x000000, 0xffeadc, 0x000000, 0x001b8a, 0x000000,
	0xffdc97, 0x000000, 0x002d01, 0x000000, 0xffc767,
	0x000000, 0x00467f, 0x000000, 0xffa8f1, 0x000000,
	0x006ab0, 0x000000, 0xff7e26, 0x000000, 0x009d20,
	0x000000, 0xff42ce, 0x000000, 0x00e2f1, 0x000000,
	0xfef07e, 0x000000, 0x014470, 0x000000, 0xfe7c1b,
	0x000000, 0x01d10f, 0x000000, 0xfdcf39, 0x000000,
	0x02aaeb, 0x000000, 0xfcb2e7, 0x000000, 0x04311d,
	0x000000, 0xfa719c, 0x000000, 0x07f53f, 0x000000,
	0xf288b5, 0x000000, 0x28b482, 0x3fffff, 0x28b482,
	0x000000, 0xf288b5, 0x000000, 0x07f53f, 0x000000,
	0xfa719c, 0x000000, 0x04311d, 0x000000, 0xfcb2e7,
	0x000000, 0x02aaeb, 0x000000, 0xfdcf39, 0x000000,
	0x01d10f, 0x000000, 0xfe7c1b, 0x000000, 0x014470,
	0x000000, 0xfef07e, 0x000000, 0x00e2f1, 0x000000,
	0xff42ce, 0x000000, 0x009d20, 0x000000, 0xff7e26,
	0x000000, 0x006ab0, 0x000000, 0xffa8f1, 0x000000,
	0x00467f, 0x000000, 0xffc767, 0x000000, 0x002d01,
	0x000000, 0xffdc97, 0x000000, 0x001b8a, 0x000000,
	0xffeadc, 0x000000, 0x000fff, 0x000000, 0xfff416,
	0x000000, 0x0008b7, 0x000000, 0xfff9c1, 0x000000,
	0x000460, 0x000000, 0xfffd05, 0x000000, 0x0001f7,
	0x000000, 0xfffec1, 0x000000, 0x0000c0, 0x000000,
	0xffff94, 0x000000, 0x000038, 0x000000, 0xffffe8,
	0x000000, 0x000007
};

static const int lpf1_mode1[] = {
	0x000014, 0xffffb2, 0xfffed9, 0xfffdce, 0xfffd45,
	0xfffe32, 0x000147, 0x000645, 0x000b86, 0x000e21,
	0x000ae3, 0x000000, 0xffeece, 0xffdca8, 0xffd212,
	0xffd7d1, 0xfff2a7, 0x001f4c, 0x0050c2, 0x0072aa,
	0x006ff1, 0x003c32, 0xffdc4e, 0xff6a18, 0xff0fef,
	0xfefbaf, 0xff4c40, 0x000000, 0x00ebc8, 0x01c077,
	0x02209e, 0x01c1a4, 0x008e60, 0xfebe52, 0xfcd690,
	0xfb8fa5, 0xfba498, 0xfd9812, 0x0181ce, 0x06f5f3,
	0x0d112f, 0x12a958, 0x169686, 0x18000e, 0x169686,
	0x12a958, 0x0d112f, 0x06f5f3, 0x0181ce, 0xfd9812,
	0xfba498, 0xfb8fa5, 0xfcd690, 0xfebe52, 0x008e60,
	0x01c1a4, 0x02209e, 0x01c077, 0x00ebc8, 0x000000,
	0xff4c40, 0xfefbaf, 0xff0fef, 0xff6a18, 0xffdc4e,
	0x003c32, 0x006ff1, 0x0072aa, 0x0050c2, 0x001f4c,
	0xfff2a7, 0xffd7d1, 0xffd212, 0xffdca8, 0xffeece,
	0x000000, 0x000ae3, 0x000e21, 0x000b86, 0x000645,
	0x000147, 0xfffe32, 0xfffd45, 0xfffdce, 0xfffed9,
	0xffffb2, 0x000014,
};

static const int lpf3_mode1[] = {
	0x000000, 0x000081, 0x000000, 0xfffedb, 0x000000,
	0x00022d, 0x000000, 0xfffc46, 0x000000, 0x0005f7,
	0x000000, 0xfff6eb, 0x000000, 0x000d4e, 0x000000,
	0xffed1e, 0x000000, 0x001a1c, 0x000000, 0xffdcb0,
	0x000000, 0x002ede, 0x000000, 0xffc2d1, 0x000000,
	0x004ebe, 0x000000, 0xff9beb, 0x000000, 0x007dd7,
	0x000000, 0xff633a, 0x000000, 0x00c1d2, 0x000000,
	0xff11d5, 0x000000, 0x012368, 0x000000, 0xfe9c45,
	0x000000, 0x01b252, 0x000000, 0xfdebf6, 0x000000,
	0x0290b8, 0x000000, 0xfcca0d, 0x000000, 0x041d7c,
	0x000000, 0xfa8152, 0x000000, 0x07e9c6, 0x000000,
	0xf28fb5, 0x000000, 0x28b216, 0x3fffde, 0x28b216,
	0x000000, 0xf28fb5, 0x000000, 0x07e9c6, 0x000000,
	0xfa8152, 0x000000, 0x041d7c, 0x000000, 0xfcca0d,
	0x000000, 0x0290b8, 0x000000, 0xfdebf6, 0x000000,
	0x01b252, 0x000000, 0xfe9c45, 0x000000, 0x012368,
	0x000000, 0xff11d5, 0x000000, 0x00c1d2, 0x000000,
	0xff633a, 0x000000, 0x007dd7, 0x000000, 0xff9beb,
	0x000000, 0x004ebe, 0x000000, 0xffc2d1, 0x000000,
	0x002ede, 0x000000, 0xffdcb0, 0x000000, 0x001a1c,
	0x000000, 0xffed1e, 0x000000, 0x000d4e, 0x000000,
	0xfff6eb, 0x000000, 0x0005f7, 0x000000, 0xfffc46,
	0x000000, 0x00022d, 0x000000, 0xfffedb, 0x000000,
	0x000081, 0x000000,
};

static const int lpf1_mode2[] = {
	0x000014, 0xffffb2, 0xfffed9, 0xfffdce, 0xfffd45,
	0xfffe32, 0x000147, 0x000645, 0x000b86, 0x000e21,
	0x000ae3, 0x000000, 0xffeece, 0xffdca8, 0xffd212,
	0xffd7d1, 0xfff2a7, 0x001f4c, 0x0050c2, 0x0072aa,
	0x006ff1, 0x003c32, 0xffdc4e, 0xff6a18, 0xff0fef,
	0xfefbaf, 0xff4c40, 0x000000, 0x00ebc8, 0x01c077,
	0x02209e, 0x01c1a4, 0x008e60, 0xfebe52, 0xfcd690,
	0xfb8fa5, 0xfba498, 0xfd9812, 0x0181ce, 0x06f5f3,
	0x0d112f, 0x12a958, 0x169686, 0x18000e, 0x169686,
	0x12a958, 0x0d112f, 0x06f5f3, 0x0181ce, 0xfd9812,
	0xfba498, 0xfb8fa5, 0xfcd690, 0xfebe52, 0x008e60,
	0x01c1a4, 0x02209e, 0x01c077, 0x00ebc8, 0x000000,
	0xff4c40, 0xfefbaf, 0xff0fef, 0xff6a18, 0xffdc4e,
	0x003c32, 0x006ff1, 0x0072aa, 0x0050c2, 0x001f4c,
	0xfff2a7, 0xffd7d1, 0xffd212, 0xffdca8, 0xffeece,
	0x000000, 0x000ae3, 0x000e21, 0x000b86, 0x000645,
	0x000147, 0xfffe32, 0xfffd45, 0xfffdce, 0xfffed9,
	0xffffb2, 0x000014
};

static const int lpf3_mode2[] = {
	0x00005e, 0xffff19, 0xfffe3e, 0x00030a, 0x0004de,
	0xfff899, 0xfff531, 0x000f4a, 0x001510, 0xffe39e,
	0xffda78, 0x0030d1, 0x003e97, 0xffb0c5, 0xff9cd2,
	0x007aec, 0x009706, 0xff47dd, 0xff20f2, 0x010cbd,
	0x01426b, 0xfe7e4e, 0xfe3340, 0x0226a1, 0x0293d1,
	0xfce4d3, 0xfc382d, 0x04ad05, 0x05ef42, 0xf82315,
	0xf4bde1, 0x130bdd, 0x399128, 0x399128, 0x130bdd,
	0xf4bde1, 0xf82315, 0x05ef42, 0x04ad05, 0xfc382d,
	0xfce4d3, 0x0293d1, 0x0226a1, 0xfe3340, 0xfe7e4e,
	0x01426b, 0x010cbd, 0xff20f2, 0xff47dd, 0x009706,
	0x007aec, 0xff9cd2, 0xffb0c5, 0x003e97, 0x0030d1,
	0xffda78, 0xffe39e, 0x001510, 0x000f4a, 0xfff531,
	0xfff899, 0x0004de, 0x00030a, 0xfffe3e, 0xffff19,
	0x00005e
};

static const int lpf1_mode3[] = {
	0x000000, 0xfffc12, 0xfff5cb, 0xfff022, 0xffeffa,
	0xfffa03, 0x000f84, 0x002b96, 0x00429d, 0x00455c,
	0x00277a, 0xffe762, 0xff93e1, 0xff4bc4, 0xff3567,
	0xff6f81, 0x000000, 0x00c850, 0x018619, 0x01e3e3,
	0x01972b, 0x008323, 0xfed332, 0xfd00e8, 0xfbbe66,
	0xfbc791, 0xfda631, 0x017bb2, 0x06e40b, 0x0cfe8e,
	0x129dfd, 0x1693d6, 0x18011b, 0x1693d6, 0x129dfd,
	0x0cfe8e, 0x06e40b, 0x017bb2, 0xfda631, 0xfbc791,
	0xfbbe66, 0xfd00e8, 0xfed332, 0x008323, 0x01972b,
	0x01e3e3, 0x018619, 0x00c850, 0x000000, 0xff6f81,
	0xff3567, 0xff4bc4, 0xff93e1, 0xffe762, 0x00277a,
	0x00455c, 0x00429d, 0x002b96, 0x000f84, 0xfffa03,
	0xffeffa, 0xfff022, 0xfff5cb, 0xfffc12, 0x000000,
};

static const int lpf3_mode3[] = {
	0x000000, 0xfff4f6, 0x000000, 0x001e36, 0x000000,
	0xffbfb6, 0x000000, 0x007789, 0x000000, 0xff3423,
	0x000000, 0x0147cc, 0x000000, 0xfe0523, 0x000000,
	0x02ffbb, 0x000000, 0xfb728b, 0x000000, 0x0732af,
	0x000000, 0xf301d5, 0x000000, 0x288c99, 0x40023d,
	0x288c99, 0x000000, 0xf301d5, 0x000000, 0x0732af,
	0x000000, 0xfb728b, 0x000000, 0x02ffbb, 0x000000,
	0xfe0523, 0x000000, 0x0147cc, 0x000000, 0xff3423,
	0x000000, 0x007789, 0x000000, 0xffbfb6, 0x000000,
	0x001e36, 0x000000, 0xfff4f6, 0x000000
};

static const int lpf1_mode4[] = {
	0xfff71d, 0xffd0ad, 0xffa4b6, 0xff8cdb, 0xffa5d4,
	0x000000, 0x009021, 0x012899, 0x0181ac, 0x0151f3,
	0x0070b6, 0xfef591, 0xfd46bc, 0xfc0b63, 0xfc00d4,
	0xfdbd02, 0x017215, 0x06c95c, 0x0ce665, 0x1295f9,
	0x169d63, 0x181214, 0x169d63, 0x1295f9, 0x0ce665,
	0x06c95c, 0x017215, 0xfdbd02, 0xfc00d4, 0xfc0b63,
	0xfd46bc, 0xfef591, 0x0070b6, 0x0151f3, 0x0181ac,
	0x012899, 0x009021, 0x000000, 0xffa5d4, 0xff8cdb,
	0xffa4b6, 0xffd0ad, 0xfff71d
};

static const int lpf3_mode4[] = {
	0xffd46b, 0xffb7a1, 0x006ded, 0x009ddb, 0xff25e9,
	0xfedaef, 0x018208, 0x01f591, 0xfd7972, 0xfcbff4,
	0x043527, 0x058a27, 0xf872cb, 0xf4f5a2, 0x12ef7c,
	0x399f1f, 0x399f1f, 0x12ef7c, 0xf4f5a2, 0xf872cb,
	0x058a27, 0x043527, 0xfcbff4, 0xfd7972, 0x01f591,
	0x018208, 0xfedaef, 0xff25e9, 0x009ddb, 0x006ded,
	0xffb7a1, 0xffd46b
};
