/*
 * Copyright (c) 2014-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/slab.h>
#include <crypto/sonos_signature_common_linux.h>
#include <crypto/sonos_signature_verify_linux.h>
#include <linux/sonos_mdp_global.h>
#include <linux/sonos_sec_general.h>

#define SU_BE32_TO_CPU		be32_to_cpu
#define SU_CPU_TO_BE32		cpu_to_be32
#define SU_GET_CPUID		sonos_get_cpuid
#define SU_GET_UNLOCK_COUNTER	sonos_get_unlock_counter
#define SU_PRINT		printk
#define SU_PLVL_DEBUG		KERN_DEBUG
#define SU_PLVL_INFO		KERN_INFO
#define SU_PLVL_ERR		KERN_ERR

#include "sonos_unlock_token.c.inc"
#include "sonos_unlock.c.inc"

EXPORT_SYMBOL(sonosUnlockVerifyCpuSerialSig);
EXPORT_SYMBOL(sonosUnlockIsDeviceUnlocked);
EXPORT_SYMBOL(sonosUnlockIsAuthFeatureEnabled);

int is_mdp_authorized(u32 mdp_authorization_flag)
{
	int result = 0;
	SonosSignature *sig = NULL;

	sig = kmalloc(sizeof(*sig), GFP_KERNEL);

	result = sig &&
		 sonosUnlockIsAuthFeatureEnabled(mdp_authorization_flag,
						 &sys_mdp,
						 &sys_mdp3,
						 sig,
						 sonosHash,
						 sonosRawVerify,
						 sonosKeyLookup,
						 "unit",
						 "unlock",
						 NULL);

	kfree(sig);
	return result;
}
EXPORT_SYMBOL(is_mdp_authorized);

static int sysrq_authorization = 0;
int is_sysrq_authorized(void)
{
	return sysrq_authorization;
}
EXPORT_SYMBOL(is_sysrq_authorized);

void check_sysrq_authorization(void)
{
	sysrq_authorization = is_mdp_authorized(MDP_AUTH_FLAG_KERNEL_DEBUG_ENABLE);
}
EXPORT_SYMBOL(check_sysrq_authorization);

