/*
 * Copyright (c) 2018-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef SONOS_SEC_FS_KEYS_H
#define SONOS_SEC_FS_KEYS_H

#include <linux/types.h>

#if defined(CONFIG_DM_CRYPT)
extern bool sonos_replace_luks_key_if_sentinel(char *hexKey);
#endif

#if defined(CONFIG_UBIFS_FS)
#define UBIFS_CRYPT_TYPE_NONE		0
#define UBIFS_CRYPT_TYPE_FIXED		4
#define UBIFS_CRYPT_TYPE_RED_KEY	6

#define UBIFS_CRYPTO_KEYSIZE		16
#define UBIFS_CRYPTO_ALGORITHM		"ctr(aes)"

extern void sonos_set_proc_crypt(int);
extern void ubifs_set_ubifs_key(const u8 *);
extern bool sonos_set_ubifs_key(u32 type);
#endif

#endif
