/*
 * include/dt-bindings/clock/gxl-clkc.h
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#ifndef __GX_CLKC_H
#define __GX_CLKC_H

/*
 * CLKID index values
 */

#define CLKID_SYS_PLL       0
#define CLKID_CPUCLK        1
#define CLKID_HDMI_PLL      2
#define CLKID_FIXED_PLL		  3
#define CLKID_FCLK_DIV2     4
#define CLKID_FCLK_DIV3     5
#define CLKID_FCLK_DIV4     6
#define CLKID_FCLK_DIV5		  7
#define CLKID_FCLK_DIV7		  8
#define CLKID_GP0_PLL       9
#define CLKID_MPEG_SEL		  10
#define CLKID_MPEG_DIV		  11
#define CLKID_CLK81         12
#define CLKID_MPLL0		  13
#define CLKID_MPLL1		  14
#define CLKID_MPLL2     15
#define CLKID_MPLL3		  16
#define CLKID_CPU_FCLK_P00	17
#define CLKID_CPU_FCLK_P01	18
#define CLKID_CPU_FCLK_P0	19
#define CLKID_CPU_FCLK_P10	20
#define CLKID_CPU_FCLK_P11	21
#define CLKID_CPU_FCLK_P1	22
#define CLKID_CPU_FCLK_P	23
#define CLKID_CPU_CLK		24
/*HHI_GCLK_MPEG0: 0x50*/
#define GATE_BASE0    25
#define CLKID_DDR    (GATE_BASE0 + 0)
#define CLKID_DOS		  (GATE_BASE0 + 1)
#define CLKID_ISA		  (GATE_BASE0 + 2)
#define CLKID_PL301		  (GATE_BASE0 + 3)
#define CLKID_PERIPHS		 (GATE_BASE0 + 4)
#define CLKID_SPICC		  (GATE_BASE0 + 5)
#define CLKID_I2C         (GATE_BASE0 + 6)
#define CLKID_SANA		  (GATE_BASE0 + 7)
#define CLKID_SMART_CARD	  (GATE_BASE0 + 8)
#define CLKID_RNG0		  (GATE_BASE0 + 9)
#define CLKID_UART0		  (GATE_BASE0 + 10)
#define CLKID_SDHC		  (GATE_BASE0 + 11)
#define CLKID_STREAM		  (GATE_BASE0 + 12)
#define CLKID_ASYNC_FIFO	  (GATE_BASE0 + 13)
#define CLKID_SDIO		  (GATE_BASE0 + 14)
#define CLKID_ABUF		  (GATE_BASE0 + 15)
#define CLKID_HIU_IFACE		  (GATE_BASE0 + 16)
#define CLKID_BT656	(GATE_BASE0 + 17)
#define CLKID_ASSIST_MISC	  (GATE_BASE0 + 18)
#define CLKID_SD_EMMC_A	(GATE_BASE0 + 19)
#define CLKID_SD_EMMC_B	(GATE_BASE0 + 20)
#define CLKID_SD_EMMC_C	(GATE_BASE0 + 21)
#define CLKID_DMA	(GATE_BASE0 + 22)
#define CLKID_ACODEC	(GATE_BASE0 + 23)
#define CLKID_SPI (GATE_BASE0 + 24)
/*HHI_GCLK_MPEG1: 0x51*/
#define GATE_BASE1    (GATE_BASE0 + 25) /*25+25*/
#define CLKID_PCLK_TVFE	(GATE_BASE1 + 0)
#define CLKID_I2S_SPDIF		  (GATE_BASE1 + 1)
#define CLKID_ETH		  (GATE_BASE1 + 2)
#define CLKID_DEMUX		  (GATE_BASE1 + 3)
#define CLKID_AIU_GLUE		  (GATE_BASE1 + 4)
#define CLKID_IEC958		  (GATE_BASE1 + 5)
#define CLKID_I2S_OUT		  (GATE_BASE1 + 6)
#define CLKID_AMCLK		  (GATE_BASE1 + 7)
#define CLKID_AIFIFO2		  (GATE_BASE1 + 8)
#define CLKID_MIXER		  (GATE_BASE1 + 9)
#define CLKID_MIXER_IFACE	  (GATE_BASE1 + 10)
#define CLKID_ADC		  (GATE_BASE1 + 11)
#define CLKID_BLKMV		  (GATE_BASE1 + 12)
#define CLKID_AIU_TOP		  (GATE_BASE1 + 13)
#define CLKID_UART1		  (GATE_BASE1 + 14)
#define CLKID_G2D		  (GATE_BASE1 + 15)
#define CLKID_USB0    (GATE_BASE1 + 16)
#define CLKID_USB1    (GATE_BASE1 + 17)
#define CLKID_RESET		  (GATE_BASE1 + 18)
#define CLKID_NAND		  (GATE_BASE1 + 19)
#define CLKID_DOS_PARSER	  (GATE_BASE1 + 20)
#define CLKID_USB_GENERAL      (GATE_BASE1 + 21)
#define CLKID_VDIN1		  (GATE_BASE1 + 22)
#define CLKID_AHB_ARB0		  (GATE_BASE1 + 23)
#define CLKID_EFUSE		  (GATE_BASE1 + 24)
#define CLKID_BOOT_ROM		  (GATE_BASE1 + 25)
/*HHI_GCLK_MPEG2: 0x52*/
#define GATE_BASE2    (GATE_BASE1 + 26)  /*25+25+26*/
#define CLKID_AHB_DATA_BUS	  (GATE_BASE2 + 0)
#define CLKID_AHB_CTRL_BUS	  (GATE_BASE2 + 1)
#define CLKID_HDCP22_PCLK	  (GATE_BASE2 + 2)
#define CLKID_HDMITX_PCLK		  (GATE_BASE2 + 3)
#define CLKID_PDM_PCLK		  (GATE_BASE2 + 4)
#define CLKID_BT656_PCLK1		  (GATE_BASE2 + 5)
#define CLKID_USB1_TO_DDR (GATE_BASE2 + 6)
#define CLKID_USB0_TO_DDR (GATE_BASE2 + 7)
#define CLKID_AIU_PCLK		  (GATE_BASE2 + 8)
#define CLKID_MMC_PCLK		  (GATE_BASE2 + 9)
#define CLKID_DVIN		  (GATE_BASE2 + 10)
#define CLKID_UART2		  (GATE_BASE2 + 11)
#define CLKID_SARADC		  (GATE_BASE2 + 12)
#define CLKID_VPU_INTR		  (GATE_BASE2 + 13)
#define CLKID_SEC_AHB_AHB3_BRIDGE (GATE_BASE2 + 14)
#define CLKID_APB3_AO		  (GATE_BASE2 + 15)
#define CLKID_MCLK_TVFE		  (GATE_BASE2 + 16)
#define CLKID_CLK81_GIC		  (GATE_BASE2 + 17)

/*HHI_GCLK_OTHER: 0x54*/
#define GATE_BASE3    (GATE_BASE2 + 18) /*25+25+26+18*/
#define CLKID_VCLK2_VENCI0	  (GATE_BASE3 + 0)
#define CLKID_VCLK2_VENCI1	  (GATE_BASE3 + 1)
#define CLKID_VCLK2_VENCP0	  (GATE_BASE3 + 2)
#define CLKID_VCLK2_VENCP1	  (GATE_BASE3 + 3)
#define CLKID_VCLK2_VENCT0	  (GATE_BASE3 + 4)
#define CLKID_VCLK2_VENCT1	  (GATE_BASE3 + 5)
#define CLKID_VCLK2_OTHER	  (GATE_BASE3 + 6)
#define CLKID_VCLK2_ENCI	  (GATE_BASE3 + 7)
#define CLKID_VCLK2_ENCP	  (GATE_BASE3 + 8)
#define CLKID_DAC_CLK		  (GATE_BASE3 + 9)
#define CLKID_AOCLK_GATE	  (GATE_BASE3 + 10)
#define CLKID_IEC958_GATE	  (GATE_BASE3 + 11)
#define CLKID_ENC480P		  (GATE_BASE3 + 12)
#define CLKID_RNG1		  (GATE_BASE3 + 13)
#define CLKID_VCLK2_ENCT	  (GATE_BASE3 + 14)
#define CLKID_VCLK2_ENCL	  (GATE_BASE3 + 15)
#define CLKID_VCLK2_VENCLMMC	  (GATE_BASE3 + 16)
#define CLKID_VCLK2_VENCL	  (GATE_BASE3 + 17)
#define CLKID_VCLK2_OTHER1	  (GATE_BASE3 + 18)
#define CLKID_EDP		  (GATE_BASE3 + 19)

#define AO_BASE (GATE_BASE3 + 20) /*25+25+26+18+20*/
#define CLKID_AO_MEDIA_CPU	  (AO_BASE + 0)
#define CLKID_AO_AHB_SRAM	  (AO_BASE + 1)
#define CLKID_AO_AHB_BUS	  (AO_BASE + 2)
#define CLKID_AO_IFACE		  (AO_BASE + 3)
#define CLKID_AO_I2C	(AO_BASE + 4)

#define OTHER_BASE (AO_BASE + 5) /*25+25+26+18+20+5=119*/
#define CLKID_SD_EMMC_A_P0_MUX (OTHER_BASE + 0)
#define CLKID_SD_EMMC_A_P0_DIV (OTHER_BASE + 1)
#define CLKID_SD_EMMC_A_P0_GATE (OTHER_BASE + 2)
#define CLKID_SD_EMMC_A_P0_COMP (OTHER_BASE + 3)
#define CLKID_SD_EMMC_B_P0_MUX (OTHER_BASE + 4)
#define CLKID_SD_EMMC_B_P0_DIV (OTHER_BASE + 5)
#define CLKID_SD_EMMC_B_P0_GATE (OTHER_BASE + 6)
#define CLKID_SD_EMMC_B_P0_COMP (OTHER_BASE + 7)
#define CLKID_SD_EMMC_C_P0_MUX (OTHER_BASE + 8)
#define CLKID_SD_EMMC_C_P0_DIV (OTHER_BASE + 9)
#define CLKID_SD_EMMC_C_P0_GATE (OTHER_BASE + 10)
#define CLKID_SD_EMMC_C_P0_COMP (OTHER_BASE + 11)
#define CLKID_SD_EMMC_A_MUX	 (OTHER_BASE + 12)
#define CLKID_SD_EMMC_A_DIV	 (OTHER_BASE + 13)
#define CLKID_SD_EMMC_A_GATE	 (OTHER_BASE + 14)
#define CLKID_SD_EMMC_A_COMP  (OTHER_BASE + 15)
#define CLKID_SD_EMMC_B_MUX	 (OTHER_BASE + 16)
#define CLKID_SD_EMMC_B_DIV	 (OTHER_BASE + 17)
#define CLKID_SD_EMMC_B_GATE	 (OTHER_BASE + 18)
#define CLKID_SD_EMMC_B_COMP  (OTHER_BASE + 19)
#define CLKID_SD_EMMC_C_MUX	 (OTHER_BASE + 20)
#define CLKID_SD_EMMC_C_DIV	 (OTHER_BASE + 21)
#define CLKID_SD_EMMC_C_GATE	 (OTHER_BASE + 22)
#define CLKID_SD_EMMC_C_COMP  (OTHER_BASE + 23)

#define CLKID_GPU_BASE (OTHER_BASE + 24) /*25+25+26+18+20+5+24*/
#define CLKID_GPU_P0_MUX (CLKID_GPU_BASE + 0)
#define CLKID_GPU_P0_DIV (CLKID_GPU_BASE + 1)
#define CLKID_GPU_P0_GATE (CLKID_GPU_BASE + 2)
#define CLKID_GPU_P0_COMP (CLKID_GPU_BASE + 3)
#define CLKID_GPU_P1_MUX (CLKID_GPU_BASE + 4)
#define CLKID_GPU_P1_DIV (CLKID_GPU_BASE + 5)
#define CLKID_GPU_P1_GATE (CLKID_GPU_BASE + 6)
#define CLKID_GPU_P1_COMP (CLKID_GPU_BASE + 7)
#define CLKID_GPU_MUX (CLKID_GPU_BASE + 8)

#define CLKID_MEDIA_BASE (CLKID_GPU_BASE + 9) /*25+25+26+18+20+5+24+9*/
#define CLKID_VDEC_P0_MUX (CLKID_MEDIA_BASE + 0)
#define CLKID_VDEC_P0_DIV (CLKID_MEDIA_BASE + 1)
#define CLKID_VDEC_P0_GATE (CLKID_MEDIA_BASE + 2)
#define CLKID_VDEC_P0_COMP (CLKID_MEDIA_BASE + 3)
#define CLKID_VDEC_P1_MUX (CLKID_MEDIA_BASE + 4)
#define CLKID_VDEC_P1_DIV (CLKID_MEDIA_BASE + 5)
#define CLKID_VDEC_P1_GATE (CLKID_MEDIA_BASE + 6)
#define CLKID_VDEC_P1_COMP (CLKID_MEDIA_BASE + 7)
#define CLKID_VDEC_MUX (CLKID_MEDIA_BASE + 8)
#define CLKID_HCODEC_P0_MUX (CLKID_MEDIA_BASE + 9)
#define CLKID_HCODEC_P0_DIV (CLKID_MEDIA_BASE + 10)
#define CLKID_HCODEC_P0_GATE (CLKID_MEDIA_BASE + 11)
#define CLKID_HCODEC_P0_COMP (CLKID_MEDIA_BASE + 12)
#define CLKID_HCODEC_P1_MUX (CLKID_MEDIA_BASE + 13)
#define CLKID_HCODEC_P1_DIV (CLKID_MEDIA_BASE + 14)
#define CLKID_HCODEC_P1_GATE (CLKID_MEDIA_BASE + 15)
#define CLKID_HCODEC_P1_COMP (CLKID_MEDIA_BASE + 16)
#define CLKID_HCODEC_MUX (CLKID_MEDIA_BASE + 17)
#define CLKID_HEVC_P0_MUX (CLKID_MEDIA_BASE + 18)
#define CLKID_HEVC_P0_DIV (CLKID_MEDIA_BASE + 19)
#define CLKID_HEVC_P0_GATE (CLKID_MEDIA_BASE + 20)
#define CLKID_HEVC_P0_COMP (CLKID_MEDIA_BASE + 21)
#define CLKID_HEVC_P1_MUX (CLKID_MEDIA_BASE + 22)
#define CLKID_HEVC_P1_DIV (CLKID_MEDIA_BASE + 23)
#define CLKID_HEVC_P1_GATE (CLKID_MEDIA_BASE + 24)
#define CLKID_HEVC_P1_COMP (CLKID_MEDIA_BASE + 25)
#define CLKID_HEVC_MUX (CLKID_MEDIA_BASE + 26)
#define CLKID_VPU_P0_MUX (CLKID_MEDIA_BASE + 27)
#define CLKID_VPU_P0_DIV (CLKID_MEDIA_BASE + 28)
#define CLKID_VPU_P0_GATE (CLKID_MEDIA_BASE + 29)
#define CLKID_VPU_P0_COMP (CLKID_MEDIA_BASE + 30)
#define CLKID_VPU_P1_MUX (CLKID_MEDIA_BASE + 31)
#define CLKID_VPU_P1_DIV (CLKID_MEDIA_BASE + 32)
#define CLKID_VPU_P1_GATE (CLKID_MEDIA_BASE + 33)
#define CLKID_VPU_P1_COMP (CLKID_MEDIA_BASE + 34)
#define CLKID_VPU_MUX (CLKID_MEDIA_BASE + 35)
#define CLKID_VAPB_P0_MUX (CLKID_MEDIA_BASE + 36)
#define CLKID_VAPB_P0_DIV (CLKID_MEDIA_BASE + 37)
#define CLKID_VAPB_P0_GATE (CLKID_MEDIA_BASE + 38)
#define CLKID_VAPB_P0_COMP (CLKID_MEDIA_BASE + 39)
#define CLKID_VAPB_P1_MUX (CLKID_MEDIA_BASE + 40)
#define CLKID_VAPB_P1_DIV (CLKID_MEDIA_BASE + 41)
#define CLKID_VAPB_P1_GATE (CLKID_MEDIA_BASE + 42)
#define CLKID_VAPB_P1_COMP (CLKID_MEDIA_BASE + 43)
#define CLKID_VAPB_MUX (CLKID_MEDIA_BASE + 44)
#define CLKID_GE2D_GATE (CLKID_MEDIA_BASE + 45)
#define CLKID_BT656_CLK1_MUX (CLKID_MEDIA_BASE + 46)
#define CLKID_BT656_CLK1_DIV (CLKID_MEDIA_BASE + 47)
#define CLKID_BT656_CLK1_GATE (CLKID_MEDIA_BASE + 48)
#define CLKID_BT656_CLK1_COMP (CLKID_MEDIA_BASE + 49)

#define CLKID_MISC_BASE (CLKID_MEDIA_BASE + 50) /*25+25+26+18+20+5+24+9+50*/
#define CLKID_VDIN_MEAS_MUX (CLKID_MISC_BASE + 0)
#define CLKID_VDIN_MEAS_DIV (CLKID_MISC_BASE + 1)
#define CLKID_VDIN_MEAS_GATE (CLKID_MISC_BASE + 2)
#define CLKID_VDIN_MEAS_COMP (CLKID_MISC_BASE + 3)
#define CLKID_AMCLK_MUX (CLKID_MISC_BASE + 4)
#define CLKID_AMCLK_DIV (CLKID_MISC_BASE + 5)
#define CLKID_AMCLK_GATE (CLKID_MISC_BASE + 6)
#define CLKID_AMCLK_COMP (CLKID_MISC_BASE + 7)
#define CLKID_PDM_MUX (CLKID_MISC_BASE + 8)
#define CLKID_PDM_DIV (CLKID_MISC_BASE + 9)
#define CLKID_PDM_GATE (CLKID_MISC_BASE + 10)
#define CLKID_PDM_COMP (CLKID_MISC_BASE + 11)
#define CLKID_I958_MUX (CLKID_MISC_BASE + 12)
#define CLKID_I958_DIV (CLKID_MISC_BASE + 13)
#define CLKID_I958_GATE (CLKID_MISC_BASE + 14)
#define CLKID_I958_COMP (CLKID_MISC_BASE + 15)
#define CLKID_PCM_MCLK_MUX (CLKID_MISC_BASE + 16)
#define CLKID_PCM_MCLK_DIV (CLKID_MISC_BASE + 17)
#define CLKID_PCM_MCLK_GATE (CLKID_MISC_BASE + 18)
#define CLKID_PCM_MCLK_COMP (CLKID_MISC_BASE + 19)
#define CLKID_PCM_SCLK_DIV (CLKID_MISC_BASE + 20)
#define CLKID_PCM_SCLK_GATE (CLKID_MISC_BASE + 21)
#define CLKID_I958_COMP_SPDIF (CLKID_MISC_BASE + 22)
#define CLKID_SARADC_MUX (CLKID_MISC_BASE + 23)
#define CLKID_SARADC_DIV (CLKID_MISC_BASE + 24)
#define CLKID_SARADC_GATE (CLKID_MISC_BASE + 25)
#define CLKID_SARADC_COMP (CLKID_MISC_BASE + 26)

#define NR_CLKS				(CLKID_SARADC_COMP + 1)

#endif /* __GX_CLKC_H */
