/*
 * Copyright (C) 2017 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#ifndef __PINCTRL_MTK_MT8518_H
#define __PINCTRL_MTK_MT8518_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_desc_pin mtk_pins_mt8518[] = {
	MTK_PIN(
		PINCTRL_PIN(0, "NFI_NCEB0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "NCEB0"),
		MTK_FUNCTION(7, "DBG_MON_B_4")
	),
	MTK_PIN(
		PINCTRL_PIN(1, "NFI_NREB"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "NREB"),
		MTK_FUNCTION(7, "DBG_MON_B_5")
	),
	MTK_PIN(
		PINCTRL_PIN(2, "NFI_NRNB"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "NRNB"),
		MTK_FUNCTION(2, "MSDC0_DS"),
		MTK_FUNCTION(7, "DBG_MON_B_6")
	),
	MTK_PIN(
		PINCTRL_PIN(3, "MSDC0_DAT7"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(2, "NLD7"),
		MTK_FUNCTION(7, "DBG_MON_B_23")
	),
	MTK_PIN(
		PINCTRL_PIN(4, "MSDC0_DAT6"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(2, "NLD6"),
		MTK_FUNCTION(7, "DBG_MON_B_24")
	),
	MTK_PIN(
		PINCTRL_PIN(5, "MSDC0_DAT5"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(2, "NLD4"),
		MTK_FUNCTION(7, "DBG_MON_B_25")
	),
	MTK_PIN(
		PINCTRL_PIN(6, "MSDC0_DAT4"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(2, "NLD3"),
		MTK_FUNCTION(7, "DBG_MON_B_26")
	),
	MTK_PIN(
		PINCTRL_PIN(7, "MSDC0_RSTB"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(2, "NLD0"),
		MTK_FUNCTION(7, "DBG_MON_B_7")
	),
	MTK_PIN(
		PINCTRL_PIN(8, "MSDC0_CMD"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(2, "NALE"),
		MTK_FUNCTION(7, "DBG_MON_B_27")
	),
	MTK_PIN(
		PINCTRL_PIN(9, "MSDC0_CLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(2, "NWEB"),
		MTK_FUNCTION(7, "DBG_MON_B_8")
	),
	MTK_PIN(
		PINCTRL_PIN(10, "MSDC0_DAT3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(2, "NLD1"),
		MTK_FUNCTION(7, "DBG_MON_B_9")
	),
	MTK_PIN(
		PINCTRL_PIN(11, "MSDC0_DAT2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(2, "NLD5"),
		MTK_FUNCTION(7, "DBG_MON_B_10")
	),
	MTK_PIN(
		PINCTRL_PIN(12, "MSDC0_DAT1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 12),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(2, "NCLE"),
		MTK_FUNCTION(7, "DBG_MON_B_11")
	),
	MTK_PIN(
		PINCTRL_PIN(13, "MSDC0_DAT0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 13),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(2, "NLD2"),
		MTK_FUNCTION(7, "DBG_MON_B_12")
	),
	MTK_PIN(
		PINCTRL_PIN(14, "RTC32K_CK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "RTC32K_CK"),
		MTK_FUNCTION(2, "SPLIN_D3")
	),
	MTK_PIN(
		PINCTRL_PIN(15, "WATCHDOG"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN(
		PINCTRL_PIN(16, "SUSPEND"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "SUSPEND")
	),
	MTK_PIN(
		PINCTRL_PIN(17, "JTMS"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "JTMS"),
		MTK_FUNCTION(2, "PCM_SYNC"),
		MTK_FUNCTION(3, "SPI0_CSB"),
		MTK_FUNCTION(6, "DFD_TMS_XI"),
		MTK_FUNCTION(7, "DBG_MON_B_13")
	),
	MTK_PIN(
		PINCTRL_PIN(18, "JTCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "JTCK"),
		MTK_FUNCTION(2, "PCM_CLK"),
		MTK_FUNCTION(3, "SPI0_CLK"),
		MTK_FUNCTION(6, "DFD_TCK_XI"),
		MTK_FUNCTION(7, "DBG_MON_B_14")
	),
	MTK_PIN(
		PINCTRL_PIN(19, "JTDI"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "JTDI"),
		MTK_FUNCTION(2, "PCM_RX"),
		MTK_FUNCTION(3, "SPI0_MI"),
		MTK_FUNCTION(6, "DFD_TDI_XI"),
		MTK_FUNCTION(7, "DBG_MON_B_15")
	),
	MTK_PIN(
		PINCTRL_PIN(20, "JTDO"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "JTDO"),
		MTK_FUNCTION(2, "PCM_TX"),
		MTK_FUNCTION(3, "SPI0_MO"),
		MTK_FUNCTION(6, "DFD_TDO"),
		MTK_FUNCTION(7, "DBG_MON_B_16")
	),
	MTK_PIN(
		PINCTRL_PIN(21, "SDA3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "SDA3_0")
	),
	MTK_PIN(
		PINCTRL_PIN(22, "SCL3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 22),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "SCL3_0")
	),
	MTK_PIN(
		PINCTRL_PIN(23, "PWRAP_SPI_CLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CK"),
		MTK_FUNCTION(2, "SPDIF_OUT"),
		MTK_FUNCTION(3, "CONN_TSF"),
		MTK_FUNCTION(6, "SPLIN_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B_28")
	),
	MTK_PIN(
		PINCTRL_PIN(24, "PWRAP_SPI_CSN"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CSN"),
		MTK_FUNCTION(2, "TDMO_MCLK"),
		MTK_FUNCTION(3, "PCM_SYNC"),
		MTK_FUNCTION(5, "URXD1"),
		MTK_FUNCTION(6, "SPLIN_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_B_17")
	),
	MTK_PIN(
		PINCTRL_PIN(25, "PWRAP_SPI_MOSI"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MO"),
		MTK_FUNCTION(2, "TDMO_BCK"),
		MTK_FUNCTION(3, "PCM_CLK"),
		MTK_FUNCTION(4, "CONN_TSF"),
		MTK_FUNCTION(5, "UTXD1"),
		MTK_FUNCTION(6, "SPLIN_D0"),
		MTK_FUNCTION(7, "DBG_MON_B_18")
	),
	MTK_PIN(
		PINCTRL_PIN(26, "PWRAP_SPI_MISO"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MI"),
		MTK_FUNCTION(2, "TDMO_LRCK"),
		MTK_FUNCTION(3, "PCM_RX"),
		MTK_FUNCTION(4, "CONN_TSF"),
		MTK_FUNCTION(5, "URTS1"),
		MTK_FUNCTION(6, "SPLIN_D1"),
		MTK_FUNCTION(7, "DBG_MON_B_19")
	),
	MTK_PIN(
		PINCTRL_PIN(27, "PWRAP_INT"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(2, "TDMO_DO"),
		MTK_FUNCTION(3, "PCM_TX"),
		MTK_FUNCTION(5, "UCTS1"),
		MTK_FUNCTION(6, "SPLIN_D2"),
		MTK_FUNCTION(7, "DBG_MON_B_20")
	),
	MTK_PIN(
		PINCTRL_PIN(28, "EINT22"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "VCORE_SWITCH"),
		MTK_FUNCTION(2, "PWM_A"),
		MTK_FUNCTION(3, "CONN_TSF")
	),
	MTK_PIN(
		PINCTRL_PIN(29, "MSDC2_CMD"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(2, "PWM_A"),
		MTK_FUNCTION(3, "SPI0_CSB"),
		MTK_FUNCTION(4, "MSDC2_DAT1"),
		MTK_FUNCTION(5, "DBG_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A_1")
	),
	MTK_PIN(
		PINCTRL_PIN(30, "MSDC2_CLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(2, "PWM_B"),
		MTK_FUNCTION(3, "SPI0_CLK"),
		MTK_FUNCTION(4, "MSDC2_CLK"),
		MTK_FUNCTION(5, "DBG_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A_2")
	),
	MTK_PIN(
		PINCTRL_PIN(31, "MSDC2_DAT0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "SPI0_MI"),
		MTK_FUNCTION(4, "MSDC2_DAT2"),
		MTK_FUNCTION(7, "DBG_MON_A_3")
	),
	MTK_PIN(
		PINCTRL_PIN(32, "MSDC2_DAT1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(2, "PWM_D"),
		MTK_FUNCTION(3, "SPI0_MO"),
		MTK_FUNCTION(4, "MSDC2_CMD")
	),
	MTK_PIN(
		PINCTRL_PIN(33, "MSDC2_DAT2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(4, "MSDC2_DS"),
		MTK_FUNCTION(7, "DBG_MON_A_5")
	),
	MTK_PIN(
		PINCTRL_PIN(34, "MSDC2_DAT3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(4, "MSDC2_DAT0"),
		MTK_FUNCTION(7, "DBG_MON_A_6")
	),
	MTK_PIN(
		PINCTRL_PIN(35, "MSDC2_DS"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "MSDC2_DS"),
		MTK_FUNCTION(2, "CONN_TSF"),
		MTK_FUNCTION(4, "MSDC2_DAT3"),
		MTK_FUNCTION(7, "DBG_MON_A_7")
	),
	MTK_PIN(
		PINCTRL_PIN(36, "EINT0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "EXT_TXD0"),
		MTK_FUNCTION(2, "DBI_CSX"),
		MTK_FUNCTION(3, "SPI0_CSB"),
		MTK_FUNCTION(4, "DPI_PCLK"),
		MTK_FUNCTION(5, "CLKM0"),
		MTK_FUNCTION(6, "SPIS_CSB"),
		MTK_FUNCTION(7, "DBG_MON_A_8")
	),
	MTK_PIN(
		PINCTRL_PIN(37, "EINT1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "EXT_TXD1"),
		MTK_FUNCTION(2, "DBI_SCL"),
		MTK_FUNCTION(3, "SPI0_CLK"),
		MTK_FUNCTION(4, "DPI_VSYNC"),
		MTK_FUNCTION(5, "CLKM1"),
		MTK_FUNCTION(6, "SPIS_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A_9")
	),
	MTK_PIN(
		PINCTRL_PIN(38, "EINT2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "EXT_TXC"),
		MTK_FUNCTION(2, "DBI_DOUT"),
		MTK_FUNCTION(3, "SPI0_MI"),
		MTK_FUNCTION(4, "DPI_HSYNC"),
		MTK_FUNCTION(5, "CLKM2"),
		MTK_FUNCTION(6, "SPIS_MI"),
		MTK_FUNCTION(7, "DBG_MON_A_10")
	),
	MTK_PIN(
		PINCTRL_PIN(39, "EINT3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "EXT_RXER"),
		MTK_FUNCTION(2, "DBI_DIN"),
		MTK_FUNCTION(3, "SPI0_MO"),
		MTK_FUNCTION(4, "DPI_DE"),
		MTK_FUNCTION(5, "CLKM3"),
		MTK_FUNCTION(6, "SPIS_MO"),
		MTK_FUNCTION(7, "DBG_MON_A_11")
	),
	MTK_PIN(
		PINCTRL_PIN(40, "EINT4"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "EXT_RXC"),
		MTK_FUNCTION(2, "DBI_SDA"),
		MTK_FUNCTION(4, "DPI_DATA0"),
		MTK_FUNCTION(5, "CLKM4"),
		MTK_FUNCTION(7, "DBG_MON_A_12")
	),
	MTK_PIN(
		PINCTRL_PIN(41, "EINT5"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "EXT_RXDV"),
		MTK_FUNCTION(2, "DBI_DCX"),
		MTK_FUNCTION(4, "DPI_DATA1"),
		MTK_FUNCTION(5, "CLKM5"),
		MTK_FUNCTION(7, "DBG_MON_A_0")
	),
	MTK_PIN(
		PINCTRL_PIN(42, "EINT6"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "EXT_RXD0"),
		MTK_FUNCTION(2, "DBI_RESX"),
		MTK_FUNCTION(3, "DPI_DATA2"),
		MTK_FUNCTION(5, "CLKM0"),
		MTK_FUNCTION(6, "JTRSTB_CM4"),
		MTK_FUNCTION(7, "DBG_MON_A_14")
	),
	MTK_PIN(
		PINCTRL_PIN(43, "EINT7"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "EXT_RXD1"),
		MTK_FUNCTION(2, "DBI_TE"),
		MTK_FUNCTION(3, "DPI_DATA3"),
		MTK_FUNCTION(5, "CLKM1"),
		MTK_FUNCTION(6, "JTCK_CM4"),
		MTK_FUNCTION(7, "DBG_MON_A_15")
	),
	MTK_PIN(
		PINCTRL_PIN(44, "EINT8"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "EXT_TXEN"),
		MTK_FUNCTION(2, "DISP_PWM"),
		MTK_FUNCTION(3, "DPI_DATA4"),
		MTK_FUNCTION(5, "CLKM2"),
		MTK_FUNCTION(6, "JTMS_CM4"),
		MTK_FUNCTION(7, "DBG_MON_A_16")
	),
	MTK_PIN(
		PINCTRL_PIN(45, "EINT9"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "EXT_MDIO"),
		MTK_FUNCTION(2, "DPI_DATA5"),
		MTK_FUNCTION(3, "SDA1_0"),
		MTK_FUNCTION(5, "CLKM3"),
		MTK_FUNCTION(6, "JTDI_CM4"),
		MTK_FUNCTION(7, "DBG_MON_A_17")
	),
	MTK_PIN(
		PINCTRL_PIN(46, "EINT10"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "EXT_MDC"),
		MTK_FUNCTION(2, "DPI_DATA6"),
		MTK_FUNCTION(3, "SCL1_0"),
		MTK_FUNCTION(6, "JTDO_CM4"),
		MTK_FUNCTION(7, "DBG_MON_A_18")
	),
	MTK_PIN(
		PINCTRL_PIN(47, "EINT11"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "DPI_DATA7"),
		MTK_FUNCTION(3, "PWM_A"),
		MTK_FUNCTION(4, "SPLIN_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A_19")
	),
	MTK_PIN(
		PINCTRL_PIN(48, "EINT12"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "PCM_CLK"),
		MTK_FUNCTION(2, "DPI_DATA8"),
		MTK_FUNCTION(3, "PWM_B"),
		MTK_FUNCTION(4, "SPLIN_LRCK"),
		MTK_FUNCTION(5, "URXD1"),
		MTK_FUNCTION(6, "DFD_NTRST_XI"),
		MTK_FUNCTION(7, "DBG_MON_B_29")
	),
	MTK_PIN(
		PINCTRL_PIN(49, "EINT13"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "PCM_SYNC"),
		MTK_FUNCTION(2, "DPI_DATA9"),
		MTK_FUNCTION(3, "DISP_PWM"),
		MTK_FUNCTION(4, "SPLIN_D0"),
		MTK_FUNCTION(5, "UTXD1"),
		MTK_FUNCTION(6, "DFD_TMS_XI"),
		MTK_FUNCTION(7, "DBG_MON_B_30")
	),
	MTK_PIN(
		PINCTRL_PIN(50, "EINT14"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "PCM_RX"),
		MTK_FUNCTION(2, "DPI_DATA10"),
		MTK_FUNCTION(3, "PWM_C"),
		MTK_FUNCTION(4, "SPLIN_D1"),
		MTK_FUNCTION(5, "URTS1"),
		MTK_FUNCTION(6, "DFD_TCK_XI")
	),
	MTK_PIN(
		PINCTRL_PIN(51, "EINT15"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "PCM_TX"),
		MTK_FUNCTION(2, "DPI_DATA11"),
		MTK_FUNCTION(3, "PWM_D"),
		MTK_FUNCTION(4, "SPLIN_D2"),
		MTK_FUNCTION(5, "UCTS1"),
		MTK_FUNCTION(6, "DFD_TDI_XI")
	),
	MTK_PIN(
		PINCTRL_PIN(52, "URXD1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "URXD2"),
		MTK_FUNCTION(3, "UTXD1"),
		MTK_FUNCTION(6, "PCM_CLK"),
		MTK_FUNCTION(7, "DBG_MON_B_31")
	),
	MTK_PIN(
		PINCTRL_PIN(53, "UTXD1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "UTXD2"),
		MTK_FUNCTION(3, "URXD1"),
		MTK_FUNCTION(6, "PCM_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A_23")
	),
	MTK_PIN(
		PINCTRL_PIN(54, "URTS1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "URTS1"),
		MTK_FUNCTION(2, "URTS2"),
		MTK_FUNCTION(4, "URXD0"),
		MTK_FUNCTION(5, "DBG_SDA"),
		MTK_FUNCTION(6, "PCM_RX"),
		MTK_FUNCTION(7, "DBG_MON_A_24")
	),
	MTK_PIN(
		PINCTRL_PIN(55, "UCTS1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "UCTS1"),
		MTK_FUNCTION(2, "UCTS2"),
		MTK_FUNCTION(4, "UTXD0"),
		MTK_FUNCTION(5, "DBG_SCL"),
		MTK_FUNCTION(6, "PCM_TX"),
		MTK_FUNCTION(7, "DBG_MON_A_25")
	),
	MTK_PIN(
		PINCTRL_PIN(56, "IR"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "IR"),
		MTK_FUNCTION(4, "SPLIN_D3"),
		MTK_FUNCTION(5, "USB_DRVVBUS"),
		MTK_FUNCTION(7, "DBG_MON_A_26")
	),
	MTK_PIN(
		PINCTRL_PIN(57, "EINT16"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "USB_DRVVBUS"),
		MTK_FUNCTION(2, "CONN_TSF"),
		MTK_FUNCTION(3, "KPROW2"),
		MTK_FUNCTION(4, "KPCOL2"),
		MTK_FUNCTION(5, "CLKM4"),
		MTK_FUNCTION(6, "DFD_TDO"),
		MTK_FUNCTION(7, "DBG_MON_A_27")
	),
	MTK_PIN(
		PINCTRL_PIN(58, "EINT17"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "PCIE_PERST"),
		MTK_FUNCTION(3, "KPCOL2"),
		MTK_FUNCTION(5, "CLKM5"),
		MTK_FUNCTION(7, "DBG_MON_A_28")
	),
	MTK_PIN(
		PINCTRL_PIN(59, "EINT18"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "SPDIF_OUT"),
		MTK_FUNCTION(2, "PCIE_WAKE"),
		MTK_FUNCTION(3, "KPROW0"),
		MTK_FUNCTION(7, "DBG_MON_A_29")
	),
	MTK_PIN(
		PINCTRL_PIN(60, "EINT19"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "AUD_EXTCK2"),
		MTK_FUNCTION(2, "PCIE_CLKREQ"),
		MTK_FUNCTION(3, "KPROW1"),
		MTK_FUNCTION(4, "UCTS1"),
		MTK_FUNCTION(5, "KPCOL1"),
		MTK_FUNCTION(6, "URTS1"),
		MTK_FUNCTION(7, "DBG_MON_A_30")
	),
	MTK_PIN(
		PINCTRL_PIN(61, "EINT20"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "USBDL"),
		MTK_FUNCTION(3, "KPCOL0"),
		MTK_FUNCTION(7, "DBG_MON_A_31")
	),
	MTK_PIN(
		PINCTRL_PIN(62, "EINT21"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "PWM_B"),
		MTK_FUNCTION(2, "VCORE_SWITCH"),
		MTK_FUNCTION(3, "KPCOL1"),
		MTK_FUNCTION(4, "URTS1"),
		MTK_FUNCTION(5, "SPDIF_IN_1"),
		MTK_FUNCTION(6, "UCTS1"),
		MTK_FUNCTION(7, "DBG_MON_A_13")
	),
	MTK_PIN(
		PINCTRL_PIN(63, "I2SO_MCLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "I2SO_MCLKA"),
		MTK_FUNCTION(2, "TDMO_MCLK"),
		MTK_FUNCTION(3, "I2SIN_MCLKA"),
		MTK_FUNCTION(4, "AUD_EXTCK1"),
		MTK_FUNCTION(5, "I2SIN_BYPS_MCLKA")
	),
	MTK_PIN(
		PINCTRL_PIN(64, "I2SO_BCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "I2SO_BCKA"),
		MTK_FUNCTION(2, "TDMO_BCK"),
		MTK_FUNCTION(3, "I2SIN_BCKA"),
		MTK_FUNCTION(5, "I2SIN_BYPS_BCKA")
	),
	MTK_PIN(
		PINCTRL_PIN(65, "I2SO_LRCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "I2SO_LRCKA"),
		MTK_FUNCTION(2, "TDMO_LRCK"),
		MTK_FUNCTION(3, "I2SIN_LRCKA"),
		MTK_FUNCTION(5, "I2SIN_BYPS_LRCKA")
	),
	MTK_PIN(
		PINCTRL_PIN(66, "I2SO_D0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "I2SO_D0"),
		MTK_FUNCTION(2, "TDMO_DO"),
		MTK_FUNCTION(3, "I2SIN_D0"),
		MTK_FUNCTION(5, "I2SIN_BYPS_D0")
	),
	MTK_PIN(
		PINCTRL_PIN(67, "I2SO_D1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "I2SO_D1"),
		MTK_FUNCTION(2, "TDMO_DO1"),
		MTK_FUNCTION(3, "I2SIN_D1"),
		MTK_FUNCTION(5, "KPROW0"),
		MTK_FUNCTION(6, "I2SIN_BYPS_D1")
	),
	MTK_PIN(
		PINCTRL_PIN(68, "I2SO_D2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "I2SO_D2"),
		MTK_FUNCTION(2, "TDMO_DO2"),
		MTK_FUNCTION(3, "I2SIN_D2"),
		MTK_FUNCTION(4, "AUD_EXTCK2"),
		MTK_FUNCTION(5, "KPROW1"),
		MTK_FUNCTION(6, "I2SIN_BYPS_D2")
	),
	MTK_PIN(
		PINCTRL_PIN(69, "I2SO_D3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "I2SO_D3"),
		MTK_FUNCTION(2, "TDMO_DO3"),
		MTK_FUNCTION(3, "I2SIN_D3"),
		MTK_FUNCTION(4, "AUD_EXTCK1"),
		MTK_FUNCTION(5, "KPCOL0"),
		MTK_FUNCTION(6, "I2SIN_BYPS_D3")
	),
	MTK_PIN(
		PINCTRL_PIN(70, "SPDIF_IN0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "SPDIF_IN_0"),
		MTK_FUNCTION(2, "SPDIF_IN_1"),
		MTK_FUNCTION(3, "I2SIN_D0"),
		MTK_FUNCTION(4, "USB_DRVVBUS"),
		MTK_FUNCTION(5, "KPCOL1")
	),
	MTK_PIN(
		PINCTRL_PIN(71, "DMIC_CLK0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "DMIC_CLK0"),
		MTK_FUNCTION(2, "I2SIN_MCLKA"),
		MTK_FUNCTION(3, "SPLIN_BCK"),
		MTK_FUNCTION(4, "SPDIF_IN_0"),
		MTK_FUNCTION(5, "TDMO_MCLK")
	),
	MTK_PIN(
		PINCTRL_PIN(72, "DMIC_CLK1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "DMIC_CLK1"),
		MTK_FUNCTION(2, "I2SIN_BCKA"),
		MTK_FUNCTION(3, "SPLIN_LRCK"),
		MTK_FUNCTION(4, "SPDIF_IN_1"),
		MTK_FUNCTION(5, "TDMO_BCK")
	),
	MTK_PIN(
		PINCTRL_PIN(73, "DMIC_DAT0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "DMIC_DAT0"),
		MTK_FUNCTION(2, "I2SIN_LRCKA"),
		MTK_FUNCTION(3, "SPLIN_D0"),
		MTK_FUNCTION(5, "TDMO_LRCK")
	),
	MTK_PIN(
		PINCTRL_PIN(74, "DMIC_DAT1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "DMIC_DAT1"),
		MTK_FUNCTION(3, "SPLIN_D1"),
		MTK_FUNCTION(5, "TDMO_DO"),
		MTK_FUNCTION(6, "KPROW2")
	),
	MTK_PIN(
		PINCTRL_PIN(75, "DMIC_DAT2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "DMIC_DAT2"),
		MTK_FUNCTION(3, "SPLIN_D2"),
		MTK_FUNCTION(5, "TDMO_DO1")
	),
	MTK_PIN(
		PINCTRL_PIN(76, "DMIC_DAT3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "DMIC_DAT3"),
		MTK_FUNCTION(3, "SPLIN_D3"),
		MTK_FUNCTION(4, "SPDIF_IN_2"),
		MTK_FUNCTION(5, "TDMO_DO2"),
		MTK_FUNCTION(6, "KPCOL2")
	),
	MTK_PIN(
		PINCTRL_PIN(77, "TDM_MCLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "TDMIN_MCLK"),
		MTK_FUNCTION(2, "TDMO_MCLK"),
		MTK_FUNCTION(3, "I2SIN_MCLKA"),
		MTK_FUNCTION(4, "NOR_IO0"),
		MTK_FUNCTION(5, "NAND_IO0"),
		MTK_FUNCTION(6, "KPCOL0"),
		MTK_FUNCTION(7, "TDMO_DO4")
	),
	MTK_PIN(
		PINCTRL_PIN(78, "TDM_BCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "TDMIN_BCK"),
		MTK_FUNCTION(2, "TDMO_BCK"),
		MTK_FUNCTION(3, "I2SIN_BCKA"),
		MTK_FUNCTION(4, "NOR_IO1"),
		MTK_FUNCTION(5, "NAND_IO1"),
		MTK_FUNCTION(6, "KPCOL1"),
		MTK_FUNCTION(7, "TDMO_DO5")
	),
	MTK_PIN(
		PINCTRL_PIN(79, "TDM_LRCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "TDMIN_LRCK"),
		MTK_FUNCTION(2, "TDMO_LRCK"),
		MTK_FUNCTION(3, "I2SIN_LRCKA"),
		MTK_FUNCTION(4, "NOR_IO2"),
		MTK_FUNCTION(5, "NAND_IO2"),
		MTK_FUNCTION(6, "KPROW0"),
		MTK_FUNCTION(7, "TDMO_DO6")
	),
	MTK_PIN(
		PINCTRL_PIN(80, "TDM_DI"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "TDMIN_DI"),
		MTK_FUNCTION(2, "TDMO_DO"),
		MTK_FUNCTION(3, "I2SIN_D0"),
		MTK_FUNCTION(4, "NOR_IO3"),
		MTK_FUNCTION(5, "NAND_IO3"),
		MTK_FUNCTION(6, "KPROW1"),
		MTK_FUNCTION(7, "TDMO_DO7")
	),
	MTK_PIN(
		PINCTRL_PIN(81, "I2SIN_D0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "I2SIN_D0"),
		MTK_FUNCTION(2, "TDMIN_DI"),
		MTK_FUNCTION(3, "I2SO_D0"),
		MTK_FUNCTION(5, "TDMO_DO"),
		MTK_FUNCTION(6, "DMIC_DAT4"),
		MTK_FUNCTION(7, "SPLIN_D0")
	),
	MTK_PIN(
		PINCTRL_PIN(82, "I2SIN_D1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "I2SIN_D1"),
		MTK_FUNCTION(3, "I2SO_D1"),
		MTK_FUNCTION(4, "PWM_A"),
		MTK_FUNCTION(5, "TDMO_DO1"),
		MTK_FUNCTION(6, "DMIC_DAT5"),
		MTK_FUNCTION(7, "SPLIN_D1")
	),
	MTK_PIN(
		PINCTRL_PIN(83, "I2SIN_D2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "I2SIN_D2"),
		MTK_FUNCTION(2, "NOR_CS"),
		MTK_FUNCTION(3, "I2SO_D2"),
		MTK_FUNCTION(4, "NAND_CS"),
		MTK_FUNCTION(5, "TDMO_DO2"),
		MTK_FUNCTION(6, "DMIC_DAT6"),
		MTK_FUNCTION(7, "SPLIN_D2")
	),
	MTK_PIN(
		PINCTRL_PIN(84, "I2SIN_D3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "I2SIN_D3"),
		MTK_FUNCTION(2, "NOR_CK"),
		MTK_FUNCTION(3, "I2SO_D3"),
		MTK_FUNCTION(4, "NAND_CK"),
		MTK_FUNCTION(5, "TDMO_DO3"),
		MTK_FUNCTION(6, "DMIC_DAT7"),
		MTK_FUNCTION(7, "SPLIN_D3")
	),
	MTK_PIN(
		PINCTRL_PIN(85, "I2SIN_MCLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "I2SIN_MCLKA"),
		MTK_FUNCTION(2, "TDMIN_MCLK"),
		MTK_FUNCTION(3, "I2SO_MCLKA"),
		MTK_FUNCTION(4, "PWM_B"),
		MTK_FUNCTION(5, "TDMO_MCLK"),
		MTK_FUNCTION(6, "DMIC_CLK2"),
		MTK_FUNCTION(7, "I2SIN_D1")
	),
	MTK_PIN(
		PINCTRL_PIN(86, "I2SIN_BCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "I2SIN_BCKA"),
		MTK_FUNCTION(2, "TDMIN_BCK"),
		MTK_FUNCTION(3, "I2SO_BCKA"),
		MTK_FUNCTION(4, "I2SIN_D2"),
		MTK_FUNCTION(5, "TDMO_BCK"),
		MTK_FUNCTION(6, "DMIC_CLK3"),
		MTK_FUNCTION(7, "SPLIN_BCK")
	),
	MTK_PIN(
		PINCTRL_PIN(87, "I2SIN_LRCK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "I2SIN_LRCKA"),
		MTK_FUNCTION(2, "TDMIN_LRCK"),
		MTK_FUNCTION(3, "I2SO_LRCKA"),
		MTK_FUNCTION(4, "PWM_D"),
		MTK_FUNCTION(5, "TDMO_LRCK"),
		MTK_FUNCTION(6, "I2SIN_D3"),
		MTK_FUNCTION(7, "SPLIN_LRCK")
	),
	MTK_PIN(
		PINCTRL_PIN(88, "SPI1_CS"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "SPI1_CSB"),
		MTK_FUNCTION(2, "SPDIF_OUT"),
		MTK_FUNCTION(3, "SPIS_CSB"),
		MTK_FUNCTION(5, "PWM_A"),
		MTK_FUNCTION(6, "DFD_NTRST_XI")
	),
	MTK_PIN(
		PINCTRL_PIN(89, "SPI1_CK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "SPI1_CLK"),
		MTK_FUNCTION(3, "SPIS_CLK"),
		MTK_FUNCTION(5, "PWM_B")
	),
	MTK_PIN(
		PINCTRL_PIN(90, "SPI1_MI"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "SPI1_MI"),
		MTK_FUNCTION(2, "SPI1_MO"),
		MTK_FUNCTION(3, "SPIS_MI"),
		MTK_FUNCTION(4, "SPIS_MO"),
		MTK_FUNCTION(5, "PWM_C"),
		MTK_FUNCTION(6, "KPROW2")
	),
	MTK_PIN(
		PINCTRL_PIN(91, "SPI1_MO"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "SPI1_MO"),
		MTK_FUNCTION(2, "SPI1_MI"),
		MTK_FUNCTION(3, "SPIS_MO"),
		MTK_FUNCTION(4, "SPIS_MI"),
		MTK_FUNCTION(5, "PWM_D"),
		MTK_FUNCTION(6, "KPCOL2")
	),
	MTK_PIN(
		PINCTRL_PIN(92, "SPI2_CS"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "SPI2_CSB"),
		MTK_FUNCTION(2, "SPIS_CSB"),
		MTK_FUNCTION(3, "URXD1"),
		MTK_FUNCTION(4, "URXD2"),
		MTK_FUNCTION(5, "SPDIF_OUT"),
		MTK_FUNCTION(6, "KPROW0"),
		MTK_FUNCTION(7, "TDMO_DO4")
	),
	MTK_PIN(
		PINCTRL_PIN(93, "SPI2_CK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "SPI2_CLK"),
		MTK_FUNCTION(2, "SPIS_CLK"),
		MTK_FUNCTION(3, "UTXD1"),
		MTK_FUNCTION(4, "UTXD2"),
		MTK_FUNCTION(6, "KPROW1"),
		MTK_FUNCTION(7, "TDMO_DO5")
	),
	MTK_PIN(
		PINCTRL_PIN(94, "SPI2_MI0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "SPI2_MI0"),
		MTK_FUNCTION(2, "SPIS_MI"),
		MTK_FUNCTION(3, "URTS1"),
		MTK_FUNCTION(4, "URTS2"),
		MTK_FUNCTION(5, "SPI2_MI1"),
		MTK_FUNCTION(6, "KPCOL0"),
		MTK_FUNCTION(7, "TDMO_DO6")
	),
	MTK_PIN(
		PINCTRL_PIN(95, "SPI2_MI1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "SPI2_MI1"),
		MTK_FUNCTION(2, "SPIS_MO"),
		MTK_FUNCTION(3, "UCTS1"),
		MTK_FUNCTION(4, "UCTS2"),
		MTK_FUNCTION(5, "SPI2_MI0"),
		MTK_FUNCTION(6, "KPCOL1"),
		MTK_FUNCTION(7, "TDMO_DO7")
	),
	MTK_PIN(
		PINCTRL_PIN(96, "SPI2_MI2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "SPI2_MI2")
	),
	MTK_PIN(
		PINCTRL_PIN(97, "SPI2_MI3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "SPI2_MI3")
	),
	MTK_PIN(
		PINCTRL_PIN(98, "SW_RESET_DSP"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPIO98")
	),
	MTK_PIN(
		PINCTRL_PIN(99, "GPIO1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPIO99")
	),
	MTK_PIN(
		PINCTRL_PIN(100, "GPIO2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "GPIO100")
	),
	MTK_PIN(
		PINCTRL_PIN(101, "GPIO3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "GPIO101")
	),
	MTK_PIN(
		PINCTRL_PIN(102, "GPIO4"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(0, "GPIO102")
	),
	MTK_PIN(
		PINCTRL_PIN(103, "RTC32K_DSP"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 103),
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "CLK_32K"),
		MTK_FUNCTION(2, "SPDIF_IN_2")
	),
	MTK_PIN(
		PINCTRL_PIN(104, "URXD0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 104),
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "URTS1"),
		MTK_FUNCTION(4, "URTS2"),
		MTK_FUNCTION(7, "DBG_MON_A_4")
	),
	MTK_PIN(
		PINCTRL_PIN(105, "UTXD0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 105),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "UCTS1"),
		MTK_FUNCTION(4, "UCTS2"),
		MTK_FUNCTION(7, "DBG_MON_A_20")
	),
	MTK_PIN(
		PINCTRL_PIN(106, "URXD2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 106),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "URTS0"),
		MTK_FUNCTION(4, "KPCOL3"),
		MTK_FUNCTION(7, "DBG_MON_A_21")
	),
	MTK_PIN(
		PINCTRL_PIN(107, "UTXD2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 107),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "UCTS0"),
		MTK_FUNCTION(4, "KPCOL4"),
		MTK_FUNCTION(5, "SPDIF_OUT"),
		MTK_FUNCTION(7, "DBG_MON_A_22")
	),
	MTK_PIN(
		PINCTRL_PIN(108, "SDA1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 108),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "SDA1_0")
	),
	MTK_PIN(
		PINCTRL_PIN(109, "SCL1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 109),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "SCL1_0")
	),
	MTK_PIN(
		PINCTRL_PIN(110, "SDA0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 110),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "SDA0_0")
	),
	MTK_PIN(
		PINCTRL_PIN(111, "SCL0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "SCL0_0")
	),
	MTK_PIN(
		PINCTRL_PIN(112, "SDA2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "SDA2_0")
	),
	MTK_PIN(
		PINCTRL_PIN(113, "SCL2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "SCL2_0")
	),
	MTK_PIN(
		PINCTRL_PIN(114, "MSDC1_CMD"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 114),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(2, "NOR_CS"),
		MTK_FUNCTION(3, "PWM_A"),
		MTK_FUNCTION(4, "NAND_CS"),
		MTK_FUNCTION(5, "JTMS"),
		MTK_FUNCTION(6, "NTRST_UDI"),
		MTK_FUNCTION(7, "DBG_MON_B_0")
	),
	MTK_PIN(
		PINCTRL_PIN(115, "MSDC1_CLK"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "NOR_CK"),
		MTK_FUNCTION(3, "PWM_B"),
		MTK_FUNCTION(4, "NAND_CK"),
		MTK_FUNCTION(5, "JTCK"),
		MTK_FUNCTION(6, "TCK_UDI"),
		MTK_FUNCTION(7, "DBG_MON_B_1")
	),
	MTK_PIN(
		PINCTRL_PIN(116, "MSDC1_DAT0"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(2, "NOR_IO0"),
		MTK_FUNCTION(3, "PWM_C"),
		MTK_FUNCTION(4, "NAND_IO0"),
		MTK_FUNCTION(5, "JTDI"),
		MTK_FUNCTION(6, "TDI_UDI"),
		MTK_FUNCTION(7, "DBG_MON_B_2")
	),
	MTK_PIN(
		PINCTRL_PIN(117, "MSDC1_DAT1"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "NOR_IO1"),
		MTK_FUNCTION(3, "PWM_D"),
		MTK_FUNCTION(4, "NAND_IO1"),
		MTK_FUNCTION(5, "JTDO"),
		MTK_FUNCTION(6, "TMS_UDI"),
		MTK_FUNCTION(7, "DBG_MON_B_3")
	),
	MTK_PIN(
		PINCTRL_PIN(118, "MSDC1_DAT2"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "NOR_IO2"),
		MTK_FUNCTION(3, "NAND_IO2"),
		MTK_FUNCTION(4, "SDA0_0"),
		MTK_FUNCTION(5, "KPCOL3"),
		MTK_FUNCTION(6, "TDO_UDI"),
		MTK_FUNCTION(7, "DBG_MON_B_21")
	),
	MTK_PIN(
		PINCTRL_PIN(119, "MSDC1_DAT3"),
		NULL, "mt8518",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "NOR_IO3"),
		MTK_FUNCTION(3, "NAND_IO3"),
		MTK_FUNCTION(4, "SCL0_0"),
		MTK_FUNCTION(5, "KPCOL4"),
		MTK_FUNCTION(6, "IDDIG"),
		MTK_FUNCTION(7, "DBG_MON_B_22")
	),
};

#endif/* __PINCTRL_MTK_MT8518_H */
