/*
 * Copyright (C) 2016 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/err.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/pinctrl/pinctrl.h>

#include "pinctrl-imx.h"

enum imx7ulp_pads {
	ULP1_PAD_PTA0 = 0,
	ULP1_PAD_PTA1,
	ULP1_PAD_PTA2,
	ULP1_PAD_PTA3,
	ULP1_PAD_PTA4,
	ULP1_PAD_PTA5,
	ULP1_PAD_PTA6,
	ULP1_PAD_PTA7,
	ULP1_PAD_PTA8,
	ULP1_PAD_PTA9,
	ULP1_PAD_PTA10,
	ULP1_PAD_PTA11,
	ULP1_PAD_PTA12,
	ULP1_PAD_PTA13,
	ULP1_PAD_PTA14,
	ULP1_PAD_PTA15,
	ULP1_PAD_PTA16,
	ULP1_PAD_PTA17,
	ULP1_PAD_PTA18,
	ULP1_PAD_PTA19,
	ULP1_PAD_PTA20,
	ULP1_PAD_PTA21,
	ULP1_PAD_PTA22,
	ULP1_PAD_PTA23,
	ULP1_PAD_PTA24,
	ULP1_PAD_PTA25,
	ULP1_PAD_PTA26,
	ULP1_PAD_PTA27,
	ULP1_PAD_PTA28,
	ULP1_PAD_PTA29,
	ULP1_PAD_PTA30,
	ULP1_PAD_PTA31,
	ULP1_PAD_PTB0,
	ULP1_PAD_PTB1,
	ULP1_PAD_PTB2,
	ULP1_PAD_PTB3,
	ULP1_PAD_PTB4,
	ULP1_PAD_PTB5,
	ULP1_PAD_PTB6,
	ULP1_PAD_PTB7,
	ULP1_PAD_PTB8,
	ULP1_PAD_PTB9,
	ULP1_PAD_PTB10,
	ULP1_PAD_PTB11,
	ULP1_PAD_PTB12,
	ULP1_PAD_PTB13,
	ULP1_PAD_PTB14,
	ULP1_PAD_PTB15,
	ULP1_PAD_PTB16,
	ULP1_PAD_PTB17,
	ULP1_PAD_PTB18,
	ULP1_PAD_PTB19 = 51,
	ULP1_PAD_PTC0 = 0,
	ULP1_PAD_PTC1,
	ULP1_PAD_PTC2,
	ULP1_PAD_PTC3,
	ULP1_PAD_PTC4,
	ULP1_PAD_PTC5,
	ULP1_PAD_PTC6,
	ULP1_PAD_PTC7,
	ULP1_PAD_PTC8,
	ULP1_PAD_PTC9,
	ULP1_PAD_PTC10,
	ULP1_PAD_PTC11,
	ULP1_PAD_PTC12,
	ULP1_PAD_PTC13,
	ULP1_PAD_PTC14,
	ULP1_PAD_PTC15,
	ULP1_PAD_PTC16,
	ULP1_PAD_PTC17,
	ULP1_PAD_PTC18,
	ULP1_PAD_PTC19,
	ULP1_PAD_RESERVE0,
	ULP1_PAD_RESERVE1,
	ULP1_PAD_RESERVE2,
	ULP1_PAD_RESERVE3,
	ULP1_PAD_RESERVE4,
	ULP1_PAD_RESERVE5,
	ULP1_PAD_RESERVE6,
	ULP1_PAD_RESERVE7,
	ULP1_PAD_RESERVE8,
	ULP1_PAD_RESERVE9,
	ULP1_PAD_RESERVE10,
	ULP1_PAD_RESERVE11,
	ULP1_PAD_PTD0,
	ULP1_PAD_PTD1,
	ULP1_PAD_PTD2,
	ULP1_PAD_PTD3,
	ULP1_PAD_PTD4,
	ULP1_PAD_PTD5,
	ULP1_PAD_PTD6,
	ULP1_PAD_PTD7,
	ULP1_PAD_PTD8,
	ULP1_PAD_PTD9,
	ULP1_PAD_PTD10,
	ULP1_PAD_PTD11,
	ULP1_PAD_RESERVE12,
	ULP1_PAD_RESERVE13,
	ULP1_PAD_RESERVE14,
	ULP1_PAD_RESERVE15,
	ULP1_PAD_RESERVE16,
	ULP1_PAD_RESERVE17,
	ULP1_PAD_RESERVE18,
	ULP1_PAD_RESERVE19,
	ULP1_PAD_RESERVE20,
	ULP1_PAD_RESERVE21,
	ULP1_PAD_RESERVE22,
	ULP1_PAD_RESERVE23,
	ULP1_PAD_RESERVE24,
	ULP1_PAD_RESERVE25,
	ULP1_PAD_RESERVE26,
	ULP1_PAD_RESERVE27,
	ULP1_PAD_RESERVE28,
	ULP1_PAD_RESERVE29,
	ULP1_PAD_RESERVE30,
	ULP1_PAD_RESERVE31,
	ULP1_PAD_PTE0,
	ULP1_PAD_PTE1,
	ULP1_PAD_PTE2,
	ULP1_PAD_PTE3,
	ULP1_PAD_PTE4,
	ULP1_PAD_PTE5,
	ULP1_PAD_PTE6,
	ULP1_PAD_PTE7,
	ULP1_PAD_PTE8,
	ULP1_PAD_PTE9,
	ULP1_PAD_PTE10,
	ULP1_PAD_PTE11,
	ULP1_PAD_PTE12,
	ULP1_PAD_PTE13,
	ULP1_PAD_PTE14,
	ULP1_PAD_PTE15,
	ULP1_PAD_RESERVE32,
	ULP1_PAD_RESERVE33,
	ULP1_PAD_RESERVE34,
	ULP1_PAD_RESERVE35,
	ULP1_PAD_RESERVE36,
	ULP1_PAD_RESERVE37,
	ULP1_PAD_RESERVE38,
	ULP1_PAD_RESERVE39,
	ULP1_PAD_RESERVE40,
	ULP1_PAD_RESERVE41,
	ULP1_PAD_RESERVE42,
	ULP1_PAD_RESERVE43,
	ULP1_PAD_RESERVE44,
	ULP1_PAD_RESERVE45,
	ULP1_PAD_RESERVE46,
	ULP1_PAD_RESERVE47,
	ULP1_PAD_PTF0,
	ULP1_PAD_PTF1,
	ULP1_PAD_PTF2,
	ULP1_PAD_PTF3,
	ULP1_PAD_PTF4,
	ULP1_PAD_PTF5,
	ULP1_PAD_PTF6,
	ULP1_PAD_PTF7,
	ULP1_PAD_PTF8,
	ULP1_PAD_PTF9,
	ULP1_PAD_PTF10,
	ULP1_PAD_PTF11,
	ULP1_PAD_PTF12,
	ULP1_PAD_PTF13,
	ULP1_PAD_PTF14,
	ULP1_PAD_PTF15,
	ULP1_PAD_PTF16,
	ULP1_PAD_PTF17,
	ULP1_PAD_PTF18,
	ULP1_PAD_PTF19,
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imx7ulp_pinctrl_pads_0[] = {
	IMX_PINCTRL_PIN(ULP1_PAD_PTA0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA12),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA13),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA14),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA15),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA16),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA17),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA18),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA19),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA20),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA21),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA22),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA23),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA24),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA25),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA26),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA27),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA28),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA29),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA30),
	IMX_PINCTRL_PIN(ULP1_PAD_PTA31),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB12),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB13),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB14),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB15),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB16),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB17),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB18),
	IMX_PINCTRL_PIN(ULP1_PAD_PTB19),
};

/* Pad names for the pinmux subsystem */
static const struct pinctrl_pin_desc imx7ulp_pinctrl_pads_1[] = {
	IMX_PINCTRL_PIN(ULP1_PAD_PTC0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC12),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC13),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC14),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC15),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC16),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC17),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC18),
	IMX_PINCTRL_PIN(ULP1_PAD_PTC19),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE0),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE1),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE2),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE3),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE4),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE5),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE6),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE7),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE8),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE9),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE10),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTD11),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE12),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE13),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE14),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE15),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE16),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE17),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE18),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE19),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE20),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE21),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE22),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE23),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE24),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE25),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE26),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE27),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE28),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE29),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE30),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE31),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE12),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE13),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE14),
	IMX_PINCTRL_PIN(ULP1_PAD_PTE15),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE32),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE33),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE34),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE35),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE36),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE37),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE38),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE39),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE40),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE41),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE42),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE43),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE44),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE45),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE46),
	IMX_PINCTRL_PIN(ULP1_PAD_RESERVE47),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF0),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF1),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF2),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF3),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF4),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF5),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF6),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF7),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF8),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF9),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF10),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF11),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF12),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF13),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF14),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF15),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF16),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF17),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF18),
	IMX_PINCTRL_PIN(ULP1_PAD_PTF19),
};

#define BM_MUX_MODE		0xf00
#define BP_MUX_MODE		8

static struct imx_pinctrl_soc_info imx7ulp_pinctrl_info_0 = {
	.pins = imx7ulp_pinctrl_pads_0,
	.npins = ARRAY_SIZE(imx7ulp_pinctrl_pads_0),
	.flags = ZERO_OFFSET_VALID | SHARE_MUX_CONF_REG,
	.mux_mask = BM_MUX_MODE,
	.mux_shift = BP_MUX_MODE,
	.ibe_bit = BIT(16),
	.obe_bit = BIT(17),
};

static struct imx_pinctrl_soc_info imx7ulp_pinctrl_info_1 = {
	.pins = imx7ulp_pinctrl_pads_1,
	.npins = ARRAY_SIZE(imx7ulp_pinctrl_pads_1),
	.flags = ZERO_OFFSET_VALID | SHARE_MUX_CONF_REG,
	.mux_mask = BM_MUX_MODE,
	.mux_shift = BP_MUX_MODE,
	.ibe_bit = BIT(16),
	.obe_bit = BIT(17),
};

static struct of_device_id imx7ulp_pinctrl_of_match[] = {
	{ .compatible = "fsl,imx7ulp-iomuxc-0", .data = &imx7ulp_pinctrl_info_0 },
	{ .compatible = "fsl,imx7ulp-iomuxc-1", .data = &imx7ulp_pinctrl_info_1,},
	{ /* sentinel */ }
};

static int imx7ulp_pinctrl_probe(struct platform_device *pdev)
{
	const struct of_device_id *match;
	struct imx_pinctrl_soc_info *pinctrl_info;

	match = of_match_device(imx7ulp_pinctrl_of_match, &pdev->dev);

	if (!match)
		return -ENODEV;

	pinctrl_info = (struct imx_pinctrl_soc_info *) match->data;

	return imx_pinctrl_probe(pdev, pinctrl_info);
}

static int __maybe_unused imx7ulp_pinctrl_suspend(struct device *dev)
{
	return imx_pinctrl_suspend(dev);
}

static int __maybe_unused imx7ulp_pinctrl_resume(struct device *dev)
{
	return imx_pinctrl_resume(dev);
}

static const struct dev_pm_ops imx7ulp_pinctrl_pm_ops = {
	SET_LATE_SYSTEM_SLEEP_PM_OPS(imx7ulp_pinctrl_suspend,
		imx7ulp_pinctrl_resume)
};

static struct platform_driver imx7ulp_pinctrl_driver = {
	.driver = {
		.name = "imx7ulp-pinctrl",
		.owner = THIS_MODULE,
		.of_match_table = of_match_ptr(imx7ulp_pinctrl_of_match),
		.pm = &imx7ulp_pinctrl_pm_ops,
	},
	.probe = imx7ulp_pinctrl_probe,
};

static int __init imx7ulp_pinctrl_init(void)
{
	return platform_driver_register(&imx7ulp_pinctrl_driver);
}
arch_initcall(imx7ulp_pinctrl_init);

static void __exit imx7ulp_pinctrl_exit(void)
{
	platform_driver_unregister(&imx7ulp_pinctrl_driver);
}
module_exit(imx7ulp_pinctrl_exit);

MODULE_AUTHOR("Fugang Duan <fugang.duan@nxp.com>");
MODULE_DESCRIPTION("Freescale imx7ulp pinctrl driver");
MODULE_LICENSE("GPL v2");
