/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#ifndef _MTK_BATTERY_TABLE_H
#define _MTK_BATTERY_TABLE_H

#include "mtk_battery.h"

#ifndef _DEA_MODIFY_
#else
#include "mtk_battery_internal.h"
#endif

/* ============================================================
 * define
 * ============================================================
 */

/* Qmax for battery  */
#define Q_MAX_L_CURRENT 0
#define Q_MAX_H_CURRENT 10000

/* multiple battery profile compile options */
/*#define MTK_GET_BATTERY_ID_BY_AUXADC*/


/* if ACTIVE_TABLE == 0 && MULTI_BATTERY == 0
 * load g_FG_PSEUDO100_Tx from dtsi
 */
#define MULTI_BATTERY 0
#define BATTERY_ID_CHANNEL_NUM 1
#define BATTERY_PROFILE_ID 0
#define TOTAL_BATTERY_NUMBER 4

/*
 * if ACTIVE_TABLE == 0 , use DTSI table
 * if ACTIVE_TABLE == x , use .h table
 * ACTIVE_TABLE <= MAX_TABLE
 */
#define ACTIVE_TABLE 0

/*#define MTK_GET_BATTERY_ID_BY_GPIO*/

/* Qmax for battery  */
int g_Q_MAX[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 2946, 2712, 2490, 1965},/*T0*/
	{ 2796, 2851, 2468, 1984},/*T1*/
	{ 2718, 2432, 2310, 1946},/*T2*/
	{ 2535, 1991, 1858, 1873},/*T3*/
	{ 2523, 1960, 1843, 1851},/*T4*/
	{ 2211, 1652, 1533, 1541},/*T5*/
	{ 2201, 1642, 1523, 1531},/*T6*/
	{ 2191, 1632, 1513, 1521},/*T7*/
	{ 2181, 1622, 1503, 1511},/*T8*/
	{ 2171, 1612, 1493, 1501} /*T9*/
};

int g_Q_MAX_H_CURRENT[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 2646, 2412, 2190, 1665},/*T0*/
	{ 2496, 2551, 2168, 1684},/*T1*/
	{ 2418, 2132, 2010, 1646},/*T2*/
	{ 2235, 1691, 1558, 1573},/*T3*/
	{ 2223, 1660, 1543, 1551},/*T4*/
	{ 2210, 1650, 1533, 1541},/*T5*/
	{ 2200, 1640, 1523, 1531},/*T6*/
	{ 2190, 1630, 1513, 1521},/*T7*/
	{ 2180, 1620, 1503, 1511},/*T8*/
	{ 2170, 1610, 1493, 1501} /*T9*/
};

int g_Q_MAX_SYS_VOLTAGE[TOTAL_BATTERY_NUMBER] = { 3400, 3400, 3400, 3400};

/* 0~0.5V for battery 0, 0.5~1V for battery 1*/
/* 1~1.5V for battery 2, -1 for the last one (battery 3) */
int g_battery_id_voltage[TOTAL_BATTERY_NUMBER] = {
	500000, 1000000, 1500000, -1};

int g_FG_PSEUDO1[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 5, 6, 7, 8},/*T0*/
	{ 9, 10, 11, 12},/*T1*/
	{ 13, 14, 15, 16},/*T2*/
	{ 17, 18, 19, 20},/*T3*/
	{ 21, 22, 23, 24},/*T4*/
	{ 23, 22, 21, 20},/*T5*/
	{ 19, 18, 17, 16},/*T6*/
	{ 15, 14, 13, 12},/*T7*/
	{ 11, 10, 11, 12},/*T8*/
	{ 13, 14, 15, 16} /*T9*/
};

int g_FG_PSEUDO100[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{ 98, 98, 98, 97},/*T0*/
	{ 95, 95, 94, 93},/*T1*/
	{ 90, 90, 90, 89},/*T2*/
	{ 80, 80, 86, 85},/*T3*/
	{ 80, 80, 82, 81},/*T4*/
	{ 82, 83, 84, 85},/*T5*/
	{ 84, 83, 82, 81},/*T6*/
	{ 82, 83, 84, 85},/*T7*/
	{ 84, 83, 82, 81},/*T8*/
	{ 82, 83, 84, 85} /*T9*/
};

/* shutdown_hl_zcv */
int g_SHUTDOWN_HL_ZCV[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{3400, 3410, 3420, 3430},/*T0*/
	{3450, 3460, 3470, 3480},/*T1*/
	{3500, 3510, 3520, 3530},/*T2*/
	{3550, 3460, 3470, 3480},/*T3*/
	{3600, 3610, 3620, 3630},/*T4*/
	{3601, 3611, 3621, 3631},/*T5*/
	{3602, 3612, 3622, 3632},/*T6*/
	{3603, 3613, 3623, 3633},/*T7*/
	{3604, 3614, 3624, 3634},/*T8*/
	{3605, 3615, 3625, 3635} /*T9*/
};

/* g_FG_PSEUDO1_OFFSET */
int g_FG_PSEUDO1_OFFSET[TOTAL_BATTERY_NUMBER] = {0, 0, 0, 0};

/* pmic_min_vol by temp ,control by MULTI_TEMP_GAUGE0=1, 34000=3.4v */
int g_PMIC_MIN_VOL[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{33500, 33500, 33500, 33500},/*T0*/
	{33500, 33500, 33500, 33500},/*T1*/
	{33500, 33500, 33500, 33500},/*T2*/
	{33500, 33500, 33500, 33500},/*T3*/
	{33500, 33500, 33500, 33500},/*T4*/
	{33001, 33006, 33009, 33004},/*T5*/
	{33002, 33007, 33008, 33003},/*T6*/
	{33003, 33008, 33007, 33002},/*T7*/
	{33004, 33009, 33006, 33001},/*T8*/
	{33005, 33010, 33005, 33000} /*T9*/
};

/* POWERON_SYSTEM_IBOOT by temp ,control by MULTI_TEMP_GAUGE0=1 ,5000 = 500ma*/
int g_PON_SYS_IBOOT[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{5000, 5000, 5000, 5000},/*T0*/
	{5000, 5000, 5000, 5000},/*T1*/
	{5000, 5000, 5000, 5000},/*T2*/
	{5000, 5000, 5000, 5000},/*T3*/
	{5000, 5000, 5000, 5000},/*T4*/
	{5000, 5000, 5000, 5000},/*T5*/
	{5000, 5000, 5000, 5000},/*T6*/
	{5000, 5000, 5000, 5000},/*T7*/
	{5000, 5000, 5000, 5000},/*T8*/
	{5000, 5000, 5000, 5000} /*T9*/
};

/* Q_MAX_SYS_VOLTAGE by temp ,control by MULTI_TEMP_GAUGE0=1, */
int g_QMAX_SYS_VOL[MAX_TABLE][TOTAL_BATTERY_NUMBER] = {
	/*bat1,   bat2,   bat3,    bat4*/
	{33500, 33500, 33500, 33500},/*T0*/
	{33500, 33500, 33500, 33500},/*T1*/
	{33500, 33500, 33500, 33500},/*T2*/
	{33500, 33500, 33500, 33500},/*T3*/
	{33500, 33500, 33500, 33500},/*T4*/
	{33500, 33500, 33500, 33500},/*T5*/
	{33500, 33500, 33500, 33500},/*T6*/
	{33500, 33500, 33500, 33500},/*T7*/
	{33500, 33500, 33500, 33500},/*T8*/
	{33500, 33500, 33500, 33500} /*T9*/
};


#define TEMPERATURE_TB0	255
#define TEMPERATURE_TB1	254

int g_temperature[MAX_TABLE] = {
	25,/*TEMPERATURE_T0*/
	10,/*TEMPERATURE_T1*/
	0,/*TEMPERATURE_T2*/
	-10,/*TEMPERATURE_T3*/
	-20,/*TEMPERATURE_T4*/
	-25,/*TEMPERATURE_T5*/
	-30,/*TEMPERATURE_T6*/
	-35,/*TEMPERATURE_T7*/
	-40,/*TEMPERATURE_T8*/
	-45/*TEMPERATURE_T9*/
};


#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             16900
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900
#endif

#define RBAT_PULL_UP_VOLT          1800

#define BIF_NTC_R 16000

#if (BAT_NTC_10 == 1)
struct FUELGAUGE_TEMPERATURE Fg_Temperature_Table[21] = {
		{-40, 195652},
		{-35, 148171},
		{-30, 113347},
		{-25, 87559},
		{-20, 68237},
		{-15, 53650},
		{-10, 42506},
		{-5, 33892},
		{0, 27219},
		{5, 22021},
		{10, 17926},
		{15, 14674},
		{20, 12081},
		{25, 10000},
		{30, 8315},
		{35, 6948},
		{40, 5834},
		{45, 4917},
		{50, 4161},
		{55, 3535},
		{60, 3014}
};
#endif

#if (BAT_NTC_47 == 1)
struct FUELGAUGE_TEMPERATURE Fg_Temperature_Table[21] = {
		{-40, 1747920},
		{-35, 1245428},
		{-30, 898485},
		{-25, 655802},
		{-20, 483954},
		{-15, 360850},
		{-10, 271697},
		{-5, 206463},
		{0, 158214},
		{5, 122259},
		{10, 95227},
		{15, 74730},
		{20, 59065},
		{25, 47000},
		{30, 37643},
		{35, 30334},
		{40, 24591},
		{45, 20048},
		{50, 16433},
		{55, 13539},
		{60, 11210}
};
#endif



/* ============================================================
 * <DOD, Battery_Voltage> Table
 * ============================================================
 */



/* T0 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t0[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 43370, 1150},
		{341, 43172, 1150},
		{682, 43003, 1150},
		{1024, 42860, 1149},
		{1365, 42717, 1132},
		{1706, 42586, 1135},
		{2047, 42462, 1155},
		{2389, 42332, 1189},
		{2730, 42203, 1189},
		{3071, 42074, 1179},
		{3412, 41952, 1196},
		{3754, 41829, 1200},
		{4095, 41708, 1205},
		{4436, 41592, 1222},
		{4777, 41470, 1211},
		{5119, 41350, 1212},
		{5460, 41234, 1246},
		{5801, 41124, 1265},
		{6142, 41012, 1275},
		{6483, 40896, 1275},
		{6825, 40793, 1340},
		{7166, 40690, 1400},
		{7507, 40588, 1450},
		{7848, 40479, 1467},
		{8190, 40373, 1494},
		{8531, 40271, 1531},
		{8872, 40168, 1599},
		{9213, 40070, 1646},
		{9555, 39976, 1678},
		{9896, 39887, 1695},
		{10237, 39798, 1724},
		{10578, 39710, 1758},
		{10920, 39621, 1792},
		{11261, 39537, 1813},
		{11602, 39447, 1810},
		{11943, 39338, 1759},
		{12284, 39218, 1665},
		{12626, 39092, 1543},
		{12967, 38963, 1390},
		{13308, 38845, 1313},
		{13649, 38744, 1253},
		{13991, 38662, 1201},
		{14332, 38594, 1217},
		{14673, 38529, 1225},
		{15014, 38468, 1225},
		{15356, 38413, 1225},
		{15697, 38362, 1245},
		{16038, 38314, 1273},
		{16379, 38259, 1256},
		{16721, 38214, 1261},
		{17062, 38171, 1278},
		{17403, 38124, 1295},
		{17744, 38081, 1312},
		{18086, 38041, 1329},
		{18427, 38007, 1346},
		{18768, 37968, 1350},
		{19109, 37927, 1350},
		{19450, 37886, 1350},
		{19792, 37845, 1350},
		{20133, 37807, 1357},
		{20474, 37773, 1374},
		{20815, 37731, 1375},
		{21157, 37687, 1375},
		{21498, 37639, 1375},
		{21839, 37584, 1375},
		{22180, 37522, 1346},
		{22522, 37454, 1303},
		{22863, 37393, 1337},
		{23204, 37310, 1329},
		{23545, 37213, 1306},
		{23887, 37111, 1340},
		{24228, 36994, 1314},
		{24569, 36894, 1271},
		{24910, 36866, 1254},
		{25251, 36855, 1289},
		{25593, 36846, 1340},
		{25934, 36832, 1392},
		{26275, 36813, 1500},
		{26616, 36712, 1575},
		{26958, 36473, 1575},
		{27299, 35987, 1652},
		{27640, 35505, 1813},
		{27981, 35061, 2069},
		{28323, 34950, 2358},
		{28664, 34841, 2674},
		{29005, 34712, 3008},
		{29346, 34295, 3196},
		{29688, 33559, 4075},
		{30029, 32534, 6080},
		{30370, 30200, 5900}
	},
	{
		{0, 43390, 1180},
		{336, 43182, 1177},
		{672, 43001, 1175},
		{1009, 42847, 1175},
		{1345, 42709, 1157},
		{1681, 42577, 1150},
		{2017, 42450, 1151},
		{2353, 42329, 1168},
		{2689, 42208, 1185},
		{3026, 42088, 1202},
		{3362, 41974, 1219},
		{3698, 41854, 1214},
		{4034, 41732, 1200},
		{4370, 41617, 1200},
		{4707, 41508, 1211},
		{5043, 41397, 1225},
		{5379, 41276, 1225},
		{5715, 41165, 1225},
		{6051, 41058, 1236},
		{6387, 40955, 1287},
		{6724, 40849, 1325},
		{7060, 40747, 1363},
		{7396, 40659, 1414},
		{7732, 40572, 1451},
		{8068, 40475, 1475},
		{8404, 40354, 1475},
		{8741, 40225, 1475},
		{9077, 40105, 1498},
		{9413, 40004, 1566},
		{9749, 39909, 1604},
		{10085, 39822, 1650},
		{10422, 39748, 1717},
		{10758, 39686, 1770},
		{11094, 39621, 1800},
		{11430, 39547, 1800},
		{11766, 39459, 1800},
		{12102, 39367, 1792},
		{12439, 39273, 1776},
		{12775, 39147, 1661},
		{13111, 39016, 1528},
		{13447, 38881, 1376},
		{13783, 38773, 1308},
		{14120, 38683, 1267},
		{14456, 38609, 1250},
		{14792, 38540, 1233},
		{15128, 38480, 1225},
		{15464, 38426, 1225},
		{15800, 38372, 1225},
		{16137, 38322, 1235},
		{16473, 38275, 1252},
		{16809, 38228, 1268},
		{17145, 38185, 1285},
		{17481, 38144, 1300},
		{17818, 38103, 1300},
		{18154, 38063, 1311},
		{18490, 38023, 1325},
		{18826, 37982, 1325},
		{19162, 37951, 1337},
		{19498, 37922, 1350},
		{19835, 37880, 1350},
		{20171, 37845, 1363},
		{20507, 37813, 1384},
		{20843, 37786, 1417},
		{21179, 37749, 1412},
		{21516, 37709, 1400},
		{21852, 37668, 1400},
		{22188, 37611, 1373},
		{22524, 37547, 1339},
		{22860, 37480, 1305},
		{23196, 37424, 1314},
		{23533, 37356, 1325},
		{23869, 37262, 1325},
		{24205, 37156, 1325},
		{24541, 37045, 1318},
		{24877, 36928, 1301},
		{25213, 36901, 1300},
		{25550, 36887, 1322},
		{25886, 36880, 1373},
		{26222, 36867, 1423},
		{26558, 36847, 1513},
		{26894, 36820, 1648},
		{27231, 36604, 1684},
		{27567, 36235, 1744},
		{27903, 35731, 1837},
		{28239, 35240, 2139},
		{28575, 34883, 2386},
		{28911, 34593, 2629},
		{29248, 33699, 3469},
		{29584, 32440, 8726},
		{29920, 30670, 7125}
	},
	{
		{0, 43430, 1100},
		{283, 43298, 1100},
		{567, 43157, 1056},
		{850, 43023, 1071},
		{1134, 42887, 1055},
		{1417, 42761, 1107},
		{1701, 42625, 1090},
		{1984, 42496, 1091},
		{2268, 42373, 1100},
		{2551, 42250, 1140},
		{2835, 42115, 1150},
		{3118, 41980, 1125},
		{3402, 41857, 1135},
		{3685, 41734, 1159},
		{3969, 41612, 1168},
		{4252, 41489, 1156},
		{4536, 41366, 1175},
		{4819, 41244, 1178},
		{5103, 41128, 1205},
		{5386, 41022, 1249},
		{5670, 40890, 1225},
		{5953, 40786, 1225},
		{6237, 40664, 1225},
		{6520, 40567, 1246},
		{6804, 40453, 1250},
		{7087, 40339, 1250},
		{7371, 40233, 1268},
		{7654, 40122, 1291},
		{7938, 40021, 1315},
		{8221, 39926, 1325},
		{8504, 39841, 1349},
		{8788, 39751, 1375},
		{9071, 39654, 1385},
		{9355, 39572, 1409},
		{9638, 39488, 1425},
		{9922, 39388, 1431},
		{10205, 39302, 1455},
		{10489, 39204, 1468},
		{10772, 39083, 1412},
		{11056, 38933, 1295},
		{11339, 38800, 1200},
		{11623, 38696, 1176},
		{11906, 38619, 1153},
		{12190, 38543, 1129},
		{12473, 38483, 1144},
		{12757, 38419, 1150},
		{13040, 38359, 1150},
		{13324, 38308, 1166},
		{13607, 38260, 1205},
		{13891, 38213, 1238},
		{14174, 38166, 1250},
		{14458, 38119, 1239},
		{14741, 38071, 1234},
		{15025, 38027, 1258},
		{15308, 37987, 1275},
		{15592, 37944, 1280},
		{15875, 37914, 1300},
		{16159, 37877, 1302},
		{16442, 37849, 1326},
		{16726, 37820, 1350},
		{17009, 37783, 1350},
		{17292, 37744, 1327},
		{17576, 37689, 1282},
		{17859, 37608, 1215},
		{18143, 37545, 1200},
		{18426, 37509, 1234},
		{18710, 37475, 1250},
		{18993, 37436, 1265},
		{19277, 37387, 1261},
		{19560, 37335, 1250},
		{19844, 37288, 1250},
		{20127, 37240, 1260},
		{20411, 37183, 1275},
		{20694, 37105, 1275},
		{20978, 37017, 1281},
		{21261, 36913, 1290},
		{21545, 36801, 1250},
		{21828, 36748, 1250},
		{22112, 36730, 1252},
		{22395, 36720, 1299},
		{22679, 36711, 1346},
		{22962, 36692, 1373},
		{23246, 36673, 1396},
		{23529, 36622, 1420},
		{23813, 36417, 1406},
		{24096, 36041, 1486},
		{24380, 35534, 1620},
		{24663, 34847, 1718},
		{24947, 33831, 1858},
		{25230, 32440, 1150}
	},
	{
		{0, 41890, 1400},
		{226, 41777, 1400},
		{451, 41659, 1375},
		{677, 41544, 1376},
		{903, 41439, 1450},
		{1129, 41333, 1450},
		{1354, 41223, 1437},
		{1580, 41110, 1418},
		{1806, 40997, 1400},
		{2032, 40896, 1400},
		{2257, 40792, 1400},
		{2483, 40690, 1392},
		{2709, 40593, 1381},
		{2934, 40510, 1456},
		{3160, 40411, 1432},
		{3386, 40312, 1400},
		{3612, 40222, 1405},
		{3837, 40139, 1462},
		{4063, 40062, 1475},
		{4289, 39984, 1483},
		{4515, 39901, 1502},
		{4740, 39818, 1521},
		{4966, 39741, 1525},
		{5192, 39663, 1517},
		{5418, 39581, 1500},
		{5643, 39503, 1500},
		{5869, 39427, 1500},
		{6095, 39363, 1538},
		{6320, 39307, 1597},
		{6546, 39231, 1578},
		{6772, 39175, 1607},
		{6998, 39111, 1625},
		{7223, 39040, 1636},
		{7449, 38987, 1692},
		{7675, 38902, 1684},
		{7901, 38804, 1645},
		{8126, 38700, 1596},
		{8352, 38602, 1577},
		{8578, 38504, 1509},
		{8803, 38427, 1475},
		{9029, 38367, 1471},
		{9255, 38307, 1452},
		{9481, 38258, 1467},
		{9706, 38208, 1464},
		{9932, 38160, 1450},
		{10158, 38122, 1450},
		{10384, 38092, 1468},
		{10609, 38057, 1487},
		{10835, 38017, 1484},
		{11061, 37972, 1427},
		{11287, 37948, 1443},
		{11512, 37926, 1462},
		{11738, 37899, 1475},
		{11964, 37861, 1475},
		{12189, 37845, 1512},
		{12415, 37825, 1537},
		{12641, 37803, 1550},
		{12867, 37780, 1550},
		{13092, 37750, 1569},
		{13318, 37730, 1587},
		{13544, 37703, 1582},
		{13770, 37650, 1525},
		{13995, 37572, 1486},
		{14221, 37523, 1488},
		{14447, 37486, 1500},
		{14672, 37448, 1499},
		{14898, 37402, 1480},
		{15124, 37357, 1475},
		{15350, 37306, 1453},
		{15575, 37248, 1403},
		{15801, 37218, 1440},
		{16027, 37171, 1464},
		{16253, 37103, 1452},
		{16478, 37014, 1403},
		{16704, 36939, 1441},
		{16930, 36841, 1436},
		{17156, 36767, 1433},
		{17381, 36739, 1450},
		{17607, 36724, 1450},
		{17833, 36708, 1464},
		{18058, 36693, 1483},
		{18284, 36673, 1500},
		{18510, 36628, 1500},
		{18736, 36459, 1500},
		{18961, 36145, 1528},
		{19187, 35672, 1569},
		{19413, 35018, 1531},
		{19639, 34068, 1604},
		{19864, 32770, 1672},
		{20090, 32530, 1375}
	}

};

/* T1 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t1[TOTAL_BATTERY_NUMBER][90] = {
		{
		{0, 43450, 1250},
		{341, 43238, 1250},
		{682, 42961, 1323},
		{1024, 42632, 1473},
		{1365, 42380, 1797},
		{1706, 42171, 2030},
		{2047, 41995, 2184},
		{2389, 41845, 2235},
		{2730, 41714, 2286},
		{3071, 41591, 2329},
		{3412, 41468, 2346},
		{3754, 41350, 2390},
		{4095, 41232, 2425},
		{4436, 41109, 2425},
		{4777, 40998, 2454},
		{5119, 40891, 2488},
		{5460, 40789, 2522},
		{5801, 40704, 2573},
		{6142, 40605, 2608},
		{6483, 40489, 2625},
		{6825, 40345, 2659},
		{7166, 40209, 2694},
		{7507, 40082, 2726},
		{7848, 39987, 2743},
		{8190, 39904, 2781},
		{8531, 39829, 2828},
		{8872, 39752, 2845},
		{9213, 39667, 2850},
		{9555, 39576, 2846},
		{9896, 39481, 2829},
		{10237, 39375, 2785},
		{10578, 39261, 2718},
		{10920, 39138, 2615},
		{11261, 39019, 2526},
		{11602, 38907, 2454},
		{11943, 38805, 2403},
		{12284, 38716, 2351},
		{12626, 38637, 2333},
		{12967, 38569, 2350},
		{13308, 38507, 2350},
		{13649, 38449, 2360},
		{13991, 38393, 2377},
		{14332, 38339, 2394},
		{14673, 38293, 2433},
		{15014, 38251, 2478},
		{15356, 38203, 2495},
		{15697, 38155, 2500},
		{16038, 38111, 2513},
		{16379, 38076, 2566},
		{16721, 38036, 2589},
		{17062, 37998, 2606},
		{17403, 37964, 2623},
		{17744, 37930, 2671},
		{18086, 37898, 2707},
		{18427, 37871, 2724},
		{18768, 37823, 2725},
		{19109, 37778, 2716},
		{19450, 37738, 2702},
		{19792, 37704, 2736},
		{20133, 37666, 2760},
		{20474, 37623, 2775},
		{20815, 37568, 2775},
		{21157, 37505, 2775},
		{21498, 37433, 2778},
		{21839, 37350, 2796},
		{22180, 37252, 2787},
		{22522, 37154, 2775},
		{22863, 37065, 2775},
		{23204, 37016, 2761},
		{23545, 36982, 2781},
		{23887, 36962, 2867},
		{24228, 36948, 2998},
		{24569, 36928, 3181},
		{24910, 36900, 3425},
		{25251, 36763, 3681},
		{25593, 36441, 3754},
		{25934, 35948, 3670},
		{26275, 35347, 3602},
		{26616, 35011, 3781},
		{26958, 34848, 4175},
		{27299, 34691, 4892},
		{27640, 34255, 5689},
		{27981, 33516, 7331},
		{28323, 32126, 10356},
		{28664, 30290, 6100},
		{29005, 30290, 6100},
		{29346, 30290, 6100},
		{29688, 30290, 6100},
		{30029, 30290, 6100},
		{30370, 30290, 6100}
	},
	{
		{0, 43250, 1850},
		{336, 42974, 1850},
		{672, 42757, 1884},
		{1009, 42596, 1950},
		{1345, 42455, 1950},
		{1681, 42321, 1959},
		{2017, 42194, 1976},
		{2353, 42073, 1993},
		{2689, 41948, 1991},
		{3026, 41822, 1979},
		{3362, 41714, 2029},
		{3698, 41599, 2050},
		{4034, 41479, 2052},
		{4370, 41369, 2069},
		{4707, 41256, 2086},
		{5043, 41143, 2108},
		{5379, 41036, 2158},
		{5715, 40932, 2186},
		{6051, 40837, 2212},
		{6387, 40763, 2279},
		{6724, 40679, 2347},
		{7060, 40581, 2397},
		{7396, 40439, 2380},
		{7732, 40289, 2375},
		{8068, 40142, 2383},
		{8404, 40021, 2416},
		{8741, 39925, 2463},
		{9077, 39841, 2513},
		{9413, 39765, 2565},
		{9749, 39685, 2602},
		{10085, 39609, 2636},
		{10422, 39542, 2669},
		{10758, 39469, 2675},
		{11094, 39390, 2658},
		{11430, 39303, 2607},
		{11766, 39198, 2543},
		{12102, 39086, 2457},
		{12439, 38965, 2339},
		{12775, 38856, 2251},
		{13111, 38753, 2173},
		{13447, 38657, 2105},
		{13783, 38581, 2084},
		{14120, 38513, 2075},
		{14456, 38453, 2075},
		{14792, 38392, 2075},
		{15128, 38338, 2091},
		{15464, 38291, 2124},
		{15800, 38250, 2142},
		{16137, 38207, 2158},
		{16473, 38160, 2175},
		{16809, 38113, 2175},
		{17145, 38072, 2201},
		{17481, 38039, 2251},
		{17818, 38012, 2285},
		{18154, 37977, 2310},
		{18490, 37938, 2329},
		{18826, 37911, 2380},
		{19162, 37884, 2420},
		{19498, 37857, 2452},
		{19835, 37830, 2469},
		{20171, 37807, 2496},
		{20507, 37787, 2530},
		{20843, 37767, 2563},
		{21179, 37742, 2586},
		{21516, 37713, 2600},
		{21852, 37673, 2600},
		{22188, 37628, 2600},
		{22524, 37576, 2603},
		{22860, 37502, 2620},
		{23196, 37414, 2637},
		{23533, 37315, 2654},
		{23869, 37201, 2670},
		{24205, 37095, 2687},
		{24541, 37011, 2709},
		{24877, 36977, 2743},
		{25213, 36954, 2816},
		{25550, 36936, 2925},
		{25886, 36923, 3093},
		{26222, 36898, 3383},
		{26558, 36813, 3660},
		{26894, 36604, 3844},
		{27231, 36093, 3931},
		{27567, 35533, 4109},
		{27903, 34995, 4496},
		{28239, 34579, 5186},
		{28575, 33807, 7181},
		{28911, 32371, 10949},
		{29248, 30130, 6000},
		{29584, 30130, 6000},
		{29920, 30130, 6000}
	},
	{
		{0, 43370, 1600},
		{283, 43219, 1600},
		{567, 43085, 1644},
		{850, 42945, 1650},
		{1134, 42807, 1650},
		{1417, 42681, 1669},
		{1701, 42552, 1693},
		{1984, 42419, 1684},
		{2268, 42293, 1690},
		{2551, 42170, 1713},
		{2835, 42040, 1725},
		{3118, 41910, 1737},
		{3402, 41791, 1760},
		{3685, 41671, 1775},
		{3969, 41544, 1782},
		{4252, 41429, 1794},
		{4536, 41308, 1784},
		{4819, 41191, 1822},
		{5103, 41058, 1803},
		{5386, 40954, 1825},
		{5670, 40840, 1825},
		{5953, 40755, 1872},
		{6237, 40652, 1897},
		{6520, 40540, 1900},
		{6804, 40407, 1920},
		{7087, 40282, 1944},
		{7371, 40159, 1968},
		{7654, 40049, 1991},
		{7938, 39945, 2000},
		{8221, 39852, 2013},
		{8504, 39771, 2061},
		{8788, 39690, 2100},
		{9071, 39612, 2120},
		{9355, 39535, 2150},
		{9638, 39441, 2150},
		{9922, 39341, 2138},
		{10205, 39224, 2082},
		{10489, 39090, 1987},
		{10772, 38946, 1895},
		{11056, 38824, 1846},
		{11339, 38720, 1775},
		{11623, 38635, 1728},
		{11906, 38559, 1703},
		{12190, 38500, 1742},
		{12473, 38443, 1750},
		{12757, 38385, 1750},
		{13040, 38335, 1785},
		{13324, 38281, 1800},
		{13607, 38236, 1815},
		{13891, 38193, 1838},
		{14174, 38146, 1862},
		{14458, 38098, 1864},
		{14741, 38058, 1870},
		{15025, 38023, 1891},
		{15308, 37981, 1897},
		{15592, 37953, 1956},
		{15875, 37921, 1975},
		{16159, 37876, 1969},
		{16442, 37848, 1925},
		{16726, 37828, 1925},
		{17009, 37790, 1925},
		{17292, 37771, 1996},
		{17576, 37735, 1978},
		{17859, 37713, 1954},
		{18143, 37679, 1969},
		{18426, 37648, 1975},
		{18710, 37612, 1992},
		{18993, 37568, 2048},
		{19277, 37521, 2134},
		{19560, 37468, 2188},
		{19844, 37416, 2224},
		{20127, 37356, 2239},
		{20411, 37268, 2244},
		{20694, 37169, 2275},
		{20978, 37072, 2260},
		{21261, 36959, 2219},
		{21545, 36886, 2195},
		{21828, 36869, 2185},
		{22112, 36860, 2261},
		{22395, 36859, 2408},
		{22679, 36840, 2549},
		{22962, 36821, 2644},
		{23246, 36785, 2739},
		{23529, 36655, 2812},
		{23813, 36281, 2825},
		{24096, 35762, 2951},
		{24380, 35056, 3241},
		{24663, 34070, 3591},
		{24947, 32900, 2300},
		{25230, 32900, 2300}
	},
	{
		{0, 41890, 1375},
		{226, 41755, 1375},
		{451, 41639, 1400},
		{677, 41531, 1419},
		{903, 41419, 1400},
		{1129, 41306, 1419},
		{1354, 41198, 1425},
		{1580, 41095, 1432},
		{1806, 40997, 1450},
		{2032, 40888, 1450},
		{2257, 40788, 1464},
		{2483, 40693, 1475},
		{2709, 40602, 1478},
		{2934, 40512, 1516},
		{3160, 40416, 1525},
		{3386, 40322, 1525},
		{3612, 40232, 1527},
		{3837, 40149, 1546},
		{4063, 40072, 1564},
		{4289, 39994, 1575},
		{4515, 39910, 1571},
		{4740, 39820, 1533},
		{4966, 39753, 1584},
		{5192, 39686, 1633},
		{5418, 39611, 1650},
		{5643, 39536, 1650},
		{5869, 39466, 1680},
		{6095, 39398, 1709},
		{6320, 39329, 1725},
		{6546, 39269, 1725},
		{6772, 39202, 1757},
		{6998, 39135, 1785},
		{7223, 39068, 1804},
		{7449, 39008, 1822},
		{7675, 38916, 1793},
		{7901, 38814, 1745},
		{8126, 38710, 1685},
		{8352, 38612, 1609},
		{8578, 38514, 1551},
		{8803, 38437, 1515},
		{9029, 38379, 1496},
		{9255, 38326, 1477},
		{9481, 38280, 1492},
		{9706, 38234, 1489},
		{9932, 38186, 1470},
		{10158, 38133, 1451},
		{10384, 38102, 1486},
		{10609, 38067, 1500},
		{10835, 38031, 1500},
		{11061, 38001, 1500},
		{11287, 37978, 1536},
		{11512, 37951, 1550},
		{11738, 37921, 1544},
		{11964, 37891, 1526},
		{12189, 37875, 1562},
		{12415, 37855, 1575},
		{12641, 37835, 1581},
		{12867, 37820, 1600},
		{13092, 37790, 1581},
		{13318, 37775, 1587},
		{13544, 37763, 1600},
		{13770, 37740, 1600},
		{13995, 37717, 1581},
		{14221, 37689, 1562},
		{14447, 37661, 1543},
		{14672, 37638, 1523},
		{14898, 37592, 1485},
		{15124, 37553, 1489},
		{15350, 37512, 1493},
		{15575, 37466, 1476},
		{15801, 37414, 1495},
		{16027, 37367, 1514},
		{16253, 37306, 1517},
		{16478, 37224, 1497},
		{16704, 37149, 1459},
		{16930, 37062, 1492},
		{17156, 36975, 1509},
		{17381, 36899, 1475},
		{17607, 36883, 1475},
		{17833, 36868, 1490},
		{18058, 36856, 1536},
		{18284, 36844, 1597},
		{18510, 36807, 1578},
		{18736, 36726, 1575},
		{18961, 36524, 1603},
		{19187, 36175, 1665},
		{19413, 35656, 1760},
		{19639, 34923, 1869},
		{19864, 33879, 2088},
		{20090, 32560, 1425}
	}

};

/* T2 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t2[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 43430, 1830},
		{341, 43287, 1827},
		{682, 43151, 1843},
		{1024, 43021, 1876},
		{1365, 42884, 1893},
		{1706, 42737, 1921},
		{2047, 42576, 1953},
		{2389, 42371, 1970},
		{2730, 42113, 2131},
		{3071, 41845, 2414},
		{3412, 41613, 2891},
		{3754, 41423, 3277},
		{4095, 41255, 3573},
		{4436, 41109, 3730},
		{4777, 40983, 3795},
		{5119, 40871, 3846},
		{5460, 40776, 3897},
		{5801, 40687, 3980},
		{6142, 40569, 4025},
		{6483, 40418, 4026},
		{6825, 40258, 4078},
		{7166, 40112, 4110},
		{7507, 39980, 4131},
		{7848, 39884, 4182},
		{8190, 39802, 4222},
		{8531, 39725, 4250},
		{8872, 39643, 4250},
		{9213, 39555, 4238},
		{9555, 39460, 4211},
		{9896, 39351, 4160},
		{10237, 39241, 4108},
		{10578, 39130, 4051},
		{10920, 39014, 3983},
		{11261, 38910, 3945},
		{11602, 38812, 3918},
		{11943, 38722, 3900},
		{12284, 38646, 3917},
		{12626, 38578, 3934},
		{12967, 38517, 3953},
		{13308, 38463, 4004},
		{13649, 38408, 4045},
		{13991, 38353, 4079},
		{14332, 38299, 4113},
		{14673, 38253, 4147},
		{15014, 38211, 4185},
		{15356, 38162, 4237},
		{15697, 38114, 4276},
		{16038, 38068, 4310},
		{16379, 38027, 4344},
		{16721, 37986, 4392},
		{17062, 37948, 4443},
		{17403, 37914, 4494},
		{17744, 37867, 4516},
		{18086, 37824, 4548},
		{18427, 37790, 4600},
		{18768, 37743, 4617},
		{19109, 37695, 4661},
		{19450, 37646, 4727},
		{19792, 37585, 4761},
		{20133, 37523, 4806},
		{20474, 37459, 4861},
		{20815, 37391, 4929},
		{21157, 37308, 4950},
		{21498, 37224, 4962},
		{21839, 37156, 5013},
		{22180, 37104, 5090},
		{22522, 37060, 5197},
		{22863, 37025, 5353},
		{23204, 36996, 5596},
		{23545, 36966, 5899},
		{23887, 36932, 6274},
		{24228, 36828, 6634},
		{24569, 36621, 6889},
		{24910, 36300, 7025},
		{25251, 35743, 6920},
		{25593, 35261, 6962},
		{25934, 34860, 7193},
		{26275, 34662, 8132},
		{26616, 34213, 9319},
		{26958, 33489, 10826},
		{27299, 31877, 9783},
		{27640, 30900, 7375},
		{27981, 30900, 7375},
		{28323, 30900, 7375},
		{28664, 30900, 7375},
		{29005, 30900, 7375},
		{29346, 30900, 7375},
		{29688, 30900, 7375},
		{30029, 30900, 7375},
		{30370, 30900, 7375}
	},
	{
		{0, 43220, 2780},
		{336, 42864, 2777},
		{672, 42576, 2870},
		{1009, 42356, 3052},
		{1345, 42201, 3119},
		{1681, 42058, 3159},
		{2017, 41924, 3177},
		{2353, 41803, 3210},
		{2689, 41682, 3234},
		{3026, 41561, 3254},
		{3362, 41444, 3305},
		{3698, 41329, 3335},
		{4034, 41216, 3354},
		{4370, 41108, 3388},
		{4707, 41001, 3422},
		{5043, 40898, 3463},
		{5379, 40824, 3547},
		{5715, 40746, 3654},
		{6051, 40656, 3753},
		{6387, 40521, 3770},
		{6724, 40363, 3763},
		{7060, 40201, 3750},
		{7396, 40059, 3750},
		{7732, 39943, 3774},
		{8068, 39841, 3812},
		{8404, 39761, 3862},
		{8741, 39685, 3900},
		{9077, 39611, 3938},
		{9413, 39535, 3990},
		{9749, 39461, 4013},
		{10085, 39378, 4004},
		{10422, 39278, 3937},
		{10758, 39177, 3869},
		{11094, 39074, 3802},
		{11430, 38966, 3735},
		{11766, 38864, 3668},
		{12102, 38768, 3619},
		{12439, 38681, 3602},
		{12775, 38599, 3571},
		{13111, 38524, 3557},
		{13447, 38457, 3573},
		{13783, 38400, 3606},
		{14120, 38349, 3647},
		{14456, 38302, 3698},
		{14792, 38248, 3732},
		{15128, 38204, 3790},
		{15464, 38171, 3874},
		{15800, 38124, 3892},
		{16137, 38080, 3933},
		{16473, 38040, 4001},
		{16809, 38006, 4068},
		{17145, 37976, 4135},
		{17481, 37949, 4202},
		{17818, 37915, 4252},
		{18154, 37885, 4312},
		{18490, 37859, 4379},
		{18826, 37839, 4446},
		{19162, 37818, 4523},
		{19498, 37798, 4606},
		{19835, 37778, 4673},
		{20171, 37758, 4761},
		{20507, 37735, 4864},
		{20843, 37702, 4965},
		{21179, 37655, 5033},
		{21516, 37600, 5092},
		{21852, 37539, 5193},
		{22188, 37461, 5271},
		{22524, 37371, 5338},
		{22860, 37270, 5405},
		{23196, 37179, 5484},
		{23533, 37098, 5579},
		{23869, 37045, 5714},
		{24205, 37005, 5875},
		{24541, 36975, 6082},
		{24877, 36954, 6385},
		{25213, 36918, 6806},
		{25550, 36848, 7260},
		{25886, 36707, 7713},
		{26222, 36348, 8018},
		{26558, 35860, 8287},
		{26894, 35208, 8556},
		{27231, 34775, 9554},
		{27567, 34161, 11119},
		{27903, 33035, 12603},
		{28239, 30790, 7325},
		{28575, 30790, 7325},
		{28911, 30790, 7325},
		{29248, 30790, 7325},
		{29584, 30790, 7325},
		{29920, 30790, 7325}
	},
	{
		{0, 43120, 4500},
		{283, 42893, 4500},
		{567, 42729, 4589},
		{850, 42585, 4683},
		{1134, 42447, 4760},
		{1417, 42306, 4813},
		{1701, 42179, 4860},
		{1984, 42043, 4859},
		{2268, 41913, 4894},
		{2551, 41790, 4965},
		{2835, 41667, 5012},
		{3118, 41542, 5036},
		{3402, 41417, 5080},
		{3685, 41298, 5143},
		{3969, 41184, 5190},
		{4252, 41069, 5225},
		{4536, 40953, 5244},
		{4819, 40870, 5341},
		{5103, 40791, 5456},
		{5386, 40672, 5528},
		{5670, 40540, 5575},
		{5953, 40380, 5599},
		{6237, 40219, 5578},
		{6520, 40083, 5638},
		{6804, 39974, 5689},
		{7087, 39868, 5719},
		{7371, 39777, 5760},
		{7654, 39692, 5807},
		{7938, 39601, 5825},
		{8221, 39512, 5852},
		{8504, 39417, 5887},
		{8788, 39309, 5889},
		{9071, 39194, 5865},
		{9355, 39078, 5850},
		{9638, 38965, 5843},
		{9922, 38854, 5825},
		{10205, 38753, 5830},
		{10489, 38670, 5856},
		{10772, 38595, 5906},
		{11056, 38526, 5978},
		{11339, 38460, 6025},
		{11623, 38403, 6119},
		{11906, 38347, 6192},
		{12190, 38298, 6262},
		{12473, 38251, 6333},
		{12757, 38211, 6458},
		{13040, 38159, 6517},
		{13324, 38114, 6606},
		{13607, 38076, 6694},
		{13891, 38039, 6779},
		{14174, 38001, 6873},
		{14458, 37967, 6957},
		{14741, 37935, 7038},
		{15025, 37903, 7135},
		{15308, 37881, 7229},
		{15592, 37860, 7348},
		{15875, 37854, 7523},
		{16159, 37829, 7654},
		{16442, 37818, 7867},
		{16726, 37790, 8080},
		{17009, 37780, 8324},
		{17292, 37761, 8513},
		{17576, 37733, 8658},
		{17859, 37713, 8841},
		{18143, 37671, 8972},
		{18426, 37631, 9126},
		{18710, 37579, 9278},
		{18993, 37508, 9422},
		{19277, 37439, 9578},
		{19560, 37351, 9717},
		{19844, 37252, 9883},
		{20127, 37158, 10064},
		{20411, 37078, 10224},
		{20694, 37024, 10431},
		{20978, 36981, 10688},
		{21261, 36955, 10989},
		{21545, 36935, 11366},
		{21828, 36906, 11833},
		{22112, 36876, 12189},
		{22395, 36821, 12053},
		{22679, 36711, 11794},
		{22962, 36386, 10993},
		{23246, 34000, 5025},
		{23529, 34000, 5025},
		{23813, 34000, 5025},
		{24096, 34000, 5025},
		{24380, 34000, 5025},
		{24663, 34000, 5025},
		{24947, 34000, 5025},
		{25230, 34000, 5025}
	},
	{
		{0, 41770, 2275},
		{226, 41620, 2275},
		{451, 41494, 2325},
		{677, 41376, 2369},
		{903, 41249, 2350},
		{1129, 41143, 2388},
		{1354, 41038, 2413},
		{1580, 40938, 2425},
		{1806, 40848, 2425},
		{2032, 40757, 2444},
		{2257, 40662, 2463},
		{2483, 40560, 2489},
		{2709, 40451, 2525},
		{2934, 40338, 2525},
		{3160, 40236, 2553},
		{3386, 40138, 2591},
		{3612, 40042, 2625},
		{3837, 39959, 2625},
		{4063, 39894, 2668},
		{4289, 39834, 2708},
		{4515, 39772, 2727},
		{4740, 39697, 2746},
		{4966, 39621, 2750},
		{5192, 39556, 2784},
		{5418, 39501, 2852},
		{5643, 39426, 2871},
		{5869, 39356, 2860},
		{6095, 39284, 2850},
		{6320, 39207, 2850},
		{6546, 39131, 2850},
		{6772, 39056, 2850},
		{6998, 38973, 2821},
		{7223, 38880, 2761},
		{7449, 38774, 2685},
		{7675, 38676, 2594},
		{7901, 38590, 2550},
		{8126, 38519, 2546},
		{8352, 38467, 2527},
		{8578, 38401, 2509},
		{8803, 38341, 2490},
		{9029, 38290, 2471},
		{9255, 38245, 2452},
		{9481, 38200, 2483},
		{9706, 38159, 2500},
		{9932, 38121, 2496},
		{10158, 38084, 2477},
		{10384, 38059, 2510},
		{10609, 38027, 2537},
		{10835, 37996, 2550},
		{11061, 37981, 2550},
		{11287, 37944, 2550},
		{11512, 37921, 2574},
		{11738, 37903, 2600},
		{11964, 37881, 2600},
		{12189, 37873, 2637},
		{12415, 37855, 2638},
		{12641, 37838, 2637},
		{12867, 37830, 2674},
		{13092, 37815, 2675},
		{13318, 37805, 2700},
		{13544, 37800, 2725},
		{13770, 37800, 2725},
		{13995, 37784, 2725},
		{14221, 37769, 2738},
		{14447, 37748, 2743},
		{14672, 37718, 2723},
		{14898, 37672, 2685},
		{15124, 37633, 2689},
		{15350, 37583, 2685},
		{15575, 37516, 2650},
		{15801, 37456, 2650},
		{16027, 37379, 2650},
		{16253, 37299, 2665},
		{16478, 37223, 2700},
		{16704, 37132, 2700},
		{16930, 37070, 2686},
		{17156, 37030, 2699},
		{17381, 37009, 2752},
		{17607, 36994, 2771},
		{17833, 36978, 2861},
		{18058, 36956, 2993},
		{18284, 36912, 3139},
		{18510, 36791, 3233},
		{18736, 36436, 3265},
		{18961, 35915, 3414},
		{19187, 35218, 3789},
		{19413, 34232, 4636},
		{19639, 33050, 2700},
		{19864, 33050, 2700},
		{20090, 33050, 2700}
	}

};

/* T3 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t3[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 43350, 3000},
		{341, 43200, 3000},
		{682, 43057, 3018},
		{1024, 42921, 3051},
		{1365, 42788, 3069},
		{1706, 42662, 3075},
		{2047, 42540, 3081},
		{2389, 42424, 3115},
		{2730, 42308, 3161},
		{3071, 42191, 3204},
		{3412, 42068, 3221},
		{3754, 41943, 3252},
		{4095, 41819, 3281},
		{4436, 41696, 3298},
		{4777, 41597, 3419},
		{5119, 41482, 3562},
		{5460, 41338, 3716},
		{5801, 41073, 3982},
		{6142, 40801, 4498},
		{6483, 40531, 5276},
		{6825, 40306, 5924},
		{7166, 40096, 6455},
		{7507, 39906, 6865},
		{7848, 39776, 7001},
		{8190, 39664, 7083},
		{8531, 39564, 7144},
		{8872, 39473, 7248},
		{9213, 39374, 7288},
		{9555, 39268, 7291},
		{9896, 39152, 7256},
		{10237, 39041, 7250},
		{10578, 38937, 7256},
		{10920, 38841, 7273},
		{11261, 38752, 7290},
		{11602, 38674, 7329},
		{11943, 38611, 7399},
		{12284, 38543, 7433},
		{12626, 38478, 7494},
		{12967, 38418, 7579},
		{13308, 38370, 7665},
		{13649, 38318, 7740},
		{13991, 38263, 7812},
		{14332, 38208, 7917},
		{14673, 38157, 8008},
		{15014, 38108, 8094},
		{15356, 38054, 8179},
		{15697, 38004, 8277},
		{16038, 37950, 8375},
		{16379, 37882, 8460},
		{16721, 37818, 8561},
		{17062, 37754, 8665},
		{17403, 37685, 8767},
		{17744, 37611, 8854},
		{18086, 37539, 8962},
		{18427, 37471, 9099},
		{18768, 37396, 9201},
		{19109, 37323, 9360},
		{19450, 37254, 9573},
		{19792, 37186, 9829},
		{20133, 37122, 10095},
		{20474, 37060, 10379},
		{20815, 36999, 10720},
		{21157, 36923, 11073},
		{21498, 36823, 11429},
		{21839, 36663, 11778},
		{22180, 36403, 11985},
		{22522, 36056, 12106},
		{22863, 35585, 12123},
		{23204, 35097, 12404},
		{23545, 34613, 13121},
		{23887, 34142, 14435},
		{24228, 33199, 13057},
		{24569, 31910, 10050},
		{24910, 31910, 10050},
		{25251, 31910, 10050},
		{25593, 31910, 10050},
		{25934, 31910, 10050},
		{26275, 31910, 10050},
		{26616, 31910, 10050},
		{26958, 31910, 10050},
		{27299, 31910, 10050},
		{27640, 31910, 10050},
		{27981, 31910, 10050},
		{28323, 31910, 10050},
		{28664, 31910, 10050},
		{29005, 31910, 10050},
		{29346, 31910, 10050},
		{29688, 31910, 10050},
		{30029, 31910, 10050},
		{30370, 31910, 10050}
	},
	{
		{0, 43230, 4750},
		{336, 43048, 4750},
		{672, 42857, 4793},
		{1009, 42654, 4878},
		{1345, 42398, 4978},
		{1681, 42146, 5170},
		{2017, 41900, 5440},
		{2353, 41701, 5731},
		{2689, 41532, 5980},
		{3026, 41386, 6184},
		{3362, 41251, 6268},
		{3698, 41125, 6342},
		{4034, 41008, 6411},
		{4370, 40914, 6495},
		{4707, 40828, 6622},
		{5043, 40740, 6755},
		{5379, 40612, 6789},
		{5715, 40462, 6811},
		{6051, 40301, 6828},
		{6387, 40139, 6845},
		{6724, 39999, 6874},
		{7060, 39876, 6912},
		{7396, 39775, 6962},
		{7732, 39695, 7025},
		{8068, 39617, 7093},
		{8404, 39530, 7160},
		{8741, 39442, 7214},
		{9077, 39353, 7245},
		{9413, 39259, 7228},
		{9749, 39159, 7212},
		{10085, 39058, 7195},
		{10422, 38955, 7177},
		{10758, 38859, 7175},
		{11094, 38768, 7175},
		{11430, 38680, 7175},
		{11766, 38605, 7205},
		{12102, 38531, 7232},
		{12439, 38457, 7248},
		{12775, 38407, 7357},
		{13111, 38355, 7446},
		{13447, 38294, 7497},
		{13783, 38252, 7594},
		{14120, 38206, 7687},
		{14456, 38152, 7771},
		{14792, 38118, 7872},
		{15128, 38081, 7972},
		{15464, 38041, 8073},
		{15800, 38007, 8191},
		{16137, 37977, 8308},
		{16473, 37950, 8426},
		{16809, 37930, 8561},
		{17145, 37909, 8688},
		{17481, 37889, 8810},
		{17818, 37869, 8961},
		{18154, 37845, 9102},
		{18490, 37818, 9240},
		{18826, 37791, 9408},
		{19162, 37756, 9566},
		{19498, 37715, 9717},
		{19835, 37675, 9869},
		{20171, 37626, 10041},
		{20507, 37570, 10216},
		{20843, 37496, 10334},
		{21179, 37422, 10496},
		{21516, 37348, 10681},
		{21852, 37274, 10865},
		{22188, 37209, 11085},
		{22524, 37150, 11336},
		{22860, 37096, 11655},
		{23196, 37047, 12046},
		{23533, 37000, 12495},
		{23869, 36953, 13049},
		{24205, 36867, 13653},
		{24541, 36743, 14259},
		{24877, 36548, 14814},
		{25213, 36226, 15318},
		{25550, 35804, 15796},
		{25886, 35219, 16250},
		{26222, 34662, 16481},
		{26558, 34014, 15057},
		{26894, 32443, 11134},
		{27231, 31780, 9450},
		{27567, 31780, 9450},
		{27903, 31780, 9450},
		{28239, 31780, 9450},
		{28575, 31780, 9450},
		{28911, 31780, 9450},
		{29248, 31780, 9450},
		{29584, 31780, 9450},
		{29920, 31780, 9450}
	},
	{
		{0, 43000, 7425},
		{283, 42802, 7425},
		{567, 42630, 7647},
		{850, 42443, 7800},
		{1134, 42241, 7906},
		{1417, 42026, 8077},
		{1701, 41815, 8336},
		{1984, 41620, 8619},
		{2268, 41455, 8873},
		{2551, 41309, 9042},
		{2835, 41175, 9137},
		{3118, 41059, 9221},
		{3402, 40955, 9295},
		{3685, 40855, 9378},
		{3969, 40754, 9512},
		{4252, 40631, 9612},
		{4536, 40475, 9664},
		{4819, 40296, 9739},
		{5103, 40124, 9841},
		{5386, 39983, 9978},
		{5670, 39860, 10025},
		{5953, 39775, 10167},
		{6237, 39672, 10219},
		{6520, 39593, 10308},
		{6804, 39491, 10325},
		{7087, 39402, 10401},
		{7371, 39303, 10425},
		{7654, 39205, 10441},
		{7938, 39105, 10465},
		{8221, 39001, 10515},
		{8504, 38902, 10574},
		{8788, 38806, 10622},
		{9071, 38718, 10690},
		{9355, 38642, 10776},
		{9638, 38566, 10847},
		{9922, 38496, 10924},
		{10205, 38439, 11018},
		{10489, 38382, 11113},
		{10772, 38326, 11216},
		{11056, 38287, 11355},
		{11339, 38230, 11450},
		{11623, 38183, 11544},
		{11906, 38136, 11661},
		{12190, 38097, 11779},
		{12473, 38067, 11936},
		{12757, 38023, 11994},
		{13040, 37989, 12105},
		{13324, 37961, 12279},
		{13607, 37932, 12409},
		{13891, 37909, 12571},
		{14174, 37890, 12783},
		{14458, 37871, 13010},
		{14741, 37852, 13251},
		{15025, 37833, 13478},
		{15308, 37814, 13698},
		{15592, 37793, 13935},
		{15875, 37766, 14172},
		{16159, 37746, 14365},
		{16442, 37726, 14325},
		{16726, 37703, 14260},
		{17009, 37673, 14207},
		{17292, 37640, 14100},
		{17576, 37618, 14044},
		{17859, 37575, 13950},
		{18143, 37524, 13834},
		{18426, 37428, 13575},
		{18710, 34000, 5050},
		{18993, 34000, 5050},
		{19277, 34000, 5050},
		{19560, 34000, 5050},
		{19844, 34000, 5050},
		{20127, 34000, 5050},
		{20411, 34000, 5050},
		{20694, 34000, 5050},
		{20978, 34000, 5050},
		{21261, 34000, 5050},
		{21545, 34000, 5050},
		{21828, 34000, 5050},
		{22112, 34000, 5050},
		{22395, 34000, 5050},
		{22679, 34000, 5050},
		{22962, 34000, 5050},
		{23246, 34000, 5050},
		{23529, 34000, 5050},
		{23813, 34000, 5050},
		{24096, 34000, 5050},
		{24380, 34000, 5050},
		{24663, 34000, 5050},
		{24947, 34000, 5050},
		{25230, 34000, 5050}
	},
	{
		{0, 41650, 3325},
		{226, 41447, 3325},
		{451, 41269, 3464},
		{677, 41116, 3632},
		{903, 40989, 3726},
		{1129, 40891, 3782},
		{1354, 40793, 3813},
		{1580, 40690, 3838},
		{1806, 40577, 3876},
		{2032, 40452, 3915},
		{2257, 40336, 3953},
		{2483, 40227, 3998},
		{2709, 40122, 4050},
		{2934, 40024, 4050},
		{3160, 39938, 4078},
		{3386, 39864, 4116},
		{3612, 39803, 4152},
		{3837, 39736, 4171},
		{4063, 39668, 4189},
		{4289, 39604, 4216},
		{4515, 39541, 4252},
		{4740, 39458, 4271},
		{4966, 39393, 4304},
		{5192, 39326, 4308},
		{5418, 39250, 4275},
		{5643, 39164, 4275},
		{5869, 39081, 4275},
		{6095, 38990, 4227},
		{6320, 38892, 4137},
		{6546, 38795, 4061},
		{6772, 38710, 4002},
		{6998, 38635, 3985},
		{7223, 38566, 3996},
		{7449, 38490, 3978},
		{7675, 38428, 3926},
		{7901, 38372, 3910},
		{8126, 38322, 3929},
		{8352, 38285, 3948},
		{8578, 38247, 3966},
		{8803, 38201, 3975},
		{9029, 38152, 3975},
		{9255, 38114, 3975},
		{9481, 38083, 4008},
		{9706, 38053, 4047},
		{9932, 38026, 4085},
		{10158, 38011, 4123},
		{10384, 37982, 4143},
		{10609, 37961, 4173},
		{10835, 37941, 4200},
		{11061, 37911, 4200},
		{11287, 37888, 4218},
		{11512, 37875, 4237},
		{11738, 37863, 4250},
		{11964, 37841, 4250},
		{12189, 37833, 4287},
		{12415, 37825, 4336},
		{12641, 37818, 4381},
		{12867, 37810, 4400},
		{13092, 37803, 4456},
		{13318, 37785, 4463},
		{13544, 37760, 4462},
		{13770, 37730, 4500},
		{13995, 37699, 4500},
		{14221, 37663, 4527},
		{14447, 37623, 4557},
		{14672, 37576, 4577},
		{14898, 37509, 4615},
		{15124, 37441, 4639},
		{15350, 37370, 4657},
		{15575, 37294, 4676},
		{15801, 37212, 4695},
		{16027, 37157, 4728},
		{16253, 37115, 4796},
		{16478, 37077, 4908},
		{16704, 37039, 5002},
		{16930, 37019, 5181},
		{17156, 37000, 5451},
		{17381, 36973, 5819},
		{17607, 36895, 6286},
		{17833, 36679, 6756},
		{18058, 36304, 7461},
		{18284, 35764, 8290},
		{18510, 35020, 7601},
		{18736, 33999, 5050},
		{18961, 33990, 5050},
		{19187, 33990, 5050},
		{19413, 33990, 5050},
		{19639, 33990, 5050},
		{19864, 33990, 5050},
		{20090, 33990, 5050}
	}

};

/* T4 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t4[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5304},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11603}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T5 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t5[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5305},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11605}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T6 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t6[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5306},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11606}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T7 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t7[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5307},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11607}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T8 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t8[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5308},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11608}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};

/* T9 */
struct FUELGAUGE_PROFILE_STRUCT fg_profile_t9[TOTAL_BATTERY_NUMBER][90] = {
	{
		{0, 42980, 5309},
		{336, 42832, 5300},
		{673, 42691, 5331},
		{1009, 42556, 5398},
		{1346, 42415, 5485},
		{1682, 42266, 5548},
		{2018, 42112, 5595},
		{2355, 41957, 5682},
		{2691, 41794, 5832},
		{3028, 41626, 6033},
		{3364, 41462, 6278},
		{3700, 41282, 6561},
		{4037, 41093, 6884},
		{4373, 40898, 7298},
		{4710, 40742, 7686},
		{5046, 40606, 8046},
		{5382, 40465, 8353},
		{5719, 40292, 8598},
		{6055, 40111, 8792},
		{6392, 39963, 8879},
		{6728, 39844, 9029},
		{7064, 39739, 9179},
		{7401, 39645, 9246},
		{7737, 39566, 9311},
		{8074, 39487, 9387},
		{8410, 39392, 9497},
		{8747, 39303, 9489},
		{9083, 39210, 9482},
		{9419, 39103, 9569},
		{9756, 38984, 9502},
		{10092, 38869, 9452},
		{10429, 38766, 9541},
		{10765, 38687, 9629},
		{11101, 38611, 9693},
		{11438, 38530, 9715},
		{11774, 38467, 9814},
		{12111, 38406, 9923},
		{12447, 38346, 10032},
		{12783, 38285, 10122},
		{13120, 38230, 10245},
		{13456, 38183, 10420},
		{13793, 38149, 10574},
		{14129, 38109, 10719},
		{14465, 38062, 10850},
		{14802, 38028, 11085},
		{15138, 37991, 11315},
		{15475, 37951, 11534},
		{15811, 37924, 11666},
		{16147, 37893, 11830},
		{16484, 37860, 12028},
		{16820, 37833, 12290},
		{17157, 37798, 12509},
		{17493, 37757, 12691},
		{17829, 37717, 12909},
		{18166, 37680, 13178},
		{18502, 37644, 13475},
		{18839, 37576, 13671},
		{19175, 37517, 13920},
		{19511, 37462, 14186},
		{19848, 37394, 14317},
		{20184, 37323, 14533},
		{20521, 37250, 14798},
		{20857, 37183, 15083},
		{21193, 37124, 15425},
		{21530, 37069, 15800},
		{21866, 37009, 16194},
		{22203, 36962, 16860},
		{22539, 36916, 17637},
		{22876, 36849, 18381},
		{23212, 36719, 19140},
		{23548, 36517, 19837},
		{23885, 36160, 20305},
		{24221, 35626, 20732},
		{24558, 35047, 21203},
		{24894, 34524, 21399},
		{25230, 34044, 19815},
		{25567, 32822, 15920},
		{25903, 31200, 11603},
		{26240, 31200, 11603},
		{26576, 31200, 11603},
		{26912, 31200, 11603},
		{27249, 31200, 11603},
		{27585, 31200, 11603},
		{27922, 31200, 11603},
		{28258, 31200, 11603},
		{28594, 31200, 11603},
		{28931, 31200, 11603},
		{29267, 31200, 11603},
		{29604, 31200, 11603},
		{29940, 31200, 11609}
	},
	{
		{0, 41760, 6890},
		{327, 41633, 5860},
		{653, 41533, 5925},
		{980, 41435, 5883},
		{1307, 41163, 5795},
		{1633, 40827, 6028},
		{1960, 40570, 6370},
		{2286, 40372, 6738},
		{2613, 40157, 7366},
		{2940, 39901, 8336},
		{3266, 39716, 9253},
		{3593, 39559, 9684},
		{3920, 39448, 9911},
		{4246, 39368, 9926},
		{4573, 39283, 10000},
		{4899, 39188, 9902},
		{5226, 39111, 10114},
		{5553, 39047, 10228},
		{5879, 38928, 10045},
		{6206, 38840, 10114},
		{6533, 38745, 10152},
		{6859, 38677, 10156},
		{7186, 38591, 10208},
		{7512, 38535, 10322},
		{7839, 38459, 10370},
		{8166, 38426, 10413},
		{8492, 38363, 10407},
		{8819, 38329, 10461},
		{9146, 38274, 10400},
		{9472, 38206, 10312},
		{9799, 38160, 10482},
		{10126, 38144, 10695},
		{10452, 38078, 10595},
		{10779, 38043, 10687},
		{11105, 38008, 10806},
		{11432, 37982, 10881},
		{11759, 37919, 14515},
		{12085, 37898, 14333},
		{12412, 37874, 15022},
		{12739, 37827, 15669},
		{13065, 37788, 15301},
		{13392, 37753, 11592},
		{13718, 37717, 11216},
		{14045, 37665, 11331},
		{14372, 37618, 11388},
		{14698, 37547, 11671},
		{15025, 37515, 12263},
		{15352, 37426, 12441},
		{15678, 37355, 12574},
		{16005, 37297, 12571},
		{16331, 37230, 12657},
		{16658, 37172, 12987},
		{16985, 37129, 13394},
		{17311, 37064, 13607},
		{17638, 37044, 13702},
		{17965, 36985, 14008},
		{18291, 36927, 13577},
		{18618, 36762, 12896},
		{18944, 36491, 13454},
		{19271, 36057, 13614},
		{19598, 35452, 16709},
		{19924, 34375, 13547},
		{20251, 32882, 16132},
		{20578, 31935, 13264},
		{20904, 30830, 12903},
		{21231, 30830, 12903},
		{21558, 30830, 12903},
		{21884, 30830, 12903},
		{22211, 30830, 12903},
		{22537, 30830, 12903},
		{22864, 30830, 12903},
		{23191, 30830, 12903},
		{23517, 30830, 12903},
		{23844, 30830, 12903},
		{24171, 30830, 12903},
		{24497, 30830, 12903},
		{24824, 30830, 12903},
		{25150, 30830, 12903},
		{25477, 30830, 12903},
		{25804, 30830, 12903},
		{26130, 30830, 12903},
		{26457, 30830, 12903},
		{26784, 30830, 12903},
		{27110, 30830, 12903},
		{27437, 30830, 12903},
		{27763, 30830, 12903},
		{28090, 30830, 12903},
		{28417, 30830, 12903},
		{28743, 30830, 12903},
		{29070, 30830, 12903}
	},
	{
		{0, 42950, 9653},
		{283, 42752, 9653},
		{567, 42580, 9941},
		{850, 42393, 10140},
		{1134, 42191, 10278},
		{1417, 41976, 10500},
		{1701, 41765, 10837},
		{1984, 41570, 11205},
		{2268, 41405, 11535},
		{2551, 41259, 11755},
		{2835, 41125, 11878},
		{3118, 41009, 11987},
		{3402, 40905, 12084},
		{3685, 40805, 12191},
		{3969, 40704, 12366},
		{4252, 40581, 12496},
		{4536, 40425, 12563},
		{4819, 40246, 12661},
		{5103, 40074, 12793},
		{5386, 39933, 12971},
		{5670, 39810, 13033},
		{5953, 39725, 13217},
		{6237, 39622, 13285},
		{6520, 39543, 13400},
		{6804, 39441, 13423},
		{7087, 39352, 13521},
		{7371, 39253, 13553},
		{7654, 39155, 13573},
		{7938, 39055, 13605},
		{8221, 38951, 13670},
		{8504, 38852, 13746},
		{8788, 38756, 13809},
		{9071, 38668, 13897},
		{9355, 38592, 14009},
		{9638, 38516, 14101},
		{9922, 38446, 14201},
		{10205, 38389, 14323},
		{10489, 38332, 14447},
		{10772, 38276, 14581},
		{11056, 38237, 14762},
		{11339, 38180, 14885},
		{11623, 38133, 15007},
		{11906, 38086, 15159},
		{12190, 38047, 15313},
		{12473, 38017, 15517},
		{12757, 37973, 15592},
		{13040, 37939, 15737},
		{13324, 37911, 15963},
		{13607, 37882, 16132},
		{13891, 37859, 16342},
		{14174, 37840, 16618},
		{14458, 37821, 16913},
		{14741, 37802, 17226},
		{15025, 37783, 17521},
		{15308, 37764, 17807},
		{15592, 37743, 18116},
		{15875, 37716, 18424},
		{16159, 37696, 18675},
		{16442, 37676, 18623},
		{16726, 37653, 18538},
		{17009, 37623, 18469},
		{17292, 37590, 18330},
		{17576, 37568, 18257},
		{17859, 37525, 18135},
		{18143, 37474, 17984},
		{18426, 37378, 17648},
		{18710, 33950, 6565},
		{18993, 33950, 6565},
		{19277, 33950, 6565},
		{19560, 33950, 6565},
		{19844, 33950, 6565},
		{20127, 33950, 6565},
		{20411, 33950, 6565},
		{20694, 33950, 6565},
		{20978, 33950, 6565},
		{21261, 33950, 6565},
		{21545, 33950, 6565},
		{21828, 33950, 6565},
		{22112, 33950, 6565},
		{22395, 33950, 6565},
		{22679, 33950, 6565},
		{22962, 33950, 6565},
		{23246, 33950, 6565},
		{23529, 33950, 6565},
		{23813, 33950, 6565},
		{24096, 33950, 6565},
		{24380, 33950, 6565},
		{24663, 33950, 6565},
		{24947, 33950, 6565},
		{25230, 33950, 6565}
	},
	{
		{0, 41600, 4323},
		{226, 41397, 4323},
		{451, 41219, 4503},
		{677, 41066, 4722},
		{903, 40939, 4844},
		{1129, 40841, 4917},
		{1354, 40743, 4957},
		{1580, 40640, 4989},
		{1806, 40527, 5039},
		{2032, 40402, 5090},
		{2257, 40286, 5139},
		{2483, 40177, 5197},
		{2709, 40072, 5265},
		{2934, 39974, 5265},
		{3160, 39888, 5301},
		{3386, 39814, 5351},
		{3612, 39753, 5398},
		{3837, 39686, 5422},
		{4063, 39618, 5446},
		{4289, 39554, 5481},
		{4515, 39491, 5528},
		{4740, 39408, 5552},
		{4966, 39343, 5595},
		{5192, 39276, 5600},
		{5418, 39200, 5558},
		{5643, 39114, 5558},
		{5869, 39031, 5558},
		{6095, 38940, 5495},
		{6320, 38842, 5378},
		{6546, 38745, 5279},
		{6772, 38660, 5203},
		{6998, 38585, 5181},
		{7223, 38516, 5195},
		{7449, 38440, 5171},
		{7675, 38378, 5104},
		{7901, 38322, 5083},
		{8126, 38272, 5108},
		{8352, 38235, 5132},
		{8578, 38197, 5156},
		{8803, 38151, 5168},
		{9029, 38102, 5168},
		{9255, 38064, 5168},
		{9481, 38033, 5210},
		{9706, 38003, 5261},
		{9932, 37976, 5311},
		{10158, 37961, 5360},
		{10384, 37932, 5386},
		{10609, 37911, 5425},
		{10835, 37891, 5460},
		{11061, 37861, 5460},
		{11287, 37838, 5483},
		{11512, 37825, 5508},
		{11738, 37813, 5525},
		{11964, 37791, 5525},
		{12189, 37783, 5573},
		{12415, 37775, 5637},
		{12641, 37768, 5695},
		{12867, 37760, 5720},
		{13092, 37753, 5793},
		{13318, 37735, 5802},
		{13544, 37710, 5801},
		{13770, 37680, 5850},
		{13995, 37649, 5850},
		{14221, 37613, 5885},
		{14447, 37573, 5924},
		{14672, 37526, 5950},
		{14898, 37459, 6000},
		{15124, 37391, 6031},
		{15350, 37320, 6054},
		{15575, 37244, 6079},
		{15801, 37162, 6104},
		{16027, 37107, 6146},
		{16253, 37065, 6235},
		{16478, 37027, 6380},
		{16704, 36989, 6503},
		{16930, 36969, 6735},
		{17156, 36950, 7086},
		{17381, 36923, 7565},
		{17607, 36845, 8172},
		{17833, 36629, 8783},
		{18058, 36254, 9699},
		{18284, 35714, 10777},
		{18510, 34970, 9881},
		{18736, 33949, 6565},
		{18961, 33940, 6565},
		{19187, 33940, 6565},
		{19413, 33940, 6565},
		{19639, 33940, 6565},
		{19864, 33940, 6565},
		{20090, 33940, 6565}
	}

};


/* ============================================================
 * function prototype
 * ============================================================
 */

#endif
