/*
 * drivers/amlogic/media/vout/lcd/lcd_extern/mipi_TL050FHV02CT.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <linux/i2c.h>
#include <linux/amlogic/i2c-amlogic.h>
#include <linux/clk.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/of.h>
#include <linux/amlogic/media/vout/lcd/lcd_extern.h>
#include "lcd_extern.h"

#define LCD_EXTERN_NAME			"mipi_TL050FHV02CT"

/* ******************** mipi command ********************
 * format:  data_type, num, data....
 * special: data_type=0xff, num<0xff means delay ms, num=0xff means ending.
 */
static unsigned char mipi_init_on_table[] = {
	0x29, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x03,
	0x29, 10, 0x90, 0x03, 0x14, 0x09, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00,
	0x29, 10, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x29, 12, 0x92, 0x40, 0x0B, 0x0C, 0x0D, 0x0E, 0x00, 0x38, 0x00, 0x10,
			0x03, 0x04,
	0x29, 9, 0x94, 0x00, 0x08, 0x0B, 0x03, 0xD2, 0x03, 0xD3, 0x0C,
	0x29, 17, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x29, 3, 0x99, 0x00, 0x00,
	0x29, 12, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00,
	0x29, 7, 0x9B, 0x01, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x29, 3, 0x9C, 0x00, 0x00,
	0x29, 9, 0x9D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00,
	0x29, 3, 0x9E, 0x00, 0x00,
	0x29, 11, 0xA0, 0x9F, 0x1F, 0x08, 0x1F, 0x0A, 0x1F, 0x00, 0x1F, 0x14,
			0x1F,
	0x29, 11, 0xA1, 0x15, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xA2, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xA4, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xA5, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x15,
	0x29, 11, 0xA6, 0x1F, 0x14, 0x1F, 0x01, 0x1F, 0x0B, 0x1F, 0x09, 0x1F,
			0x1F,
	0x29, 11, 0xA7, 0x1F, 0x1F, 0x0B, 0x1F, 0x09, 0x1F, 0x01, 0x1F, 0x15,
			0x1F,
	0x29, 11, 0xA8, 0x14, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xA9, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xAB, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x1F,
	0x29, 11, 0xAC, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
			0x14,
	0x29, 11, 0xAD, 0x1F, 0x15, 0x1F, 0x00, 0x1F, 0x08, 0x1F, 0x0A, 0x1F,
			0x1F,
	0x29, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x00,
	0x29, 4, 0xBC, 0x00, 0x00, 0x00,
	0x29, 5, 0xB8, 0x01, 0xAF, 0x8F, 0x8F,
	0x29, 6, 0xF0, 0x55, 0xAA, 0x52, 0x08, 0x01,
	0x29, 17, 0xD1, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xD2, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xD3, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xD4, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 17, 0xD5, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xD6, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xD7, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xD8, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 17, 0xD9, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xDD, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xDE, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xDF, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 17, 0xE0, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xE1, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xE2, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xE3, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 17, 0xE4, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xE5, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xE6, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xE7, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 17, 0xE8, 0x00, 0x00, 0x00, 0x09, 0x00, 0x1F, 0x00, 0x30, 0x00,
			0x3F, 0x00, 0x5D, 0x00, 0x79, 0x00, 0xA7,
	0x29, 17, 0xE9, 0x00, 0xCF, 0x01, 0x12, 0x01, 0x49, 0x01, 0xA1, 0x01,
			0xEB, 0x01, 0xED, 0x02, 0x2F, 0x02, 0x74,
	0x29, 17, 0xEA, 0x02, 0x9F, 0x02, 0xD5, 0x02, 0xFB, 0x03, 0x2C, 0x03,
			0x4B, 0x03, 0x73, 0x03, 0x8C, 0x03, 0xA5,
	0x29, 5, 0xEB, 0x03, 0xC5, 0x03, 0xFF,
	0x29, 4, 0xB0, 0x05, 0x05, 0x05,
	0x29, 4, 0xB1, 0x05, 0x05, 0x05,
	0x29, 4, 0xB3, 0x10, 0x10, 0x10,
	0x29, 4, 0xB4, 0x06, 0x06, 0x06,
	0x29, 4, 0xB6, 0x44, 0x44, 0x44,
	0x29, 4, 0xB7, 0x34, 0x34, 0x34,
	0x29, 4, 0xB8, 0x34, 0x34, 0x34,
	0x29, 4, 0xB9, 0x24, 0x24, 0x24,
	0x29, 4, 0xBA, 0x24, 0x24, 0x24,
	0x29, 4, 0xBC, 0x00, 0x70, 0x00,
	0x29, 4, 0xBD, 0x00, 0x70, 0x00,
	0x23, 2, 0xBE, 0x50,
	0x23, 2, 0x35, 0x00,
	0x13, 1, 0x11,
	0xff, 200,
	0x13, 1, 0x29,
	0xff, 200,
	0xFF, 0xFF,   /* ending flag */
};

static unsigned char mipi_init_off_table[] = {
	0x05, 1, 0x28, /* display off */
	0xff, 10,      /* delay 10ms */
	0x05, 1, 0x10, /* sleep in */
	0xff, 150,      /* delay 150ms */
	0xff, 0xff,   /* ending flag */
};

static int lcd_extern_driver_update(struct aml_lcd_extern_driver_s *ext_drv)
{
	int ret = 0;

	if (ext_drv) {
		ext_drv->config.table_init_on  = &mipi_init_on_table[0];
		ext_drv->config.table_init_off = &mipi_init_off_table[0];
	} else {
		EXTERR("%s driver is null\n", LCD_EXTERN_NAME);
		ret = -1;
	}

	return ret;
}

int aml_lcd_extern_mipi_tl050fhv02ct_probe(
	struct aml_lcd_extern_driver_s *ext_drv)
{
	int ret = 0;

	ret = lcd_extern_driver_update(ext_drv);

	if (lcd_debug_print_flag)
		EXTPR("%s: %d\n", __func__, ret);
	return ret;
}

