/*
 * Copyright (C) 2018 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */
#ifndef __DTS_MT8518_PINFUNC_H
#define __DTS_MT8518_PINFUNC_H

#include <dt-bindings/pinctrl/mt65xx.h>

#define MT8518_PIN_0_NFI_NCEB0__FUNC_GPIO0 (MTK_PIN_NO(0) | 0)
#define MT8518_PIN_0_NFI_NCEB0__FUNC_NCEB0 (MTK_PIN_NO(0) | 1)
#define MT8518_PIN_0_NFI_NCEB0__FUNC_DBG_MON_B_4 (MTK_PIN_NO(0) | 7)

#define MT8518_PIN_1_NFI_NREB__FUNC_GPIO1 (MTK_PIN_NO(1) | 0)
#define MT8518_PIN_1_NFI_NREB__FUNC_NREB (MTK_PIN_NO(1) | 1)
#define MT8518_PIN_1_NFI_NREB__FUNC_DBG_MON_B_5 (MTK_PIN_NO(1) | 7)

#define MT8518_PIN_2_NFI_NRNB__FUNC_GPIO2 (MTK_PIN_NO(2) | 0)
#define MT8518_PIN_2_NFI_NRNB__FUNC_NRNB (MTK_PIN_NO(2) | 1)
#define MT8518_PIN_2_NFI_NRNB__FUNC_MSDC0_DS (MTK_PIN_NO(2) | 2)
#define MT8518_PIN_2_NFI_NRNB__FUNC_DBG_MON_B_6 (MTK_PIN_NO(2) | 7)

#define MT8518_PIN_3_MSDC0_DAT7__FUNC_GPIO3 (MTK_PIN_NO(3) | 0)
#define MT8518_PIN_3_MSDC0_DAT7__FUNC_MSDC0_DAT7 (MTK_PIN_NO(3) | 1)
#define MT8518_PIN_3_MSDC0_DAT7__FUNC_NLD7 (MTK_PIN_NO(3) | 2)
#define MT8518_PIN_3_MSDC0_DAT7__FUNC_DBG_MON_B_23 (MTK_PIN_NO(3) | 7)

#define MT8518_PIN_4_MSDC0_DAT6__FUNC_GPIO4 (MTK_PIN_NO(4) | 0)
#define MT8518_PIN_4_MSDC0_DAT6__FUNC_MSDC0_DAT6 (MTK_PIN_NO(4) | 1)
#define MT8518_PIN_4_MSDC0_DAT6__FUNC_NLD6 (MTK_PIN_NO(4) | 2)
#define MT8518_PIN_4_MSDC0_DAT6__FUNC_DBG_MON_B_24 (MTK_PIN_NO(4) | 7)

#define MT8518_PIN_5_MSDC0_DAT5__FUNC_GPIO5 (MTK_PIN_NO(5) | 0)
#define MT8518_PIN_5_MSDC0_DAT5__FUNC_MSDC0_DAT5 (MTK_PIN_NO(5) | 1)
#define MT8518_PIN_5_MSDC0_DAT5__FUNC_NLD4 (MTK_PIN_NO(5) | 2)
#define MT8518_PIN_5_MSDC0_DAT5__FUNC_DBG_MON_B_25 (MTK_PIN_NO(5) | 7)

#define MT8518_PIN_6_MSDC0_DAT4__FUNC_GPIO6 (MTK_PIN_NO(6) | 0)
#define MT8518_PIN_6_MSDC0_DAT4__FUNC_MSDC0_DAT4 (MTK_PIN_NO(6) | 1)
#define MT8518_PIN_6_MSDC0_DAT4__FUNC_NLD3 (MTK_PIN_NO(6) | 2)
#define MT8518_PIN_6_MSDC0_DAT4__FUNC_DBG_MON_B_26 (MTK_PIN_NO(6) | 7)

#define MT8518_PIN_7_MSDC0_RSTB__FUNC_GPIO7 (MTK_PIN_NO(7) | 0)
#define MT8518_PIN_7_MSDC0_RSTB__FUNC_MSDC0_RSTB (MTK_PIN_NO(7) | 1)
#define MT8518_PIN_7_MSDC0_RSTB__FUNC_NLD0 (MTK_PIN_NO(7) | 2)
#define MT8518_PIN_7_MSDC0_RSTB__FUNC_DBG_MON_B_7 (MTK_PIN_NO(7) | 7)

#define MT8518_PIN_8_MSDC0_CMD__FUNC_GPIO8 (MTK_PIN_NO(8) | 0)
#define MT8518_PIN_8_MSDC0_CMD__FUNC_MSDC0_CMD (MTK_PIN_NO(8) | 1)
#define MT8518_PIN_8_MSDC0_CMD__FUNC_NALE (MTK_PIN_NO(8) | 2)
#define MT8518_PIN_8_MSDC0_CMD__FUNC_DBG_MON_B_27 (MTK_PIN_NO(8) | 7)

#define MT8518_PIN_9_MSDC0_CLK__FUNC_GPIO9 (MTK_PIN_NO(9) | 0)
#define MT8518_PIN_9_MSDC0_CLK__FUNC_MSDC0_CLK (MTK_PIN_NO(9) | 1)
#define MT8518_PIN_9_MSDC0_CLK__FUNC_NWEB (MTK_PIN_NO(9) | 2)
#define MT8518_PIN_9_MSDC0_CLK__FUNC_DBG_MON_B_8 (MTK_PIN_NO(9) | 7)

#define MT8518_PIN_10_MSDC0_DAT3__FUNC_GPIO10 (MTK_PIN_NO(10) | 0)
#define MT8518_PIN_10_MSDC0_DAT3__FUNC_MSDC0_DAT3 (MTK_PIN_NO(10) | 1)
#define MT8518_PIN_10_MSDC0_DAT3__FUNC_NLD1 (MTK_PIN_NO(10) | 2)
#define MT8518_PIN_10_MSDC0_DAT3__FUNC_DBG_MON_B_9 (MTK_PIN_NO(10) | 7)

#define MT8518_PIN_11_MSDC0_DAT2__FUNC_GPIO11 (MTK_PIN_NO(11) | 0)
#define MT8518_PIN_11_MSDC0_DAT2__FUNC_MSDC0_DAT2 (MTK_PIN_NO(11) | 1)
#define MT8518_PIN_11_MSDC0_DAT2__FUNC_NLD5 (MTK_PIN_NO(11) | 2)
#define MT8518_PIN_11_MSDC0_DAT2__FUNC_DBG_MON_B_10 (MTK_PIN_NO(11) | 7)

#define MT8518_PIN_12_MSDC0_DAT1__FUNC_GPIO12 (MTK_PIN_NO(12) | 0)
#define MT8518_PIN_12_MSDC0_DAT1__FUNC_MSDC0_DAT1 (MTK_PIN_NO(12) | 1)
#define MT8518_PIN_12_MSDC0_DAT1__FUNC_NCLE (MTK_PIN_NO(12) | 2)
#define MT8518_PIN_12_MSDC0_DAT1__FUNC_DBG_MON_B_11 (MTK_PIN_NO(12) | 7)

#define MT8518_PIN_13_MSDC0_DAT0__FUNC_GPIO13 (MTK_PIN_NO(13) | 0)
#define MT8518_PIN_13_MSDC0_DAT0__FUNC_MSDC0_DAT0 (MTK_PIN_NO(13) | 1)
#define MT8518_PIN_13_MSDC0_DAT0__FUNC_NLD2 (MTK_PIN_NO(13) | 2)
#define MT8518_PIN_13_MSDC0_DAT0__FUNC_DBG_MON_B_12 (MTK_PIN_NO(13) | 7)

#define MT8518_PIN_14_RTC32K_CK__FUNC_GPIO14 (MTK_PIN_NO(14) | 0)
#define MT8518_PIN_14_RTC32K_CK__FUNC_RTC32K_CK (MTK_PIN_NO(14) | 1)
#define MT8518_PIN_14_RTC32K_CK__FUNC_SPLIN_D3 (MTK_PIN_NO(14) | 2)

#define MT8518_PIN_15_WATCHDOG__FUNC_GPIO15 (MTK_PIN_NO(15) | 0)
#define MT8518_PIN_15_WATCHDOG__FUNC_WATCHDOG (MTK_PIN_NO(15) | 1)

#define MT8518_PIN_16_SUSPEND__FUNC_GPIO16 (MTK_PIN_NO(16) | 0)
#define MT8518_PIN_16_SUSPEND__FUNC_SUSPEND (MTK_PIN_NO(16) | 1)

#define MT8518_PIN_17_JTMS__FUNC_GPIO17 (MTK_PIN_NO(17) | 0)
#define MT8518_PIN_17_JTMS__FUNC_JTMS (MTK_PIN_NO(17) | 1)
#define MT8518_PIN_17_JTMS__FUNC_PCM_SYNC (MTK_PIN_NO(17) | 2)
#define MT8518_PIN_17_JTMS__FUNC_SPI0_CSB (MTK_PIN_NO(17) | 3)
#define MT8518_PIN_17_JTMS__FUNC_DFD_TMS_XI (MTK_PIN_NO(17) | 6)
#define MT8518_PIN_17_JTMS__FUNC_DBG_MON_B_13 (MTK_PIN_NO(17) | 7)

#define MT8518_PIN_18_JTCK__FUNC_GPIO18 (MTK_PIN_NO(18) | 0)
#define MT8518_PIN_18_JTCK__FUNC_JTCK (MTK_PIN_NO(18) | 1)
#define MT8518_PIN_18_JTCK__FUNC_PCM_CLK (MTK_PIN_NO(18) | 2)
#define MT8518_PIN_18_JTCK__FUNC_SPI0_CLK (MTK_PIN_NO(18) | 3)
#define MT8518_PIN_18_JTCK__FUNC_DFD_TCK_XI (MTK_PIN_NO(18) | 6)
#define MT8518_PIN_18_JTCK__FUNC_DBG_MON_B_14 (MTK_PIN_NO(18) | 7)

#define MT8518_PIN_19_JTDI__FUNC_GPIO19 (MTK_PIN_NO(19) | 0)
#define MT8518_PIN_19_JTDI__FUNC_JTDI (MTK_PIN_NO(19) | 1)
#define MT8518_PIN_19_JTDI__FUNC_PCM_RX (MTK_PIN_NO(19) | 2)
#define MT8518_PIN_19_JTDI__FUNC_SPI0_MI (MTK_PIN_NO(19) | 3)
#define MT8518_PIN_19_JTDI__FUNC_DFD_TDI_XI (MTK_PIN_NO(19) | 6)
#define MT8518_PIN_19_JTDI__FUNC_DBG_MON_B_15 (MTK_PIN_NO(19) | 7)

#define MT8518_PIN_20_JTDO__FUNC_GPIO20 (MTK_PIN_NO(20) | 0)
#define MT8518_PIN_20_JTDO__FUNC_JTDO (MTK_PIN_NO(20) | 1)
#define MT8518_PIN_20_JTDO__FUNC_PCM_TX (MTK_PIN_NO(20) | 2)
#define MT8518_PIN_20_JTDO__FUNC_SPI0_MO (MTK_PIN_NO(20) | 3)
#define MT8518_PIN_20_JTDO__FUNC_DFD_TDO (MTK_PIN_NO(20) | 6)
#define MT8518_PIN_20_JTDO__FUNC_DBG_MON_B_16 (MTK_PIN_NO(20) | 7)

#define MT8518_PIN_21_SDA3__FUNC_GPIO21 (MTK_PIN_NO(21) | 0)
#define MT8518_PIN_21_SDA3__FUNC_SDA3_0 (MTK_PIN_NO(21) | 1)

#define MT8518_PIN_22_SCL3__FUNC_GPIO22 (MTK_PIN_NO(22) | 0)
#define MT8518_PIN_22_SCL3__FUNC_SCL3_0 (MTK_PIN_NO(22) | 1)

#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_GPIO23 (MTK_PIN_NO(23) | 0)
#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_PWRAP_SPI0_CK (MTK_PIN_NO(23) | 1)
#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_SPDIF_OUT (MTK_PIN_NO(23) | 2)
#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_CONN_TSF (MTK_PIN_NO(23) | 3)
#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_SPLIN_BCK (MTK_PIN_NO(23) | 6)
#define MT8518_PIN_23_PWRAP_SPI_CLK__FUNC_DBG_MON_B_28 (MTK_PIN_NO(23) | 7)

#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_GPIO24 (MTK_PIN_NO(24) | 0)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_PWRAP_SPI0_CSN (MTK_PIN_NO(24) | 1)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_TDMO_MCLK (MTK_PIN_NO(24) | 2)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_PCM_SYNC (MTK_PIN_NO(24) | 3)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_URXD1 (MTK_PIN_NO(24) | 5)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_SPLIN_LRCK (MTK_PIN_NO(24) | 6)
#define MT8518_PIN_24_PWRAP_SPI_CSN__FUNC_DBG_MON_B_17 (MTK_PIN_NO(24) | 7)

#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_GPIO25 (MTK_PIN_NO(25) | 0)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_PWRAP_SPI0_MO (MTK_PIN_NO(25) | 1)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_TDMO_BCK (MTK_PIN_NO(25) | 2)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_PCM_CLK (MTK_PIN_NO(25) | 3)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_CONN_TSF (MTK_PIN_NO(25) | 4)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_UTXD1 (MTK_PIN_NO(25) | 5)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_SPLIN_D0 (MTK_PIN_NO(25) | 6)
#define MT8518_PIN_25_PWRAP_SPI_MOSI__FUNC_DBG_MON_B_18 (MTK_PIN_NO(25) | 7)

#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_GPIO26 (MTK_PIN_NO(26) | 0)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_PWRAP_SPI0_MI (MTK_PIN_NO(26) | 1)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_TDMO_LRCK (MTK_PIN_NO(26) | 2)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_PCM_RX (MTK_PIN_NO(26) | 3)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_CONN_TSF (MTK_PIN_NO(26) | 4)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_URTS1 (MTK_PIN_NO(26) | 5)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_SPLIN_D1 (MTK_PIN_NO(26) | 6)
#define MT8518_PIN_26_PWRAP_SPI_MISO__FUNC_DBG_MON_B_19 (MTK_PIN_NO(26) | 7)

#define MT8518_PIN_27_PWRAP_INT__FUNC_GPIO27 (MTK_PIN_NO(27) | 0)
#define MT8518_PIN_27_PWRAP_INT__FUNC_TDMO_DO (MTK_PIN_NO(27) | 2)
#define MT8518_PIN_27_PWRAP_INT__FUNC_PCM_TX (MTK_PIN_NO(27) | 3)
#define MT8518_PIN_27_PWRAP_INT__FUNC_UCTS1 (MTK_PIN_NO(27) | 5)
#define MT8518_PIN_27_PWRAP_INT__FUNC_SPLIN_D2 (MTK_PIN_NO(27) | 6)
#define MT8518_PIN_27_PWRAP_INT__FUNC_DBG_MON_B_20 (MTK_PIN_NO(27) | 7)

#define MT8518_PIN_28_EINT22__FUNC_GPIO28 (MTK_PIN_NO(28) | 0)
#define MT8518_PIN_28_EINT22__FUNC_VCORE_SWITCH (MTK_PIN_NO(28) | 1)
#define MT8518_PIN_28_EINT22__FUNC_PWM_A (MTK_PIN_NO(28) | 2)
#define MT8518_PIN_28_EINT22__FUNC_CONN_TSF (MTK_PIN_NO(28) | 3)

#define MT8518_PIN_29_MSDC2_CMD__FUNC_GPIO29 (MTK_PIN_NO(29) | 0)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_MSDC2_CMD (MTK_PIN_NO(29) | 1)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_PWM_A (MTK_PIN_NO(29) | 2)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_SPI0_CSB (MTK_PIN_NO(29) | 3)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_MSDC2_DAT1 (MTK_PIN_NO(29) | 4)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_DBG_SDA (MTK_PIN_NO(29) | 5)
#define MT8518_PIN_29_MSDC2_CMD__FUNC_DBG_MON_A_1 (MTK_PIN_NO(29) | 7)

#define MT8518_PIN_30_MSDC2_CLK__FUNC_GPIO30 (MTK_PIN_NO(30) | 0)
#define MT8518_PIN_30_MSDC2_CLK__FUNC_MSDC2_CLK (MTK_PIN_NO(30) | 1)
#define MT8518_PIN_30_MSDC2_CLK__FUNC_PWM_B (MTK_PIN_NO(30) | 2)
#define MT8518_PIN_30_MSDC2_CLK__FUNC_SPI0_CLK (MTK_PIN_NO(30) | 3)
#define MT8518_PIN_30_MSDC2_CLK__FUNC_DBG_SCL (MTK_PIN_NO(30) | 5)
#define MT8518_PIN_30_MSDC2_CLK__FUNC_DBG_MON_A_2 (MTK_PIN_NO(30) | 7)

#define MT8518_PIN_31_MSDC2_DAT0__FUNC_GPIO31 (MTK_PIN_NO(31) | 0)
#define MT8518_PIN_31_MSDC2_DAT0__FUNC_MSDC2_DAT0 (MTK_PIN_NO(31) | 1)
#define MT8518_PIN_31_MSDC2_DAT0__FUNC_PWM_C (MTK_PIN_NO(31) | 2)
#define MT8518_PIN_31_MSDC2_DAT0__FUNC_SPI0_MI (MTK_PIN_NO(31) | 3)
#define MT8518_PIN_31_MSDC2_DAT0__FUNC_MSDC2_DAT2 (MTK_PIN_NO(31) | 4)
#define MT8518_PIN_31_MSDC2_DAT0__FUNC_DBG_MON_A_3 (MTK_PIN_NO(31) | 7)

#define MT8518_PIN_32_MSDC2_DAT1__FUNC_GPIO32 (MTK_PIN_NO(32) | 0)
#define MT8518_PIN_32_MSDC2_DAT1__FUNC_MSDC2_DAT1 (MTK_PIN_NO(32) | 1)
#define MT8518_PIN_32_MSDC2_DAT1__FUNC_PWM_D (MTK_PIN_NO(32) | 2)
#define MT8518_PIN_32_MSDC2_DAT1__FUNC_SPI0_MO (MTK_PIN_NO(32) | 3)
#define MT8518_PIN_32_MSDC2_DAT1__FUNC_MSDC2_CMD (MTK_PIN_NO(32) | 4)

#define MT8518_PIN_33_MSDC2_DAT2__FUNC_GPIO33 (MTK_PIN_NO(33) | 0)
#define MT8518_PIN_33_MSDC2_DAT2__FUNC_MSDC2_DAT2 (MTK_PIN_NO(33) | 1)
#define MT8518_PIN_33_MSDC2_DAT2__FUNC_MSDC2_DS (MTK_PIN_NO(33) | 4)
#define MT8518_PIN_33_MSDC2_DAT2__FUNC_DBG_MON_A_5 (MTK_PIN_NO(33) | 7)

#define MT8518_PIN_34_MSDC2_DAT3__FUNC_GPIO34 (MTK_PIN_NO(34) | 0)
#define MT8518_PIN_34_MSDC2_DAT3__FUNC_MSDC2_DAT3 (MTK_PIN_NO(34) | 1)
#define MT8518_PIN_34_MSDC2_DAT3__FUNC_MSDC2_DAT0 (MTK_PIN_NO(34) | 4)
#define MT8518_PIN_34_MSDC2_DAT3__FUNC_DBG_MON_A_6 (MTK_PIN_NO(34) | 7)

#define MT8518_PIN_35_MSDC2_DS__FUNC_GPIO35 (MTK_PIN_NO(35) | 0)
#define MT8518_PIN_35_MSDC2_DS__FUNC_MSDC2_DS (MTK_PIN_NO(35) | 1)
#define MT8518_PIN_35_MSDC2_DS__FUNC_CONN_TSF (MTK_PIN_NO(35) | 2)
#define MT8518_PIN_35_MSDC2_DS__FUNC_MSDC2_DAT3 (MTK_PIN_NO(35) | 4)
#define MT8518_PIN_35_MSDC2_DS__FUNC_DBG_MON_A_7 (MTK_PIN_NO(35) | 7)

#define MT8518_PIN_36_EINT0__FUNC_GPIO36 (MTK_PIN_NO(36) | 0)
#define MT8518_PIN_36_EINT0__FUNC_EXT_TXD0 (MTK_PIN_NO(36) | 1)
#define MT8518_PIN_36_EINT0__FUNC_DBI_CSX (MTK_PIN_NO(36) | 2)
#define MT8518_PIN_36_EINT0__FUNC_SPI0_CSB (MTK_PIN_NO(36) | 3)
#define MT8518_PIN_36_EINT0__FUNC_DPI_PCLK (MTK_PIN_NO(36) | 4)
#define MT8518_PIN_36_EINT0__FUNC_CLKM0 (MTK_PIN_NO(36) | 5)
#define MT8518_PIN_36_EINT0__FUNC_SPIS_CSB (MTK_PIN_NO(36) | 6)
#define MT8518_PIN_36_EINT0__FUNC_DBG_MON_A_8 (MTK_PIN_NO(36) | 7)

#define MT8518_PIN_37_EINT1__FUNC_GPIO37 (MTK_PIN_NO(37) | 0)
#define MT8518_PIN_37_EINT1__FUNC_EXT_TXD1 (MTK_PIN_NO(37) | 1)
#define MT8518_PIN_37_EINT1__FUNC_DBI_SCL (MTK_PIN_NO(37) | 2)
#define MT8518_PIN_37_EINT1__FUNC_SPI0_CLK (MTK_PIN_NO(37) | 3)
#define MT8518_PIN_37_EINT1__FUNC_DPI_VSYNC (MTK_PIN_NO(37) | 4)
#define MT8518_PIN_37_EINT1__FUNC_CLKM1 (MTK_PIN_NO(37) | 5)
#define MT8518_PIN_37_EINT1__FUNC_SPIS_CLK (MTK_PIN_NO(37) | 6)
#define MT8518_PIN_37_EINT1__FUNC_DBG_MON_A_9 (MTK_PIN_NO(37) | 7)

#define MT8518_PIN_38_EINT2__FUNC_GPIO38 (MTK_PIN_NO(38) | 0)
#define MT8518_PIN_38_EINT2__FUNC_EXT_TXC (MTK_PIN_NO(38) | 1)
#define MT8518_PIN_38_EINT2__FUNC_DBI_DOUT (MTK_PIN_NO(38) | 2)
#define MT8518_PIN_38_EINT2__FUNC_SPI0_MI (MTK_PIN_NO(38) | 3)
#define MT8518_PIN_38_EINT2__FUNC_DPI_HSYNC (MTK_PIN_NO(38) | 4)
#define MT8518_PIN_38_EINT2__FUNC_CLKM2 (MTK_PIN_NO(38) | 5)
#define MT8518_PIN_38_EINT2__FUNC_SPIS_MI (MTK_PIN_NO(38) | 6)
#define MT8518_PIN_38_EINT2__FUNC_DBG_MON_A_10 (MTK_PIN_NO(38) | 7)

#define MT8518_PIN_39_EINT3__FUNC_GPIO39 (MTK_PIN_NO(39) | 0)
#define MT8518_PIN_39_EINT3__FUNC_EXT_RXER (MTK_PIN_NO(39) | 1)
#define MT8518_PIN_39_EINT3__FUNC_DBI_DIN (MTK_PIN_NO(39) | 2)
#define MT8518_PIN_39_EINT3__FUNC_SPI0_MO (MTK_PIN_NO(39) | 3)
#define MT8518_PIN_39_EINT3__FUNC_DPI_DE (MTK_PIN_NO(39) | 4)
#define MT8518_PIN_39_EINT3__FUNC_CLKM3 (MTK_PIN_NO(39) | 5)
#define MT8518_PIN_39_EINT3__FUNC_SPIS_MO (MTK_PIN_NO(39) | 6)
#define MT8518_PIN_39_EINT3__FUNC_DBG_MON_A_11 (MTK_PIN_NO(39) | 7)

#define MT8518_PIN_40_EINT4__FUNC_GPIO40 (MTK_PIN_NO(40) | 0)
#define MT8518_PIN_40_EINT4__FUNC_EXT_RXC (MTK_PIN_NO(40) | 1)
#define MT8518_PIN_40_EINT4__FUNC_DBI_SDA (MTK_PIN_NO(40) | 2)
#define MT8518_PIN_40_EINT4__FUNC_DPI_DATA0 (MTK_PIN_NO(40) | 4)
#define MT8518_PIN_40_EINT4__FUNC_CLKM4 (MTK_PIN_NO(40) | 5)
#define MT8518_PIN_40_EINT4__FUNC_DBG_MON_A_12 (MTK_PIN_NO(40) | 7)

#define MT8518_PIN_41_EINT5__FUNC_GPIO41 (MTK_PIN_NO(41) | 0)
#define MT8518_PIN_41_EINT5__FUNC_EXT_RXDV (MTK_PIN_NO(41) | 1)
#define MT8518_PIN_41_EINT5__FUNC_DBI_DCX (MTK_PIN_NO(41) | 2)
#define MT8518_PIN_41_EINT5__FUNC_DPI_DATA1 (MTK_PIN_NO(41) | 4)
#define MT8518_PIN_41_EINT5__FUNC_CLKM5 (MTK_PIN_NO(41) | 5)
#define MT8518_PIN_41_EINT5__FUNC_DBG_MON_A_0 (MTK_PIN_NO(41) | 7)

#define MT8518_PIN_42_EINT6__FUNC_GPIO42 (MTK_PIN_NO(42) | 0)
#define MT8518_PIN_42_EINT6__FUNC_EXT_RXD0 (MTK_PIN_NO(42) | 1)
#define MT8518_PIN_42_EINT6__FUNC_DBI_RESX (MTK_PIN_NO(42) | 2)
#define MT8518_PIN_42_EINT6__FUNC_DPI_DATA2 (MTK_PIN_NO(42) | 3)
#define MT8518_PIN_42_EINT6__FUNC_CLKM0 (MTK_PIN_NO(42) | 5)
#define MT8518_PIN_42_EINT6__FUNC_JTRSTB_CM4 (MTK_PIN_NO(42) | 6)
#define MT8518_PIN_42_EINT6__FUNC_DBG_MON_A_14 (MTK_PIN_NO(42) | 7)

#define MT8518_PIN_43_EINT7__FUNC_GPIO43 (MTK_PIN_NO(43) | 0)
#define MT8518_PIN_43_EINT7__FUNC_EXT_RXD1 (MTK_PIN_NO(43) | 1)
#define MT8518_PIN_43_EINT7__FUNC_DBI_TE (MTK_PIN_NO(43) | 2)
#define MT8518_PIN_43_EINT7__FUNC_DPI_DATA3 (MTK_PIN_NO(43) | 3)
#define MT8518_PIN_43_EINT7__FUNC_CLKM1 (MTK_PIN_NO(43) | 5)
#define MT8518_PIN_43_EINT7__FUNC_JTCK_CM4 (MTK_PIN_NO(43) | 6)
#define MT8518_PIN_43_EINT7__FUNC_DBG_MON_A_15 (MTK_PIN_NO(43) | 7)

#define MT8518_PIN_44_EINT8__FUNC_GPIO44 (MTK_PIN_NO(44) | 0)
#define MT8518_PIN_44_EINT8__FUNC_EXT_TXEN (MTK_PIN_NO(44) | 1)
#define MT8518_PIN_44_EINT8__FUNC_DISP_PWM (MTK_PIN_NO(44) | 2)
#define MT8518_PIN_44_EINT8__FUNC_DPI_DATA4 (MTK_PIN_NO(44) | 3)
#define MT8518_PIN_44_EINT8__FUNC_CLKM2 (MTK_PIN_NO(44) | 5)
#define MT8518_PIN_44_EINT8__FUNC_JTMS_CM4 (MTK_PIN_NO(44) | 6)
#define MT8518_PIN_44_EINT8__FUNC_DBG_MON_A_16 (MTK_PIN_NO(44) | 7)

#define MT8518_PIN_45_EINT9__FUNC_GPIO45 (MTK_PIN_NO(45) | 0)
#define MT8518_PIN_45_EINT9__FUNC_EXT_MDIO (MTK_PIN_NO(45) | 1)
#define MT8518_PIN_45_EINT9__FUNC_DPI_DATA5 (MTK_PIN_NO(45) | 2)
#define MT8518_PIN_45_EINT9__FUNC_SDA1_0 (MTK_PIN_NO(45) | 3)
#define MT8518_PIN_45_EINT9__FUNC_CLKM3 (MTK_PIN_NO(45) | 5)
#define MT8518_PIN_45_EINT9__FUNC_JTDI_CM4 (MTK_PIN_NO(45) | 6)
#define MT8518_PIN_45_EINT9__FUNC_DBG_MON_A_17 (MTK_PIN_NO(45) | 7)

#define MT8518_PIN_46_EINT10__FUNC_GPIO46 (MTK_PIN_NO(46) | 0)
#define MT8518_PIN_46_EINT10__FUNC_EXT_MDC (MTK_PIN_NO(46) | 1)
#define MT8518_PIN_46_EINT10__FUNC_DPI_DATA6 (MTK_PIN_NO(46) | 2)
#define MT8518_PIN_46_EINT10__FUNC_SCL1_0 (MTK_PIN_NO(46) | 3)
#define MT8518_PIN_46_EINT10__FUNC_JTDO_CM4 (MTK_PIN_NO(46) | 6)
#define MT8518_PIN_46_EINT10__FUNC_DBG_MON_A_18 (MTK_PIN_NO(46) | 7)

#define MT8518_PIN_47_EINT11__FUNC_GPIO47 (MTK_PIN_NO(47) | 0)
#define MT8518_PIN_47_EINT11__FUNC_IDDIG (MTK_PIN_NO(47) | 1)
#define MT8518_PIN_47_EINT11__FUNC_DPI_DATA7 (MTK_PIN_NO(47) | 2)
#define MT8518_PIN_47_EINT11__FUNC_PWM_A (MTK_PIN_NO(47) | 3)
#define MT8518_PIN_47_EINT11__FUNC_SPLIN_BCK (MTK_PIN_NO(47) | 4)
#define MT8518_PIN_47_EINT11__FUNC_DBG_MON_A_19 (MTK_PIN_NO(47) | 7)

#define MT8518_PIN_48_EINT12__FUNC_GPIO48 (MTK_PIN_NO(48) | 0)
#define MT8518_PIN_48_EINT12__FUNC_PCM_CLK (MTK_PIN_NO(48) | 1)
#define MT8518_PIN_48_EINT12__FUNC_DPI_DATA8 (MTK_PIN_NO(48) | 2)
#define MT8518_PIN_48_EINT12__FUNC_PWM_B (MTK_PIN_NO(48) | 3)
#define MT8518_PIN_48_EINT12__FUNC_SPLIN_LRCK (MTK_PIN_NO(48) | 4)
#define MT8518_PIN_48_EINT12__FUNC_URXD1 (MTK_PIN_NO(48) | 5)
#define MT8518_PIN_48_EINT12__FUNC_DFD_NTRST_XI (MTK_PIN_NO(48) | 6)
#define MT8518_PIN_48_EINT12__FUNC_DBG_MON_B_29 (MTK_PIN_NO(48) | 7)

#define MT8518_PIN_49_EINT13__FUNC_GPIO49 (MTK_PIN_NO(49) | 0)
#define MT8518_PIN_49_EINT13__FUNC_PCM_SYNC (MTK_PIN_NO(49) | 1)
#define MT8518_PIN_49_EINT13__FUNC_DPI_DATA9 (MTK_PIN_NO(49) | 2)
#define MT8518_PIN_49_EINT13__FUNC_DISP_PWM (MTK_PIN_NO(49) | 3)
#define MT8518_PIN_49_EINT13__FUNC_SPLIN_D0 (MTK_PIN_NO(49) | 4)
#define MT8518_PIN_49_EINT13__FUNC_UTXD1 (MTK_PIN_NO(49) | 5)
#define MT8518_PIN_49_EINT13__FUNC_DFD_TMS_XI (MTK_PIN_NO(49) | 6)
#define MT8518_PIN_49_EINT13__FUNC_DBG_MON_B_30 (MTK_PIN_NO(49) | 7)

#define MT8518_PIN_50_EINT14__FUNC_GPIO50 (MTK_PIN_NO(50) | 0)
#define MT8518_PIN_50_EINT14__FUNC_PCM_RX (MTK_PIN_NO(50) | 1)
#define MT8518_PIN_50_EINT14__FUNC_DPI_DATA10 (MTK_PIN_NO(50) | 2)
#define MT8518_PIN_50_EINT14__FUNC_PWM_C (MTK_PIN_NO(50) | 3)
#define MT8518_PIN_50_EINT14__FUNC_SPLIN_D1 (MTK_PIN_NO(50) | 4)
#define MT8518_PIN_50_EINT14__FUNC_URTS1 (MTK_PIN_NO(50) | 5)
#define MT8518_PIN_50_EINT14__FUNC_DFD_TCK_XI (MTK_PIN_NO(50) | 6)

#define MT8518_PIN_51_EINT15__FUNC_GPIO51 (MTK_PIN_NO(51) | 0)
#define MT8518_PIN_51_EINT15__FUNC_PCM_TX (MTK_PIN_NO(51) | 1)
#define MT8518_PIN_51_EINT15__FUNC_DPI_DATA11 (MTK_PIN_NO(51) | 2)
#define MT8518_PIN_51_EINT15__FUNC_PWM_D (MTK_PIN_NO(51) | 3)
#define MT8518_PIN_51_EINT15__FUNC_SPLIN_D2 (MTK_PIN_NO(51) | 4)
#define MT8518_PIN_51_EINT15__FUNC_UCTS1 (MTK_PIN_NO(51) | 5)
#define MT8518_PIN_51_EINT15__FUNC_DFD_TDI_XI (MTK_PIN_NO(51) | 6)

#define MT8518_PIN_52_URXD1__FUNC_GPIO52 (MTK_PIN_NO(52) | 0)
#define MT8518_PIN_52_URXD1__FUNC_URXD1 (MTK_PIN_NO(52) | 1)
#define MT8518_PIN_52_URXD1__FUNC_URXD2 (MTK_PIN_NO(52) | 2)
#define MT8518_PIN_52_URXD1__FUNC_UTXD1 (MTK_PIN_NO(52) | 3)
#define MT8518_PIN_52_URXD1__FUNC_PCM_CLK (MTK_PIN_NO(52) | 6)
#define MT8518_PIN_52_URXD1__FUNC_DBG_MON_B_31 (MTK_PIN_NO(52) | 7)

#define MT8518_PIN_53_UTXD1__FUNC_GPIO53 (MTK_PIN_NO(53) | 0)
#define MT8518_PIN_53_UTXD1__FUNC_UTXD1 (MTK_PIN_NO(53) | 1)
#define MT8518_PIN_53_UTXD1__FUNC_UTXD2 (MTK_PIN_NO(53) | 2)
#define MT8518_PIN_53_UTXD1__FUNC_URXD1 (MTK_PIN_NO(53) | 3)
#define MT8518_PIN_53_UTXD1__FUNC_PCM_SYNC (MTK_PIN_NO(53) | 6)
#define MT8518_PIN_53_UTXD1__FUNC_DBG_MON_A_23 (MTK_PIN_NO(53) | 7)

#define MT8518_PIN_54_URTS1__FUNC_GPIO54 (MTK_PIN_NO(54) | 0)
#define MT8518_PIN_54_URTS1__FUNC_URTS1 (MTK_PIN_NO(54) | 1)
#define MT8518_PIN_54_URTS1__FUNC_URTS2 (MTK_PIN_NO(54) | 2)
#define MT8518_PIN_54_URTS1__FUNC_URXD0 (MTK_PIN_NO(54) | 4)
#define MT8518_PIN_54_URTS1__FUNC_DBG_SDA (MTK_PIN_NO(54) | 5)
#define MT8518_PIN_54_URTS1__FUNC_PCM_RX (MTK_PIN_NO(54) | 6)
#define MT8518_PIN_54_URTS1__FUNC_DBG_MON_A_24 (MTK_PIN_NO(54) | 7)

#define MT8518_PIN_55_UCTS1__FUNC_GPIO55 (MTK_PIN_NO(55) | 0)
#define MT8518_PIN_55_UCTS1__FUNC_UCTS1 (MTK_PIN_NO(55) | 1)
#define MT8518_PIN_55_UCTS1__FUNC_UCTS2 (MTK_PIN_NO(55) | 2)
#define MT8518_PIN_55_UCTS1__FUNC_UTXD0 (MTK_PIN_NO(55) | 4)
#define MT8518_PIN_55_UCTS1__FUNC_DBG_SCL (MTK_PIN_NO(55) | 5)
#define MT8518_PIN_55_UCTS1__FUNC_PCM_TX (MTK_PIN_NO(55) | 6)
#define MT8518_PIN_55_UCTS1__FUNC_DBG_MON_A_25 (MTK_PIN_NO(55) | 7)

#define MT8518_PIN_56_IR__FUNC_GPIO56 (MTK_PIN_NO(56) | 0)
#define MT8518_PIN_56_IR__FUNC_IR (MTK_PIN_NO(56) | 1)
#define MT8518_PIN_56_IR__FUNC_SPLIN_D3 (MTK_PIN_NO(56) | 4)
#define MT8518_PIN_56_IR__FUNC_USB_DRVVBUS (MTK_PIN_NO(56) | 5)
#define MT8518_PIN_56_IR__FUNC_DBG_MON_A_26 (MTK_PIN_NO(56) | 7)

#define MT8518_PIN_57_EINT16__FUNC_GPIO57 (MTK_PIN_NO(57) | 0)
#define MT8518_PIN_57_EINT16__FUNC_USB_DRVVBUS (MTK_PIN_NO(57) | 1)
#define MT8518_PIN_57_EINT16__FUNC_CONN_TSF (MTK_PIN_NO(57) | 2)
#define MT8518_PIN_57_EINT16__FUNC_KPROW2 (MTK_PIN_NO(57) | 3)
#define MT8518_PIN_57_EINT16__FUNC_KPCOL2 (MTK_PIN_NO(57) | 4)
#define MT8518_PIN_57_EINT16__FUNC_CLKM4 (MTK_PIN_NO(57) | 5)
#define MT8518_PIN_57_EINT16__FUNC_DFD_TDO (MTK_PIN_NO(57) | 6)
#define MT8518_PIN_57_EINT16__FUNC_DBG_MON_A_27 (MTK_PIN_NO(57) | 7)

#define MT8518_PIN_58_EINT17__FUNC_GPIO58 (MTK_PIN_NO(58) | 0)
#define MT8518_PIN_58_EINT17__FUNC_IDDIG (MTK_PIN_NO(58) | 1)
#define MT8518_PIN_58_EINT17__FUNC_PCIE_PERST (MTK_PIN_NO(58) | 2)
#define MT8518_PIN_58_EINT17__FUNC_KPCOL2 (MTK_PIN_NO(58) | 3)
#define MT8518_PIN_58_EINT17__FUNC_CLKM5 (MTK_PIN_NO(58) | 5)
#define MT8518_PIN_58_EINT17__FUNC_DBG_MON_A_28 (MTK_PIN_NO(58) | 7)

#define MT8518_PIN_59_EINT18__FUNC_GPIO59 (MTK_PIN_NO(59) | 0)
#define MT8518_PIN_59_EINT18__FUNC_SPDIF_OUT (MTK_PIN_NO(59) | 1)
#define MT8518_PIN_59_EINT18__FUNC_PCIE_WAKE (MTK_PIN_NO(59) | 2)
#define MT8518_PIN_59_EINT18__FUNC_KPROW0 (MTK_PIN_NO(59) | 3)
#define MT8518_PIN_59_EINT18__FUNC_DBG_MON_A_29 (MTK_PIN_NO(59) | 7)

#define MT8518_PIN_60_EINT19__FUNC_GPIO60 (MTK_PIN_NO(60) | 0)
#define MT8518_PIN_60_EINT19__FUNC_AUD_EXTCK2 (MTK_PIN_NO(60) | 1)
#define MT8518_PIN_60_EINT19__FUNC_PCIE_CLKREQ (MTK_PIN_NO(60) | 2)
#define MT8518_PIN_60_EINT19__FUNC_KPROW1 (MTK_PIN_NO(60) | 3)
#define MT8518_PIN_60_EINT19__FUNC_UCTS1 (MTK_PIN_NO(60) | 4)
#define MT8518_PIN_60_EINT19__FUNC_KPCOL1 (MTK_PIN_NO(60) | 5)
#define MT8518_PIN_60_EINT19__FUNC_URTS1 (MTK_PIN_NO(60) | 6)
#define MT8518_PIN_60_EINT19__FUNC_DBG_MON_A_30 (MTK_PIN_NO(60) | 7)

#define MT8518_PIN_61_EINT20__FUNC_GPIO61 (MTK_PIN_NO(61) | 0)
#define MT8518_PIN_61_EINT20__FUNC_USBDL (MTK_PIN_NO(61) | 1)
#define MT8518_PIN_61_EINT20__FUNC_KPCOL0 (MTK_PIN_NO(61) | 3)
#define MT8518_PIN_61_EINT20__FUNC_DBG_MON_A_31 (MTK_PIN_NO(61) | 7)

#define MT8518_PIN_62_EINT21__FUNC_GPIO62 (MTK_PIN_NO(62) | 0)
#define MT8518_PIN_62_EINT21__FUNC_PWM_B (MTK_PIN_NO(62) | 1)
#define MT8518_PIN_62_EINT21__FUNC_VCORE_SWITCH (MTK_PIN_NO(62) | 2)
#define MT8518_PIN_62_EINT21__FUNC_KPCOL1 (MTK_PIN_NO(62) | 3)
#define MT8518_PIN_62_EINT21__FUNC_URTS1 (MTK_PIN_NO(62) | 4)
#define MT8518_PIN_62_EINT21__FUNC_SPDIF_IN_1 (MTK_PIN_NO(62) | 5)
#define MT8518_PIN_62_EINT21__FUNC_UCTS1 (MTK_PIN_NO(62) | 6)
#define MT8518_PIN_62_EINT21__FUNC_DBG_MON_A_13 (MTK_PIN_NO(62) | 7)

#define MT8518_PIN_63_I2SO_MCLK__FUNC_GPIO63 (MTK_PIN_NO(63) | 0)
#define MT8518_PIN_63_I2SO_MCLK__FUNC_I2SO_MCLKA (MTK_PIN_NO(63) | 1)
#define MT8518_PIN_63_I2SO_MCLK__FUNC_TDMO_MCLK (MTK_PIN_NO(63) | 2)
#define MT8518_PIN_63_I2SO_MCLK__FUNC_I2SIN_MCLKA (MTK_PIN_NO(63) | 3)
#define MT8518_PIN_63_I2SO_MCLK__FUNC_AUD_EXTCK1 (MTK_PIN_NO(63) | 4)
#define MT8518_PIN_63_I2SO_MCLK__FUNC_I2SIN_BYPS_MCLKA (MTK_PIN_NO(63) | 5)

#define MT8518_PIN_64_I2SO_BCK__FUNC_GPIO64 (MTK_PIN_NO(64) | 0)
#define MT8518_PIN_64_I2SO_BCK__FUNC_I2SO_BCKA (MTK_PIN_NO(64) | 1)
#define MT8518_PIN_64_I2SO_BCK__FUNC_TDMO_BCK (MTK_PIN_NO(64) | 2)
#define MT8518_PIN_64_I2SO_BCK__FUNC_I2SIN_BCKA (MTK_PIN_NO(64) | 3)
#define MT8518_PIN_64_I2SO_BCK__FUNC_I2SIN_BYPS_BCKA (MTK_PIN_NO(64) | 5)

#define MT8518_PIN_65_I2SO_LRCK__FUNC_GPIO65 (MTK_PIN_NO(65) | 0)
#define MT8518_PIN_65_I2SO_LRCK__FUNC_I2SO_LRCKA (MTK_PIN_NO(65) | 1)
#define MT8518_PIN_65_I2SO_LRCK__FUNC_TDMO_LRCK (MTK_PIN_NO(65) | 2)
#define MT8518_PIN_65_I2SO_LRCK__FUNC_I2SIN_LRCKA (MTK_PIN_NO(65) | 3)
#define MT8518_PIN_65_I2SO_LRCK__FUNC_I2SIN_BYPS_LRCKA (MTK_PIN_NO(65) | 5)

#define MT8518_PIN_66_I2SO_D0__FUNC_GPIO66 (MTK_PIN_NO(66) | 0)
#define MT8518_PIN_66_I2SO_D0__FUNC_I2SO_D0 (MTK_PIN_NO(66) | 1)
#define MT8518_PIN_66_I2SO_D0__FUNC_TDMO_DO (MTK_PIN_NO(66) | 2)
#define MT8518_PIN_66_I2SO_D0__FUNC_I2SIN_D0 (MTK_PIN_NO(66) | 3)
#define MT8518_PIN_66_I2SO_D0__FUNC_I2SIN_BYPS_D0 (MTK_PIN_NO(66) | 5)

#define MT8518_PIN_67_I2SO_D1__FUNC_GPIO67 (MTK_PIN_NO(67) | 0)
#define MT8518_PIN_67_I2SO_D1__FUNC_I2SO_D1 (MTK_PIN_NO(67) | 1)
#define MT8518_PIN_67_I2SO_D1__FUNC_TDMO_DO1 (MTK_PIN_NO(67) | 2)
#define MT8518_PIN_67_I2SO_D1__FUNC_I2SIN_D1 (MTK_PIN_NO(67) | 3)
#define MT8518_PIN_67_I2SO_D1__FUNC_KPROW0 (MTK_PIN_NO(67) | 5)
#define MT8518_PIN_67_I2SO_D1__FUNC_I2SIN_BYPS_D1 (MTK_PIN_NO(67) | 6)

#define MT8518_PIN_68_I2SO_D2__FUNC_GPIO68 (MTK_PIN_NO(68) | 0)
#define MT8518_PIN_68_I2SO_D2__FUNC_I2SO_D2 (MTK_PIN_NO(68) | 1)
#define MT8518_PIN_68_I2SO_D2__FUNC_TDMO_DO2 (MTK_PIN_NO(68) | 2)
#define MT8518_PIN_68_I2SO_D2__FUNC_I2SIN_D2 (MTK_PIN_NO(68) | 3)
#define MT8518_PIN_68_I2SO_D2__FUNC_AUD_EXTCK2 (MTK_PIN_NO(68) | 4)
#define MT8518_PIN_68_I2SO_D2__FUNC_KPROW1 (MTK_PIN_NO(68) | 5)
#define MT8518_PIN_68_I2SO_D2__FUNC_I2SIN_BYPS_D2 (MTK_PIN_NO(68) | 6)

#define MT8518_PIN_69_I2SO_D3__FUNC_GPIO69 (MTK_PIN_NO(69) | 0)
#define MT8518_PIN_69_I2SO_D3__FUNC_I2SO_D3 (MTK_PIN_NO(69) | 1)
#define MT8518_PIN_69_I2SO_D3__FUNC_TDMO_DO3 (MTK_PIN_NO(69) | 2)
#define MT8518_PIN_69_I2SO_D3__FUNC_I2SIN_D3 (MTK_PIN_NO(69) | 3)
#define MT8518_PIN_69_I2SO_D3__FUNC_AUD_EXTCK1 (MTK_PIN_NO(69) | 4)
#define MT8518_PIN_69_I2SO_D3__FUNC_KPCOL0 (MTK_PIN_NO(69) | 5)
#define MT8518_PIN_69_I2SO_D3__FUNC_I2SIN_BYPS_D3 (MTK_PIN_NO(69) | 6)

#define MT8518_PIN_70_SPDIF_IN0__FUNC_GPIO70 (MTK_PIN_NO(70) | 0)
#define MT8518_PIN_70_SPDIF_IN0__FUNC_SPDIF_IN_0 (MTK_PIN_NO(70) | 1)
#define MT8518_PIN_70_SPDIF_IN0__FUNC_SPDIF_IN_1 (MTK_PIN_NO(70) | 2)
#define MT8518_PIN_70_SPDIF_IN0__FUNC_I2SIN_D0 (MTK_PIN_NO(70) | 3)
#define MT8518_PIN_70_SPDIF_IN0__FUNC_USB_DRVVBUS (MTK_PIN_NO(70) | 4)
#define MT8518_PIN_70_SPDIF_IN0__FUNC_KPCOL1 (MTK_PIN_NO(70) | 5)

#define MT8518_PIN_71_DMIC_CLK0__FUNC_GPIO71 (MTK_PIN_NO(71) | 0)
#define MT8518_PIN_71_DMIC_CLK0__FUNC_DMIC_CLK0 (MTK_PIN_NO(71) | 1)
#define MT8518_PIN_71_DMIC_CLK0__FUNC_I2SIN_MCLKA (MTK_PIN_NO(71) | 2)
#define MT8518_PIN_71_DMIC_CLK0__FUNC_SPLIN_BCK (MTK_PIN_NO(71) | 3)
#define MT8518_PIN_71_DMIC_CLK0__FUNC_SPDIF_IN_0 (MTK_PIN_NO(71) | 4)
#define MT8518_PIN_71_DMIC_CLK0__FUNC_TDMO_MCLK (MTK_PIN_NO(71) | 5)

#define MT8518_PIN_72_DMIC_CLK1__FUNC_GPIO72 (MTK_PIN_NO(72) | 0)
#define MT8518_PIN_72_DMIC_CLK1__FUNC_DMIC_CLK1 (MTK_PIN_NO(72) | 1)
#define MT8518_PIN_72_DMIC_CLK1__FUNC_I2SIN_BCKA (MTK_PIN_NO(72) | 2)
#define MT8518_PIN_72_DMIC_CLK1__FUNC_SPLIN_LRCK (MTK_PIN_NO(72) | 3)
#define MT8518_PIN_72_DMIC_CLK1__FUNC_SPDIF_IN_1 (MTK_PIN_NO(72) | 4)
#define MT8518_PIN_72_DMIC_CLK1__FUNC_TDMO_BCK (MTK_PIN_NO(72) | 5)

#define MT8518_PIN_73_DMIC_DAT0__FUNC_GPIO73 (MTK_PIN_NO(73) | 0)
#define MT8518_PIN_73_DMIC_DAT0__FUNC_DMIC_DAT0 (MTK_PIN_NO(73) | 1)
#define MT8518_PIN_73_DMIC_DAT0__FUNC_I2SIN_LRCKA (MTK_PIN_NO(73) | 2)
#define MT8518_PIN_73_DMIC_DAT0__FUNC_SPLIN_D0 (MTK_PIN_NO(73) | 3)
#define MT8518_PIN_73_DMIC_DAT0__FUNC_TDMO_LRCK (MTK_PIN_NO(73) | 5)

#define MT8518_PIN_74_DMIC_DAT1__FUNC_GPIO74 (MTK_PIN_NO(74) | 0)
#define MT8518_PIN_74_DMIC_DAT1__FUNC_DMIC_DAT1 (MTK_PIN_NO(74) | 1)
#define MT8518_PIN_74_DMIC_DAT1__FUNC_SPLIN_D1 (MTK_PIN_NO(74) | 3)
#define MT8518_PIN_74_DMIC_DAT1__FUNC_TDMO_DO (MTK_PIN_NO(74) | 5)
#define MT8518_PIN_74_DMIC_DAT1__FUNC_KPROW2 (MTK_PIN_NO(74) | 6)

#define MT8518_PIN_75_DMIC_DAT2__FUNC_GPIO75 (MTK_PIN_NO(75) | 0)
#define MT8518_PIN_75_DMIC_DAT2__FUNC_DMIC_DAT2 (MTK_PIN_NO(75) | 1)
#define MT8518_PIN_75_DMIC_DAT2__FUNC_SPLIN_D2 (MTK_PIN_NO(75) | 3)
#define MT8518_PIN_75_DMIC_DAT2__FUNC_TDMO_DO1 (MTK_PIN_NO(75) | 5)

#define MT8518_PIN_76_DMIC_DAT3__FUNC_GPIO76 (MTK_PIN_NO(76) | 0)
#define MT8518_PIN_76_DMIC_DAT3__FUNC_DMIC_DAT3 (MTK_PIN_NO(76) | 1)
#define MT8518_PIN_76_DMIC_DAT3__FUNC_SPLIN_D3 (MTK_PIN_NO(76) | 3)
#define MT8518_PIN_76_DMIC_DAT3__FUNC_SPDIF_IN_2 (MTK_PIN_NO(76) | 4)
#define MT8518_PIN_76_DMIC_DAT3__FUNC_TDMO_DO2 (MTK_PIN_NO(76) | 5)
#define MT8518_PIN_76_DMIC_DAT3__FUNC_KPCOL2 (MTK_PIN_NO(76) | 6)

#define MT8518_PIN_77_TDM_MCLK__FUNC_GPIO77 (MTK_PIN_NO(77) | 0)
#define MT8518_PIN_77_TDM_MCLK__FUNC_TDMIN_MCLK (MTK_PIN_NO(77) | 1)
#define MT8518_PIN_77_TDM_MCLK__FUNC_TDMO_MCLK (MTK_PIN_NO(77) | 2)
#define MT8518_PIN_77_TDM_MCLK__FUNC_I2SIN_MCLKA (MTK_PIN_NO(77) | 3)
#define MT8518_PIN_77_TDM_MCLK__FUNC_NOR_IO0 (MTK_PIN_NO(77) | 4)
#define MT8518_PIN_77_TDM_MCLK__FUNC_NAND_IO0 (MTK_PIN_NO(77) | 5)
#define MT8518_PIN_77_TDM_MCLK__FUNC_KPCOL0 (MTK_PIN_NO(77) | 6)
#define MT8518_PIN_77_TDM_MCLK__FUNC_TDMO_DO4 (MTK_PIN_NO(77) | 7)

#define MT8518_PIN_78_TDM_BCK__FUNC_GPIO78 (MTK_PIN_NO(78) | 0)
#define MT8518_PIN_78_TDM_BCK__FUNC_TDMIN_BCK (MTK_PIN_NO(78) | 1)
#define MT8518_PIN_78_TDM_BCK__FUNC_TDMO_BCK (MTK_PIN_NO(78) | 2)
#define MT8518_PIN_78_TDM_BCK__FUNC_I2SIN_BCKA (MTK_PIN_NO(78) | 3)
#define MT8518_PIN_78_TDM_BCK__FUNC_NOR_IO1 (MTK_PIN_NO(78) | 4)
#define MT8518_PIN_78_TDM_BCK__FUNC_NAND_IO1 (MTK_PIN_NO(78) | 5)
#define MT8518_PIN_78_TDM_BCK__FUNC_KPCOL1 (MTK_PIN_NO(78) | 6)
#define MT8518_PIN_78_TDM_BCK__FUNC_TDMO_DO5 (MTK_PIN_NO(78) | 7)

#define MT8518_PIN_79_TDM_LRCK__FUNC_GPIO79 (MTK_PIN_NO(79) | 0)
#define MT8518_PIN_79_TDM_LRCK__FUNC_TDMIN_LRCK (MTK_PIN_NO(79) | 1)
#define MT8518_PIN_79_TDM_LRCK__FUNC_TDMO_LRCK (MTK_PIN_NO(79) | 2)
#define MT8518_PIN_79_TDM_LRCK__FUNC_I2SIN_LRCKA (MTK_PIN_NO(79) | 3)
#define MT8518_PIN_79_TDM_LRCK__FUNC_NOR_IO2 (MTK_PIN_NO(79) | 4)
#define MT8518_PIN_79_TDM_LRCK__FUNC_NAND_IO2 (MTK_PIN_NO(79) | 5)
#define MT8518_PIN_79_TDM_LRCK__FUNC_KPROW0 (MTK_PIN_NO(79) | 6)
#define MT8518_PIN_79_TDM_LRCK__FUNC_TDMO_DO6 (MTK_PIN_NO(79) | 7)

#define MT8518_PIN_80_TDM_DI__FUNC_GPIO80 (MTK_PIN_NO(80) | 0)
#define MT8518_PIN_80_TDM_DI__FUNC_TDMIN_DI (MTK_PIN_NO(80) | 1)
#define MT8518_PIN_80_TDM_DI__FUNC_TDMO_DO (MTK_PIN_NO(80) | 2)
#define MT8518_PIN_80_TDM_DI__FUNC_I2SIN_D0 (MTK_PIN_NO(80) | 3)
#define MT8518_PIN_80_TDM_DI__FUNC_NOR_IO3 (MTK_PIN_NO(80) | 4)
#define MT8518_PIN_80_TDM_DI__FUNC_NAND_IO3 (MTK_PIN_NO(80) | 5)
#define MT8518_PIN_80_TDM_DI__FUNC_KPROW1 (MTK_PIN_NO(80) | 6)
#define MT8518_PIN_80_TDM_DI__FUNC_TDMO_DO7 (MTK_PIN_NO(80) | 7)

#define MT8518_PIN_81_I2SIN_D0__FUNC_GPIO81 (MTK_PIN_NO(81) | 0)
#define MT8518_PIN_81_I2SIN_D0__FUNC_I2SIN_D0 (MTK_PIN_NO(81) | 1)
#define MT8518_PIN_81_I2SIN_D0__FUNC_TDMIN_DI (MTK_PIN_NO(81) | 2)
#define MT8518_PIN_81_I2SIN_D0__FUNC_I2SO_D0 (MTK_PIN_NO(81) | 3)
#define MT8518_PIN_81_I2SIN_D0__FUNC_TDMO_DO (MTK_PIN_NO(81) | 5)
#define MT8518_PIN_81_I2SIN_D0__FUNC_DMIC_DAT4 (MTK_PIN_NO(81) | 6)
#define MT8518_PIN_81_I2SIN_D0__FUNC_SPLIN_D0 (MTK_PIN_NO(81) | 7)

#define MT8518_PIN_82_I2SIN_D1__FUNC_GPIO82 (MTK_PIN_NO(82) | 0)
#define MT8518_PIN_82_I2SIN_D1__FUNC_I2SIN_D1 (MTK_PIN_NO(82) | 1)
#define MT8518_PIN_82_I2SIN_D1__FUNC_I2SO_D1 (MTK_PIN_NO(82) | 3)
#define MT8518_PIN_82_I2SIN_D1__FUNC_PWM_A (MTK_PIN_NO(82) | 4)
#define MT8518_PIN_82_I2SIN_D1__FUNC_TDMO_DO1 (MTK_PIN_NO(82) | 5)
#define MT8518_PIN_82_I2SIN_D1__FUNC_DMIC_DAT5 (MTK_PIN_NO(82) | 6)
#define MT8518_PIN_82_I2SIN_D1__FUNC_SPLIN_D1 (MTK_PIN_NO(82) | 7)

#define MT8518_PIN_83_I2SIN_D2__FUNC_GPIO83 (MTK_PIN_NO(83) | 0)
#define MT8518_PIN_83_I2SIN_D2__FUNC_I2SIN_D2 (MTK_PIN_NO(83) | 1)
#define MT8518_PIN_83_I2SIN_D2__FUNC_NOR_CS (MTK_PIN_NO(83) | 2)
#define MT8518_PIN_83_I2SIN_D2__FUNC_I2SO_D2 (MTK_PIN_NO(83) | 3)
#define MT8518_PIN_83_I2SIN_D2__FUNC_NAND_CS (MTK_PIN_NO(83) | 4)
#define MT8518_PIN_83_I2SIN_D2__FUNC_TDMO_DO2 (MTK_PIN_NO(83) | 5)
#define MT8518_PIN_83_I2SIN_D2__FUNC_DMIC_DAT6 (MTK_PIN_NO(83) | 6)
#define MT8518_PIN_83_I2SIN_D2__FUNC_SPLIN_D2 (MTK_PIN_NO(83) | 7)

#define MT8518_PIN_84_I2SIN_D3__FUNC_GPIO84 (MTK_PIN_NO(84) | 0)
#define MT8518_PIN_84_I2SIN_D3__FUNC_I2SIN_D3 (MTK_PIN_NO(84) | 1)
#define MT8518_PIN_84_I2SIN_D3__FUNC_NOR_CK (MTK_PIN_NO(84) | 2)
#define MT8518_PIN_84_I2SIN_D3__FUNC_I2SO_D3 (MTK_PIN_NO(84) | 3)
#define MT8518_PIN_84_I2SIN_D3__FUNC_NAND_CK (MTK_PIN_NO(84) | 4)
#define MT8518_PIN_84_I2SIN_D3__FUNC_TDMO_DO3 (MTK_PIN_NO(84) | 5)
#define MT8518_PIN_84_I2SIN_D3__FUNC_DMIC_DAT7 (MTK_PIN_NO(84) | 6)
#define MT8518_PIN_84_I2SIN_D3__FUNC_SPLIN_D3 (MTK_PIN_NO(84) | 7)

#define MT8518_PIN_85_I2SIN_MCLK__FUNC_GPIO85 (MTK_PIN_NO(85) | 0)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_I2SIN_MCLKA (MTK_PIN_NO(85) | 1)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_TDMIN_MCLK (MTK_PIN_NO(85) | 2)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_I2SO_MCLKA (MTK_PIN_NO(85) | 3)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_PWM_B (MTK_PIN_NO(85) | 4)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_TDMO_MCLK (MTK_PIN_NO(85) | 5)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_DMIC_CLK2 (MTK_PIN_NO(85) | 6)
#define MT8518_PIN_85_I2SIN_MCLK__FUNC_I2SIN_D1 (MTK_PIN_NO(85) | 7)

#define MT8518_PIN_86_I2SIN_BCK__FUNC_GPIO86 (MTK_PIN_NO(86) | 0)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_I2SIN_BCKA (MTK_PIN_NO(86) | 1)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_TDMIN_BCK (MTK_PIN_NO(86) | 2)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_I2SO_BCKA (MTK_PIN_NO(86) | 3)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_I2SIN_D2 (MTK_PIN_NO(86) | 4)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_TDMO_BCK (MTK_PIN_NO(86) | 5)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_DMIC_CLK3 (MTK_PIN_NO(86) | 6)
#define MT8518_PIN_86_I2SIN_BCK__FUNC_SPLIN_BCK (MTK_PIN_NO(86) | 7)

#define MT8518_PIN_87_I2SIN_LRCK__FUNC_GPIO87 (MTK_PIN_NO(87) | 0)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_I2SIN_LRCKA (MTK_PIN_NO(87) | 1)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_TDMIN_LRCK (MTK_PIN_NO(87) | 2)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_I2SO_LRCKA (MTK_PIN_NO(87) | 3)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_PWM_D (MTK_PIN_NO(87) | 4)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_TDMO_LRCK (MTK_PIN_NO(87) | 5)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_I2SIN_D3 (MTK_PIN_NO(87) | 6)
#define MT8518_PIN_87_I2SIN_LRCK__FUNC_SPLIN_LRCK (MTK_PIN_NO(87) | 7)

#define MT8518_PIN_88_SPI1_CS__FUNC_GPIO88 (MTK_PIN_NO(88) | 0)
#define MT8518_PIN_88_SPI1_CS__FUNC_SPI1_CSB (MTK_PIN_NO(88) | 1)
#define MT8518_PIN_88_SPI1_CS__FUNC_SPDIF_OUT (MTK_PIN_NO(88) | 2)
#define MT8518_PIN_88_SPI1_CS__FUNC_SPIS_CSB (MTK_PIN_NO(88) | 3)
#define MT8518_PIN_88_SPI1_CS__FUNC_PWM_A (MTK_PIN_NO(88) | 5)
#define MT8518_PIN_88_SPI1_CS__FUNC_DFD_NTRST_XI (MTK_PIN_NO(88) | 6)

#define MT8518_PIN_89_SPI1_CK__FUNC_GPIO89 (MTK_PIN_NO(89) | 0)
#define MT8518_PIN_89_SPI1_CK__FUNC_SPI1_CLK (MTK_PIN_NO(89) | 1)
#define MT8518_PIN_89_SPI1_CK__FUNC_SPIS_CLK (MTK_PIN_NO(89) | 3)
#define MT8518_PIN_89_SPI1_CK__FUNC_PWM_B (MTK_PIN_NO(89) | 5)

#define MT8518_PIN_90_SPI1_MI__FUNC_GPIO90 (MTK_PIN_NO(90) | 0)
#define MT8518_PIN_90_SPI1_MI__FUNC_SPI1_MI (MTK_PIN_NO(90) | 1)
#define MT8518_PIN_90_SPI1_MI__FUNC_SPI1_MO (MTK_PIN_NO(90) | 2)
#define MT8518_PIN_90_SPI1_MI__FUNC_SPIS_MI (MTK_PIN_NO(90) | 3)
#define MT8518_PIN_90_SPI1_MI__FUNC_SPIS_MO (MTK_PIN_NO(90) | 4)
#define MT8518_PIN_90_SPI1_MI__FUNC_PWM_C (MTK_PIN_NO(90) | 5)
#define MT8518_PIN_90_SPI1_MI__FUNC_KPROW2 (MTK_PIN_NO(90) | 6)

#define MT8518_PIN_91_SPI1_MO__FUNC_GPIO91 (MTK_PIN_NO(91) | 0)
#define MT8518_PIN_91_SPI1_MO__FUNC_SPI1_MO (MTK_PIN_NO(91) | 1)
#define MT8518_PIN_91_SPI1_MO__FUNC_SPI1_MI (MTK_PIN_NO(91) | 2)
#define MT8518_PIN_91_SPI1_MO__FUNC_SPIS_MO (MTK_PIN_NO(91) | 3)
#define MT8518_PIN_91_SPI1_MO__FUNC_SPIS_MI (MTK_PIN_NO(91) | 4)
#define MT8518_PIN_91_SPI1_MO__FUNC_PWM_D (MTK_PIN_NO(91) | 5)
#define MT8518_PIN_91_SPI1_MO__FUNC_KPCOL2 (MTK_PIN_NO(91) | 6)

#define MT8518_PIN_92_SPI2_CS__FUNC_GPIO92 (MTK_PIN_NO(92) | 0)
#define MT8518_PIN_92_SPI2_CS__FUNC_SPI2_CSB (MTK_PIN_NO(92) | 1)
#define MT8518_PIN_92_SPI2_CS__FUNC_SPIS_CSB (MTK_PIN_NO(92) | 2)
#define MT8518_PIN_92_SPI2_CS__FUNC_URXD1 (MTK_PIN_NO(92) | 3)
#define MT8518_PIN_92_SPI2_CS__FUNC_URXD2 (MTK_PIN_NO(92) | 4)
#define MT8518_PIN_92_SPI2_CS__FUNC_SPDIF_OUT (MTK_PIN_NO(92) | 5)
#define MT8518_PIN_92_SPI2_CS__FUNC_KPROW0 (MTK_PIN_NO(92) | 6)
#define MT8518_PIN_92_SPI2_CS__FUNC_TDMO_DO4 (MTK_PIN_NO(92) | 7)

#define MT8518_PIN_93_SPI2_CK__FUNC_GPIO93 (MTK_PIN_NO(93) | 0)
#define MT8518_PIN_93_SPI2_CK__FUNC_SPI2_CLK (MTK_PIN_NO(93) | 1)
#define MT8518_PIN_93_SPI2_CK__FUNC_SPIS_CLK (MTK_PIN_NO(93) | 2)
#define MT8518_PIN_93_SPI2_CK__FUNC_UTXD1 (MTK_PIN_NO(93) | 3)
#define MT8518_PIN_93_SPI2_CK__FUNC_UTXD2 (MTK_PIN_NO(93) | 4)
#define MT8518_PIN_93_SPI2_CK__FUNC_KPROW1 (MTK_PIN_NO(93) | 6)
#define MT8518_PIN_93_SPI2_CK__FUNC_TDMO_DO5 (MTK_PIN_NO(93) | 7)

#define MT8518_PIN_94_SPI2_MI0__FUNC_GPIO94 (MTK_PIN_NO(94) | 0)
#define MT8518_PIN_94_SPI2_MI0__FUNC_SPI2_MI0 (MTK_PIN_NO(94) | 1)
#define MT8518_PIN_94_SPI2_MI0__FUNC_SPIS_MI (MTK_PIN_NO(94) | 2)
#define MT8518_PIN_94_SPI2_MI0__FUNC_URTS1 (MTK_PIN_NO(94) | 3)
#define MT8518_PIN_94_SPI2_MI0__FUNC_URTS2 (MTK_PIN_NO(94) | 4)
#define MT8518_PIN_94_SPI2_MI0__FUNC_SPI2_MI1 (MTK_PIN_NO(94) | 5)
#define MT8518_PIN_94_SPI2_MI0__FUNC_KPCOL0 (MTK_PIN_NO(94) | 6)
#define MT8518_PIN_94_SPI2_MI0__FUNC_TDMO_DO6 (MTK_PIN_NO(94) | 7)

#define MT8518_PIN_95_SPI2_MI1__FUNC_GPIO95 (MTK_PIN_NO(95) | 0)
#define MT8518_PIN_95_SPI2_MI1__FUNC_SPI2_MI1 (MTK_PIN_NO(95) | 1)
#define MT8518_PIN_95_SPI2_MI1__FUNC_SPIS_MO (MTK_PIN_NO(95) | 2)
#define MT8518_PIN_95_SPI2_MI1__FUNC_UCTS1 (MTK_PIN_NO(95) | 3)
#define MT8518_PIN_95_SPI2_MI1__FUNC_UCTS2 (MTK_PIN_NO(95) | 4)
#define MT8518_PIN_95_SPI2_MI1__FUNC_SPI2_MI0 (MTK_PIN_NO(95) | 5)
#define MT8518_PIN_95_SPI2_MI1__FUNC_KPCOL1 (MTK_PIN_NO(95) | 6)
#define MT8518_PIN_95_SPI2_MI1__FUNC_TDMO_DO7 (MTK_PIN_NO(95) | 7)

#define MT8518_PIN_96_SPI2_MI2__FUNC_GPIO96 (MTK_PIN_NO(96) | 0)
#define MT8518_PIN_96_SPI2_MI2__FUNC_SPI2_MI2 (MTK_PIN_NO(96) | 1)

#define MT8518_PIN_97_SPI2_MI3__FUNC_GPIO97 (MTK_PIN_NO(97) | 0)
#define MT8518_PIN_97_SPI2_MI3__FUNC_SPI2_MI3 (MTK_PIN_NO(97) | 1)

#define MT8518_PIN_98_SW_RESET_DSP__FUNC_GPIO98 (MTK_PIN_NO(98) | 0)

#define MT8518_PIN_99_GPIO1__FUNC_GPIO99 (MTK_PIN_NO(99) | 0)

#define MT8518_PIN_100_GPIO2__FUNC_GPIO100 (MTK_PIN_NO(100) | 0)

#define MT8518_PIN_101_GPIO3__FUNC_GPIO101 (MTK_PIN_NO(101) | 0)

#define MT8518_PIN_102_GPIO4__FUNC_GPIO102 (MTK_PIN_NO(102) | 0)

#define MT8518_PIN_103_RTC32K_DSP__FUNC_GPIO103 (MTK_PIN_NO(103) | 0)
#define MT8518_PIN_103_RTC32K_DSP__FUNC_CLK_32K (MTK_PIN_NO(103) | 1)
#define MT8518_PIN_103_RTC32K_DSP__FUNC_SPDIF_IN_2 (MTK_PIN_NO(103) | 2)

#define MT8518_PIN_104_URXD0__FUNC_GPIO104 (MTK_PIN_NO(104) | 0)
#define MT8518_PIN_104_URXD0__FUNC_URXD0 (MTK_PIN_NO(104) | 1)
#define MT8518_PIN_104_URXD0__FUNC_URTS1 (MTK_PIN_NO(104) | 2)
#define MT8518_PIN_104_URXD0__FUNC_URTS2 (MTK_PIN_NO(104) | 4)
#define MT8518_PIN_104_URXD0__FUNC_DBG_MON_A_4 (MTK_PIN_NO(104) | 7)

#define MT8518_PIN_105_UTXD0__FUNC_GPIO105 (MTK_PIN_NO(105) | 0)
#define MT8518_PIN_105_UTXD0__FUNC_UTXD0 (MTK_PIN_NO(105) | 1)
#define MT8518_PIN_105_UTXD0__FUNC_UCTS1 (MTK_PIN_NO(105) | 2)
#define MT8518_PIN_105_UTXD0__FUNC_UCTS2 (MTK_PIN_NO(105) | 4)
#define MT8518_PIN_105_UTXD0__FUNC_DBG_MON_A_20 (MTK_PIN_NO(105) | 7)

#define MT8518_PIN_106_URXD2__FUNC_GPIO106 (MTK_PIN_NO(106) | 0)
#define MT8518_PIN_106_URXD2__FUNC_URXD2 (MTK_PIN_NO(106) | 1)
#define MT8518_PIN_106_URXD2__FUNC_UTXD1 (MTK_PIN_NO(106) | 2)
#define MT8518_PIN_106_URXD2__FUNC_URTS0 (MTK_PIN_NO(106) | 3)
#define MT8518_PIN_106_URXD2__FUNC_KPCOL3 (MTK_PIN_NO(106) | 4)
#define MT8518_PIN_106_URXD2__FUNC_DBG_MON_A_21 (MTK_PIN_NO(106) | 7)

#define MT8518_PIN_107_UTXD2__FUNC_GPIO107 (MTK_PIN_NO(107) | 0)
#define MT8518_PIN_107_UTXD2__FUNC_UTXD2 (MTK_PIN_NO(107) | 1)
#define MT8518_PIN_107_UTXD2__FUNC_URXD1 (MTK_PIN_NO(107) | 2)
#define MT8518_PIN_107_UTXD2__FUNC_UCTS0 (MTK_PIN_NO(107) | 3)
#define MT8518_PIN_107_UTXD2__FUNC_KPCOL4 (MTK_PIN_NO(107) | 4)
#define MT8518_PIN_107_UTXD2__FUNC_SPDIF_OUT (MTK_PIN_NO(107) | 5)
#define MT8518_PIN_107_UTXD2__FUNC_DBG_MON_A_22 (MTK_PIN_NO(107) | 7)

#define MT8518_PIN_108_SDA1__FUNC_GPIO108 (MTK_PIN_NO(108) | 0)
#define MT8518_PIN_108_SDA1__FUNC_SDA1_0 (MTK_PIN_NO(108) | 1)

#define MT8518_PIN_109_SCL1__FUNC_GPIO109 (MTK_PIN_NO(109) | 0)
#define MT8518_PIN_109_SCL1__FUNC_SCL1_0 (MTK_PIN_NO(109) | 1)

#define MT8518_PIN_110_SDA0__FUNC_GPIO110 (MTK_PIN_NO(110) | 0)
#define MT8518_PIN_110_SDA0__FUNC_SDA0_0 (MTK_PIN_NO(110) | 1)

#define MT8518_PIN_111_SCL0__FUNC_GPIO111 (MTK_PIN_NO(111) | 0)
#define MT8518_PIN_111_SCL0__FUNC_SCL0_0 (MTK_PIN_NO(111) | 1)

#define MT8518_PIN_112_SDA2__FUNC_GPIO112 (MTK_PIN_NO(112) | 0)
#define MT8518_PIN_112_SDA2__FUNC_SDA2_0 (MTK_PIN_NO(112) | 1)

#define MT8518_PIN_113_SCL2__FUNC_GPIO113 (MTK_PIN_NO(113) | 0)
#define MT8518_PIN_113_SCL2__FUNC_SCL2_0 (MTK_PIN_NO(113) | 1)

#define MT8518_PIN_114_MSDC1_CMD__FUNC_GPIO114 (MTK_PIN_NO(114) | 0)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_MSDC1_CMD (MTK_PIN_NO(114) | 1)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_NOR_CS (MTK_PIN_NO(114) | 2)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_PWM_A (MTK_PIN_NO(114) | 3)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_NAND_CS (MTK_PIN_NO(114) | 4)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_JTMS (MTK_PIN_NO(114) | 5)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_NTRST_UDI (MTK_PIN_NO(114) | 6)
#define MT8518_PIN_114_MSDC1_CMD__FUNC_DBG_MON_B_0 (MTK_PIN_NO(114) | 7)

#define MT8518_PIN_115_MSDC1_CLK__FUNC_GPIO115 (MTK_PIN_NO(115) | 0)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_MSDC1_CLK (MTK_PIN_NO(115) | 1)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_NOR_CK (MTK_PIN_NO(115) | 2)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_PWM_B (MTK_PIN_NO(115) | 3)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_NAND_CK (MTK_PIN_NO(115) | 4)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_JTCK (MTK_PIN_NO(115) | 5)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_TCK_UDI (MTK_PIN_NO(115) | 6)
#define MT8518_PIN_115_MSDC1_CLK__FUNC_DBG_MON_B_1 (MTK_PIN_NO(115) | 7)

#define MT8518_PIN_116_MSDC1_DAT0__FUNC_GPIO116 (MTK_PIN_NO(116) | 0)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_MSDC1_DAT0 (MTK_PIN_NO(116) | 1)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_NOR_IO0 (MTK_PIN_NO(116) | 2)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_PWM_C (MTK_PIN_NO(116) | 3)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_NAND_IO0 (MTK_PIN_NO(116) | 4)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_JTDI (MTK_PIN_NO(116) | 5)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_TDI_UDI (MTK_PIN_NO(116) | 6)
#define MT8518_PIN_116_MSDC1_DAT0__FUNC_DBG_MON_B_2 (MTK_PIN_NO(116) | 7)

#define MT8518_PIN_117_MSDC1_DAT1__FUNC_GPIO117 (MTK_PIN_NO(117) | 0)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_MSDC1_DAT1 (MTK_PIN_NO(117) | 1)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_NOR_IO1 (MTK_PIN_NO(117) | 2)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_PWM_D (MTK_PIN_NO(117) | 3)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_NAND_IO1 (MTK_PIN_NO(117) | 4)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_JTDO (MTK_PIN_NO(117) | 5)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_TMS_UDI (MTK_PIN_NO(117) | 6)
#define MT8518_PIN_117_MSDC1_DAT1__FUNC_DBG_MON_B_3 (MTK_PIN_NO(117) | 7)

#define MT8518_PIN_118_MSDC1_DAT2__FUNC_GPIO118 (MTK_PIN_NO(118) | 0)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_MSDC1_DAT2 (MTK_PIN_NO(118) | 1)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_NOR_IO2 (MTK_PIN_NO(118) | 2)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_NAND_IO2 (MTK_PIN_NO(118) | 3)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_SDA0_0 (MTK_PIN_NO(118) | 4)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_KPCOL3 (MTK_PIN_NO(118) | 5)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_TDO_UDI (MTK_PIN_NO(118) | 6)
#define MT8518_PIN_118_MSDC1_DAT2__FUNC_DBG_MON_B_21 (MTK_PIN_NO(118) | 7)

#define MT8518_PIN_119_MSDC1_DAT3__FUNC_GPIO119 (MTK_PIN_NO(119) | 0)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_MSDC1_DAT3 (MTK_PIN_NO(119) | 1)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_NOR_IO3 (MTK_PIN_NO(119) | 2)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_NAND_IO3 (MTK_PIN_NO(119) | 3)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_SCL0_0 (MTK_PIN_NO(119) | 4)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_KPCOL4 (MTK_PIN_NO(119) | 5)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_IDDIG (MTK_PIN_NO(119) | 6)
#define MT8518_PIN_119_MSDC1_DAT3__FUNC_DBG_MON_B_22 (MTK_PIN_NO(119) | 7)

#endif /* __DTS_MT8518_PINFUNC_H */
