/*
 * Copyright (c) 2014-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * The following file is used for prototypes and data structures for
 * sonos APIs embedded in the Linux kernel.
 *
 * See kernel/sonos.c.
 */

#ifndef SONOS_KERNEL_H
#define SONOS_KERNEL_H

#if defined(CONFIG_SONOS)

extern int sonos_product_id;

#if defined(SONOS_ARCH_ATTR_SOC_IS_MT8521P)
#define PRODUCT_ID_ELREY 3
#define PRODUCT_ID_HIDEOUT 1
#define PRODUCT_ID_DOMINO 2

#define PRODUCT_ID_IS_ELREY ( (sonos_product_id == PRODUCT_ID_ELREY) )
#define PRODUCT_ID_IS_HIDEOUT ( (sonos_product_id == PRODUCT_ID_HIDEOUT) )
#define PRODUCT_ID_IS_DOMINO ( (sonos_product_id == PRODUCT_ID_DOMINO) )
#endif

#if defined(CONFIG_SONOS_SECBOOT)
#define UBIFS_CRYPT_TYPE_NONE		0
#define UBIFS_CRYPT_TYPE_FIXED		4
#define UBIFS_CRYPT_TYPE_BLACK_KEY	5
#define UBIFS_CRYPT_TYPE_RED_KEY	6

#define SECMEM_KEYMOD_LEN 8

#include <crypto/aes.h>
#include <linux/types.h>

#if defined(SONOS_ARCH_ATTR_SOC_IS_IMX6)
struct crypt_operation {
	bool	is_encrypt;
	void	*input_buffer;
	size_t	input_length;
	void	*output_buffer;
	size_t	*output_length;
	size_t	original_length;
	char	keymod[SECMEM_KEYMOD_LEN];
};

struct platform_device;
extern int sonos_sm_encdec(struct platform_device *pdev,
			   struct crypt_operation *op);

#define SONOS_BLOB_IMX6_RED_OVERHEAD	48
#define SONOS_BLOB_MAX_ENC_OVERHEAD	(SONOS_BLOB_IMX6_RED_OVERHEAD + \
					 AES_BLOCK_SIZE)

#elif defined(SONOS_ARCH_ATTR_SOC_IS_MT8521P)
#define SONOS_BLOB_MTK_GCM_TAG_SIZE	16
#define SONOS_BLOB_MAX_ENC_OVERHEAD	(AES_BLOCK_SIZE + AES_BLOCK_SIZE + \
					 SONOS_BLOB_MTK_GCM_TAG_SIZE)
#endif

#define SONOS_BLOB_BUFFER_SIZE		2048
#define SONOS_BLOB_MAX_ENC_INPUT_SIZE	(SONOS_BLOB_BUFFER_SIZE - \
					 SONOS_BLOB_MAX_ENC_OVERHEAD)

extern int sonos_blob_encdec(bool isEncrypt, const void *in, size_t inLen,
			     void *out, size_t *pOutLen,
			     const void *keymod, size_t keymodLen);

extern int sonos_set_ubifs_key(u32);
extern void sonos_set_proc_crypt(int);

extern int sonos_get_cpuid(uint8_t *, size_t);
extern int sonos_get_unlock_counter(uint32_t *);
#endif

#ifdef CONFIG_VF610_ADC
extern int vf610_read_adc(int chan, int *mvolts);
#elif defined(CONFIG_MEDIATEK_MT6577_AUXADC)
extern int mt6577_read_adc(int chan, int *mvolts);
#endif

extern int read_adc_voltage(int chan, int *mvolts);

extern int nand_shutdown_access(int);

#include "mdp.h"
extern int bootgeneration;
extern int bootsection;
extern struct manufacturing_data_page sys_mdp;
#endif
#endif
