/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef __PINCTRL_MTK_MT7622_H
#define __PINCTRL_MTK_MT7622_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_pin_info mtk_pin_info_mode[] = {
	MTK_PIN_INFO(0, 0x320, 16, 4, 0),
	MTK_PIN_INFO(1, 0x3A0, 16, 4, 0),
	MTK_PIN_INFO(2, 0x3A0, 20, 4, 0),
	MTK_PIN_INFO(3, 0x3A0, 24, 4, 0),
	MTK_PIN_INFO(4, 0x3A0, 28, 4, 0),
	MTK_PIN_INFO(5, 0x320, 0, 4, 0),
	MTK_PIN_INFO(6, 0x300, 4, 4, 0),
	MTK_PIN_INFO(7, 0x300, 4, 4, 0),
	MTK_PIN_INFO(8, 0x350, 20, 4, 0),
	MTK_PIN_INFO(9, 0x350, 24, 4, 0),
	MTK_PIN_INFO(10, 0x300, 8, 4, 0),
	MTK_PIN_INFO(11, 0x300, 8, 4, 0),
	MTK_PIN_INFO(12, 0x300, 8, 4, 0),
	MTK_PIN_INFO(13, 0x300, 8, 4, 0),
	MTK_PIN_INFO(14, 0x320, 4, 4, 0),
	MTK_PIN_INFO(15, 0x320, 8, 4, 0),
	MTK_PIN_INFO(16, 0x320, 20, 4, 0),
	MTK_PIN_INFO(17, 0x320, 24, 4, 0),
	MTK_PIN_INFO(18, 0x310, 16, 4, 0),
	MTK_PIN_INFO(19, 0x310, 20, 4, 0),
	MTK_PIN_INFO(20, 0x310, 24, 4, 0),
	MTK_PIN_INFO(21, 0x310, 28, 4, 0),
	MTK_PIN_INFO(22, 0x380, 16, 4, 0),
	MTK_PIN_INFO(23, 0x300, 24, 4, 0),
	MTK_PIN_INFO(24, 0x300, 24, 4, 0),
	MTK_PIN_INFO(25, 0x300, 12, 4, 0),
	MTK_PIN_INFO(26, 0x300, 12, 4, 0),
	MTK_PIN_INFO(27, 0x300, 12, 4, 0),
	MTK_PIN_INFO(28, 0x300, 12, 4, 0),
	MTK_PIN_INFO(29, 0x300, 12, 4, 0),
	MTK_PIN_INFO(30, 0x300, 12, 4, 0),
	MTK_PIN_INFO(31, 0x300, 12, 4, 0),
	MTK_PIN_INFO(32, 0x300, 12, 4, 0),
	MTK_PIN_INFO(33, 0x300, 12, 4, 0),
	MTK_PIN_INFO(34, 0x300, 12, 4, 0),
	MTK_PIN_INFO(35, 0x300, 12, 4, 0),
	MTK_PIN_INFO(36, 0x300, 12, 4, 0),
	MTK_PIN_INFO(37, 0x300, 20, 4, 0),
	MTK_PIN_INFO(38, 0x300, 20, 4, 0),
	MTK_PIN_INFO(39, 0x300, 20, 4, 0),
	MTK_PIN_INFO(40, 0x300, 20, 4, 0),
	MTK_PIN_INFO(41, 0x300, 20, 4, 0),
	MTK_PIN_INFO(42, 0x300, 20, 4, 0),
	MTK_PIN_INFO(43, 0x300, 20, 4, 0),
	MTK_PIN_INFO(44, 0x300, 20, 4, 0),
	MTK_PIN_INFO(45, 0x300, 20, 4, 0),
	MTK_PIN_INFO(46, 0x300, 20, 4, 0),
	MTK_PIN_INFO(47, 0x300, 20, 4, 0),
	MTK_PIN_INFO(48, 0x300, 20, 4, 0),
	MTK_PIN_INFO(49, 0x300, 20, 4, 0),
	MTK_PIN_INFO(50, 0x300, 20, 4, 0),
	MTK_PIN_INFO(51, 0x330, 4, 4, 0),
	MTK_PIN_INFO(52, 0x330, 8, 4, 0),
	MTK_PIN_INFO(53, 0x330, 12, 4, 0),
	MTK_PIN_INFO(54, 0x330, 16, 4, 0),
	MTK_PIN_INFO(55, 0x330, 20, 4, 0),
	MTK_PIN_INFO(56, 0x330, 24, 4, 0),
	MTK_PIN_INFO(57, 0x330, 28, 4, 0),
	MTK_PIN_INFO(58, 0x340, 0, 4, 0),
	MTK_PIN_INFO(59, 0x340, 4, 4, 0),
	MTK_PIN_INFO(60, 0x340, 8, 4, 0),
	MTK_PIN_INFO(61, 0x340, 12, 4, 0),
	MTK_PIN_INFO(62, 0x340, 16, 4, 0),
	MTK_PIN_INFO(63, 0x340, 20, 4, 0),
	MTK_PIN_INFO(64, 0x340, 24, 4, 0),
	MTK_PIN_INFO(65, 0x340, 28, 4, 0),
	MTK_PIN_INFO(66, 0x350, 0, 4, 0),
	MTK_PIN_INFO(67, 0x350, 4, 4, 0),
	MTK_PIN_INFO(68, 0x350, 8, 4, 0),
	MTK_PIN_INFO(69, 0x350, 12, 4, 0),
	MTK_PIN_INFO(70, 0x350, 16, 4, 0),
	MTK_PIN_INFO(71, 0x300, 16, 4, 0),
	MTK_PIN_INFO(72, 0x300, 16, 4, 0),
	MTK_PIN_INFO(73, 0x310, 0, 4, 0),
	MTK_PIN_INFO(74, 0x310, 4, 4, 0),
	MTK_PIN_INFO(75, 0x310, 8, 4, 0),
	MTK_PIN_INFO(76, 0x310, 12, 4, 0),
	MTK_PIN_INFO(77, 0x320, 28, 4, 0),
	MTK_PIN_INFO(78, 0x320, 12, 4, 0),
	MTK_PIN_INFO(79, 0x3A0, 0, 4, 0),
	MTK_PIN_INFO(80, 0x3A0, 4, 4, 0),
	MTK_PIN_INFO(81, 0x3A0, 8, 4, 0),
	MTK_PIN_INFO(82, 0x3A0, 12, 4, 0),
	MTK_PIN_INFO(83, 0x350, 28, 4, 0),
	MTK_PIN_INFO(84, 0x330, 0, 4, 0),
	MTK_PIN_INFO(85, 0x360, 4, 4, 0),
	MTK_PIN_INFO(86, 0x360, 8, 4, 0),
	MTK_PIN_INFO(87, 0x360, 12, 4, 0),
	MTK_PIN_INFO(88, 0x360, 16, 4, 0),
	MTK_PIN_INFO(89, 0x360, 20, 4, 0),
	MTK_PIN_INFO(90, 0x360, 24, 4, 0),
	MTK_PIN_INFO(91, 0x390, 16, 4, 0),
	MTK_PIN_INFO(92, 0x390, 20, 4, 0),
	MTK_PIN_INFO(93, 0x390, 24, 4, 0),
	MTK_PIN_INFO(94, 0x390, 28, 4, 0),
	MTK_PIN_INFO(95, 0x380, 20, 4, 0),
	MTK_PIN_INFO(96, 0x380, 24, 4, 0),
	MTK_PIN_INFO(97, 0x380, 28, 4, 0),
	MTK_PIN_INFO(98, 0x390, 0, 4, 0),
	MTK_PIN_INFO(99, 0x390, 4, 4, 0),
	MTK_PIN_INFO(100, 0x390, 8, 4, 0),
	MTK_PIN_INFO(101, 0x390, 12, 4, 0),
	MTK_PIN_INFO(102, 0x360, 0, 4, 0),
};

static const struct mtk_pin_info mtk_pin_info_dir[] = {
	MTK_PIN_INFO(0, 0x000, 0, 1, 0),
	MTK_PIN_INFO(1, 0x000, 1, 1, 0),
	MTK_PIN_INFO(2, 0x000, 2, 1, 0),
	MTK_PIN_INFO(3, 0x000, 3, 1, 0),
	MTK_PIN_INFO(4, 0x000, 4, 1, 0),
	MTK_PIN_INFO(5, 0x000, 5, 1, 0),
	MTK_PIN_INFO(6, 0x000, 6, 1, 0),
	MTK_PIN_INFO(7, 0x000, 7, 1, 0),
	MTK_PIN_INFO(8, 0x000, 8, 1, 0),
	MTK_PIN_INFO(9, 0x000, 9, 1, 0),
	MTK_PIN_INFO(10, 0x000, 10, 1, 0),
	MTK_PIN_INFO(11, 0x000, 11, 1, 0),
	MTK_PIN_INFO(12, 0x000, 12, 1, 0),
	MTK_PIN_INFO(13, 0x000, 13, 1, 0),
	MTK_PIN_INFO(14, 0x000, 14, 1, 0),
	MTK_PIN_INFO(15, 0x000, 15, 1, 0),
	MTK_PIN_INFO(16, 0x000, 16, 1, 0),
	MTK_PIN_INFO(17, 0x000, 17, 1, 0),
	MTK_PIN_INFO(18, 0x000, 18, 1, 0),
	MTK_PIN_INFO(19, 0x000, 19, 1, 0),
	MTK_PIN_INFO(20, 0x000, 20, 1, 0),
	MTK_PIN_INFO(21, 0x000, 21, 1, 0),
	MTK_PIN_INFO(22, 0x000, 22, 1, 0),
	MTK_PIN_INFO(23, 0x000, 23, 1, 0),
	MTK_PIN_INFO(24, 0x000, 24, 1, 0),
	MTK_PIN_INFO(25, 0x000, 25, 1, 0),
	MTK_PIN_INFO(26, 0x000, 26, 1, 0),
	MTK_PIN_INFO(27, 0x000, 27, 1, 0),
	MTK_PIN_INFO(28, 0x000, 28, 1, 0),
	MTK_PIN_INFO(29, 0x000, 29, 1, 0),
	MTK_PIN_INFO(30, 0x000, 30, 1, 0),
	MTK_PIN_INFO(31, 0x000, 31, 1, 0),
	MTK_PIN_INFO(32, 0x010, 0, 1, 0),
	MTK_PIN_INFO(33, 0x010, 1, 1, 0),
	MTK_PIN_INFO(34, 0x010, 2, 1, 0),
	MTK_PIN_INFO(35, 0x010, 3, 1, 0),
	MTK_PIN_INFO(36, 0x010, 4, 1, 0),
	MTK_PIN_INFO(37, 0x010, 5, 1, 0),
	MTK_PIN_INFO(38, 0x010, 6, 1, 0),
	MTK_PIN_INFO(39, 0x010, 7, 1, 0),
	MTK_PIN_INFO(40, 0x010, 8, 1, 0),
	MTK_PIN_INFO(41, 0x010, 9, 1, 0),
	MTK_PIN_INFO(42, 0x010, 10, 1, 0),
	MTK_PIN_INFO(43, 0x010, 11, 1, 0),
	MTK_PIN_INFO(44, 0x010, 12, 1, 0),
	MTK_PIN_INFO(45, 0x010, 13, 1, 0),
	MTK_PIN_INFO(46, 0x010, 14, 1, 0),
	MTK_PIN_INFO(47, 0x010, 15, 1, 0),
	MTK_PIN_INFO(48, 0x010, 16, 1, 0),
	MTK_PIN_INFO(49, 0x010, 17, 1, 0),
	MTK_PIN_INFO(50, 0x010, 18, 1, 0),
	MTK_PIN_INFO(51, 0x010, 19, 1, 0),
	MTK_PIN_INFO(52, 0x010, 20, 1, 0),
	MTK_PIN_INFO(53, 0x010, 21, 1, 0),
	MTK_PIN_INFO(54, 0x010, 22, 1, 0),
	MTK_PIN_INFO(55, 0x010, 23, 1, 0),
	MTK_PIN_INFO(56, 0x010, 24, 1, 0),
	MTK_PIN_INFO(57, 0x010, 25, 1, 0),
	MTK_PIN_INFO(58, 0x010, 26, 1, 0),
	MTK_PIN_INFO(59, 0x010, 27, 1, 0),
	MTK_PIN_INFO(60, 0x010, 28, 1, 0),
	MTK_PIN_INFO(61, 0x010, 29, 1, 0),
	MTK_PIN_INFO(62, 0x010, 30, 1, 0),
	MTK_PIN_INFO(63, 0x010, 31, 1, 0),
	MTK_PIN_INFO(64, 0x020, 0, 1, 0),
	MTK_PIN_INFO(65, 0x020, 1, 1, 0),
	MTK_PIN_INFO(66, 0x020, 2, 1, 0),
	MTK_PIN_INFO(67, 0x020, 3, 1, 0),
	MTK_PIN_INFO(68, 0x020, 4, 1, 0),
	MTK_PIN_INFO(69, 0x020, 5, 1, 0),
	MTK_PIN_INFO(70, 0x020, 6, 1, 0),
	MTK_PIN_INFO(71, 0x020, 7, 1, 0),
	MTK_PIN_INFO(72, 0x020, 8, 1, 0),
	MTK_PIN_INFO(73, 0x020, 9, 1, 0),
	MTK_PIN_INFO(74, 0x020, 10, 1, 0),
	MTK_PIN_INFO(75, 0x020, 11, 1, 0),
	MTK_PIN_INFO(76, 0x020, 12, 1, 0),
	MTK_PIN_INFO(77, 0x020, 13, 1, 0),
	MTK_PIN_INFO(78, 0x020, 14, 1, 0),
	MTK_PIN_INFO(79, 0x020, 15, 1, 0),
	MTK_PIN_INFO(80, 0x020, 16, 1, 0),
	MTK_PIN_INFO(81, 0x020, 17, 1, 0),
	MTK_PIN_INFO(82, 0x020, 18, 1, 0),
	MTK_PIN_INFO(83, 0x020, 19, 1, 0),
	MTK_PIN_INFO(84, 0x020, 20, 1, 0),
	MTK_PIN_INFO(85, 0x020, 21, 1, 0),
	MTK_PIN_INFO(86, 0x020, 22, 1, 0),
	MTK_PIN_INFO(87, 0x020, 23, 1, 0),
	MTK_PIN_INFO(88, 0x020, 24, 1, 0),
	MTK_PIN_INFO(89, 0x020, 25, 1, 0),
	MTK_PIN_INFO(90, 0x020, 26, 1, 0),
	MTK_PIN_INFO(91, 0x020, 27, 1, 0),
	MTK_PIN_INFO(92, 0x020, 28, 1, 0),
	MTK_PIN_INFO(93, 0x020, 29, 1, 0),
	MTK_PIN_INFO(94, 0x020, 30, 1, 0),
	MTK_PIN_INFO(95, 0x020, 31, 1, 0),
	MTK_PIN_INFO(96, 0x030, 0, 1, 0),
	MTK_PIN_INFO(97, 0x030, 1, 1, 0),
	MTK_PIN_INFO(98, 0x030, 2, 1, 0),
	MTK_PIN_INFO(99, 0x030, 3, 1, 0),
	MTK_PIN_INFO(100, 0x030, 4, 1, 0),
	MTK_PIN_INFO(101, 0x030, 5, 1, 0),
	MTK_PIN_INFO(102, 0x030, 6, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_datain[] = {
	MTK_PIN_INFO(0, 0x200, 0, 1, 0),
	MTK_PIN_INFO(1, 0x200, 1, 1, 0),
	MTK_PIN_INFO(2, 0x200, 2, 1, 0),
	MTK_PIN_INFO(3, 0x200, 3, 1, 0),
	MTK_PIN_INFO(4, 0x200, 4, 1, 0),
	MTK_PIN_INFO(5, 0x200, 5, 1, 0),
	MTK_PIN_INFO(6, 0x200, 6, 1, 0),
	MTK_PIN_INFO(7, 0x200, 7, 1, 0),
	MTK_PIN_INFO(8, 0x200, 8, 1, 0),
	MTK_PIN_INFO(9, 0x200, 9, 1, 0),
	MTK_PIN_INFO(10, 0x200, 10, 1, 0),
	MTK_PIN_INFO(11, 0x200, 11, 1, 0),
	MTK_PIN_INFO(12, 0x200, 12, 1, 0),
	MTK_PIN_INFO(13, 0x200, 13, 1, 0),
	MTK_PIN_INFO(14, 0x200, 14, 1, 0),
	MTK_PIN_INFO(15, 0x200, 15, 1, 0),
	MTK_PIN_INFO(16, 0x200, 16, 1, 0),
	MTK_PIN_INFO(17, 0x200, 17, 1, 0),
	MTK_PIN_INFO(18, 0x200, 18, 1, 0),
	MTK_PIN_INFO(19, 0x200, 19, 1, 0),
	MTK_PIN_INFO(20, 0x200, 20, 1, 0),
	MTK_PIN_INFO(21, 0x200, 21, 1, 0),
	MTK_PIN_INFO(22, 0x200, 22, 1, 0),
	MTK_PIN_INFO(23, 0x200, 23, 1, 0),
	MTK_PIN_INFO(24, 0x200, 24, 1, 0),
	MTK_PIN_INFO(25, 0x200, 25, 1, 0),
	MTK_PIN_INFO(26, 0x200, 26, 1, 0),
	MTK_PIN_INFO(27, 0x200, 27, 1, 0),
	MTK_PIN_INFO(28, 0x200, 28, 1, 0),
	MTK_PIN_INFO(29, 0x200, 29, 1, 0),
	MTK_PIN_INFO(30, 0x200, 30, 1, 0),
	MTK_PIN_INFO(31, 0x200, 31, 1, 0),
	MTK_PIN_INFO(32, 0x210, 0, 1, 0),
	MTK_PIN_INFO(33, 0x210, 1, 1, 0),
	MTK_PIN_INFO(34, 0x210, 2, 1, 0),
	MTK_PIN_INFO(35, 0x210, 3, 1, 0),
	MTK_PIN_INFO(36, 0x210, 4, 1, 0),
	MTK_PIN_INFO(37, 0x210, 5, 1, 0),
	MTK_PIN_INFO(38, 0x210, 6, 1, 0),
	MTK_PIN_INFO(39, 0x210, 7, 1, 0),
	MTK_PIN_INFO(40, 0x210, 8, 1, 0),
	MTK_PIN_INFO(41, 0x210, 9, 1, 0),
	MTK_PIN_INFO(42, 0x210, 10, 1, 0),
	MTK_PIN_INFO(43, 0x210, 11, 1, 0),
	MTK_PIN_INFO(44, 0x210, 12, 1, 0),
	MTK_PIN_INFO(45, 0x210, 13, 1, 0),
	MTK_PIN_INFO(46, 0x210, 14, 1, 0),
	MTK_PIN_INFO(47, 0x210, 15, 1, 0),
	MTK_PIN_INFO(48, 0x210, 16, 1, 0),
	MTK_PIN_INFO(49, 0x210, 17, 1, 0),
	MTK_PIN_INFO(50, 0x210, 18, 1, 0),
	MTK_PIN_INFO(51, 0x210, 19, 1, 0),
	MTK_PIN_INFO(52, 0x210, 20, 1, 0),
	MTK_PIN_INFO(53, 0x210, 21, 1, 0),
	MTK_PIN_INFO(54, 0x210, 22, 1, 0),
	MTK_PIN_INFO(55, 0x210, 23, 1, 0),
	MTK_PIN_INFO(56, 0x210, 24, 1, 0),
	MTK_PIN_INFO(57, 0x210, 25, 1, 0),
	MTK_PIN_INFO(58, 0x210, 26, 1, 0),
	MTK_PIN_INFO(59, 0x210, 27, 1, 0),
	MTK_PIN_INFO(60, 0x210, 28, 1, 0),
	MTK_PIN_INFO(61, 0x210, 29, 1, 0),
	MTK_PIN_INFO(62, 0x210, 30, 1, 0),
	MTK_PIN_INFO(63, 0x210, 31, 1, 0),
	MTK_PIN_INFO(64, 0x220, 0, 1, 0),
	MTK_PIN_INFO(65, 0x220, 1, 1, 0),
	MTK_PIN_INFO(66, 0x220, 2, 1, 0),
	MTK_PIN_INFO(67, 0x220, 3, 1, 0),
	MTK_PIN_INFO(68, 0x220, 4, 1, 0),
	MTK_PIN_INFO(69, 0x220, 5, 1, 0),
	MTK_PIN_INFO(70, 0x220, 6, 1, 0),
	MTK_PIN_INFO(71, 0x220, 7, 1, 0),
	MTK_PIN_INFO(72, 0x220, 8, 1, 0),
	MTK_PIN_INFO(73, 0x220, 9, 1, 0),
	MTK_PIN_INFO(74, 0x220, 10, 1, 0),
	MTK_PIN_INFO(75, 0x220, 11, 1, 0),
	MTK_PIN_INFO(76, 0x220, 12, 1, 0),
	MTK_PIN_INFO(77, 0x220, 13, 1, 0),
	MTK_PIN_INFO(78, 0x220, 14, 1, 0),
	MTK_PIN_INFO(79, 0x220, 15, 1, 0),
	MTK_PIN_INFO(80, 0x220, 16, 1, 0),
	MTK_PIN_INFO(81, 0x220, 17, 1, 0),
	MTK_PIN_INFO(82, 0x220, 18, 1, 0),
	MTK_PIN_INFO(83, 0x220, 19, 1, 0),
	MTK_PIN_INFO(84, 0x220, 20, 1, 0),
	MTK_PIN_INFO(85, 0x220, 21, 1, 0),
	MTK_PIN_INFO(86, 0x220, 22, 1, 0),
	MTK_PIN_INFO(87, 0x220, 23, 1, 0),
	MTK_PIN_INFO(88, 0x220, 24, 1, 0),
	MTK_PIN_INFO(89, 0x220, 25, 1, 0),
	MTK_PIN_INFO(90, 0x220, 26, 1, 0),
	MTK_PIN_INFO(91, 0x220, 27, 1, 0),
	MTK_PIN_INFO(92, 0x220, 28, 1, 0),
	MTK_PIN_INFO(93, 0x220, 29, 1, 0),
	MTK_PIN_INFO(94, 0x220, 30, 1, 0),
	MTK_PIN_INFO(95, 0x220, 31, 1, 0),
	MTK_PIN_INFO(96, 0x230, 0, 1, 0),
	MTK_PIN_INFO(97, 0x230, 1, 1, 0),
	MTK_PIN_INFO(98, 0x230, 2, 1, 0),
	MTK_PIN_INFO(99, 0x230, 3, 1, 0),
	MTK_PIN_INFO(100, 0x230, 4, 1, 0),
	MTK_PIN_INFO(101, 0x230, 5, 1, 0),
	MTK_PIN_INFO(102, 0x230, 6, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_dataout[] = {
	MTK_PIN_INFO(0, 0x100, 0, 1, 0),
	MTK_PIN_INFO(1, 0x100, 1, 1, 0),
	MTK_PIN_INFO(2, 0x100, 2, 1, 0),
	MTK_PIN_INFO(3, 0x100, 3, 1, 0),
	MTK_PIN_INFO(4, 0x100, 4, 1, 0),
	MTK_PIN_INFO(5, 0x100, 5, 1, 0),
	MTK_PIN_INFO(6, 0x100, 6, 1, 0),
	MTK_PIN_INFO(7, 0x100, 7, 1, 0),
	MTK_PIN_INFO(8, 0x100, 8, 1, 0),
	MTK_PIN_INFO(9, 0x100, 9, 1, 0),
	MTK_PIN_INFO(10, 0x100, 10, 1, 0),
	MTK_PIN_INFO(11, 0x100, 11, 1, 0),
	MTK_PIN_INFO(12, 0x100, 12, 1, 0),
	MTK_PIN_INFO(13, 0x100, 13, 1, 0),
	MTK_PIN_INFO(14, 0x100, 14, 1, 0),
	MTK_PIN_INFO(15, 0x100, 15, 1, 0),
	MTK_PIN_INFO(16, 0x100, 16, 1, 0),
	MTK_PIN_INFO(17, 0x100, 17, 1, 0),
	MTK_PIN_INFO(18, 0x100, 18, 1, 0),
	MTK_PIN_INFO(19, 0x100, 19, 1, 0),
	MTK_PIN_INFO(20, 0x100, 20, 1, 0),
	MTK_PIN_INFO(21, 0x100, 21, 1, 0),
	MTK_PIN_INFO(22, 0x100, 22, 1, 0),
	MTK_PIN_INFO(23, 0x100, 23, 1, 0),
	MTK_PIN_INFO(24, 0x100, 24, 1, 0),
	MTK_PIN_INFO(25, 0x100, 25, 1, 0),
	MTK_PIN_INFO(26, 0x100, 26, 1, 0),
	MTK_PIN_INFO(27, 0x100, 27, 1, 0),
	MTK_PIN_INFO(28, 0x100, 28, 1, 0),
	MTK_PIN_INFO(29, 0x100, 29, 1, 0),
	MTK_PIN_INFO(30, 0x100, 30, 1, 0),
	MTK_PIN_INFO(31, 0x100, 31, 1, 0),
	MTK_PIN_INFO(32, 0x110, 0, 1, 0),
	MTK_PIN_INFO(33, 0x110, 1, 1, 0),
	MTK_PIN_INFO(34, 0x110, 2, 1, 0),
	MTK_PIN_INFO(35, 0x110, 3, 1, 0),
	MTK_PIN_INFO(36, 0x110, 4, 1, 0),
	MTK_PIN_INFO(37, 0x110, 5, 1, 0),
	MTK_PIN_INFO(38, 0x110, 6, 1, 0),
	MTK_PIN_INFO(39, 0x110, 7, 1, 0),
	MTK_PIN_INFO(40, 0x110, 8, 1, 0),
	MTK_PIN_INFO(41, 0x110, 9, 1, 0),
	MTK_PIN_INFO(42, 0x110, 10, 1, 0),
	MTK_PIN_INFO(43, 0x110, 11, 1, 0),
	MTK_PIN_INFO(44, 0x110, 12, 1, 0),
	MTK_PIN_INFO(45, 0x110, 13, 1, 0),
	MTK_PIN_INFO(46, 0x110, 14, 1, 0),
	MTK_PIN_INFO(47, 0x110, 15, 1, 0),
	MTK_PIN_INFO(48, 0x110, 16, 1, 0),
	MTK_PIN_INFO(49, 0x110, 17, 1, 0),
	MTK_PIN_INFO(50, 0x110, 18, 1, 0),
	MTK_PIN_INFO(51, 0x110, 19, 1, 0),
	MTK_PIN_INFO(52, 0x110, 20, 1, 0),
	MTK_PIN_INFO(53, 0x110, 21, 1, 0),
	MTK_PIN_INFO(54, 0x110, 22, 1, 0),
	MTK_PIN_INFO(55, 0x110, 23, 1, 0),
	MTK_PIN_INFO(56, 0x110, 24, 1, 0),
	MTK_PIN_INFO(57, 0x110, 25, 1, 0),
	MTK_PIN_INFO(58, 0x110, 26, 1, 0),
	MTK_PIN_INFO(59, 0x110, 27, 1, 0),
	MTK_PIN_INFO(60, 0x110, 28, 1, 0),
	MTK_PIN_INFO(61, 0x110, 29, 1, 0),
	MTK_PIN_INFO(62, 0x110, 30, 1, 0),
	MTK_PIN_INFO(63, 0x110, 31, 1, 0),
	MTK_PIN_INFO(64, 0x120, 0, 1, 0),
	MTK_PIN_INFO(65, 0x120, 1, 1, 0),
	MTK_PIN_INFO(66, 0x120, 2, 1, 0),
	MTK_PIN_INFO(67, 0x120, 3, 1, 0),
	MTK_PIN_INFO(68, 0x120, 4, 1, 0),
	MTK_PIN_INFO(69, 0x120, 5, 1, 0),
	MTK_PIN_INFO(70, 0x120, 6, 1, 0),
	MTK_PIN_INFO(71, 0x120, 7, 1, 0),
	MTK_PIN_INFO(72, 0x120, 8, 1, 0),
	MTK_PIN_INFO(73, 0x120, 9, 1, 0),
	MTK_PIN_INFO(74, 0x120, 10, 1, 0),
	MTK_PIN_INFO(75, 0x120, 11, 1, 0),
	MTK_PIN_INFO(76, 0x120, 12, 1, 0),
	MTK_PIN_INFO(77, 0x120, 13, 1, 0),
	MTK_PIN_INFO(78, 0x120, 14, 1, 0),
	MTK_PIN_INFO(79, 0x120, 15, 1, 0),
	MTK_PIN_INFO(80, 0x120, 16, 1, 0),
	MTK_PIN_INFO(81, 0x120, 17, 1, 0),
	MTK_PIN_INFO(82, 0x120, 18, 1, 0),
	MTK_PIN_INFO(83, 0x120, 19, 1, 0),
	MTK_PIN_INFO(84, 0x120, 20, 1, 0),
	MTK_PIN_INFO(85, 0x120, 21, 1, 0),
	MTK_PIN_INFO(86, 0x120, 22, 1, 0),
	MTK_PIN_INFO(87, 0x120, 23, 1, 0),
	MTK_PIN_INFO(88, 0x120, 24, 1, 0),
	MTK_PIN_INFO(89, 0x120, 25, 1, 0),
	MTK_PIN_INFO(90, 0x120, 26, 1, 0),
	MTK_PIN_INFO(91, 0x120, 27, 1, 0),
	MTK_PIN_INFO(92, 0x120, 28, 1, 0),
	MTK_PIN_INFO(93, 0x120, 29, 1, 0),
	MTK_PIN_INFO(94, 0x120, 30, 1, 0),
	MTK_PIN_INFO(95, 0x120, 31, 1, 0),
	MTK_PIN_INFO(96, 0x130, 0, 1, 0),
	MTK_PIN_INFO(97, 0x130, 1, 1, 0),
	MTK_PIN_INFO(98, 0x130, 2, 1, 0),
	MTK_PIN_INFO(99, 0x130, 3, 1, 0),
	MTK_PIN_INFO(100, 0x130, 4, 1, 0),
	MTK_PIN_INFO(101, 0x130, 5, 1, 0),
	MTK_PIN_INFO(102, 0x130, 6, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_pu[] = {
	MTK_PIN_INFO(0, 0x930, 0, 1, 0),
	MTK_PIN_INFO(1, 0x930, 1, 1, 0),
	MTK_PIN_INFO(2, 0x930, 2, 1, 0),
	MTK_PIN_INFO(3, 0x930, 3, 1, 0),
	MTK_PIN_INFO(4, 0x930, 4, 1, 0),
	MTK_PIN_INFO(5, 0x930, 5, 1, 0),
	MTK_PIN_INFO(6, 0x930, 6, 1, 0),
	MTK_PIN_INFO(7, 0x930, 7, 1, 0),
	MTK_PIN_INFO(8, 0x930, 8, 1, 0),
	MTK_PIN_INFO(9, 0x930, 9, 1, 0),
	MTK_PIN_INFO(10, 0x930, 10, 1, 0),
	MTK_PIN_INFO(11, 0x930, 11, 1, 0),
	MTK_PIN_INFO(12, 0x930, 12, 1, 0),
	MTK_PIN_INFO(13, 0x930, 13, 1, 0),
	MTK_PIN_INFO(14, 0x930, 14, 1, 0),
	MTK_PIN_INFO(15, 0x930, 15, 1, 0),
	MTK_PIN_INFO(16, 0x930, 16, 1, 0),
	MTK_PIN_INFO(17, 0x930, 17, 1, 0),
	MTK_PIN_INFO(18, 0x930, 18, 1, 0),
	MTK_PIN_INFO(19, 0x930, 19, 1, 0),
	MTK_PIN_INFO(20, 0x930, 20, 1, 0),
	MTK_PIN_INFO(21, 0x930, 21, 1, 0),
	MTK_PIN_INFO(22, 0x930, 22, 1, 0),
	MTK_PIN_INFO(23, 0x930, 23, 1, 0),
	MTK_PIN_INFO(24, 0x930, 24, 1, 0),
	MTK_PIN_INFO(25, 0x930, 25, 1, 0),
	MTK_PIN_INFO(26, 0x930, 26, 1, 0),
	MTK_PIN_INFO(27, 0x930, 27, 1, 0),
	MTK_PIN_INFO(28, 0x930, 28, 1, 0),
	MTK_PIN_INFO(29, 0x930, 29, 1, 0),
	MTK_PIN_INFO(30, 0x930, 30, 1, 0),
	MTK_PIN_INFO(31, 0x930, 31, 1, 0),
	MTK_PIN_INFO(32, 0xA30, 0, 1, 0),
	MTK_PIN_INFO(33, 0xA30, 1, 1, 0),
	MTK_PIN_INFO(34, 0xA30, 2, 1, 0),
	MTK_PIN_INFO(35, 0xA30, 3, 1, 0),
	MTK_PIN_INFO(36, 0xA30, 4, 1, 0),
	MTK_PIN_INFO(37, 0xA30, 5, 1, 0),
	MTK_PIN_INFO(38, 0xA30, 6, 1, 0),
	MTK_PIN_INFO(39, 0xA30, 7, 1, 0),
	MTK_PIN_INFO(40, 0xA30, 8, 1, 0),
	MTK_PIN_INFO(41, 0xA30, 9, 1, 0),
	MTK_PIN_INFO(42, 0xA30, 10, 1, 0),
	MTK_PIN_INFO(43, 0xA30, 11, 1, 0),
	MTK_PIN_INFO(44, 0xA30, 12, 1, 0),
	MTK_PIN_INFO(45, 0xA30, 13, 1, 0),
	MTK_PIN_INFO(46, 0xA30, 14, 1, 0),
	MTK_PIN_INFO(47, 0xA30, 15, 1, 0),
	MTK_PIN_INFO(48, 0xA30, 16, 1, 0),
	MTK_PIN_INFO(49, 0xA30, 17, 1, 0),
	MTK_PIN_INFO(50, 0xA30, 18, 1, 0),
	MTK_PIN_INFO(51, 0x830, 0, 1, 0),
	MTK_PIN_INFO(52, 0x830, 1, 1, 0),
	MTK_PIN_INFO(53, 0x830, 2, 1, 0),
	MTK_PIN_INFO(54, 0x830, 3, 1, 0),
	MTK_PIN_INFO(55, 0x830, 4, 1, 0),
	MTK_PIN_INFO(56, 0x830, 5, 1, 0),
	MTK_PIN_INFO(57, 0x830, 6, 1, 0),
	MTK_PIN_INFO(58, 0x830, 7, 1, 0),
	MTK_PIN_INFO(59, 0x830, 10, 1, 0),
	MTK_PIN_INFO(60, 0x830, 11, 1, 0),
	MTK_PIN_INFO(61, 0x830, 8, 1, 0),
	MTK_PIN_INFO(62, 0x830, 9, 1, 0),
	MTK_PIN_INFO(63, 0x830, 12, 1, 0),
	MTK_PIN_INFO(64, 0x830, 13, 1, 0),
	MTK_PIN_INFO(65, 0x830, 14, 1, 0),
	MTK_PIN_INFO(66, 0x830, 15, 1, 0),
	MTK_PIN_INFO(67, 0x830, 18, 1, 0),
	MTK_PIN_INFO(68, 0x830, 19, 1, 0),
	MTK_PIN_INFO(69, 0x830, 16, 1, 0),
	MTK_PIN_INFO(70, 0x830, 17, 1, 0),
	MTK_PIN_INFO(71, 0xB30, 0, 1, 0),
	MTK_PIN_INFO(72, 0xB30, 1, 1, 0),
	MTK_PIN_INFO(73, 0xB30, 4, 1, 0),
	MTK_PIN_INFO(74, 0xB30, 5, 1, 0),
	MTK_PIN_INFO(75, 0xB30, 6, 1, 0),
	MTK_PIN_INFO(76, 0xB30, 7, 1, 0),
	MTK_PIN_INFO(77, 0xB30, 8, 1, 0),
	MTK_PIN_INFO(78, 0xB30, 9, 1, 0),
	MTK_PIN_INFO(79, 0xB30, 10, 1, 0),
	MTK_PIN_INFO(80, 0xB30, 11, 1, 0),
	MTK_PIN_INFO(81, 0xB30, 12, 1, 0),
	MTK_PIN_INFO(82, 0xB30, 13, 1, 0),
	MTK_PIN_INFO(83, 0xB30, 14, 1, 0),
	MTK_PIN_INFO(84, 0xB30, 15, 1, 0),
	MTK_PIN_INFO(85, 0xB30, 16, 1, 0),
	MTK_PIN_INFO(86, 0xB30, 17, 1, 0),
	MTK_PIN_INFO(87, 0xC30, 0, 1, 0),
	MTK_PIN_INFO(88, 0xC30, 1, 1, 0),
	MTK_PIN_INFO(89, 0xC30, 2, 1, 0),
	MTK_PIN_INFO(90, 0xC30, 3, 1, 0),
	MTK_PIN_INFO(91, 0xB30, 18, 1, 0),
	MTK_PIN_INFO(92, 0xB30, 19, 1, 0),
	MTK_PIN_INFO(93, 0xB30, 20, 1, 0),
	MTK_PIN_INFO(94, 0xB30, 21, 1, 0),
	MTK_PIN_INFO(95, 0xB30, 22, 1, 0),
	MTK_PIN_INFO(96, 0xB30, 23, 1, 0),
	MTK_PIN_INFO(97, 0xB30, 24, 1, 0),
	MTK_PIN_INFO(98, 0xB30, 25, 1, 0),
	MTK_PIN_INFO(99, 0xB30, 26, 1, 0),
	MTK_PIN_INFO(100, 0xB30, 27, 1, 0),
	MTK_PIN_INFO(101, 0xB30, 28, 1, 0),
	MTK_PIN_INFO(102, 0xB30, 29, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_pd[] = {
	MTK_PIN_INFO(0, 0x940, 0, 1, 0),
	MTK_PIN_INFO(1, 0x940, 1, 1, 0),
	MTK_PIN_INFO(2, 0x940, 2, 1, 0),
	MTK_PIN_INFO(3, 0x940, 3, 1, 0),
	MTK_PIN_INFO(4, 0x940, 4, 1, 0),
	MTK_PIN_INFO(5, 0x940, 5, 1, 0),
	MTK_PIN_INFO(6, 0x940, 6, 1, 0),
	MTK_PIN_INFO(7, 0x940, 7, 1, 0),
	MTK_PIN_INFO(8, 0x940, 8, 1, 0),
	MTK_PIN_INFO(9, 0x940, 9, 1, 0),
	MTK_PIN_INFO(10, 0x940, 10, 1, 0),
	MTK_PIN_INFO(11, 0x940, 11, 1, 0),
	MTK_PIN_INFO(12, 0x940, 12, 1, 0),
	MTK_PIN_INFO(13, 0x940, 13, 1, 0),
	MTK_PIN_INFO(14, 0x940, 14, 1, 0),
	MTK_PIN_INFO(15, 0x940, 15, 1, 0),
	MTK_PIN_INFO(16, 0x940, 16, 1, 0),
	MTK_PIN_INFO(17, 0x940, 17, 1, 0),
	MTK_PIN_INFO(18, 0x940, 18, 1, 0),
	MTK_PIN_INFO(19, 0x940, 19, 1, 0),
	MTK_PIN_INFO(20, 0x940, 20, 1, 0),
	MTK_PIN_INFO(21, 0x940, 21, 1, 0),
	MTK_PIN_INFO(22, 0x940, 22, 1, 0),
	MTK_PIN_INFO(23, 0x940, 23, 1, 0),
	MTK_PIN_INFO(24, 0x940, 24, 1, 0),
	MTK_PIN_INFO(25, 0x940, 25, 1, 0),
	MTK_PIN_INFO(26, 0x940, 26, 1, 0),
	MTK_PIN_INFO(27, 0x940, 27, 1, 0),
	MTK_PIN_INFO(28, 0x940, 28, 1, 0),
	MTK_PIN_INFO(29, 0x940, 29, 1, 0),
	MTK_PIN_INFO(30, 0x940, 30, 1, 0),
	MTK_PIN_INFO(31, 0x940, 31, 1, 0),
	MTK_PIN_INFO(32, 0xA40, 0, 1, 0),
	MTK_PIN_INFO(33, 0xA40, 1, 1, 0),
	MTK_PIN_INFO(34, 0xA40, 2, 1, 0),
	MTK_PIN_INFO(35, 0xA40, 3, 1, 0),
	MTK_PIN_INFO(36, 0xA40, 4, 1, 0),
	MTK_PIN_INFO(37, 0xA40, 5, 1, 0),
	MTK_PIN_INFO(38, 0xA40, 6, 1, 0),
	MTK_PIN_INFO(39, 0xA40, 7, 1, 0),
	MTK_PIN_INFO(40, 0xA40, 8, 1, 0),
	MTK_PIN_INFO(41, 0xA40, 9, 1, 0),
	MTK_PIN_INFO(42, 0xA40, 10, 1, 0),
	MTK_PIN_INFO(43, 0xA40, 11, 1, 0),
	MTK_PIN_INFO(44, 0xA40, 12, 1, 0),
	MTK_PIN_INFO(45, 0xA40, 13, 1, 0),
	MTK_PIN_INFO(46, 0xA40, 14, 1, 0),
	MTK_PIN_INFO(47, 0xA40, 15, 1, 0),
	MTK_PIN_INFO(48, 0xA40, 16, 1, 0),
	MTK_PIN_INFO(49, 0xA40, 17, 1, 0),
	MTK_PIN_INFO(50, 0xA40, 18, 1, 0),
	MTK_PIN_INFO(51, 0x840, 0, 1, 0),
	MTK_PIN_INFO(52, 0x840, 1, 1, 0),
	MTK_PIN_INFO(53, 0x840, 2, 1, 0),
	MTK_PIN_INFO(54, 0x840, 3, 1, 0),
	MTK_PIN_INFO(55, 0x840, 4, 1, 0),
	MTK_PIN_INFO(56, 0x840, 5, 1, 0),
	MTK_PIN_INFO(57, 0x840, 6, 1, 0),
	MTK_PIN_INFO(58, 0x840, 7, 1, 0),
	MTK_PIN_INFO(59, 0x840, 10, 1, 0),
	MTK_PIN_INFO(60, 0x840, 11, 1, 0),
	MTK_PIN_INFO(61, 0x840, 8, 1, 0),
	MTK_PIN_INFO(62, 0x840, 9, 1, 0),
	MTK_PIN_INFO(63, 0x840, 12, 1, 0),
	MTK_PIN_INFO(64, 0x840, 13, 1, 0),
	MTK_PIN_INFO(65, 0x840, 14, 1, 0),
	MTK_PIN_INFO(66, 0x840, 15, 1, 0),
	MTK_PIN_INFO(67, 0x840, 18, 1, 0),
	MTK_PIN_INFO(68, 0x840, 19, 1, 0),
	MTK_PIN_INFO(69, 0x840, 16, 1, 0),
	MTK_PIN_INFO(70, 0x840, 17, 1, 0),
	MTK_PIN_INFO(71, 0xB40, 0, 1, 0),
	MTK_PIN_INFO(72, 0xB40, 1, 1, 0),
	MTK_PIN_INFO(73, 0xB40, 4, 1, 0),
	MTK_PIN_INFO(74, 0xB40, 5, 1, 0),
	MTK_PIN_INFO(75, 0xB40, 6, 1, 0),
	MTK_PIN_INFO(76, 0xB40, 7, 1, 0),
	MTK_PIN_INFO(77, 0xB40, 8, 1, 0),
	MTK_PIN_INFO(78, 0xB40, 9, 1, 0),
	MTK_PIN_INFO(79, 0xB40, 10, 1, 0),
	MTK_PIN_INFO(80, 0xB40, 11, 1, 0),
	MTK_PIN_INFO(81, 0xB40, 12, 1, 0),
	MTK_PIN_INFO(82, 0xB40, 13, 1, 0),
	MTK_PIN_INFO(83, 0xB40, 14, 1, 0),
	MTK_PIN_INFO(84, 0xB40, 15, 1, 0),
	MTK_PIN_INFO(85, 0xB40, 16, 1, 0),
	MTK_PIN_INFO(86, 0xB40, 17, 1, 0),
	MTK_PIN_INFO(87, 0xC40, 0, 1, 0),
	MTK_PIN_INFO(88, 0xC40, 1, 1, 0),
	MTK_PIN_INFO(89, 0xC40, 2, 1, 0),
	MTK_PIN_INFO(90, 0xC40, 3, 1, 0),
	MTK_PIN_INFO(91, 0xB40, 18, 1, 0),
	MTK_PIN_INFO(92, 0xB40, 19, 1, 0),
	MTK_PIN_INFO(93, 0xB40, 20, 1, 0),
	MTK_PIN_INFO(94, 0xB40, 21, 1, 0),
	MTK_PIN_INFO(95, 0xB40, 22, 1, 0),
	MTK_PIN_INFO(96, 0xB40, 23, 1, 0),
	MTK_PIN_INFO(97, 0xB40, 24, 1, 0),
	MTK_PIN_INFO(98, 0xB40, 25, 1, 0),
	MTK_PIN_INFO(99, 0xB40, 26, 1, 0),
	MTK_PIN_INFO(100, 0xB40, 27, 1, 0),
	MTK_PIN_INFO(101, 0xB40, 28, 1, 0),
	MTK_PIN_INFO(102, 0xB40, 29, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_drve4[] = {
	MTK_PIN_INFO(0, 0x960, 0, 1, 0),
	MTK_PIN_INFO(1, 0x960, 1, 1, 0),
	MTK_PIN_INFO(2, 0x960, 2, 1, 0),
	MTK_PIN_INFO(3, 0x960, 3, 1, 0),
	MTK_PIN_INFO(4, 0x960, 4, 1, 0),
	MTK_PIN_INFO(5, 0x960, 5, 1, 0),
	MTK_PIN_INFO(6, 0x960, 6, 1, 0),
	MTK_PIN_INFO(7, 0x960, 7, 1, 0),
	MTK_PIN_INFO(8, 0x960, 8, 1, 0),
	MTK_PIN_INFO(9, 0x960, 9, 1, 0),
	MTK_PIN_INFO(10, 0x960, 10, 1, 0),
	MTK_PIN_INFO(11, 0x960, 11, 1, 0),
	MTK_PIN_INFO(12, 0x960, 12, 1, 0),
	MTK_PIN_INFO(13, 0x960, 13, 1, 0),
	MTK_PIN_INFO(14, 0x960, 14, 1, 0),
	MTK_PIN_INFO(15, 0x960, 15, 1, 0),
	MTK_PIN_INFO(16, 0x960, 16, 1, 0),
	MTK_PIN_INFO(17, 0x960, 17, 1, 0),
	MTK_PIN_INFO(18, 0x960, 18, 1, 0),
	MTK_PIN_INFO(19, 0x960, 19, 1, 0),
	MTK_PIN_INFO(20, 0x960, 20, 1, 0),
	MTK_PIN_INFO(21, 0x960, 21, 1, 0),
	MTK_PIN_INFO(22, 0x960, 22, 1, 0),
	MTK_PIN_INFO(23, 0x960, 23, 1, 0),
	MTK_PIN_INFO(24, 0x960, 24, 1, 0),
	MTK_PIN_INFO(25, 0x960, 25, 1, 0),
	MTK_PIN_INFO(26, 0x960, 26, 1, 0),
	MTK_PIN_INFO(27, 0x960, 27, 1, 0),
	MTK_PIN_INFO(28, 0x960, 28, 1, 0),
	MTK_PIN_INFO(29, 0x960, 29, 1, 0),
	MTK_PIN_INFO(30, 0x960, 30, 1, 0),
	MTK_PIN_INFO(31, 0x960, 31, 1, 0),
	MTK_PIN_INFO(32, 0xA60, 0, 1, 0),
	MTK_PIN_INFO(33, 0xA60, 1, 1, 0),
	MTK_PIN_INFO(34, 0xA60, 2, 1, 0),
	MTK_PIN_INFO(35, 0xA60, 3, 1, 0),
	MTK_PIN_INFO(36, 0xA60, 4, 1, 0),
	MTK_PIN_INFO(37, 0xA60, 5, 1, 0),
	MTK_PIN_INFO(38, 0xA60, 6, 1, 0),
	MTK_PIN_INFO(39, 0xA60, 7, 1, 0),
	MTK_PIN_INFO(40, 0xA60, 8, 1, 0),
	MTK_PIN_INFO(41, 0xA60, 9, 1, 0),
	MTK_PIN_INFO(42, 0xA60, 10, 1, 0),
	MTK_PIN_INFO(43, 0xA60, 11, 1, 0),
	MTK_PIN_INFO(44, 0xA60, 12, 1, 0),
	MTK_PIN_INFO(45, 0xA60, 13, 1, 0),
	MTK_PIN_INFO(46, 0xA60, 14, 1, 0),
	MTK_PIN_INFO(47, 0xA60, 15, 1, 0),
	MTK_PIN_INFO(48, 0xA60, 16, 1, 0),
	MTK_PIN_INFO(49, 0xA60, 17, 1, 0),
	MTK_PIN_INFO(50, 0xA60, 18, 1, 0),
	MTK_PIN_INFO(51, 0x860, 0, 1, 0),
	MTK_PIN_INFO(52, 0x860, 1, 1, 0),
	MTK_PIN_INFO(53, 0x860, 2, 1, 0),
	MTK_PIN_INFO(54, 0x860, 3, 1, 0),
	MTK_PIN_INFO(55, 0x860, 4, 1, 0),
	MTK_PIN_INFO(56, 0x860, 5, 1, 0),
	MTK_PIN_INFO(57, 0x860, 6, 1, 0),
	MTK_PIN_INFO(58, 0x860, 7, 1, 0),
	MTK_PIN_INFO(59, 0x860, 10, 1, 0),
	MTK_PIN_INFO(60, 0x860, 11, 1, 0),
	MTK_PIN_INFO(61, 0x860, 8, 1, 0),
	MTK_PIN_INFO(62, 0x860, 9, 1, 0),
	MTK_PIN_INFO(63, 0x860, 12, 1, 0),
	MTK_PIN_INFO(64, 0x860, 13, 1, 0),
	MTK_PIN_INFO(65, 0x860, 14, 1, 0),
	MTK_PIN_INFO(66, 0x860, 15, 1, 0),
	MTK_PIN_INFO(67, 0x860, 18, 1, 0),
	MTK_PIN_INFO(68, 0x860, 19, 1, 0),
	MTK_PIN_INFO(69, 0x860, 16, 1, 0),
	MTK_PIN_INFO(70, 0x860, 17, 1, 0),
	MTK_PIN_INFO(71, 0xB60, 0, 1, 0),
	MTK_PIN_INFO(72, 0xB60, 1, 1, 0),
	MTK_PIN_INFO(73, 0xB60, 4, 1, 0),
	MTK_PIN_INFO(74, 0xB60, 5, 1, 0),
	MTK_PIN_INFO(75, 0xB60, 6, 1, 0),
	MTK_PIN_INFO(76, 0xB60, 7, 1, 0),
	MTK_PIN_INFO(77, 0xB60, 8, 1, 0),
	MTK_PIN_INFO(78, 0xB60, 9, 1, 0),
	MTK_PIN_INFO(79, 0xB60, 10, 1, 0),
	MTK_PIN_INFO(80, 0xB60, 11, 1, 0),
	MTK_PIN_INFO(81, 0xB60, 12, 1, 0),
	MTK_PIN_INFO(82, 0xB60, 13, 1, 0),
	MTK_PIN_INFO(83, 0xB60, 14, 1, 0),
	MTK_PIN_INFO(84, 0xB60, 15, 1, 0),
	MTK_PIN_INFO(85, 0xB60, 16, 1, 0),
	MTK_PIN_INFO(86, 0xB60, 17, 1, 0),
	MTK_PIN_INFO(87, 0xC60, 0, 1, 0),
	MTK_PIN_INFO(88, 0xC60, 1, 1, 0),
	MTK_PIN_INFO(89, 0xC60, 2, 1, 0),
	MTK_PIN_INFO(90, 0xC60, 3, 1, 0),
	MTK_PIN_INFO(91, 0xB60, 18, 1, 0),
	MTK_PIN_INFO(92, 0xB60, 19, 1, 0),
	MTK_PIN_INFO(93, 0xB60, 20, 1, 0),
	MTK_PIN_INFO(94, 0xB60, 21, 1, 0),
	MTK_PIN_INFO(95, 0xB60, 22, 1, 0),
	MTK_PIN_INFO(96, 0xB60, 23, 1, 0),
	MTK_PIN_INFO(97, 0xB60, 24, 1, 0),
	MTK_PIN_INFO(98, 0xB60, 25, 1, 0),
	MTK_PIN_INFO(99, 0xB60, 26, 1, 0),
	MTK_PIN_INFO(100, 0xB60, 27, 1, 0),
	MTK_PIN_INFO(101, 0xB60, 28, 1, 0),
	MTK_PIN_INFO(102, 0xB60, 29, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_drve8[] = {
	MTK_PIN_INFO(0, 0x970, 0, 1, 0),
	MTK_PIN_INFO(1, 0x970, 1, 1, 0),
	MTK_PIN_INFO(2, 0x970, 2, 1, 0),
	MTK_PIN_INFO(3, 0x970, 3, 1, 0),
	MTK_PIN_INFO(4, 0x970, 4, 1, 0),
	MTK_PIN_INFO(5, 0x970, 5, 1, 0),
	MTK_PIN_INFO(6, 0x970, 6, 1, 0),
	MTK_PIN_INFO(7, 0x970, 7, 1, 0),
	MTK_PIN_INFO(8, 0x970, 8, 1, 0),
	MTK_PIN_INFO(9, 0x970, 9, 1, 0),
	MTK_PIN_INFO(10, 0x970, 10, 1, 0),
	MTK_PIN_INFO(11, 0x970, 11, 1, 0),
	MTK_PIN_INFO(12, 0x970, 12, 1, 0),
	MTK_PIN_INFO(13, 0x970, 13, 1, 0),
	MTK_PIN_INFO(14, 0x970, 14, 1, 0),
	MTK_PIN_INFO(15, 0x970, 15, 1, 0),
	MTK_PIN_INFO(16, 0x970, 16, 1, 0),
	MTK_PIN_INFO(17, 0x970, 17, 1, 0),
	MTK_PIN_INFO(18, 0x970, 18, 1, 0),
	MTK_PIN_INFO(19, 0x970, 19, 1, 0),
	MTK_PIN_INFO(20, 0x970, 20, 1, 0),
	MTK_PIN_INFO(21, 0x970, 21, 1, 0),
	MTK_PIN_INFO(22, 0x970, 22, 1, 0),
	MTK_PIN_INFO(23, 0x970, 23, 1, 0),
	MTK_PIN_INFO(24, 0x970, 24, 1, 0),
	MTK_PIN_INFO(25, 0x970, 25, 1, 0),
	MTK_PIN_INFO(26, 0x970, 26, 1, 0),
	MTK_PIN_INFO(27, 0x970, 27, 1, 0),
	MTK_PIN_INFO(28, 0x970, 28, 1, 0),
	MTK_PIN_INFO(29, 0x970, 29, 1, 0),
	MTK_PIN_INFO(30, 0x970, 30, 1, 0),
	MTK_PIN_INFO(31, 0x970, 31, 1, 0),
	MTK_PIN_INFO(32, 0xA70, 0, 1, 0),
	MTK_PIN_INFO(33, 0xA70, 1, 1, 0),
	MTK_PIN_INFO(34, 0xA70, 2, 1, 0),
	MTK_PIN_INFO(35, 0xA70, 3, 1, 0),
	MTK_PIN_INFO(36, 0xA70, 4, 1, 0),
	MTK_PIN_INFO(37, 0xA70, 5, 1, 0),
	MTK_PIN_INFO(38, 0xA70, 6, 1, 0),
	MTK_PIN_INFO(39, 0xA70, 7, 1, 0),
	MTK_PIN_INFO(40, 0xA70, 8, 1, 0),
	MTK_PIN_INFO(41, 0xA70, 9, 1, 0),
	MTK_PIN_INFO(42, 0xA70, 10, 1, 0),
	MTK_PIN_INFO(43, 0xA70, 11, 1, 0),
	MTK_PIN_INFO(44, 0xA70, 12, 1, 0),
	MTK_PIN_INFO(45, 0xA70, 13, 1, 0),
	MTK_PIN_INFO(46, 0xA70, 14, 1, 0),
	MTK_PIN_INFO(47, 0xA70, 15, 1, 0),
	MTK_PIN_INFO(48, 0xA70, 16, 1, 0),
	MTK_PIN_INFO(49, 0xA70, 17, 1, 0),
	MTK_PIN_INFO(50, 0xA70, 18, 1, 0),
	MTK_PIN_INFO(51, 0x870, 0, 1, 0),
	MTK_PIN_INFO(52, 0x870, 1, 1, 0),
	MTK_PIN_INFO(53, 0x870, 2, 1, 0),
	MTK_PIN_INFO(54, 0x870, 3, 1, 0),
	MTK_PIN_INFO(55, 0x870, 4, 1, 0),
	MTK_PIN_INFO(56, 0x870, 5, 1, 0),
	MTK_PIN_INFO(57, 0x870, 6, 1, 0),
	MTK_PIN_INFO(58, 0x870, 7, 1, 0),
	MTK_PIN_INFO(59, 0x870, 10, 1, 0),
	MTK_PIN_INFO(60, 0x870, 11, 1, 0),
	MTK_PIN_INFO(61, 0x870, 8, 1, 0),
	MTK_PIN_INFO(62, 0x870, 9, 1, 0),
	MTK_PIN_INFO(63, 0x870, 12, 1, 0),
	MTK_PIN_INFO(64, 0x870, 13, 1, 0),
	MTK_PIN_INFO(65, 0x870, 14, 1, 0),
	MTK_PIN_INFO(66, 0x870, 15, 1, 0),
	MTK_PIN_INFO(67, 0x870, 18, 1, 0),
	MTK_PIN_INFO(68, 0x870, 19, 1, 0),
	MTK_PIN_INFO(69, 0x870, 16, 1, 0),
	MTK_PIN_INFO(70, 0x870, 17, 1, 0),
	MTK_PIN_INFO(71, 0xB70, 0, 1, 0),
	MTK_PIN_INFO(72, 0xB70, 1, 1, 0),
	MTK_PIN_INFO(73, 0xB70, 4, 1, 0),
	MTK_PIN_INFO(74, 0xB70, 5, 1, 0),
	MTK_PIN_INFO(75, 0xB70, 6, 1, 0),
	MTK_PIN_INFO(76, 0xB70, 7, 1, 0),
	MTK_PIN_INFO(77, 0xB70, 8, 1, 0),
	MTK_PIN_INFO(78, 0xB70, 9, 1, 0),
	MTK_PIN_INFO(79, 0xB70, 10, 1, 0),
	MTK_PIN_INFO(80, 0xB70, 11, 1, 0),
	MTK_PIN_INFO(81, 0xB70, 12, 1, 0),
	MTK_PIN_INFO(82, 0xB70, 13, 1, 0),
	MTK_PIN_INFO(83, 0xB70, 14, 1, 0),
	MTK_PIN_INFO(84, 0xB70, 15, 1, 0),
	MTK_PIN_INFO(85, 0xB70, 16, 1, 0),
	MTK_PIN_INFO(86, 0xB70, 17, 1, 0),
	MTK_PIN_INFO(87, 0xC70, 0, 1, 0),
	MTK_PIN_INFO(88, 0xC70, 1, 1, 0),
	MTK_PIN_INFO(89, 0xC70, 2, 1, 0),
	MTK_PIN_INFO(90, 0xC70, 3, 1, 0),
	MTK_PIN_INFO(91, 0xB70, 18, 1, 0),
	MTK_PIN_INFO(92, 0xB70, 19, 1, 0),
	MTK_PIN_INFO(93, 0xB70, 20, 1, 0),
	MTK_PIN_INFO(94, 0xB70, 21, 1, 0),
	MTK_PIN_INFO(95, 0xB70, 22, 1, 0),
	MTK_PIN_INFO(96, 0xB70, 23, 1, 0),
	MTK_PIN_INFO(97, 0xB70, 24, 1, 0),
	MTK_PIN_INFO(98, 0xB70, 25, 1, 0),
	MTK_PIN_INFO(99, 0xB70, 26, 1, 0),
	MTK_PIN_INFO(100, 0xB70, 27, 1, 0),
	MTK_PIN_INFO(101, 0xB70, 28, 1, 0),
	MTK_PIN_INFO(102, 0xB70, 29, 1, 0),
};

static const struct mtk_pin_info mtk_pin_info_smt[] = {
	MTK_PIN_INFO(0, 0x920, 0, 1, 0),
	MTK_PIN_INFO(1, 0x920, 1, 1, 0),
	MTK_PIN_INFO(2, 0x920, 2, 1, 0),
	MTK_PIN_INFO(3, 0x920, 3, 1, 0),
	MTK_PIN_INFO(4, 0x920, 4, 1, 0),
	MTK_PIN_INFO(5, 0x920, 5, 1, 0),
	MTK_PIN_INFO(6, 0x920, 6, 1, 0),
	MTK_PIN_INFO(7, 0x920, 7, 1, 0),
	MTK_PIN_INFO(8, 0x920, 8, 1, 0),
	MTK_PIN_INFO(9, 0x920, 9, 1, 0),
	MTK_PIN_INFO(10, 0x920, 10, 1, 0),
	MTK_PIN_INFO(11, 0x920, 11, 1, 0),
	MTK_PIN_INFO(12, 0x920, 12, 1, 0),
	MTK_PIN_INFO(13, 0x920, 13, 1, 0),
	MTK_PIN_INFO(14, 0x920, 14, 1, 0),
	MTK_PIN_INFO(15, 0x920, 15, 1, 0),
	MTK_PIN_INFO(16, 0x920, 16, 1, 0),
	MTK_PIN_INFO(17, 0x920, 17, 1, 0),
	MTK_PIN_INFO(18, 0x920, 18, 1, 0),
	MTK_PIN_INFO(19, 0x920, 19, 1, 0),
	MTK_PIN_INFO(20, 0x920, 20, 1, 0),
	MTK_PIN_INFO(21, 0x920, 21, 1, 0),
	MTK_PIN_INFO(22, 0x920, 22, 1, 0),
	MTK_PIN_INFO(23, 0x920, 23, 1, 0),
	MTK_PIN_INFO(24, 0x920, 24, 1, 0),
	MTK_PIN_INFO(25, 0x920, 25, 1, 0),
	MTK_PIN_INFO(26, 0x920, 26, 1, 0),
	MTK_PIN_INFO(27, 0x920, 27, 1, 0),
	MTK_PIN_INFO(28, 0x920, 28, 1, 0),
	MTK_PIN_INFO(29, 0x920, 29, 1, 0),
	MTK_PIN_INFO(30, 0x920, 30, 1, 0),
	MTK_PIN_INFO(31, 0x920, 31, 1, 0),
	MTK_PIN_INFO(32, 0xA20, 0, 1, 0),
	MTK_PIN_INFO(33, 0xA20, 1, 1, 0),
	MTK_PIN_INFO(34, 0xA20, 2, 1, 0),
	MTK_PIN_INFO(35, 0xA20, 3, 1, 0),
	MTK_PIN_INFO(36, 0xA20, 4, 1, 0),
	MTK_PIN_INFO(37, 0xA20, 5, 1, 0),
	MTK_PIN_INFO(38, 0xA20, 6, 1, 0),
	MTK_PIN_INFO(39, 0xA20, 7, 1, 0),
	MTK_PIN_INFO(40, 0xA20, 8, 1, 0),
	MTK_PIN_INFO(41, 0xA20, 9, 1, 0),
	MTK_PIN_INFO(42, 0xA20, 10, 1, 0),
	MTK_PIN_INFO(43, 0xA20, 11, 1, 0),
	MTK_PIN_INFO(44, 0xA20, 12, 1, 0),
	MTK_PIN_INFO(45, 0xA20, 13, 1, 0),
	MTK_PIN_INFO(46, 0xA20, 14, 1, 0),
	MTK_PIN_INFO(47, 0xA20, 15, 1, 0),
	MTK_PIN_INFO(48, 0xA20, 16, 1, 0),
	MTK_PIN_INFO(49, 0xA20, 17, 1, 0),
	MTK_PIN_INFO(50, 0xA20, 18, 1, 0),
	MTK_PIN_INFO(51, 0x820, 0, 1, 0),
	MTK_PIN_INFO(52, 0x820, 1, 1, 0),
	MTK_PIN_INFO(53, 0x820, 2, 1, 0),
	MTK_PIN_INFO(54, 0x820, 3, 1, 0),
	MTK_PIN_INFO(55, 0x820, 4, 1, 0),
	MTK_PIN_INFO(56, 0x820, 5, 1, 0),
	MTK_PIN_INFO(57, 0x820, 6, 1, 0),
	MTK_PIN_INFO(58, 0x820, 7, 1, 0),
	MTK_PIN_INFO(59, 0x820, 10, 1, 0),
	MTK_PIN_INFO(60, 0x820, 11, 1, 0),
	MTK_PIN_INFO(61, 0x820, 8, 1, 0),
	MTK_PIN_INFO(62, 0x820, 9, 1, 0),
	MTK_PIN_INFO(63, 0x820, 12, 1, 0),
	MTK_PIN_INFO(64, 0x820, 13, 1, 0),
	MTK_PIN_INFO(65, 0x820, 14, 1, 0),
	MTK_PIN_INFO(66, 0x820, 15, 1, 0),
	MTK_PIN_INFO(67, 0x820, 18, 1, 0),
	MTK_PIN_INFO(68, 0x820, 19, 1, 0),
	MTK_PIN_INFO(69, 0x820, 16, 1, 0),
	MTK_PIN_INFO(70, 0x820, 17, 1, 0),
	MTK_PIN_INFO(71, 0xB20, 0, 1, 0),
	MTK_PIN_INFO(72, 0xB20, 1, 1, 0),
	MTK_PIN_INFO(73, 0xB20, 4, 1, 0),
	MTK_PIN_INFO(74, 0xB20, 5, 1, 0),
	MTK_PIN_INFO(75, 0xB20, 6, 1, 0),
	MTK_PIN_INFO(76, 0xB20, 7, 1, 0),
	MTK_PIN_INFO(77, 0xB20, 8, 1, 0),
	MTK_PIN_INFO(78, 0xB20, 9, 1, 0),
	MTK_PIN_INFO(79, 0xB20, 10, 1, 0),
	MTK_PIN_INFO(80, 0xB20, 11, 1, 0),
	MTK_PIN_INFO(81, 0xB20, 12, 1, 0),
	MTK_PIN_INFO(82, 0xB20, 13, 1, 0),
	MTK_PIN_INFO(83, 0xB20, 14, 1, 0),
	MTK_PIN_INFO(84, 0xB20, 15, 1, 0),
	MTK_PIN_INFO(85, 0xB20, 16, 1, 0),
	MTK_PIN_INFO(86, 0xB20, 17, 1, 0),
	MTK_PIN_INFO(87, 0xC20, 0, 1, 0),
	MTK_PIN_INFO(88, 0xC20, 1, 1, 0),
	MTK_PIN_INFO(89, 0xC20, 2, 1, 0),
	MTK_PIN_INFO(90, 0xC20, 3, 1, 0),
	MTK_PIN_INFO(91, 0xB20, 18, 1, 0),
	MTK_PIN_INFO(92, 0xB20, 19, 1, 0),
	MTK_PIN_INFO(93, 0xB20, 20, 1, 0),
	MTK_PIN_INFO(94, 0xB20, 21, 1, 0),
	MTK_PIN_INFO(95, 0xB20, 22, 1, 0),
	MTK_PIN_INFO(96, 0xB20, 23, 1, 0),
	MTK_PIN_INFO(97, 0xB20, 24, 1, 0),
	MTK_PIN_INFO(98, 0xB20, 25, 1, 0),
	MTK_PIN_INFO(99, 0xB20, 26, 1, 0),
	MTK_PIN_INFO(100, 0xB20, 27, 1, 0),
	MTK_PIN_INFO(101, 0xB20, 28, 1, 0),
	MTK_PIN_INFO(102, 0xB20, 29, 1, 0),
};

static const struct mtk_desc_pin mtk_pins_mt7622[] = {
	MTK_PIN(PINCTRL_PIN(0, "GPIO_A"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(1, "GPIO0")
	    ),
	MTK_PIN(PINCTRL_PIN(1, "I2S1_IN"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "I2S1_IN "),
		MTK_FUNCTION(1, "GPIO1"),
		MTK_FUNCTION(2, "RTS2_N ")
	    ),
	MTK_PIN(PINCTRL_PIN(2, "I2S1_OUT"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "I2S1_OUT "),
		MTK_FUNCTION(1, "GPIO2"),
		MTK_FUNCTION(2, "CTS2_N ")
	    ),
	MTK_PIN(PINCTRL_PIN(3, "I2S_BCLK"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "I2S_BCLK_OUT "),
		MTK_FUNCTION(1, "GPIO3"),
		MTK_FUNCTION(2, "TXD2 "),
		MTK_FUNCTION(3, "I2S_BCLK_IN ")
	    ),
	MTK_PIN(PINCTRL_PIN(4, "I2S_WS"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "I2S_WS_OUT "),
		MTK_FUNCTION(1, "GPIO4"),
		MTK_FUNCTION(2, "RXD2 "),
		MTK_FUNCTION(3, "I2S_WS_IN ")
	    ),
	MTK_PIN(PINCTRL_PIN(5, "I2S_MCLK"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "I2S_MCLK "),
		MTK_FUNCTION(1, "GPIO5"),
		MTK_FUNCTION(7, "DBG_UTIF17 ")
	    ),
	MTK_PIN(PINCTRL_PIN(6, "TXD0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "TXD0 "),
		MTK_FUNCTION(1, "GPIO6"),
		MTK_FUNCTION(7, "TM_SUTIF_TXD ")
	    ),
	MTK_PIN(PINCTRL_PIN(7, "RXD0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "RXD0 "),
		MTK_FUNCTION(1, "GPIO7"),
		MTK_FUNCTION(7, "TM_SUTIF_RXD ")
	    ),
	MTK_PIN(PINCTRL_PIN(8, "SPI_WP"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "SPI_WP "),
		MTK_FUNCTION(1, "GPIO8"),
		MTK_FUNCTION(2, "SNFI_WP "),
		MTK_FUNCTION(3, "TDM_OUT_MCLK "),
		MTK_FUNCTION(6, "FPC_DAT_STS ")
	    ),
	MTK_PIN(PINCTRL_PIN(9, "SPI_HOLD"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "SPI_HOLD "),
		MTK_FUNCTION(1, "GPIO9"),
		MTK_FUNCTION(2, "SNFI_HOLD "),
		MTK_FUNCTION(3, "TDM_OUT_BCLK "),
		MTK_FUNCTION(6, "FPC_DL_STS ")
	    ),
	MTK_PIN(PINCTRL_PIN(10, "SPI_CLK"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "SPI_CLK "),
		MTK_FUNCTION(1, "GPIO10"),
		MTK_FUNCTION(2, "SNFI_CLK "),
		MTK_FUNCTION(3, "TDM_OUT_WS ")
	    ),
	MTK_PIN(PINCTRL_PIN(11, "SPI_MOSI"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "SPI_MOSI "),
		MTK_FUNCTION(1, "GPIO11"),
		MTK_FUNCTION(2, "SNFI_MOSI "),
		MTK_FUNCTION(3, "TDM_IN_MCLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(12, "SPI_MISO"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 12),
		MTK_FUNCTION(0, "SPI_MISO "),
		MTK_FUNCTION(1, "GPIO12"),
		MTK_FUNCTION(2, "SNFI_MISO "),
		MTK_FUNCTION(3, "TDM_IN_BCLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(13, "SPI_CS"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 13),
		MTK_FUNCTION(0, "SPI_CS "),
		MTK_FUNCTION(1, "GPIO13"),
		MTK_FUNCTION(2, "SNFI_CS "),
		MTK_FUNCTION(3, "TDM_IN_WS ")
	    ),
	MTK_PIN(PINCTRL_PIN(14, "I2C_SDA"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "I2C0_SDA "),
		MTK_FUNCTION(1, "GPIO14"),
		MTK_FUNCTION(2, "PCIE0_PAD_WAKE_N "),
		MTK_FUNCTION(3, "PCIE1_PAD_WAKE_N "),
		MTK_FUNCTION(5, "ANTSEL22 "),
		MTK_FUNCTION(7, "TM_EXT_BGCK ")
	    ),
	MTK_PIN(PINCTRL_PIN(15, "I2C_SCL"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "I2C0_SCL "),
		MTK_FUNCTION(1, "GPIO15"),
		MTK_FUNCTION(2, "PCIE0_PAD_CLKREQ_N "),
		MTK_FUNCTION(3, "PCIE1_PAD_CLKREQ_N "),
		MTK_FUNCTION(5, "ANTSEL23 ")
	    ),
	MTK_PIN(PINCTRL_PIN(16, "I2S2_IN"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "I2S2_IN "),
		MTK_FUNCTION(1, "GPIO16"),
		MTK_FUNCTION(2, "SD_D3 "),
		MTK_FUNCTION(4, "IR_T "),
		MTK_FUNCTION(5, "ANTSEL24 "),
		MTK_FUNCTION(6, "BT_EPA_EN "),
		MTK_FUNCTION(7, "DBG_UTIF10 ")
	    ),
	MTK_PIN(PINCTRL_PIN(17, "I2S3_IN"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "I2S3_IN "),
		MTK_FUNCTION(1, "GPIO17"),
		MTK_FUNCTION(2, "SD_D2 "),
		MTK_FUNCTION(4, "IR_R "),
		MTK_FUNCTION(5, "ANTSEL25 "),
		MTK_FUNCTION(6, "BT_ELNA_EN "),
		MTK_FUNCTION(7, "DBG_UTIF11 ")
	    ),
	MTK_PIN(PINCTRL_PIN(18, "I2S4_IN"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "I2S4_IN "),
		MTK_FUNCTION(1, "GPIO18"),
		MTK_FUNCTION(2, "SD_D1 "),
		MTK_FUNCTION(5, "ANTSEL26 "),
		MTK_FUNCTION(6, "BT_ERX_EN "),
		MTK_FUNCTION(7, "DBG_UTIF12 ")
	    ),
	MTK_PIN(PINCTRL_PIN(19, "I2S2_OUT"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "I2S2_OUT "),
		MTK_FUNCTION(1, "GPIO19"),
		MTK_FUNCTION(2, "SD_D0 "),
		MTK_FUNCTION(5, "ANTSEL27 "),
		MTK_FUNCTION(6, "BT_IPATH_EN "),
		MTK_FUNCTION(7, "DBG_UTIF13 ")
	    ),
	MTK_PIN(PINCTRL_PIN(20, "I2S3_OUT"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "I2S3_OUT "),
		MTK_FUNCTION(1, "GPIO20"),
		MTK_FUNCTION(2, "SD_CLK "),
		MTK_FUNCTION(3, "TDM_OUT_DATA "),
		MTK_FUNCTION(5, "ANTSEL28 "),
		MTK_FUNCTION(6, "BT_SPXT_C1 "),
		MTK_FUNCTION(7, "DBG_UTIF14 ")
	    ),
	MTK_PIN(PINCTRL_PIN(21, "I2S4_OUT"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "I2S4_OUT "),
		MTK_FUNCTION(1, "GPIO21"),
		MTK_FUNCTION(2, "SD_CMD "),
		MTK_FUNCTION(3, "TDM_IN_DATA "),
		MTK_FUNCTION(5, "ANTSEL29 "),
		MTK_FUNCTION(6, "BT_SPXT_C0 "),
		MTK_FUNCTION(7, "DBG_UTIF15 ")
	    ),
	MTK_PIN(PINCTRL_PIN(22, "GPIO_B"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 22),
		MTK_FUNCTION(1, "GPIO22"),
		MTK_FUNCTION(3, "TSF_INTR "),
		MTK_FUNCTION(5, "ANTSEL17 "),
		MTK_FUNCTION(7, "DBG_UTIF16 ")
	    ),
	MTK_PIN(PINCTRL_PIN(23, "MDC"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "MDC "),
		MTK_FUNCTION(1, "GPIO23")
	    ),
	MTK_PIN(PINCTRL_PIN(24, "MDIO"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "MDIO "),
		MTK_FUNCTION(1, "GPIO24")
	    ),
	MTK_PIN(PINCTRL_PIN(25, "G2_TXD0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "G2_TXD0 "),
		MTK_FUNCTION(1, "GPIO25"),
		MTK_FUNCTION(2, "SD_D3 ")
	    ),
	MTK_PIN(PINCTRL_PIN(26, "G2_TXD1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "G2_TXD1 "),
		MTK_FUNCTION(1, "GPIO26"),
		MTK_FUNCTION(2, "SD_D2 ")
	    ),
	MTK_PIN(PINCTRL_PIN(27, "G2_TXD2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "G2_TXD2 "),
		MTK_FUNCTION(1, "GPIO27"),
		MTK_FUNCTION(2, "SD_D1 ")
	    ),
	MTK_PIN(PINCTRL_PIN(28, "G2_TXD3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "G2_TXD3 "),
		MTK_FUNCTION(1, "GPIO28"),
		MTK_FUNCTION(2, "SD_D0 ")
	    ),
	MTK_PIN(PINCTRL_PIN(29, "G2_TXEN"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "G2_TXEN "),
		MTK_FUNCTION(1, "GPIO29"),
		MTK_FUNCTION(2, "SD_CLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(30, "G2_TXC"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "G2_TXC "),
		MTK_FUNCTION(1, "GPIO30"),
		MTK_FUNCTION(2, "SD_CMD ")
	    ),
	MTK_PIN(PINCTRL_PIN(31, "G2_RXD0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "G2_RXD0 "),
		MTK_FUNCTION(1, "GPIO31")
	    ),
	MTK_PIN(PINCTRL_PIN(32, "G2_RXD1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "G2_RXD1 "),
		MTK_FUNCTION(1, "GPIO32")
	    ),
	MTK_PIN(PINCTRL_PIN(33, "G2_RXD2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "G2_RXD2 "),
		MTK_FUNCTION(1, "GPIO33")
	    ),
	MTK_PIN(PINCTRL_PIN(34, "G2_RXD3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "G2_RXD3 "),
		MTK_FUNCTION(1, "GPIO34")
	    ),
	MTK_PIN(PINCTRL_PIN(35, "G2_RXDV"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "G2_RXDV "),
		MTK_FUNCTION(1, "GPIO35")
	    ),
	MTK_PIN(PINCTRL_PIN(36, "G2_RXC"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "G2_RXC "),
		MTK_FUNCTION(1, "GPIO36")
	    ),
	MTK_PIN(PINCTRL_PIN(37, "NCEB"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "ND_CS_N "),
		MTK_FUNCTION(1, "GPIO37"),
		MTK_FUNCTION(7, "DBG_UTIF18 ")
	    ),
	MTK_PIN(PINCTRL_PIN(38, "NWEB"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "ND_WE_N "),
		MTK_FUNCTION(1, "GPIO38"),
		MTK_FUNCTION(7, "DBG_UTIF19 ")
	    ),
	MTK_PIN(PINCTRL_PIN(39, "NREB"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "ND_RE_N "),
		MTK_FUNCTION(1, "GPIO39"),
		MTK_FUNCTION(7, "DBG_UTIF20 ")
	    ),
	MTK_PIN(PINCTRL_PIN(40, "NDL4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "ND_D4 "),
		MTK_FUNCTION(1, "GPIO40"),
		MTK_FUNCTION(2, "EMMC_DATA4 "),
		MTK_FUNCTION(7, "DBG_UTIF21 ")
	    ),
	MTK_PIN(PINCTRL_PIN(41, "NDL5"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "ND_D5 "),
		MTK_FUNCTION(1, "GPIO41"),
		MTK_FUNCTION(2, "EMMC_DATA5 "),
		MTK_FUNCTION(7, "DBG_UTIF22 ")
	    ),
	MTK_PIN(PINCTRL_PIN(42, "NDL6"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "ND_D6 "),
		MTK_FUNCTION(1, "GPIO42"),
		MTK_FUNCTION(2, "EMMC_DATA6 "),
		MTK_FUNCTION(7, "DBG_UTIF23 ")
	    ),
	MTK_PIN(PINCTRL_PIN(43, "NDL7"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "ND_D7 "),
		MTK_FUNCTION(1, "GPIO43"),
		MTK_FUNCTION(2, "EMMC_DATA7 "),
		MTK_FUNCTION(7, "DBG_UTIF24 ")
	    ),
	MTK_PIN(PINCTRL_PIN(44, "NRB"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "ND_RB_N "),
		MTK_FUNCTION(1, "GPIO44"),
		MTK_FUNCTION(2, "EMMC_CMD "),
		MTK_FUNCTION(7, "DBG_UTIF25 ")
	    ),
	MTK_PIN(PINCTRL_PIN(45, "NCLE"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "ND_CLE "),
		MTK_FUNCTION(1, "GPIO45"),
		MTK_FUNCTION(2, "EMMC_CK "),
		MTK_FUNCTION(7, "DBG_UTIF26 ")
	    ),
	MTK_PIN(PINCTRL_PIN(46, "NALE"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "ND_ALE "),
		MTK_FUNCTION(1, "GPIO46"),
		MTK_FUNCTION(7, "DBG_UTIF27 ")
	    ),
	MTK_PIN(PINCTRL_PIN(47, "NDL0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "ND_D0 "),
		MTK_FUNCTION(1, "GPIO47"),
		MTK_FUNCTION(2, "EMMC_DATA0 "),
		MTK_FUNCTION(7, "DBG_UTIF28 ")
	    ),
	MTK_PIN(PINCTRL_PIN(48, "NDL1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "ND_D1 "),
		MTK_FUNCTION(1, "GPIO48"),
		MTK_FUNCTION(2, "EMMC_DATA1 "),
		MTK_FUNCTION(7, "DBG_UTIF29 ")
	    ),
	MTK_PIN(PINCTRL_PIN(49, "NDL2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "ND_D2 "),
		MTK_FUNCTION(1, "GPIO49"),
		MTK_FUNCTION(2, "EMMC_DATA2 "),
		MTK_FUNCTION(7, "DBG_UTIF30 ")
	    ),
	MTK_PIN(PINCTRL_PIN(50, "NDL3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "ND_D3 "),
		MTK_FUNCTION(1, "GPIO50"),
		MTK_FUNCTION(2, "EMMC_DATA3 "),
		MTK_FUNCTION(7, "DBG_UTIF31 ")
	    ),
	MTK_PIN(PINCTRL_PIN(51, "MDI_TP_P0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "TXD2 "),
		MTK_FUNCTION(1, "GPIO51"),
		MTK_FUNCTION(3, "PWM_CH1 ")
	    ),
	MTK_PIN(PINCTRL_PIN(52, "MDI_TN_P0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "RXD2 "),
		MTK_FUNCTION(1, "GPIO52"),
		MTK_FUNCTION(3, "PWM_CH2 ")
	    ),
	MTK_PIN(PINCTRL_PIN(53, "MDI_RP_P0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "RTS2_N "),
		MTK_FUNCTION(1, "GPIO53"),
		MTK_FUNCTION(3, "PWM_CH3 ")
	    ),
	MTK_PIN(PINCTRL_PIN(54, "MDI_RN_P0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "CTS2_N "),
		MTK_FUNCTION(1, "GPIO54"),
		MTK_FUNCTION(3, "PWM_CH4 ")
	    ),
	MTK_PIN(PINCTRL_PIN(55, "MDI_TP_P1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "I2C1_SCL "),
		MTK_FUNCTION(1, "GPIO55"),
		MTK_FUNCTION(2, "TXD1 "),
		MTK_FUNCTION(3, "TDM_OUT_DATA ")
	    ),
	MTK_PIN(PINCTRL_PIN(56, "MDI_TN_P1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "I2C1_SDA "),
		MTK_FUNCTION(1, "GPIO56"),
		MTK_FUNCTION(2, "RXD1 "),
		MTK_FUNCTION(3, "TDM_IN_DATA ")
	    ),
	MTK_PIN(PINCTRL_PIN(57, "MDI_RP_P1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "I2C2_SCL "),
		MTK_FUNCTION(1, "GPIO57"),
		MTK_FUNCTION(2, "RTS1_N "),
		MTK_FUNCTION(3, "TDM_OUT_MCLK "),
		MTK_FUNCTION(5, "TXD3 ")
	    ),
	MTK_PIN(PINCTRL_PIN(58, "MDI_RN_P1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "I2C2_SDA "),
		MTK_FUNCTION(1, "GPIO58"),
		MTK_FUNCTION(2, "CTS1_N "),
		MTK_FUNCTION(3, "TDM_OUT_BCLK "),
		MTK_FUNCTION(5, "RXD3 ")
	    ),
	MTK_PIN(PINCTRL_PIN(59, "MDI_RP_P2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "ESW_TXD0 "),
		MTK_FUNCTION(1, "GPIO59"),
		MTK_FUNCTION(2, "G1_TXD0 "),
		MTK_FUNCTION(3, "TDM_OUT_WS "),
		MTK_FUNCTION(4, "TXD2 "),
		MTK_FUNCTION(5, "IR_T ")
	    ),
	MTK_PIN(PINCTRL_PIN(60, "MDI_RN_P2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "ESW_TXD1 "),
		MTK_FUNCTION(1, "GPIO60"),
		MTK_FUNCTION(2, "G1_TXD1 "),
		MTK_FUNCTION(3, "TDM_IN_MCLK "),
		MTK_FUNCTION(4, "RXD2 "),
		MTK_FUNCTION(5, "IR_R ")
	    ),
	MTK_PIN(PINCTRL_PIN(61, "MDI_TP_P2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "ESW_TXD2 "),
		MTK_FUNCTION(1, "GPIO61"),
		MTK_FUNCTION(2, "G1_TXD2 "),
		MTK_FUNCTION(3, "TDM_IN_BCLK "),
		MTK_FUNCTION(4, "RTS2_N "),
		MTK_FUNCTION(5, "TXD4 ")
	    ),
	MTK_PIN(PINCTRL_PIN(62, "MDI_TN_P2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "ESW_TXD3 "),
		MTK_FUNCTION(1, "GPIO62"),
		MTK_FUNCTION(2, "G1_TXD3 "),
		MTK_FUNCTION(3, "TDM_IN_WS "),
		MTK_FUNCTION(4, "CTS2_N "),
		MTK_FUNCTION(5, "RXD4 ")
	    ),
	MTK_PIN(PINCTRL_PIN(63, "MDI_TP_P3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "ESW_TXEN "),
		MTK_FUNCTION(1, "GPIO63"),
		MTK_FUNCTION(2, "G1_TXEN "),
		MTK_FUNCTION(4, "SPIC0_CLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(64, "MDI_TN_P3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "ESW_TXC "),
		MTK_FUNCTION(1, "GPIO64"),
		MTK_FUNCTION(2, "G1_TXC "),
		MTK_FUNCTION(4, "SPIC0_MOSI ")
	    ),
	MTK_PIN(PINCTRL_PIN(65, "MDI_RP_P3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "ESW_RXD0 "),
		MTK_FUNCTION(1, "GPIO65"),
		MTK_FUNCTION(2, "G1_RXD0 "),
		MTK_FUNCTION(4, "SPIC0_MISO ")
	    ),
	MTK_PIN(PINCTRL_PIN(66, "MDI_RN_P3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "ESW_RXD1 "),
		MTK_FUNCTION(1, "GPIO66"),
		MTK_FUNCTION(2, "G1_RXD1 "),
		MTK_FUNCTION(4, "SPIC0_CS ")
	    ),
	MTK_PIN(PINCTRL_PIN(67, "MDI_RP_P4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "ESW_RXD2 "),
		MTK_FUNCTION(1, "GPIO67"),
		MTK_FUNCTION(2, "G1_RXD2 "),
		MTK_FUNCTION(3, "PWM_CH4 "),
		MTK_FUNCTION(4, "SPIC1_CLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(68, "MDI_RN_P4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "ESW_RXD3 "),
		MTK_FUNCTION(1, "GPIO68"),
		MTK_FUNCTION(2, "G1_RXD3 "),
		MTK_FUNCTION(3, "PWM_CH5 "),
		MTK_FUNCTION(4, "SPIC1_MOSI ")
	    ),
	MTK_PIN(PINCTRL_PIN(69, "MDI_TP_P4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "ESW_RXDV "),
		MTK_FUNCTION(1, "GPIO69"),
		MTK_FUNCTION(2, "G1_RXDV "),
		MTK_FUNCTION(3, "PWM_CH6 "),
		MTK_FUNCTION(4, "SPIC1_MISO ")
	    ),
	MTK_PIN(PINCTRL_PIN(70, "MDI_TN_P4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "ESW_RXC "),
		MTK_FUNCTION(1, "GPIO70"),
		MTK_FUNCTION(2, "G1_RXC "),
		MTK_FUNCTION(3, "PWM_CH7 "),
		MTK_FUNCTION(4, "SPIC1_CS ")
	    ),
	MTK_PIN(PINCTRL_PIN(71, "SPI2_CK"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "SPI2_CK "),
		MTK_FUNCTION(1, "GPIO71")
	    ),
	MTK_PIN(PINCTRL_PIN(72, "SPI2_DATA"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "SPI2_DATA "),
		MTK_FUNCTION(1, "GPIO72")
	    ),
	MTK_PIN(PINCTRL_PIN(73, "SPIC1_CLK"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "SPIC1_CLK "),
		MTK_FUNCTION(1, "GPIO73"),
		MTK_FUNCTION(2, "TXD1 "),
		MTK_FUNCTION(3, "I2C1_SCL "),
		MTK_FUNCTION(4, "PWM_CH1 "),
		MTK_FUNCTION(5, "ANTSEL12 "),
		MTK_FUNCTION(7, "DBG_UTIF0 ")
	    ),
	MTK_PIN(PINCTRL_PIN(74, "SPIC1_MOSI"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "SPIC1_MOSI "),
		MTK_FUNCTION(1, "GPIO74"),
		MTK_FUNCTION(2, "RXD1 "),
		MTK_FUNCTION(3, "I2C1_SDA "),
		MTK_FUNCTION(4, "PWM_CH2 "),
		MTK_FUNCTION(5, "ANTSEL13 "),
		MTK_FUNCTION(7, "DBG_UTIF1 ")
	    ),
	MTK_PIN(PINCTRL_PIN(75, "SPIC1_MISO"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "SPIC1_MISO "),
		MTK_FUNCTION(1, "GPIO75"),
		MTK_FUNCTION(2, "RTS1_N "),
		MTK_FUNCTION(3, "I2C2_SCL "),
		MTK_FUNCTION(4, "PWM_CH3 "),
		MTK_FUNCTION(5, "ANTSEL14 "),
		MTK_FUNCTION(7, "DBG_UTIF2 ")
	    ),
	MTK_PIN(PINCTRL_PIN(76, "SPIC1_CS"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "SPIC1_CS "),
		MTK_FUNCTION(1, "GPIO76"),
		MTK_FUNCTION(2, "CTS1_N "),
		MTK_FUNCTION(3, "I2C2_SDA "),
		MTK_FUNCTION(4, "PWM_CH4 "),
		MTK_FUNCTION(5, "ANTSEL15 "),
		MTK_FUNCTION(7, "DBG_UTIF3 ")
	    ),
	MTK_PIN(PINCTRL_PIN(77, "GPIO_D"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(1, "GPIO77"),
		MTK_FUNCTION(4, "PWM_CH5 "),
		MTK_FUNCTION(5, "ANTSEL16 "),
		MTK_FUNCTION(7, "DBG_UTIF4 ")
	    ),
	MTK_PIN(PINCTRL_PIN(78, "WATCHDOG"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "WATCHDOG "),
		MTK_FUNCTION(1, "GPIO78"),
		MTK_FUNCTION(4, "PWM_CH6 "),
		MTK_FUNCTION(5, "ANTSEL17 "),
		MTK_FUNCTION(7, "DBG_UTIF5 ")
	    ),
	MTK_PIN(PINCTRL_PIN(79, "RTS3_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "RTS3_N "),
		MTK_FUNCTION(1, "GPIO79"),
		MTK_FUNCTION(3, "SPIC0_MISO "),
		MTK_FUNCTION(4, "PCIE0_PAD_WAKE_N "),
		MTK_FUNCTION(5, "ANTSEL18 "),
		MTK_FUNCTION(7, "DBG_UTIF6 ")
	    ),
	MTK_PIN(PINCTRL_PIN(80, "CTS3_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "CTS3_N "),
		MTK_FUNCTION(1, "GPIO80"),
		MTK_FUNCTION(3, "SPIC0_CS "),
		MTK_FUNCTION(4, "PCIE0_PAD_CLKREQ_N "),
		MTK_FUNCTION(5, "ANTSEL19 "),
		MTK_FUNCTION(7, "DBG_UTIF7 ")
	    ),
	MTK_PIN(PINCTRL_PIN(81, "TXD3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "TXD3 "),
		MTK_FUNCTION(1, "GPIO81"),
		MTK_FUNCTION(2, "SPDIF_T "),
		MTK_FUNCTION(3, "SPIC0_CLK "),
		MTK_FUNCTION(4, "PWM_CH6 "),
		MTK_FUNCTION(5, "ANTSEL20 "),
		MTK_FUNCTION(7, "DBG_UTIF8 ")
	    ),
	MTK_PIN(PINCTRL_PIN(82, "RXD3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "RXD3 "),
		MTK_FUNCTION(1, "GPIO82"),
		MTK_FUNCTION(2, "SPDIF_R "),
		MTK_FUNCTION(3, "SPIC0_MOSI "),
		MTK_FUNCTION(4, "PWM_CH7 "),
		MTK_FUNCTION(5, "ANTSEL21 "),
		MTK_FUNCTION(7, "DBG_UTIF9 ")
	    ),
	MTK_PIN(PINCTRL_PIN(83, "PERST0_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "PCIE0_PAD_PERST_N "),
		MTK_FUNCTION(1, "GPIO83")
	    ),
	MTK_PIN(PINCTRL_PIN(84, "PERST1_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "PCIE1_PAD_PERST_N "),
		MTK_FUNCTION(1, "GPIO84")
	    ),
	MTK_PIN(PINCTRL_PIN(85, "WLED_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "WLED_N "),
		MTK_FUNCTION(1, "GPIO85")
	    ),
	MTK_PIN(PINCTRL_PIN(86, "EPHY_LED0_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "EPHY_LED0_N "),
		MTK_FUNCTION(1, "GPIO86"),
		MTK_FUNCTION(4, "CPUM_HW_SEL "),
		MTK_FUNCTION(6, "FPC_CTL0 "),
		MTK_FUNCTION(7, "JTRST_N ")
	    ),
	MTK_PIN(PINCTRL_PIN(87, "AUXIN0"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "I2C1_SCL "),
		MTK_FUNCTION(1, "GPIO87")
	    ),
	MTK_PIN(PINCTRL_PIN(88, "AUXIN1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "I2C1_SDA "),
		MTK_FUNCTION(1, "GPIO88")
	    ),
	MTK_PIN(PINCTRL_PIN(89, "AUXIN2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "I2C2_SCL "),
		MTK_FUNCTION(1, "GPIO89")
	    ),
	MTK_PIN(PINCTRL_PIN(90, "AUXIN3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "I2C2_SDA "),
		MTK_FUNCTION(1, "GPIO90")
	    ),
	MTK_PIN(PINCTRL_PIN(91, "TXD4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "TXD4 "),
		MTK_FUNCTION(1, "GPIO91"),
		MTK_FUNCTION(2, "EPHY_LED1_N "),
		MTK_FUNCTION(3, "DFD_TDI "),
		MTK_FUNCTION(4, "CPUM_2B_SEL "),
		MTK_FUNCTION(5, "ANTSEL0 "),
		MTK_FUNCTION(6, "FPC_CK_XI "),
		MTK_FUNCTION(7, "JTDI ")
	    ),
	MTK_PIN(PINCTRL_PIN(92, "RXD4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "RXD4 "),
		MTK_FUNCTION(1, "GPIO92"),
		MTK_FUNCTION(2, "EPHY_LED2_N "),
		MTK_FUNCTION(3, "DFD_TDO "),
		MTK_FUNCTION(4, "CPUM0 "),
		MTK_FUNCTION(5, "ANTSEL1 "),
		MTK_FUNCTION(6, "FPC_CTL1 "),
		MTK_FUNCTION(7, "JTDO ")
	    ),
	MTK_PIN(PINCTRL_PIN(93, "RTS4_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "RTS4_N "),
		MTK_FUNCTION(1, "GPIO93"),
		MTK_FUNCTION(2, "EPHY_LED3_N "),
		MTK_FUNCTION(3, "DFD_TCK "),
		MTK_FUNCTION(4, "CPUM1 "),
		MTK_FUNCTION(5, "ANTSEL2 "),
		MTK_FUNCTION(6, "FPC_CTL2 "),
		MTK_FUNCTION(7, "JTCLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(94, "CTS4_N"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "CTS4_N "),
		MTK_FUNCTION(1, "GPIO94"),
		MTK_FUNCTION(2, "EPHY_LED4_N "),
		MTK_FUNCTION(3, "DFD_TMS "),
		MTK_FUNCTION(4, "CPUM2 "),
		MTK_FUNCTION(5, "ANTSEL3 "),
		MTK_FUNCTION(6, "FPC_CTL3 "),
		MTK_FUNCTION(7, "JTMS ")
	    ),
	MTK_PIN(PINCTRL_PIN(95, "PWM1"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "PWM_CH1 "),
		MTK_FUNCTION(1, "GPIO95"),
		MTK_FUNCTION(2, "RTS4_N "),
		MTK_FUNCTION(3, "TXD2 "),
		MTK_FUNCTION(4, "CPUM3 "),
		MTK_FUNCTION(5, "ANTSEL4 "),
		MTK_FUNCTION(6, "FPC_DATA0 "),
		MTK_FUNCTION(7, "W_DBGIN ")
	    ),
	MTK_PIN(PINCTRL_PIN(96, "PWM2"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "PWM_CH2 "),
		MTK_FUNCTION(1, "GPIO96"),
		MTK_FUNCTION(2, "CTS4_N "),
		MTK_FUNCTION(3, "RXD2 "),
		MTK_FUNCTION(4, "CPUM_CK_XI "),
		MTK_FUNCTION(5, "ANTSEL5 "),
		MTK_FUNCTION(6, "FPC_DATA1 "),
		MTK_FUNCTION(7, "W_DBGACK ")
	    ),
	MTK_PIN(PINCTRL_PIN(97, "PWM3"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "PWM_CH3 "),
		MTK_FUNCTION(1, "GPIO97"),
		MTK_FUNCTION(2, "TXD4 "),
		MTK_FUNCTION(4, "AICE_TCKC "),
		MTK_FUNCTION(5, "ANTSEL6 "),
		MTK_FUNCTION(6, "FPC_DATA2 "),
		MTK_FUNCTION(7, "W_JTCLK ")
	    ),
	MTK_PIN(PINCTRL_PIN(98, "PWM4"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "PWM_CH4 "),
		MTK_FUNCTION(1, "GPIO98"),
		MTK_FUNCTION(2, "RXD4 "),
		MTK_FUNCTION(5, "ANTSEL7 "),
		MTK_FUNCTION(6, "FPC_DATA3 "),
		MTK_FUNCTION(7, "W_JTDI ")
	    ),
	MTK_PIN(PINCTRL_PIN(99, "PWM5"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "PWM_CH5 "),
		MTK_FUNCTION(1, "GPIO99"),
		MTK_FUNCTION(3, "IR_T "),
		MTK_FUNCTION(4, "AICE_TMSC "),
		MTK_FUNCTION(5, "ANTSEL8 "),
		MTK_FUNCTION(6, "FPC_DATA4 "),
		MTK_FUNCTION(7, "W_JTMS ")
	    ),
	MTK_PIN(PINCTRL_PIN(100, "PWM6"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "PWM_CH6 "),
		MTK_FUNCTION(1, "GPIO100"),
		MTK_FUNCTION(3, "IR_R "),
		MTK_FUNCTION(5, "ANTSEL9 "),
		MTK_FUNCTION(6, "FPC_DATA5 "),
		MTK_FUNCTION(7, "W_JTRST_N ")
	    ),
	MTK_PIN(PINCTRL_PIN(101, "PWM7"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "PWM_CH7 "),
		MTK_FUNCTION(1, "GPIO101"),
		MTK_FUNCTION(5, "ANTSEL10 "),
		MTK_FUNCTION(6, "FPC_DATA6 "),
		MTK_FUNCTION(7, "DBG_UART_TXD ")
	    ),
	MTK_PIN(PINCTRL_PIN(102, "GPIO_E"),
		NULL, "mt7622",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(1, "GPIO102"),
		MTK_FUNCTION(5, "ANTSEL11 "),
		MTK_FUNCTION(6, "FPC_DATA7 "),
		MTK_FUNCTION(7, "W_JTDO ")
	    ),
};

#endif				/* __PINCTRL_MTK_MT7622_H */
