/*
 * Copyright (c) 2015, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * Sonos Signature format support
 */

#ifndef SONOS_SIGNATURE_KEYS_H
#define SONOS_SIGNATURE_KEYS_H

#include <crypto/sha.h>
#include "sonos_signature.h"

typedef struct {
	struct key *key;
	const uint8_t *der;
	size_t derLen;
        const char *name;
        SonosKeyIdentifierScheme_t keyIdScheme;
        uint8_t keyId[SHA1_DIGEST_SIZE];
        size_t keyIdLen;
} SonosRsaKeyEntry;

extern const SonosRsaKeyEntry * const g_SonosSigningKeys[];

extern void sonosInitKeyTable(void);

#endif
