#ifndef __FENWAY_GPIO_H__
#define __FENWAY_GPIO_H__

#define FENWAY_ANVIL_ID_PIN  25
#define FENWAY_ANVIL_ID_MASK (1 << (31 - FENWAY_ANVIL_ID_PIN))

/*  F E N W A Y  */

/* Fenway buttons GPIO pins */
#define FENWAY_GPIO_MUTE_PIN     1
#define FENWAY_GPIO_VOL_DWN_PIN 13
#define FENWAY_GPIO_VOL_UP_PIN  14

/* Fenway buttons GPIO masks */
#define FENWAY_GPIO_MUTE_MASK    (1 << (31 - FENWAY_GPIO_MUTE_PIN))
#define FENWAY_GPIO_VOL_DWN_MASK (1 << (31 - FENWAY_GPIO_VOL_DWN_PIN)) 
#define FENWAY_GPIO_VOL_UP_MASK  (1 << (31 - FENWAY_GPIO_VOL_UP_PIN))
#define FENWAY_GPIO_BUTTONS_MASK \
        (FENWAY_GPIO_MUTE_MASK | FENWAY_GPIO_VOL_DWN_MASK | FENWAY_GPIO_VOL_UP_MASK) 

/* Fenway LEDs GPIO pins */
#define FENWAY_GPIO_LED_AMBER_PIN    2
#define FENWAY_GPIO_LED_RED_PIN      3
#define FENWAY_GPIO_LED_GREEN_PIN    4
#define FENWAY_GPIO_LED_MOTION_PIN   7
#define FENWAY_GPIO_LED_WHITE_PIN   15

/* Fenway LEDs GPIO masks */
#define FENWAY_GPIO_LED_AMBER_MASK (1 << (31 - FENWAY_GPIO_LED_AMBER_PIN))
#define FENWAY_GPIO_LED_RED_MASK   (1 << (31 - FENWAY_GPIO_LED_RED_PIN))
#define FENWAY_GPIO_LED_GREEN_MASK (1 << (31 - FENWAY_GPIO_LED_GREEN_PIN))
#define FENWAY_GPIO_LED_WHITE_MASK (1 << (31 - FENWAY_GPIO_LED_WHITE_PIN))
#define FENWAY_GPIO_LEDS_MASK      (FENWAY_GPIO_LED_AMBER_MASK | FENWAY_GPIO_LED_RED_MASK | \
                                    FENWAY_GPIO_LED_WHITE_MASK | FENWAY_GPIO_LED_GREEN_MASK)

/* Fenway audio pins */
#define FENWAY_GPIO_AUDIO_RESET_PIN  16
#define FENWAY_GPIO_AUDIO_PWRDN_PIN   9

/* Fenway audio pin masks */
#define FENWAY_GPIO_AUDIO_RESET_MASK  (1 << (31 - FENWAY_GPIO_AUDIO_RESET_PIN))
#define FENWAY_GPIO_AUDIO_PWRDN_MASK  (1 << (31 - FENWAY_GPIO_AUDIO_PWRDN_PIN))

#define FENWAY_SICRH 0x7FDFF500
#define FENWAY_SICRL 0xF0000000


/*  A N V I L  */

/* Anvil buttons GPIO pins */
#define ANVIL_GPIO_MUTE_PIN     1

/* Anvil buttons GPIO masks */
#define ANVIL_GPIO_MUTE_MASK    (1 << (31 - ANVIL_GPIO_MUTE_PIN))
#define ANVIL_GPIO_BUTTONS_MASK (ANVIL_GPIO_MUTE_MASK)

/* Anvil LEDs GPIO pins */
#define ANVIL_GPIO_LED_AMBER_PIN        2
#define ANVIL_GPIO_LED_RED_PIN          3
#define ANVIL_GPIO_LED_GREEN_PIN        7
#define ANVIL_GPIO_LED_WHITE_PIN_FIXED  5  
#define ANVIL_GPIO_LED_WHITE_PIN       11  

/* Anvil LEDs GPIO masks */
#define ANVIL_GPIO_LED_AMBER_MASK (1 << (31 - ANVIL_GPIO_LED_AMBER_PIN))
#define ANVIL_GPIO_LED_RED_MASK   (1 << (31 - ANVIL_GPIO_LED_RED_PIN))
#define ANVIL_GPIO_LED_GREEN_MASK (1 << (31 - ANVIL_GPIO_LED_GREEN_PIN))
#define ANVIL_GPIO_LED_WHITE_MASK (1 << (31 - ANVIL_GPIO_LED_WHITE_PIN))
#define ANVIL_GPIO_LED_WHITE_FIXED_MASK (1 << (31 - ANVIL_GPIO_LED_WHITE_PIN_FIXED))
#define ANVIL_GPIO_LEDS_MASK      (ANVIL_GPIO_LED_AMBER_MASK | ANVIL_GPIO_LED_RED_MASK | \
                                   ANVIL_GPIO_LED_WHITE_MASK | ANVIL_GPIO_LED_WHITE_FIXED_MASK | \
                                   ANVIL_GPIO_LED_GREEN_MASK)

/* Anvil audio pins */
#define ANVIL_GPIO_AMP_READY_PIN   6
#define ANVIL_GPIO_AMP_CLIP_PIN    7
#define ANVIL_GPIO_AMP_RESET_PIN  15
#define ANVIL_GPIO_DAC_RESET_PIN  16
#define ANVIL_GPIO_AMP_OTW_PIN        17
#define ANVIL_GPIO_AMP_SD_PIN     ANVIL_GPIO_AMP_OTW_PIN
#define ANVIL_GPIO_AMP_POWER_PIN  28 
#define ANVIL_GPIO_DAC_SMUTE_PIN  29 

#define ANVIL_GPIO_AMP_OTW_INT     3

/* Anvil audio pin masks */
#define ANVIL_GPIO_AMP_READY_MASK  (1 << (31 - ANVIL_GPIO_AMP_READY_PIN))
#define ANVIL_GPIO_AMP_CLIP_MASK   (1 << (31 - ANVIL_GPIO_AMP_CLIP_PIN))
#define ANVIL_GPIO_AMP_RESET_MASK  (1 << (31 - ANVIL_GPIO_AMP_RESET_PIN))
#define ANVIL_GPIO_DAC_RESET_MASK  (1 << (31 - ANVIL_GPIO_DAC_RESET_PIN))
#define ANVIL_GPIO_AMP_OTW_MASK    (1 << (31 - ANVIL_GPIO_AMP_OTW_PIN))
#define ANVIL_GPIO_AMP_SD_MASK     ANVIL_GPIO_AMP_OTW_MASK
#define ANVIL_GPIO_AMP_POWER_MASK  (1 << (31 - ANVIL_GPIO_AMP_POWER_PIN))
#define ANVIL_GPIO_DAC_SMUTE_MASK  (1 << (31 - ANVIL_GPIO_DAC_SMUTE_PIN))

#define ANVIL_SICRH 0x7FFFF700
#define ANVIL_SICRL 0xF000000C

/*  A M O E B A  */

/* AMP VENDOR SENSE -- future input pin */
#define AMOEBA_GPIO_AMP_VENDOR_SENSE	4
#define AMOEBA_GPIO_AMP_VENDOR_MASK	(1 << (31 - AMOEBA_GPIO_AMP_VENDOR_SENSE))
#define AMOEBA_GPIO_MISC		(AMOEBA_GPIO_AMP_VENDOR_MASK)

/* Amoeba buttons GPIO pins */

#define AMOEBA_GPIO_MUTE_PIN            1
#define AMOEBA_GPIO_VOL_DWN_PIN         13
#define AMOEBA_GPIO_VOL_UP_PIN          14

/* Amoeba buttons GPIO masks */
#define AMOEBA_GPIO_MUTE_MASK    (1 << (31 - AMOEBA_GPIO_MUTE_PIN))
#define AMOEBA_GPIO_VOL_DWN_MASK (1 << (31 - AMOEBA_GPIO_VOL_DWN_PIN))
#define AMOEBA_GPIO_VOL_UP_MASK  (1 << (31 - AMOEBA_GPIO_VOL_UP_PIN))
#define AMOEBA_GPIO_BUTTONS_MASK \
        (AMOEBA_GPIO_MUTE_MASK | AMOEBA_GPIO_VOL_DWN_MASK | AMOEBA_GPIO_VOL_UP_MASK) 

/* Amoeba LEDs GPIO pins */
#define AMOEBA_GPIO_LED_AMBER_PIN        2
#define AMOEBA_GPIO_LED_RED_PIN          3
#define AMOEBA_GPIO_LED_GREEN_PIN        7
#define AMOEBA_GPIO_LED_WHITE_PIN_FIXED  5
#define AMOEBA_GPIO_LED_WHITE_PIN        11

/* Amoeba LEDs GPIO masks */
#define AMOEBA_GPIO_LED_AMBER_MASK (1 << (31 - AMOEBA_GPIO_LED_AMBER_PIN))
#define AMOEBA_GPIO_LED_RED_MASK   (1 << (31 - AMOEBA_GPIO_LED_RED_PIN))
#define AMOEBA_GPIO_LED_GREEN_MASK (1 << (31 - AMOEBA_GPIO_LED_GREEN_PIN))
#define AMOEBA_GPIO_LED_WHITE_MASK (1 << (31 - AMOEBA_GPIO_LED_WHITE_PIN))
#define AMOEBA_GPIO_LED_WHITE_FIXED_MASK (1 << (31 - AMOEBA_GPIO_LED_WHITE_PIN_FIXED))
#define AMOEBA_GPIO_LEDS_MASK      (AMOEBA_GPIO_LED_AMBER_MASK | AMOEBA_GPIO_LED_RED_MASK | \
                                    AMOEBA_GPIO_LED_WHITE_MASK | AMOEBA_GPIO_LED_WHITE_FIXED_MASK | \
                                    AMOEBA_GPIO_LED_GREEN_MASK)

/* Amoeba audio pins */
#define AMOEBA_GPIO_AMP_RESET_PIN	15
#define AMOEBA_GPIO_AMP_HIZ_PIN		16
#define AMOEBA_GPIO_AMP_PDN_PIN		17

/* Amoeba audio pin masks */
#define AMOEBA_GPIO_AMP_RESET_MASK	(1 << (31 - AMOEBA_GPIO_AMP_RESET_PIN))
#define AMOEBA_GPIO_AMP_HIZ_MASK	(1 << (31 - AMOEBA_GPIO_AMP_HIZ_PIN))
#define AMOEBA_GPIO_AMP_PDN_MASK	(1 << (31 - AMOEBA_GPIO_AMP_PDN_PIN))

#define AMOEBA_GPIO_P2_AMP_HIZ_PIN	15
#define AMOEBA_GPIO_P2_DAC_MUTE_PIN	16
#define AMOEBA_GPIO_P2_AMP_MUTE_PIN	17

#define AMOEBA_GPIO_P2_AMP_HIZ_MASK	(1 << (31 - AMOEBA_GPIO_P2_AMP_HIZ_PIN))
#define AMOEBA_GPIO_P2_DAC_MUTE_MASK	(1 << (31 - AMOEBA_GPIO_P2_DAC_MUTE_PIN))
#define AMOEBA_GPIO_P2_AMP_MUTE_MASK	(1 << (31 - AMOEBA_GPIO_P2_AMP_MUTE_PIN))

#define AMOEBA_SICRH 0x7FFFF500
#define AMOEBA_SICRL 0xF000000C

#endif
