/*
 * This file is part of libdcadec.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

static const uint8_t huff_tnl_grp_0[] = {
    0x01, 0x38, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x05, 0xFF, 0x04, 0x01, 0x26,
    0x01, 0x24, 0x01, 0x22, 0x01, 0x20, 0x01, 0x18, 0x01, 0x02, 0xFF, 0x13,
    0x01, 0x14, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x21, 0xFF, 0x1F,
    0xFF, 0x1C, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x22,
    0xFF, 0x25, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x23, 0xFF, 0x00, 0xFF, 0x24,
    0xFF, 0x20, 0xFF, 0x1E, 0xFF, 0x18, 0x01, 0x02, 0xFF, 0x16, 0x01, 0x02,
    0xFF, 0x17, 0x01, 0x02, 0xFF, 0x1D, 0xFF, 0x1B, 0xFF, 0x11, 0xFF, 0x0E,
    0xFF, 0x07, 0x01, 0x0C, 0x01, 0x02, 0xFF, 0x0C, 0x01, 0x02, 0xFF, 0x01,
    0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x1A, 0xFF, 0x03, 0xFF, 0x19,
    0xFF, 0x14, 0xFF, 0x08, 0x01, 0x0E, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x0A,
    0xFF, 0x0D, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x0F, 0xFF, 0x10,
    0x01, 0x02, 0xFF, 0x12, 0xFF, 0x15, 0xFF, 0x0B, 0x01, 0x02, 0xFF, 0x09,
    0xFF, 0x06
};

static const uint8_t huff_tnl_grp_1[] = {
    0x01, 0x30, 0x01, 0x16, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x04, 0xFF, 0x07,
    0x01, 0x02, 0xFF, 0x0A, 0x01, 0x0E, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x08,
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x03, 0xFF, 0x1B, 0x01, 0x02, 0xFF, 0x1D,
    0xFF, 0x1C, 0xFF, 0x16, 0xFF, 0x15, 0xFF, 0x0F, 0xFF, 0x0E, 0x01, 0x18,
    0x01, 0x02, 0xFF, 0x08, 0x01, 0x14, 0x01, 0x02, 0xFF, 0x10, 0x01, 0x02,
    0xFF, 0x13, 0x01, 0x02, 0xFF, 0x17, 0x01, 0x02, 0xFF, 0x1A, 0x01, 0x02,
    0xFF, 0x1E, 0x01, 0x08, 0x01, 0x06, 0x01, 0x02, 0xFF, 0x21, 0x01, 0x02,
    0xFF, 0x22, 0xFF, 0x00, 0xFF, 0x20, 0xFF, 0x1F, 0xFF, 0x0C, 0xFF, 0x05,
    0x01, 0x0E, 0x01, 0x02, 0xFF, 0x09, 0x01, 0x02, 0xFF, 0x01, 0x01, 0x08,
    0x01, 0x06, 0x01, 0x02, 0xFF, 0x14, 0x01, 0x02, 0xFF, 0x19, 0xFF, 0x18,
    0xFF, 0x12, 0xFF, 0x11, 0x01, 0x02, 0xFF, 0x06, 0x01, 0x02, 0xFF, 0x0B,
    0xFF, 0x0D
};

static const uint8_t huff_tnl_grp_2[] = {
    0x01, 0x38, 0x01, 0x1C, 0x01, 0x18, 0x01, 0x16, 0x01, 0x14, 0x01, 0x04,
    0x01, 0x02, 0xFF, 0x0E, 0xFF, 0x11, 0x01, 0x02, 0xFF, 0x0F, 0x01, 0x0C,
    0x01, 0x02, 0xFF, 0x17, 0x01, 0x02, 0xFF, 0x1C, 0x01, 0x02, 0xFF, 0x1D,
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x1E, 0xFF, 0x00, 0xFF, 0x1F, 0xFF, 0x19,
    0xFF, 0x0A, 0xFF, 0x08, 0x01, 0x02, 0xFF, 0x09, 0xFF, 0x04, 0x01, 0x1A,
    0x01, 0x0E, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x16,
    0xFF, 0x03, 0x01, 0x02, 0xFF, 0x15, 0x01, 0x02, 0xFF, 0x1A, 0xFF, 0x1B,
    0xFF, 0x0C, 0xFF, 0x0B, 0x01, 0x0A, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x10,
    0xFF, 0x12, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x14, 0xFF, 0x18, 0xFF, 0x13,
    0xFF, 0x0D, 0xFF, 0x05, 0x01, 0x02, 0xFF, 0x01, 0x01, 0x02, 0xFF, 0x06,
    0xFF, 0x07
};

static const uint8_t huff_tnl_grp_3[] = {
    0x01, 0x36, 0x01, 0x22, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x04, 0x01, 0x02,
    0xFF, 0x08, 0xFF, 0x02, 0x01, 0x02, 0xFF, 0x07, 0x01, 0x02, 0xFF, 0x17,
    0xFF, 0x0C, 0xFF, 0x05, 0x01, 0x10, 0x01, 0x0E, 0x01, 0x02, 0xFF, 0x0A,
    0x01, 0x0A, 0x01, 0x02, 0xFF, 0x14, 0x01, 0x02, 0xFF, 0x19, 0x01, 0x02,
    0xFF, 0x1A, 0x01, 0x02, 0xFF, 0x1B, 0xFF, 0x00, 0xFF, 0x16, 0xFF, 0x09,
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x0D, 0xFF, 0x11, 0xFF, 0x04, 0x01, 0x12,
    0x01, 0x0A, 0x01, 0x06, 0x01, 0x02, 0xFF, 0x0E, 0x01, 0x02, 0xFF, 0x13,
    0xFF, 0x18, 0x01, 0x02, 0xFF, 0x03, 0xFF, 0x0B, 0x01, 0x04, 0x01, 0x02,
    0xFF, 0x15, 0xFF, 0x12, 0x01, 0x02, 0xFF, 0x10, 0xFF, 0x0F, 0xFF, 0x06,
    0xFF, 0x01
};

static const uint8_t huff_tnl_grp_4[] = {
    0x01, 0x2C, 0x01, 0x02, 0xFF, 0x02, 0x01, 0x12, 0x01, 0x10, 0x01, 0x08,
    0x01, 0x06, 0x01, 0x02, 0xFF, 0x07, 0x01, 0x02, 0xFF, 0x0F, 0xFF, 0x15,
    0xFF, 0x03, 0x01, 0x02, 0xFF, 0x06, 0x01, 0x02, 0xFF, 0x0D, 0x01, 0x02,
    0xFF, 0x0E, 0xFF, 0x12, 0xFF, 0x04, 0x01, 0x08, 0x01, 0x02, 0xFF, 0x05,
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x0B, 0xFF, 0x0A, 0xFF, 0x14, 0x01, 0x0C,
    0x01, 0x0A, 0x01, 0x08, 0x01, 0x02, 0xFF, 0x0C, 0x01, 0x02, 0xFF, 0x10,
    0x01, 0x02, 0xFF, 0x16, 0xFF, 0x00, 0xFF, 0x11, 0xFF, 0x13, 0x01, 0x02,
    0xFF, 0x08, 0xFF, 0x09, 0xFF, 0x01
};

static const uint8_t huff_tnl_scf[] = {
    0x01, 0x1A, 0x01, 0x16, 0x01, 0x02, 0xFF, 0x03, 0x01, 0x12, 0x01, 0x10,
    0x01, 0x02, 0xFF, 0x0B, 0x01, 0x0C, 0x01, 0x0A, 0x01, 0x02, 0xFF, 0x10,
    0x01, 0x02, 0xFF, 0x11, 0x01, 0x02, 0xFF, 0x12, 0x01, 0x02, 0xFF, 0x13,
    0xFF, 0x00, 0xFF, 0x0F, 0xFF, 0x0E, 0xFF, 0x09, 0xFF, 0x07, 0x01, 0x02,
    0xFF, 0x02, 0xFF, 0x04, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x01, 0xFF, 0x05,
    0x01, 0x08, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x0C, 0xFF, 0x0D,
    0xFF, 0x0A, 0xFF, 0x08, 0xFF, 0x06
};

static const uint8_t huff_damp[] = {
    0x01, 0x0C, 0x01, 0x02, 0xFF, 0x02, 0x01, 0x02, 0xFF, 0x03, 0x01, 0x02,
    0xFF, 0x04, 0x01, 0x02, 0xFF, 0x05, 0x01, 0x02, 0xFF, 0x06, 0xFF, 0x00,
    0xFF, 0x01
};

static const uint8_t huff_dph[] = {
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x02, 0xFF, 0x01, 0x01, 0x0C, 0x01, 0x04,
    0x01, 0x02, 0xFF, 0x03, 0xFF, 0x07, 0x01, 0x06, 0x01, 0x02, 0xFF, 0x06,
    0x01, 0x02, 0xFF, 0x05, 0xFF, 0x00, 0xFF, 0x04, 0xFF, 0x08
};

static const uint8_t huff_fst_rsd_amp[] = {
    0x01, 0x26, 0x01, 0x1C, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x0C, 0xFF, 0x11,
    0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x01, 0xFF, 0x08, 0xFF, 0x09,
    0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x14, 0xFF, 0x03, 0xFF, 0x05,
    0x01, 0x02, 0xFF, 0x06, 0x01, 0x02, 0xFF, 0x02, 0x01, 0x06, 0x01, 0x02,
    0xFF, 0x16, 0x01, 0x02, 0xFF, 0x17, 0xFF, 0x00, 0xFF, 0x15, 0x01, 0x08,
    0x01, 0x02, 0xFF, 0x0B, 0x01, 0x02, 0xFF, 0x13, 0x01, 0x02, 0xFF, 0x07,
    0xFF, 0x04, 0xFF, 0x10, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x0A,
    0xFF, 0x12, 0xFF, 0x0F, 0x01, 0x02, 0xFF, 0x0D, 0xFF, 0x0E
};

static const uint8_t huff_rsd_apprx[] = {
    0x01, 0x02, 0xFF, 0x01, 0x01, 0x02, 0xFF, 0x02, 0x01, 0x02, 0xFF, 0x03,
    0x01, 0x02, 0xFF, 0x04, 0x01, 0x02, 0xFF, 0x05, 0xFF, 0x00
};

static const uint8_t huff_rsd_amp[] = {
    0x01, 0x20, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x02, 0xFF, 0x01, 0x01, 0x02,
    0xFF, 0x05, 0x01, 0x18, 0x01, 0x16, 0x01, 0x12, 0x01, 0x0C, 0x01, 0x02,
    0xFF, 0x0E, 0x01, 0x02, 0xFF, 0x14, 0x01, 0x02, 0xFF, 0x1A, 0x01, 0x04,
    0x01, 0x02, 0xFF, 0x19, 0xFF, 0x20, 0xFF, 0x13, 0x01, 0x02, 0xFF, 0x10,
    0x01, 0x02, 0xFF, 0x18, 0xFF, 0x11, 0x01, 0x02, 0xFF, 0x0C, 0xFF, 0x0D,
    0xFF, 0x09, 0xFF, 0x07, 0x01, 0x02, 0xFF, 0x03, 0x01, 0x02, 0xFF, 0x04,
    0x01, 0x1C, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x08, 0xFF, 0x0B, 0x01, 0x16,
    0x01, 0x04, 0x01, 0x02, 0xFF, 0x12, 0xFF, 0x0F, 0x01, 0x10, 0x01, 0x0C,
    0x01, 0x0A, 0x01, 0x02, 0xFF, 0x1E, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x24,
    0xFF, 0x22, 0x01, 0x02, 0xFF, 0x1D, 0xFF, 0x00, 0xFF, 0x15, 0x01, 0x02,
    0xFF, 0x1C, 0xFF, 0x17, 0xFF, 0x16, 0xFF, 0x0A, 0xFF, 0x06
};

static const uint8_t huff_avg_g3[] = {
    0x01, 0x20, 0x01, 0x1E, 0x01, 0x0A, 0x01, 0x02, 0xFF, 0x0E, 0x01, 0x06,
    0x01, 0x02, 0xFF, 0x0B, 0x01, 0x02, 0xFF, 0x13, 0xFF, 0x09, 0xFF, 0x0D,
    0x01, 0x12, 0x01, 0x10, 0x01, 0x02, 0xFF, 0x0A, 0x01, 0x04, 0x01, 0x02,
    0xFF, 0x14, 0xFF, 0x08, 0x01, 0x08, 0x01, 0x06, 0x01, 0x02, 0xFF, 0x06,
    0x01, 0x02, 0xFF, 0x17, 0xFF, 0x00, 0xFF, 0x15, 0xFF, 0x07, 0xFF, 0x0C,
    0xFF, 0x12, 0xFF, 0x10, 0x01, 0x02, 0xFF, 0x0F, 0xFF, 0x11
};

static const uint8_t huff_st_grid[] = {
    0x01, 0x2A, 0x01, 0x28, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x04, 0xFF, 0x03,
    0x01, 0x02, 0xFF, 0x08, 0x01, 0x20, 0x01, 0x0A, 0x01, 0x08, 0x01, 0x02,
    0xFF, 0x0E, 0x01, 0x02, 0xFF, 0x07, 0x01, 0x02, 0xFF, 0x09, 0xFF, 0x16,
    0xFF, 0x0C, 0x01, 0x14, 0x01, 0x0E, 0x01, 0x02, 0xFF, 0x10, 0x01, 0x02,
    0xFF, 0x0B, 0x01, 0x02, 0xFF, 0x0D, 0x01, 0x04, 0x01, 0x02, 0xFF, 0x11,
    0xFF, 0x0F, 0x01, 0x02, 0xFF, 0x18, 0xFF, 0x00, 0x01, 0x02, 0xFF, 0x12,
    0x01, 0x02, 0xFF, 0x14, 0xFF, 0x02, 0xFF, 0x05, 0xFF, 0x0A, 0xFF, 0x01,
    0xFF, 0x06
};

static const uint8_t * const huff_tnl_grp[] = {
    huff_tnl_grp_0,
    huff_tnl_grp_1,
    huff_tnl_grp_2,
    huff_tnl_grp_3,
    huff_tnl_grp_4
};

static const size_t huff_tnl_size[] = {
    sizeof(huff_tnl_grp_0),
    sizeof(huff_tnl_grp_1),
    sizeof(huff_tnl_grp_2),
    sizeof(huff_tnl_grp_3),
    sizeof(huff_tnl_grp_4)
};
