/*
 * Copyright (c) 2017-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * sonos_unlock_token.h: code for checking unlock token and signatures
 */

#ifndef SONOS_UNLOCK_TOKEN_H
#define SONOS_UNLOCK_TOKEN_H

#if defined(SONOS_ARCH_ATTR_IS_CONTROLLER) || \
    !(defined(SONOS_ARCH_ATTR_SUPPORTS_SECURE_BOOT) || \
      defined(SONOS_ARCH_ATTR_IS_STILL_MANUFACTURED) || \
      defined(SONOS_ARCH_ATTR_SUPPORTS_GUNIT_TESTS))
#error "this header should not be included on this ARCH"
#endif

#include "sonos_stdint.h"
#include "sonos_signature.h"
#include "sonos_signature_common.h"
#include "sonos_signature_verify.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*SonosGetUnlockCounterCallback)(uint32_t* pCounter);

#define SONOS_UNLOCK_SERIAL_LEN             6

#define SONOS_UNLOCK_SIG_PREFIX             ((const uint8_t *)"\x71\xde\x54\xd6\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d\x0d")
#define SONOS_UNLOCK_SIG_PREFIX_LEN         22

#define SONOS_UNLOCK_TOKEN_PRESIG_LEN       (SONOS_UNLOCK_SIG_PREFIX_LEN + SONOS_UNLOCK_SERIAL_LEN + 4 + 4)

#if defined(SONOS_ARCH_ATTR_SOC_IS_IMX7ULP)

#define SONOS_UNLOCK_CTR_BIT_LEN 8
#define SONOS_UNLOCK_CTR_MAX_VALUE 0xFF

#else

#define SONOS_UNLOCK_CTR_BIT_LEN   32
#define SONOS_UNLOCK_CTR_MAX_VALUE 0xFFFFFFFF

#endif

int sonosUnlockIsValidUnlockSig(const uint8_t* serial, size_t serialLen,
                                uint32_t permissions,
                                uint32_t unlockCounter,
                                const uint8_t* sigBuf, size_t sigBufLen,
                                const char* logPrefix,

                                SonosSignature* sig,
                                SonosHashCallback h,
                                SonosRawVerifyCallback v,
                                SonosKeyLookupCallback lookup,
                                const void* lookupArg,
                                SonosKeyReleaseCallback r);

#ifndef SONOS_UNLOCK_OMIT_TOKEN_SUPPORT

int sonosUnlockIsValidUnlockToken(const uint8_t* serial, size_t serialLen,
                                  uint32_t* pPermissions,
                                  uint32_t* pUnlockCounter,
                                  const uint8_t* token, size_t tokenLen,
                                  const char* logPrefix,

#ifndef SONOS_ARCH_ATTR_SUPPORTS_SECURE_BOOT
                                  SonosGetUnlockCounterCallback getCounter,
#endif
                                  SonosSignature* sig,
                                  SonosHashCallback h,
                                  SonosRawVerifyCallback v,
                                  SonosKeyLookupCallback lookup,
                                  const void* lookupArg,
                                  SonosKeyReleaseCallback r);

uint32_t sonosUnlockGetNextFuseVal(uint32_t fuseval);

#endif

#ifdef __cplusplus
}
#endif

#endif
