/*
 * Copyright (c) 2015-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * sonos_unlock.h:     code for checking unlock signatures and cpuid/serial
 *                     binding signatures as used with Sonos secure boot
 */

#ifndef SONOS_UNLOCK_H
#define SONOS_UNLOCK_H

#ifndef SONOS_ARCH_ATTR_SUPPORTS_SECURE_BOOT
#error "this header should only be included on secure boot ARCHes"
#endif

#include "sonos_unlock_token.h"

#ifdef __cplusplus
extern "C" {
#endif

struct manufacturing_data_page;
struct manufacturing_data_page3;

#define SONOS_UNLOCK_CPUID_LEN              8

#if defined(SONOS_ARCH_ATTR_SOC_VARIANT_IS_IMX6_QUAD)

#define SONOS_FUSE_UNLOCK_CTR_NAME          "MAC0"
#define SONOS_FUSE_UNLOCK_CTR_BANK          4
#define SONOS_FUSE_UNLOCK_CTR_WORD          2

#elif defined(SONOS_ARCH_ATTR_SOC_VARIANT_IS_IMX6_SOLOX)

#define SONOS_FUSE_UNLOCK_CTR_NAME          "HDCP_KEY33"
#define SONOS_FUSE_UNLOCK_CTR_BANK          10
#define SONOS_FUSE_UNLOCK_CTR_WORD          1

#elif defined(SONOS_ARCH_ATTR_SOC_IS_IMX7ULP)

#define SONOS_FUSE_UNLOCK_CTR_NAME          "TESTER11"
#define SONOS_FUSE_UNLOCK_CTR_BANK          9
#define SONOS_FUSE_UNLOCK_CTR_WORD          1
#define SONOS_FUSE_TESTER11_MASK (0xff << 8)
#define SONOS_FUSE_TESTER11_SHIFT 8

#elif defined(SONOS_ARCH_ATTR_SOC_IS_MT8518S)

#undef SONOS_UNLOCK_CPUID_LEN
#define SONOS_UNLOCK_CPUID_LEN              16

#elif defined(SONOS_ARCH_ATTR_SOC_IS_MT8521P)

#elif defined(SONOS_ARCH_ATTR_SOC_IS_A113)

#undef SONOS_UNLOCK_CPUID_LEN
#define SONOS_UNLOCK_CPUID_LEN              16

#elif !defined(SONOS_ARCH_ATTR_STUB_SECBOOT_FUSES_KERNEL) || \
      !defined(SONOS_ARCH_ATTR_STUB_SECBOOT_FUSES_UBOOT) || \
      !defined(SONOS_ARCH_ATTR_STUB_SECBOOT_FUSES_USER)
#error "unsupported secure boot SoC"
#endif


int sonosUnlockVerifyCpuSerialSig(const uint8_t* serial, size_t serialLen,
                                  const uint8_t* sigBuf, size_t sigBufLen,

                                  SonosSignature* sig,
                                  SonosHashCallback h,
                                  SonosRawVerifyCallback v,
                                  SonosKeyLookupCallback lookup,
                                  const void* lookupArg,
                                  SonosKeyReleaseCallback r);

int sonosUnlockIsDeviceUnlocked(const struct manufacturing_data_page* mdp,
                                const struct manufacturing_data_page3* mdp3,

                                SonosSignature* sig,
                                SonosHashCallback h,
                                SonosRawVerifyCallback v,
                                SonosKeyLookupCallback lookup,
                                const void* lookupArgCpuid,
                                const void* lookupArgUnlock,
                                SonosKeyReleaseCallback r);

int sonosUnlockIsAuthFeatureEnabled(uint32_t flag,
                                    const struct manufacturing_data_page* mdp,
                                    const struct manufacturing_data_page3* mdp3,

                                    SonosSignature* sig,
                                    SonosHashCallback h,
                                    SonosRawVerifyCallback v,
                                    SonosKeyLookupCallback lookup,
                                    const void* lookupArgCpuid,
                                    const void* lookupArgUnlock,
                                    SonosKeyReleaseCallback r);

#ifdef __cplusplus
}
#endif

#endif
