/*
 * Copyright (c) 2015-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * common/include/sonos_rollback.h
 */

#ifndef SONOS_ROLLBACK_H
#define SONOS_ROLLBACK_H


#define SRC_GPR_COMPATIBLE	"fsl,imx6q-src"
#if defined(SONOS_ARCH_ATTR_SOC_IS_MT8521P)
#define SRC_GPR_BASE		0x10007000
#define BOOT_COUNTER_OFFSET	0x24
#define BOOT_COUNTER_SHIFT	3
#elif defined(SONOS_ARCH_ATTR_SOC_IS_MT8518S)
#define SRC_GPR_BASE		0x10007000
#define BOOT_COUNTER_OFFSET	0x24
#define BOOT_COUNTER_SHIFT	3
#elif defined(SONOS_ARCH_ATTR_SOC_IS_A113)
#define SRC_GPR_BASE		0xff800000
#define BOOT_COUNTER_OFFSET	0x00
#define BOOT_COUNTER_SHIFT	0
#elif defined(SONOS_ARCH_ATTR_SOC_IS_IMX7ULP)
#define SRC_GPR_BASE		0x41070100
#define BOOT_COUNTER_OFFSET	0x00
#define BOOT_COUNTER_SHIFT	0
#else
#define SRC_GPR_BASE		0x20d8000
#define BOOT_COUNTER_OFFSET	0x3c
#define BOOT_COUNTER_SHIFT	0
#endif
#define BOOT_COUNTER_REG	(SRC_GPR_BASE + BOOT_COUNTER_OFFSET)

#define BC_FLAG_BAD_SIGNATURE	0x01
#define BC_FLAG_STOP_BOOT	0x02

#define BOOT_DEFAULT		0
#define FALLBACK_BOOT_COUNTER	1
#define FALLBACK_COMMAND	2
#define FALLBACK_CRC		3

#define BOOT_COUNTER_FALLBACK_THRESHOLD  3
#define BOOT_COUNTER_FAILURE_THRESHOLD   7

typedef struct {
	uint8_t boot_section;
	uint8_t fallback_flags;
	uint8_t boot_state;
	uint8_t	boot_counter;
} BootCounterReg_t;

#endif



