/*
 * Copyright (c) 2015, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * common/include/sonos_lock.h
 */

#ifndef SONOS_LOCK_H
#define SONOS_LOCK_H

#define CONSTRAINED_MODE 0
#define NORMAL_MODE 1
#define UNCONSTRAINED_MODE 2

#define KERNEL_DEFAULT		0
#define USERSPACE_SERVICE	1
#define KERNEL_SERVICE		2

#define KERNEL_SERVICE_MAX	4

#define WDT_PETS_PER_TIMEOUT	4

#ifndef	SONOS_LOCK_C
extern int sonos_forbid_execution(void);
extern int sonos_allow_execution(void);
extern int proc_noexec_set_constrained(void);
extern int sonos_forbid_insmod(void);
extern int proc_insmod_set_constrained(void);
extern int sonos_force_nodev(void);
extern int proc_nodev_set_constrained(void);
#endif
extern int is_mdp_authorized(int);

#endif
