/*
 * Copyright (c) 2014-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * SONOS LED control
 *
 * Data structures shared between the kernel and user space
 */
#ifndef SONOS_LED_H
#define SONOS_LED_H

struct led_step {
    uint8_t	r;
    uint8_t	g;
    uint8_t	b;
    uint8_t	reserved;

    uint16_t	hold_time;
    uint16_t	fade;
};

struct led_pattern {
	uint32_t	cksum;
	uint16_t	flags;
	uint8_t		repeats;
	uint8_t		num_steps;
	struct led_step	*step_array;
};

#define LED_CTL_DEFAULT			0x0000
#define LED_CTL_ENQUEUE			0x0001
#define LED_CTL_INTERRUPT		0x0002
#define LED_CTL_OVERRIDE_FEEDBACK	0x0004
#define LED_CTL_AUDIODEV_WHITE		0x0008

#define LED_CTL_MAX_STEPS		8


#define LED_BRIGHTNESS_MAX      7

enum LED_COLOR {
    LED_RED_CLR         =   0,
    LED_GREEN_CLR       =   1,
    LED_BLUE_CLR        =   2,
    LED_DIM_BLUE_CLR    =   3,
    LED_AMBER_CLR       =   4,
    LED_YELLOW_CLR      =   5,
    LED_PURPLE_CLR      =   6,
    LED_OFF             =   7,
    LED_DIM_WHITE_CLR   =   8,
    LED_WHITE_CLR       =   9,
};

#endif
