/*
 ******************************************************************************
 *
 * Copyright (c) 2013 - 2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * Include File Name: sect_upgrade_header.h
 *
 * Include File Description:
 *  In targets that boot from nor-flash a header is placed at the beginning
 *  of the kernel partition that u-boot uses to determine whether to boot
 *  section 0 or 1.
 *  On targets that boot from nand-flash this information is in oob space.
 *
 ******************************************************************************
 */



#ifndef SECT_UPGRADE_HEADER_H
#define SECT_UPGRADE_HEADER_H
#include "sonos_stdint.h"
typedef struct _SECT_UPGRADE_HEADER
{
   uint32_t magic;
   uint32_t version;
   uint32_t kernelOffset;
   uint32_t kernelChecksum;
   uint32_t kernelLength;
   uint32_t rootfsOffset;
   uint32_t rootfsChecksum;
   uint32_t rootfsLength;
   uint32_t bootgen;
   uint32_t fpgaChecksum;
   uint32_t fpgaLength;
   uint32_t m4Checksum;
   uint32_t m4Length;
   uint32_t rootfsFormat;
   uint32_t firmwareChecksum;
   uint32_t firmwareLength;
} SECT_UPGRADE_HEADER;
#define SECT_UPGRADE_HEADER_EXPECTED_SIZE   (16*4)
#define SECT_UPGRADE_HEADER_MAGIC           0x536F7821

#define SECT_UPGRADE_HEADER_VER_INITIAL     0
#define SECT_UPGRADE_HEADER_VER_ROOTFS_FMT  1
#define SECT_UPGRADE_HEADER_VERSION         SECT_UPGRADE_HEADER_VER_ROOTFS_FMT

#define SECT_UPGRADE_KERNEL_HEADER_SIZE     sizeof(SECT_UPGRADE_HEADER)
#define SECT_UPGRADE_ROOTFS_HEADER_SIZE     0

#define SECT_UPGRADE_ROOTFS_FORMAT_PLAINTEXT    0
#define SECT_UPGRADE_ROOTFS_FORMAT_FIXED_KEY	1
#define SECT_UPGRADE_ROOTFS_FORMAT_RED_KEY	2
#define SECT_UPGRADE_ROOTFS_FORMAT_BLACK_KEY	3


#endif
