/*
 ******************************************************************************
 * Copyright (c) 2013, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 * ddp.h
 *
 * Module Description:
 * 
 * Diagnotic Data Page structure and definitions
 *
 ******************************************************************************
 */


#define DDP_MAGIC   0xBEDAC0ED


#define DDP_VERSION_1              1
#define DDP_VERSION_2              2
#define DDP_VERSION_BT_CAL_SUPPORT 3
#define DDP_VERSION DDP_VERSION_BT_CAL_SUPPORT


typedef struct diagnostic_data_page
{

	unsigned long   ddpMagic;
	unsigned long   ddpVersion;

    unsigned long   dutAddr;
#define DDP_DUT_ADDR_STATIC     0x00000000
#define DDP_DUT_ADDR_STATIC_N   0x00000001
#define DDP_DUT_ADDR_DHCP       0x00000002
    unsigned long   dutNum;

#define DDP_MAX_SERIALNUMS      16
#define DDP_MAX_SERIALNUM_LEN   32
    struct
    {
        char          serialnum[DDP_MAX_SERIALNUM_LEN];
    } serialnums[DDP_MAX_SERIALNUMS];


#define DDP_MAX_RESULTS        64
#define DDP_MAX_RESULT_LEN     64
    struct
    {
        char          result[DDP_MAX_RESULT_LEN];
    } results[DDP_MAX_RESULTS];

    unsigned long   reset_cause;

#define DDP_MAX_BT_CAL_NAME     16
#define DDP_MAX_BT_CAL_RESULTS  16
    struct
    {
        char          calibration_name[DDP_MAX_BT_CAL_NAME];
        int           calibration_value;
    } calibration[DDP_MAX_BT_CAL_RESULTS];

} DDP_ST, *DDP_PST;


int ddpSetDUTAddressType(int type, int numDUT);
int ddpAddSerialNum(int index, char *serialnum);
int ddpAddStationResult(int index, char *result);
int SetResetCause(int cause);
