/*
 *   Copyright (c) 2020, Sonos, Inc.
 *   All rights reserved.
 *
 *    Common defines for Bluetooth rpmsg driver
 *
 */
#ifndef BT_RPMSG_COMMON_H
#define BT_RPMSG_COMMON_H

#define BT_RPMSG_SEND		 0x0
#define BT_RPMSG_RECEIVE	 0x1
#define BT_RPMSG_NOTIFY		 0x2

#define BT_RPMSG_DEVICE_NAME	 "bt_rpmsg"
#define BT_RPMSG_MAX_MSG_LEN	 496
#define BT_RPMSG_VERSION	 (1)
#define BT_RPMSG_MAX_PAYLOAD_LEN (BT_RPMSG_MAX_MSG_LEN-sizeof(bt_rpmsg_t))
#define BT_RPMSG_MAX_SEQ_NO	 (5)

#define BT_RPMSG_IPC_USER_HDR_LEN       (2)
#define IPC_CLIENT_MAX_PAYLOAD_LEN	(2048)
#define IPC_BASE_MSG_MAX_PAYLOAD_LEN	(IPC_CLIENT_MAX_PAYLOAD_LEN + BT_RPMSG_IPC_USER_HDR_LEN)
#define IPC_DATAGRAM_HDR_LEN		(sizeof(uint16_t))
#define IPC_DATAGRAM_MIN_LEN		0
#define IPC_DATAGRAM_MAX_LEN		IPC_BASE_MSG_MAX_PAYLOAD_LEN

#define BT_RPMSG_TIMEOUT		(1600)

enum bt_rpmsg_status {
	BT_RPMSG_SUCCESS,
	BT_RPMSG_FAILED,
	BT_RPMSG_WR_BUF_FULL,
	BT_RPMSG_RD_BUF_EMPTY,
};

enum bt_rpmsg_cmd {
	BT_CMD_RD_IPC_MSG = 0,
	BT_CMD_RD_RSP,
	BT_CMD_WR_IPC_MSG,
	BT_CMD_WR_RSP,
	BT_CMD_RSP,
	BT_CMD_REQ_RD_MSG,
	BT_CMD_REQ_WR_MSG,
	BT_CMD_MAX,
};

typedef struct {
	uint16_t len;
	uint8_t payload[IPC_BASE_MSG_MAX_PAYLOAD_LEN];
} __attribute__ ((packed)) sonos_ipc_msg_t;

#endif
