/*
 * Copyright (c) 2014-2018, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * This file is meant to replace stdint.h for all supported userspace
 * architectures in addition to the Linux kernel and uBoot. It should be
 * included before any other system include files.
 *
 * stdint.h is C99 but may not exist on Windows. We also automatically set some
 * defines here that for some dumb reason are required on C++ to get everything
 * out of the standard header.
 */

#ifndef SONOS_STDINT_H_
#define SONOS_STDINT_H_

#ifdef __KERNEL__
    #ifdef CONFIG_SYS_TEXT_BASE
        #include <asm/types.h>

        typedef u8 uint8_t;
        typedef u16 uint16_t;
        typedef u32 uint32_t;
        typedef u64 uint64_t;
        typedef s8 int8_t;
        typedef s16 int16_t;
        typedef s32 int32_t;
        typedef s64 int64_t;
    #else
        #include <linux/types.h>
    #endif
#else
    #if 0

      #include "msinttypes/stdint.h"

    #else
      #if __cplusplus > 199711L
          #include <cinttypes>
      #else

          #if defined(__SONOS_ANDROID__) && defined(__GNUC__) && defined(_STDINT_H) && !defined(__STDC_CONSTANT_MACROS) && __ANDROID_API__ < 21
                # define INT32_C(c)    c
                # define UINT32_C(c)   c ## U
                # define INT64_C(c)     __INT64_C(c)
                # define UINT64_C(c)   __UINT64_C(c)
          #endif

          #ifndef __STDC_CONSTANT_MACROS
              #define __STDC_CONSTANT_MACROS
          #endif
          #ifndef __STDC_LIMIT_MACROS
              #define __STDC_LIMIT_MACROS
          #endif
          #include <stdint.h>

          #if !defined(WIN32) && !defined(MACOSX) && !defined(__SONOS_ANDROID__)
            #if !defined(INT32_C)
              # define INT32_C(c)	c
              # if __WORDSIZE == 64
              #  define INT64_C(c)	c ## L
              # else
              #  define INT64_C(c)	c ## LL
              # endif

              # define UINT32_C(c)	c ## U
              # if __WORDSIZE == 64
              #  define UINT64_C(c)	c ## UL
              # else
              #  define UINT64_C(c)	c ## ULL
              # endif
            #endif
          #endif

      #endif

      #ifdef __SONOS_ANDROID__
          #include <limits.h>
      #endif

      typedef int32_t sec_t;
      typedef int32_t msec_t;
      typedef int32_t usec_t;

      typedef int64_t sec64_t;
      typedef int64_t msec64_t;
      typedef int64_t usec64_t;

      #define SEC_MAX  INT32_MAX
      #define MSEC_MAX INT32_MAX
      #define USEC_MAX INT32_MAX

      #define SEC_MIN  INT32_MIN
      #define MSEC_MIN INT32_MIN
      #define USEC_MIN INT32_MIN

      #define SEC64_MAX  INT64_MAX
      #define MSEC64_MAX INT64_MAX
      #define USEC64_MAX INT64_MAX

      #define SEC64_MIN  INT64_MIN
      #define MSEC64_MIN INT64_MIN
      #define USEC64_MIN INT64_MIN

    #endif
#endif

#endif
