/*
 * Copyright (c) 2014-2021, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * sonos_signature_sign.h: Sonos digital signature format
 *                         creation and serialization
 */

#ifndef SONOS_SIGNATURE_SIGN_H
#define SONOS_SIGNATURE_SIGN_H

#include "sonos_signature.h"
#include "sonos_signature_common.h"
#include "sonos_attr.h"

#ifdef __cplusplus
extern "C" {
#endif


size_t sonosSignatureSerialize(const SonosSignature *sig,
                               uint8_t *buf, size_t bufLen);

typedef int (*SonosRawSignCallback)(SonosSigningKey_t key,
                                    SonosSignatureAlg_t signAlg,
                                    SonosDigestAlg_t digestAlg,
                                    const uint8_t *digest, size_t digestLen,
                                    uint8_t *signature, size_t *pSigLen);

typedef struct
{
    SonosContentType_t contentType;
    SonosSrkRevoke_t srkRevoke;
    const uint8_t *allowlist;
    size_t allowlistLen;
    const SonosArVersion_t *pArVersion;
    size_t padToLen;
} SonosSignatureParams;

void sonosSignatureParamsInit(SonosSignatureParams *sigParams);

int sonosSignatureCreate(SonosSignature *sig,
                         SonosHashCallback hash,
                         SonosRawSignCallback rawSign,
                         SonosDigestAlg_t digestAlg,
                         SonosSignatureAlg_t sigAlg,
                         SonosSigningKey_t key,
                         SonosKeyIdentifierScheme_t keyIdScheme,
                         const uint8_t *keyId, size_t keyIdLen,
                         const uint8_t *msg, size_t msgLen,
                         const SonosSignatureParams *sigParams);

int sonosSignatureCreateFromDigest(SonosSignature *sig,
                                   SonosHashCallback hash,
                                   SonosRawSignCallback rawSign,
                                   SonosDigestAlg_t digestAlg,
                                   SonosSignatureAlg_t sigAlg,
                                   SonosSigningKey_t key,
                                   SonosKeyIdentifierScheme_t keyIdScheme,
                                   const uint8_t *keyId, size_t keyIdLen,
                                   const uint8_t *digest, size_t digestLen,
                                   const SonosSignatureParams *sigParams);

#ifdef __cplusplus
}
#endif

#endif
