/*
 * Copyright (c) 2014-2021, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * sonos_signature_common.h: helper functions for Sonos digital signature format
 */

#ifndef SONOS_SIGNATURE_COMMON_H
#define SONOS_SIGNATURE_COMMON_H

#include "sonos_signature.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef int (*SonosHashCallback)(SonosDigestAlg_t alg,
                                 const void *buf, size_t bufLen,
                                 uint8_t *digest, size_t *pDigestLen);

int sonosSignatureIsValidDigestAlg(SonosDigestAlg_t a);
int sonosSignatureIsValidSignatureAlg(SonosSignatureAlg_t a);
int sonosSignatureIsValidKeyIdentifierScheme(SonosKeyIdentifierScheme_t s);

int sonosSignatureIsValidAllowlistType(uint8_t type);

int sonosSignatureHashSignedAttributes(const SonosSignature *sig,
                                       const uint8_t *serializedAttrs,
                                       size_t serializedAttrsLen,
                                       SonosHashCallback hash,
                                       SonosDigestAlg_t alg,
                                       uint8_t *digest,
                                       size_t *pDigestLen);

#ifdef SONOS_ARCH_ATTR_IS_BUILD_TOOLS
void sonosSignaturePrintAttributes(FILE *f, const SonosSignature *sig);
#endif

#ifdef __cplusplus
}
#endif

#endif
