/*
 * Copyright (c) 2004-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 */

#ifndef SONOS_PTABLE_H
#define SONOS_PTABLE_H

#include "sonos_stdint.h"

struct ptable_ent {
	uint32_t pe_type;
#define PE_TYPE_END       0
#define PE_TYPE_DIAGS     1
#define PE_TYPE_RESERVED  2
#define PE_TYPE_FPGA      3
#define PE_TYPE_ART       4
#define PE_TYPE_DDP       5
#define PE_TYPE_MDP       6
#define PE_TYPE_KERNEL   16
#define PE_TYPE_ROOT     17
#define PE_TYPE_OPT      18
#define PE_TYPE_UBOOT    19
#define PE_TYPE_M4       20
#define PE_TYPE_LK       21
#define PE_TYPE_TEE      22
#define PE_TYPE_FIRMWARE 23
#define PE_TYPE_JFFS     64
        int32_t pe_start;
        int32_t pe_nblocks;
};

#define PT_MAX_NUM_ENTRIES  10

struct ptable {
	uint32_t pt_magic;
#define PT_MAGIC 0x653503e4
	uint32_t pt_flags;
#define PTF_REL		1
	struct ptable_ent pt_entries[PT_MAX_NUM_ENTRIES];
	uint8_t pt_reserved[384];
};

#endif
