/*
 * Copyright (c) 2018, Sonos, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * Header information for values related to using dm-verity, which are
 * determined after rootfs build time and must be inserted into the kernel.
 */
#ifndef SONOS_DMVERITY_DATA_H_
#define SONOS_DMVERITY_DATA_H_

#define SONOS_DMVERITY_MAGIC { 0xe2, 0xc1, 0xed, 0xe1, 0xab, 0xc9, 0xdb, 0xc4 }
#define SONOS_DMVERITY_MAGIC_LENGTH 8

#define SONOS_DMVERITY_ROOT_HASH_LENGTH 64

typedef struct {
    uint8_t  magic[SONOS_DMVERITY_MAGIC_LENGTH];
    uint32_t hash_offset_be;
    char     root_hash[SONOS_DMVERITY_ROOT_HASH_LENGTH];
} sonos_dmverity_data_t;

#endif
