/*
 * Copyright (c) 2015-2020, Sonos, Inc.  All rights reserved.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * sonos_crypto_enums.h: shared enum values for Sonos cryptography
 */

#ifndef SONOS_CRYPTO_ENUMS_H
#define SONOS_CRYPTO_ENUMS_H

#include "sonos_stdint.h"

typedef uint8_t SonosDigestAlg_t;
typedef uint32_t SonosSignatureAlg_t;
typedef uint8_t SonosKeyIdentifierScheme_t;
typedef uint32_t SonosKeyEncryptionAlg_t;
typedef uint32_t SonosDataEncryptionAlg_t;

#define SONOS_DIGEST_ALG_SHA256             0x01
#define SONOS_DIGEST_LEN_SHA256             32
#define SONOS_DIGEST_ALG_MD5                0x02
#define SONOS_DIGEST_LEN_MD5                16
#define SONOS_DIGEST_ALG_SHA1               0x03
#define SONOS_DIGEST_LEN_SHA1               20

#define SONOS_DIGEST_MAX_LEN                SONOS_DIGEST_LEN_SHA256
#define SONOS_DIGEST_ALG_LEN(a) ((a) == SONOS_DIGEST_ALG_SHA256 \
                                    ? SONOS_DIGEST_LEN_SHA256   \
                                    : \
                                 ((a) == SONOS_DIGEST_ALG_MD5   \
                                    ? SONOS_DIGEST_LEN_MD5      \
                                    : \
                                 ((a) == SONOS_DIGEST_ALG_SHA1  \
                                    ? SONOS_DIGEST_LEN_SHA1     \
                                    : 0)))

#define SONOS_SIGNATURE_ALG_RSAPKCS1        0x01

#define SONOS_KEYENC_ALG_RSA_OAEP_SHA1      0x01
#define SONOS_KEYENC_ALG_RSA_PKCS1          0x02

#define SONOS_DATAENC_ALG_AES_128_CBC       0x01
#define SONOS_DATAENC_ALG_AES_128_GCM       0x02
#define SONOS_DATAENC_ALG_AES_128_GCM_OTK   0x03
#define SONOS_DATAENC_ALG_CHACHA20_POLY1305 0x04


#define SONOS_DATAENC_KEY_LEN_CHACHA20_POLY1305 32
#define SONOS_DATAENC_MAX_KEY_LEN               32
#define SONOS_DATAENC_BLOCK_LEN_AES             16
#define SONOS_DATAENC_MAX_BLOCK_LEN             SONOS_DATAENC_BLOCK_LEN_AES
#define SONOS_DATAENC_IV_LEN_AES_CBC            16
#define SONOS_DATAENC_IV_LEN_AES_GCM            12
#define SONOS_DATAENC_IV_LEN_CHACHA20_POLY1305  12
#define SONOS_DATAENC_MAX_IV_LEN                SONOS_DATAENC_IV_LEN_AES_CBC
#define SONOS_DATAENC_TAG_LEN_AES_GCM           16
#define SONOS_DATAENC_TAG_LEN_CHACHA20_POLY1305 16
#define SONOS_DATAENC_MAX_TAG_LEN               SONOS_DATAENC_TAG_LEN_AES_GCM

#define SONOS_DATAENC_TAG_LEN_AES_GCM_OTK   4

#endif
