/*
 * Copyright (c) 2015, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#include "sonos_common.h"

int main(int argc, char** argv)
{
	int ret = 0;
	const sonos_enfs enfs =
	{
		.block_dev = "/dev/virtualblock1",
		.virtual_dev = "upgrade"
	};

	setlogmask(LOG_UPTO(LOG_INFO));
	//setmaxlogsize(80 * 1024);
	//openlog(PROGRAM_NAME,  0, LOG_USER);
	syslog(LOG_INFO, "****************************");

	ret = sonos_action_luksFormat(&enfs);
	if (ret) {
		syslog(LOG_ERR, "Format error %d\n", ret);
		goto end;
	}
	ret = sonos_action_open_luks(&enfs);
	if (ret) {
		syslog(LOG_ERR, "Open error %d\n", ret);
		goto end;
	}
	ret = ubi_update(&enfs);
	if (ret) {
		syslog(LOG_ERR, "UBI update %d\n", ret);
	}
	ret |= action_close(&enfs);
	if (ret) {
		syslog(LOG_ERR, "Close %d\n", ret);
	}

end:
	closelog();
	return ret;
}
