/*
 * Copyright (c) 2016-2021, Sonos, Inc.  All rights reserved.
 * SPDX-License-Identifier: GPL-2.0
 */

#ifndef EVENT_REPORTER_H
#define EVENT_REPORTER_H

#define TASK_COMM_LEN       (32)
#define MAX_EVENT_NAME_SIZE (32)

// The version of the protocol is encoded directly into the path of the event file.
#define EXTERNAL_EVENT_VER  "3"

#define EXTERNAL_EVENT_DIR  "/tmp/event_reporter_v" EXTERNAL_EVENT_VER

// Note: sonos_factory_reset.c shares knowledge of this path also.
#define EXTERNAL_EVENT_JFFS_DIR  "/jffs/sys/log/event_reporter_v" EXTERNAL_EVENT_VER

#define MAX_PATHNAME_SIZE   (1024 + 1)
#define MAX_EVENT_SIZE      (256)
#define TOTAL_SIZE_LIMIT    (1024 * 10)

struct event_context_t {
    unsigned int flags;
    char buf[MAX_EVENT_SIZE];
    size_t bufpos;
    char event_name[MAX_EVENT_NAME_SIZE];
};

// NOTE: Flags are defined by the ReportControlFlags enum in sonos_defines.h.
int init_event_ctx(struct event_context_t *evctx, const char* event_name, unsigned int flags);
int add_pair_int(struct event_context_t *evctx, const char* key, int val);
int add_pair_uint(struct event_context_t *evctx, const char* key, unsigned int val);
int add_pair_str(struct event_context_t *evctx, const char* key, const char *val);
int report_event(struct event_context_t *evctx);

#endif /* EVENT_REPORTER_H */
