/*
 * A virtual block driver.
 *
 * (C) 2015-2019 Sonos, Inc.
 * SPDX-License-Identifier:     GPL-2.0
 */

#ifndef VIRTUAL_BLOCK_IOCTL_H
#define VIRTUAL_BLOCK_IOCTL_H

#ifdef __KERNEL__
#  include <linux/version.h>
#  if LINUX_VERSION_CODE <= KERNEL_VERSION(4, 4, 24)
#    define SONOS_VIRTUAL_BLOCK_WANT_LEGACY_INTERFACE 1
#  else
#    undef  SONOS_VIRTUAL_BLOCK_WANT_LEGACY_INTERFACE
#  endif
#endif

#define VIRTUAL_BLOCK_DEV_NAME	"/dev/virtualblock1"
#define VIRTUAL_BLOCK_MAJOR	240

#define SONOS_ENV_VAR_ROOTFS_SIZE		"SONOS_UBI_ROOTFS_SIZE"
#define SONOS_ENV_VAR_ROOTFS_VOLUME_NAME	"SONOS_UBI_ROOTFS_VOLUME_NAME"
#define SONOS_ENV_VAR_ROOTFS_COMPUTE_CRC	"SONOS_UBI_ROOTFS_COMPUTE_CRC"

#define ROOTFS_UBI_NAME_LEN	32

#ifdef SONOS_VIRTUAL_BLOCK_WANT_LEGACY_INTERFACE

struct virtual_block_ioctl {
	int rootfs_size;
	char rootfs_ubi_name[ROOTFS_UBI_NAME_LEN];
};

#define VIRTUAL_BLOCK_CTL_SET_CONFIG		1
#define VIRTUAL_BLOCK_CTL_COMMIT		3
#define VIRTUAL_BLOCK_CTL_CHECK			4
#define VIRTUAL_BLOCK_CTL_COMPLETE		5
#define VIRTUAL_BLOCK_CTL_GET_CRC		6

#define	VIRTUAL_BLOCK_SET_CONFIG	_IOW(VIRTUAL_BLOCK_MAJOR, VIRTUAL_BLOCK_CTL_SET_CONFIG, struct virtual_block_ioctl *)
#define VIRTUAL_BLOCK_COMMIT		_IO(VIRTUAL_BLOCK_MAJOR, VIRTUAL_BLOCK_CTL_COMMIT)
#define VIRTUAL_BLOCK_CHECK		_IOR(VIRTUAL_BLOCK_MAJOR, VIRTUAL_BLOCK_CTL_CHECK, unsigned long *)
#define VIRTUAL_BLOCK_COMPLETE		_IO(VIRTUAL_BLOCK_MAJOR, VIRTUAL_BLOCK_CTL_COMPLETE)
#define VIRTUAL_BLOCK_GET_CRC		_IOR(VIRTUAL_BLOCK_MAJOR, VIRTUAL_BLOCK_CTL_GET_CRC, uint32_t *)

#else

struct virtual_block_start_update {
	uint32_t total_size;
	char rootfs_ubi_name[ROOTFS_UBI_NAME_LEN];
	uint8_t compute_crc;
};

#define VIRTUAL_BLOCK_START_UPDATE	_IOW(VIRTUAL_BLOCK_MAJOR, 7, struct virtual_block_start_update *)
#define VIRTUAL_BLOCK_FINISH_UPDATE	_IOR(VIRTUAL_BLOCK_MAJOR, 8, uint32_t *)
#define VIRTUAL_BLOCK_GET_CRC		_IOR(VIRTUAL_BLOCK_MAJOR, 9, uint32_t *)

#endif

#endif
