/*
 * Copyright (c) 2018-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * The purpose of this driver is to provide sonos_device class.
 */

#include <linux/err.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/list.h>
#include "sonos_device.h"

static struct class *sonos_dev_class = NULL;

struct device *sonos_device_create(
	struct device *parent,
	dev_t devt, void *drvdata,
	const char *fmt, ...)
{
	va_list vargs;
	struct device *dev;

	if (IS_ERR(sonos_dev_class)) {
		return (void*)sonos_dev_class;
	}

	va_start(vargs, fmt);
	dev = device_create_vargs(sonos_dev_class, parent, devt, drvdata, fmt, vargs);
	va_end(vargs);
	return dev;
}
EXPORT_SYMBOL(sonos_device_create);

void sonos_device_destroy(dev_t devt)
{
	if (!IS_ERR(sonos_dev_class)) {
		device_destroy(sonos_dev_class, devt);
	}
}
EXPORT_SYMBOL(sonos_device_destroy);

static int __init sonos_device_init_driver(void)
{
	sonos_dev_class = class_create(THIS_MODULE, "sonos_dev");
	if (IS_ERR(sonos_dev_class)) {
		pr_err("unable to create sonos_dev_class\n");
		return PTR_ERR(sonos_dev_class);
	}
	return 0;
}

static void __exit sonos_device_exit_driver(void)
{
	class_destroy(sonos_dev_class);
}

module_init(sonos_device_init_driver);
module_exit(sonos_device_exit_driver);

MODULE_AUTHOR("Sonos, Inc.");
MODULE_DESCRIPTION("Sonos device driver");
MODULE_LICENSE("GPL");
