/*
 * Copyright (c) 2017-2019 Sonos Inc.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * TMP102 thermal sensor - we use the native kernel driver to read temps from
 * hardware, but this shim formats the temp sensor data in a "Sonos" way
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/thermal.h>
#include "blackbox.h"
#include "sensors_dev.h"
#include "sensors_hal.h"

#define ADJUST_MTK8257_SOC_TMP_UNITS 1000

struct thermal_zone_device *mt8521_ts_soc = NULL;

int mt8521_soc_read_temp(int inst, int *temp)
{
	int status = 0;

	if (inst == THERMAL_SENSOR_SOC) {
		if (mt8521_ts_soc && (mt8521_ts_soc->ops)
			&& (mt8521_ts_soc->ops->get_temp)) {
			status = (mt8521_ts_soc->ops->get_temp)(mt8521_ts_soc, temp);
			*temp = (*temp) / ADJUST_MTK8257_SOC_TMP_UNITS;
		} else {
			bb_log(BB_MOD_SENSORS, BB_LVL_ERR, "Failure in mt8521_ts_soc to get read temp ptr.");
		}
	} else {
		bb_log(BB_MOD_SENSORS, BB_LVL_ERR, "Failure in mt8521_ts_soc to read temp");
	}
	return(status);
}

void mt8521_soc_temp_init(void)
{
	int temp_reading;
	int status;

	if (thermal_mgmt_map_device(THERMAL_SENSOR_SOC, "SOC", "mt8521p_soc", mt8521_soc_read_temp)) {
		mt8521_ts_soc = thermal_zone_get_zone_by_name("mtktscpu");
		if (mt8521_ts_soc) {
			status = mt8521_soc_read_temp(THERMAL_SENSOR_SOC, &temp_reading);
		} else {
			bb_log(BB_MOD_SENSORS, BB_LVL_ERR, "Failure in mt8521_ts_soc to get thermal zone ptrs.");
		}
	}

	return;
}

void mt8521_soc_temp_exit(void)
{
	mt8521_ts_soc = NULL;
	return;
}
