/*
 * Copyright (c) 2020, Sonos, Inc.  All rights reserved.
 *
 * SPDX-License-Identifier: GPL-2.0
 *
 * internal imx7ulp thermal sensor
 *
 * Initial implementation returns a dummy temperature value.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include "blackbox.h"
#include "sensors_dev.h"
#include "sensors_hal.h"

#define DUMMY_TEMP 47

int imx7ulp_cpu_read_temp(int inst, int *temp)
{
	int status = 0;

	if (inst == THERMAL_SENSOR_CPU) {
		*temp = DUMMY_TEMP;
	} else {
		bb_log(BB_MOD_SENSORS, BB_LVL_ERR, "Failure in %s to read temp", __func__);
		status = -EIO;
	}

	return(status);
}

void imx7ulp_cpu_temp_init(void)
{
	if (thermal_mgmt_map_device(THERMAL_SENSOR_CPU, "CPU", "imx7ulp_cpu", imx7ulp_cpu_read_temp)) {
		bb_log_dbg(BB_MOD_SENSORS, "imx7ulp CPU temperature device mapped");
	}

	return;
}

void imx7ulp_cpu_temp_exit(void)
{
	return;
}
