/*
 * Copyright (c) 2019 Sonos Inc.
 * All rights reserved.
 *
 * Use this module to collect battery temperatures
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/thermal.h>
#include <linux/err.h>
#include "blackbox.h"
#include "sensors_dev.h"
#include "sensors_hal.h"
#include "battery_temp.h"

battemp_callback ptr_battemp_cb;
static int ops_fail_count = 0;

int battery_read_temp(int inst, int *temp)
{
	int status=0;

	if (inst < THERMAL_SENSOR_NUM ) {
		if ((inst==THERMAL_SENSOR_POWER) && (ptr_battemp_cb != NULL)) {
			(*ptr_battemp_cb)(temp);
		} else {
			if (ops_fail_count < 10) {
				bb_log(BB_MOD_SENSORS, BB_LVL_INFO, "CB to read battery temp is NULL.  Driver may be unloaded or suspended.");
				ops_fail_count++;
			}
			status = -1;
		}
	}
	return(status);
}

void battery_temp_init(void)
{
	ops_fail_count = 0;
	ptr_battemp_cb = NULL;
	if (thermal_mgmt_map_device(THERMAL_SENSOR_POWER, "POWER", "sonos,battery", battery_read_temp)) {
		bb_log_dbg(BB_MOD_SENSORS, "battery temperature device mapped");
	}
	return;
}

void battery_temp_exit(void)
{
	return;
}

void battery_map_temp_device(int (*battemp_callback)(int *))
{
	if (battemp_callback == NULL) {
		if (ops_fail_count < 10) {
			bb_log(BB_MOD_SENSORS, BB_LVL_INFO, "CB to read battery temp is NULL.  Driver may be unloaded or suspended.");
			ops_fail_count++;
		}
	}
	ptr_battemp_cb = battemp_callback;
	return;
}
EXPORT_SYMBOL(battery_map_temp_device);


