/*
 * Copyright (c) 2015-2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef CAPTOUCH_SIM_H
#define CAPTOUCH_SIM_H

#include "hwevent_queue_user_api.h"
#include "event_queue_api.h"
#ifdef SONOS_ARCH_ATTR_SUPPORTS_HWEVTQ
#include "hwevent_queue_api.h"
#endif

struct captouch_sequence_entry {
	enum HWEVTQ_EventSource source;
	enum HWEVTQ_EventInfo   info;
	u32 post_event_delay;
};

struct captouch_match_entry {
	char *keyword;
	struct captouch_sequence_entry *sequence;
	enum HWEVTQ_EventSource source;
};

extern void captouch_sim_init(struct captouch_match_entry *captouch_match_table, sdd_gesture_match_t *supported);
extern int  captouch_sim_process_cmd(char *cmd);
extern void captouch_sim_print_cmds(void);

#endif
