/*
 * Copyright (c) 2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef __MICCTL_CORE_H
#define __MICCTL_CORE_H

#include <linux/of.h>
#include <linux/of_platform.h>
#include <linux/connector.h>
#include <linux/list.h>

struct micctl_device {
	struct device_node *of_node;
	int (*mute)(struct micctl_device *dev, int on);
	int (*is_muted)(struct micctl_device *dev);
	struct list_head list;
};

int micctl_register_device(struct micctl_device *mic_dev);
int micctl_unregister_device(struct micctl_device *mic_dev);

int micctl_get_device(struct device_node *np, struct micctl_device **mic_dev);

#endif
