/*
 * Copyright (c) 2020, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_platform.h>
#include <linux/platform_device.h>
#include <linux/device.h>
#include <linux/i2c.h>
#include "micctl_core.h"

static LIST_HEAD(device_list);
static DEFINE_SPINLOCK(device_list_lock);
extern void micctl_register_device_cb(void);

int micctl_register_device(struct micctl_device *mic_device)
{
	spin_lock(&device_list_lock);
	list_add(&mic_device->list, &device_list);
	spin_unlock(&device_list_lock);

	micctl_register_device_cb();

	return 0;
}
EXPORT_SYMBOL(micctl_register_device);

int micctl_unregister_device(struct micctl_device *mic_device)
{
	struct micctl_device *dev;
	int ret = 0;

	spin_lock(&device_list_lock);
	list_for_each_entry(dev, &device_list, list) {
		if (&mic_device->list == &dev->list) {
			list_del(&dev->list);
			ret = 0;
			break;
		}
	}

	spin_unlock(&device_list_lock);
	return ret;
}
EXPORT_SYMBOL(micctl_unregister_device);

int micctl_get_device(struct device_node *np, struct micctl_device **mic_dev)
{
	struct micctl_device *next;
	struct micctl_device *dev;
	int found = 0;

	spin_lock(&device_list_lock);

	list_for_each_entry_safe(dev, next, &device_list, list) {
		if (dev->of_node == np) {
			*mic_dev = dev;
			found = 1;
			break;
		}
	}

	spin_unlock(&device_list_lock);
	return found;
}
EXPORT_SYMBOL(micctl_get_device);
