/*
 * Copyright (c) 2015-2017, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef M4_H
#define M4_H

#define IR_RECORD_ON            (1)
#define IR_RECORD_OFF           (0)
#define MCC_MSG_DATA_SIZE       (150)
#define MCC_INFINITE_TIMEOUT    (0xffffffff)
#define MCC_NODE_A9             (0)
#define MCC_NODE_M4             (0)
#define MCC_A9_PORT             (1)
#define MCC_M4_PORT             (2)

typedef enum mcc_msg_type {
	IR_SYMBOL_DATA,
	IR_TIMEOUT,
	IR_RUNT_DURATION,
	IR_RECORD_EDGES,
	IR_REPLAY_EDGES,
	A9_DRVR_READY,
	A9_DRVR_AWAY,
	WD_HEART_BEAT
}MCC_MSG_TYPE;


struct mcc_message {
	unsigned char msg_type;
	uint32_t msg_len;
	uint32_t msg_data[MCC_MSG_DATA_SIZE];
};

#endif
