/* Copyright (c) 2020, Sonos, Inc.  All rights reserved */


#ifndef TOUCHPAD_LOG_ENTRY_H
#define TOUCHPAD_LOG_ENTRY_H

typedef struct touchpad_log_entry {
	uint8_t	 type;
	uint8_t	 psoc;
	uint8_t	 event_gest;
	uint8_t	 x;
	uint8_t	 y;
	uint8_t	 vector;
	uint8_t	 unused0;
	uint8_t	 unused1;
	uint32_t msec;
} __attribute__ ((packed)) touchpad_log_entry_t;

#define TOUCHPAD_LOG_TYPE_EVENT        0xee
#define TOUCHPAD_LOG_TYPE_GESTURE      0xfd

#define TOUCHPAD_LOG_XY_RELEASED       0xff
#define TOUCHPAD_LOG_VECTOR_NONVOLUME  0xff

#define TOUCHPAD_LOG_GEST_PLAY_PAUSE   1
#define TOUCHPAD_LOG_GEST_HOLD         2
#define TOUCHPAD_LOG_GEST_NEXT         3
#define TOUCHPAD_LOG_GEST_PREV         4
#define TOUCHPAD_LOG_GEST_VOLUME       5

#endif
