/*
 * Copyright (c) 2016-2020, Sonos, Inc.
 * All rights reserved.
 */
#ifndef THERMAL_MGMT_H
#define THERMAL_MGMT_H

#include "hwevent_queue_user_api.h"

#define SYSTAT_AUDIO_FAULT_TEMPERATURE_STATUS  0x10000
#define SYSTAT_AUDIO_WARN_TEMPERATURE_STATUS   0x20000
#define SYSTAT_CPU_FAULT_TEMPERATURE_STATUS    0x40000
#define SYSTAT_CPU_WARN_TEMPERATURE_STATUS     0x80000
#define SYSTAT_SOC_FAULT_TEMPERATURE_STATUS    0x4000000
#define SYSTAT_SOC_WARN_TEMPERATURE_STATUS     0x8000000
#define SYSTAT_POWER_FAULT_TEMPERATURE_STATUS  0x10000000
#define SYSTAT_POWER_WARN_TEMPERATURE_STATUS   0x20000000
#define SYSTAT_MOTION_FAULT_TEMPERATURE_STATUS  0x40000000
#define SYSTAT_MOTION_WARN_TEMPERATURE_STATUS   0x80000000

struct thermal_mgmt_inst {
	char *name;
	int   index;
	enum HWEVTQ_EventSource source;
	int   warn_temperature;
	int   fault_temperature;
	int   warn_mask;
	int   fault_mask;
	int (*thermal_read)(int inst, int *temperature);
};

#endif
