/*
 * Copyright (c) 2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef _TAS58XX_H
#define _TAS58XX_H

#define TAS58XX_DAC_CTRL	0x5d
#define TAS58XX_POWER_STATE	0x68
#define TAS58XX_PHASE_CTRL	0x6a
#define TAS58XX_CHAN_FAULT	0x70
#define TAS58XX_GLOBAL_FAULT1	0x71
#define TAS58XX_GLOBAL_FAULT2	0x72
#define TAS58XX_FAULT_CLEAR_REG	0x78
#define TAS58XX_FAULT_CLEAR	0x80

#define TAS58XX_DEV_CTRL1	0x02
#define TAS58XX_DEV_CTRL2	0x03
#define TAS58XX_SIG_CH_CTRL	0x28

#define TAS58XX_CTRL_MUTE	(1 << 3)
#define TAS58XX_CTRL_DEEP_SLEEP	0x00
#define TAS58XX_CTRL_SLEEP	0x01
#define TAS58XX_CTRL_HIZ	0x02
#define TAS58XX_CTRL_PLAY	0x03



#define	TAS58XX_MAX_REG_NUM	0x78

int tas58xx_init(void);
void tas58xx_exit(void);
void tas58xx_hw_reset(int on);

#endif
