/*
 * Copyright (c) 2020-2021, Sonos, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0
 *
 */

#ifndef __SSM3582_H__
#define __SSM3582_H__

/* SSM3582 registers addresses */
#define SSM3582_FIRSTREG		0x00
#define SSM3582_LASTREG			0x1C
#define SSM3582_VENDOR_ID		0x00
#define SSM3582_DEVICE_ID1		0x01
#define SSM3582_DEVICE_ID2		0x02
#define SSM3582_REVISION		0x03
#define SSM3582_POWER_CTRL		0x04
#define SSM3582_AMP_DAC_CTRL		0x05
#define SSM3582_DAC_CTRL		0x06
#define SSM3582_VOL_LEFT_CTRL		0x07
#define SSM3582_VOL_RIGHT_CTRL		0x08
#define SSM3582_SAI_CTRL1		0x09
#define SSM3582_SAI_CTRL2		0x0A
#define SSM3582_SLOT_LEFT_CTRL		0x0B
#define SSM3582_SLOT_RIGHT_CTRL		0x0C
#define SSM3582_LIM_LEFT_CTRL1		0x0E
#define SSM3582_LIM_LEFT_CTRL2		0x0F
#define SSM3582_LIM_LEFT_CTRL3		0x10
#define SSM3582_LIM_RIGHT_CTRL1		0x11
#define SSM3582_LIM_RIGHT_CTRL2		0x12
#define SSM3582_LIM_RIGHT_CTRL3		0x13
#define SSM3582_CLIP_LEFT_CTRL		0x14
#define SSM3582_CLIP_RIGHT_CTRL		0x15
#define SSM3582_FAULT_CTRL1		0x16
#define SSM3582_FAULT_CTRL2		0x17
#define SSM3582_STATUS1			0x18
#define SSM3582_STATUS2			0x19
#define SSM3582_VBAT			0x1A
#define SSM3582_TEMP			0x1B
#define SSM3582_SOFT_RESET		0x1C


/* Init values */
#define SSM3582_POWER_CTRL_LOW_PWR_VAL	0x21
#define SSM3582_AMP_DAC_CTRL_VAL	0xBB
#define SSM3582_DAC_CTRL_VAL		0x82
#define SSM3582_VOL_LEFT_CTRL_VAL	0x42
#define SSM3582_VOL_RIGHT_CTRL_VAL	0x42
#define SSM3582_SAI_CTRL1_VAL		0x10
#define SSM3582_SAI_CTRL2_VAL		0x06
#define SSM3582_SLOT_LEFT_CTRL_VAL	0x01
#define SSM3582_SLOT_RIGHT_CTRL_VAL	0x00
#define SSM3582_POWER_CTRL_NORMAL_OP	0x20
#define SSM3582_POWER_CTRL_APD		0xA0
#define SSM3582_SOFT_RESET_VAL		0x01
#define SSM3582_FAULT_MRCV_VAL		0x00
#define SSM3582_FAULT_MRCV_CLEAR_VAL	0x80

#define SSM3582_DAC_CTRL_UNMUTE_AMP	0x82
#define SSM3582_DAC_CTRL_MUTE_AMP	0xE2

#define SSM3582_ERROR_SIM		-2

int ssm3582_init(void);
void ssm3582_exit(void);

#endif	/* __SSM3582_H__ */
