/*
 * Copyright (c) 2018, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 */

#ifndef SONOS_DEVICE_H
#define SONOS_DEVICE_H

#include <linux/version.h>

#ifdef CONFIG_DEVTMPFS

#include <linux/platform_device.h>

extern __printf(4, 5)
struct device *sonos_device_create(
	struct device *parent,
	dev_t devt, void *drvdata,
	const char *fmt, ...);

extern void sonos_device_destroy(dev_t devt);

#else
#define sonos_device_create(parent, devt, drvdata, fmt, ARGS...)	(NULL)
#define sonos_device_destroy(devt)
#endif

#endif
