/*
 * Copyright (c) 2016-2021, Sonos, Inc.
 * All rights reserved.
 */


#ifndef SENSORS_HAL_H
#define SENSORS_HAL_H

#include "button_inst.h"
#include "hwevent_queue_user_api.h"

#define SENSORS_MAJOR_NUMBER   (212)
#define SENSORS_DEVICE_NAME    "sensors"
#define SENSORS_DEVICE_NODE    "/dev/"SENSORS_DEVICE_NAME

#define SENSORS_VERSION		(1)

#define SENSORS_GET_VERSION             _IOR(SENSORS_MAJOR_NUMBER, 0, uint32_t)
#define SENSORS_SET_REPEAT_TIME         _IOR(SENSORS_MAJOR_NUMBER, 1, uint32_t)
#define SENSORS_GET_REPEAT_TIME         _IOR(SENSORS_MAJOR_NUMBER, 2, uint32_t)
#define SENSORS_GET_BATTERY_TEMP	_IOR(SENSORS_MAJOR_NUMBER, 4, int16_t)
#if defined(SONOS_ARCH_ATTR_SUPPORTS_AMBIENT_LGT_SENSE)
#define SENSORS_GET_ALS_LUX_VAL		_IOR(SENSORS_MAJOR_NUMBER, 5, int32_t)
#define SENSORS_GET_ALS_LIGHT_COND	_IOR(SENSORS_MAJOR_NUMBER, 6, int)
#endif

#define SEN_NODEV	   -213
#define SEN_ERROR	   -212
#define SEN_RANGE	   -211

enum LIGHT_COND {
	LGT_PITCH_BLACK = 0,
	LGT_VERY_DARK,
	LGT_DARK_INDOORS,
	LGT_DIM_INDOORS,
	LGT_NORMAL_INDOORS,
	LGT_BRIGHT_INDOORS,
	LGT_DIM_OUTDOORS,
	LGT_CLOUDY_OUTDOORS,
	LGT_DIRECT_SUNLIGHT,
	LGT_NUM_CONDS
};

enum THERMAL_SENSORS {
	THERMAL_SENSOR_CPU = 0,
	THERMAL_SENSOR_AMP,
	THERMAL_SENSOR_SOC,
	THERMAL_SENSOR_POWER,
	THERMAL_SENSOR_MOTION,
	THERMAL_SENSOR_NUM
};

struct SENSORS_READ {
	int thermal_sensors[THERMAL_SENSOR_NUM];
	int thermal_status;
	enum HWEVTQ_EventInfo buttons[BUTTONS_NUM_SUPPORTED];
	enum HWEVTQ_EventInfo orientation;
	enum HWEVTQ_EventInfo line_in;
	enum HWEVTQ_EventInfo headphone;
	enum HWEVTQ_EventInfo songle;
	enum HWEVTQ_EventInfo subwoofer_out;
	enum HWEVTQ_EventInfo avtrigger;
	enum HWEVTQ_EventInfo line_out;
	enum HWEVTQ_EventInfo spdif_out;
	enum HWEVTQ_EventInfo hdmi;
};

#if defined(CONFIG_SONOS_LIS2HH12) || defined(SONOS_ARCH_ATTR_SUPPORTS_MOTION_DETECTION)
#define SENSORS_MOTION_DEVICE		_IOWR(SENSORS_MAJOR_NUMBER, 3, uint32_t)
#define MOTION_REG_READ_FLAG	0x01
#define MOTION_REG_WRITE_FLAG	0x02
#define MOTION_DATA_FETCH	0x04
#define LIS2HH12_FIFO_DEPTH	16

typedef struct {
	uint8_t	cfg_reg;
	uint8_t	cfg_data;
	uint8_t	op_flag;
	uint8_t reserved;
	uint32_t	valid_entries;
	int16_t	x_val[LIS2HH12_FIFO_DEPTH];
	int16_t	y_val[LIS2HH12_FIFO_DEPTH];
	int16_t	z_val[LIS2HH12_FIFO_DEPTH];
} motion_device_t;
#endif

#endif

