/*
 * Copyright (c) 2016-2021, Sonos, Inc.
 * All rights reserved.
 */


#ifndef SENSORS_H
#define SENSORS_H

extern void thermal_mgmt_init(void);
extern void thermal_mgmt_exit(void);
extern int thermal_mgmt_map_device(int inst, char *inst_name, char *compatible, int (*read_func)(int, int *));
extern void thermal_mgmt_read(int *temps, int *status);

extern void tmp102shim_init(void);
extern void tmp102shim_exit(void);
extern int tmp102shim_read_temp(int inst, int *temp);
#ifdef CONFIG_MTK_SOC_THERMAL
extern void mt8521_soc_temp_init(void);
extern void mt8521_soc_temp_exit(void);
extern int mt8521_soc_read_temp(int inst, int *temp);
#endif
#ifdef CONFIG_SONOS_IMX7ULP_CPU_THERMAL
extern void imx7ulp_cpu_temp_init(void);
extern void imx7ulp_cpu_temp_exit(void);
extern int imx7ulp_cpu_read_temp(int inst, int *temp);
#endif
#ifdef CONFIG_SONOS_RPMSG_THERMAL
extern void sensors_rpmsg_init(void);
extern void sensors_rpmsg_exit(void);
extern int sensors_read_rpmsg(uint8_t cmd, void *data, size_t data_len);
extern void rpmsg_temp_init(void);

extern void rpmsg_temp_exit(void);
extern int rpmsg_read_temp(int inst, int *temp);
#endif
extern void s5851_init(void);
extern void s5851_exit(void);
extern int  s5851_read_temp(int inst, int *temp);

extern void ncu15_init(void);
extern void ncu15_exit(void);
extern int ncu15_read_temp(int inst, int *temp);

extern void thermistor_init(void);
extern void thermistor_exit(void);
extern int  thermistor_read_temp(int inst, int *temp);

extern void mma8453q_init(void);
extern void mma8453q_exit(void);
struct accel_data {
	int16_t x, y, z;
};
extern int  mma8453q_get_raw_accel(struct accel_data *ad);

#if defined(CONFIG_SONOS_LIS2HH12)
#include "sensors_hal.h"
extern void lis2hh12_init(void);
extern void lis2hh12_exit(void);
extern int  lis2hh12_get_raw_accel(struct accel_data *ad);
extern int  lis2hh12_handle_ioctl(motion_device_t *);
extern enum HWEVTQ_EventInfo lis2hh12_get_current(void);
#endif

#if defined(CONFIG_SONOS_BMA420)
#include "sensors_hal.h"
extern void bma420_init(void);
extern void bma420_exit(void);
extern int  bma420_get_raw_accel(struct accel_data *ad);
extern int  bma420_handle_ioctl(motion_device_t *);
extern enum HWEVTQ_EventInfo bma420_get_current(void);
#endif

#if defined(CONFIG_SONOS_FXL6408)
#include "sensors_hal.h"
extern void fxl6408_init(void);
extern void fxl6408_exit(void);
#endif

extern void orient_init(void);
extern void orient_exit(void);
extern enum HWEVTQ_EventInfo orient_get_current(void);

extern void join_init(void);
extern void join_exit(void);
extern enum HWEVTQ_EventInfo join_get_info(void);
extern void buttons_sim_init(void);
extern void buttons_sim_exit(void);

extern void linein_overvolt_init(void);
extern void linein_overvolt_exit(void);

#define CABLE_DETECT_NAME_LINEIN "linein-detect"
#define CABLE_DETECT_NAME_SUBWOOFER_OUT "subwoof-detect"
#define CABLE_DETECT_NAME_AVTRIGGER "avtrigger-detect"
#define CABLE_DETECT_NAME_LINEOUT "lineout-detect"
#define CABLE_DETECT_NAME_SPDIF_OUT "spdif_out-detect"
extern enum HWEVTQ_EventInfo cable_detect_get_info(char *cable_name);
extern void cable_detect_init(void);
extern void cable_detect_exit(void);

extern void gpio_outs_init(void);
extern void gpio_outs_exit(void);

#if defined(CONFIG_SONOS_TIOPT3001) || defined(CONFIG_SONOS_LTR311)

enum sensors_als_ioctl_cmd {
	SENSORS_ALS_IOCTL_NO_CMD = 0,
	SENSORS_ALS_IOCTL_GET_LUX_VAL,
	SENSORS_ALS_IOCTL_GET_LIGHT_COND,
	SENSORS_ALS_IOCTL_NUM_CMDS
};

struct sensors_als_light_lims {
	int32_t min;
	int32_t max;
};
#endif

#if defined(CONFIG_SONOS_TIOPT3001)
extern void opt3001_init(void);
extern void opt3001_exit(void);
extern int opt3001_handle_ioctl(enum sensors_als_ioctl_cmd cmd, void *result);
extern bool opt3001_driver_ready(void);
#endif

#if defined(CONFIG_SONOS_LTR311)
extern void ltr311_init(void);
extern void ltr311_exit(void);
extern int ltr311_handle_ioctl(enum sensors_als_ioctl_cmd cmd, void *result);
extern bool ltr311_driver_ready(void);
#endif

extern void nxp_nfc_init(void);
extern void nxp_nfc_exit(void);

extern void battery_temp_init(void);
extern void battery_temp_exit(void);
extern int battery_read_temp(int inst, int *temp);

extern void wall_mount_init(void);
extern void wall_mount_exit(void);
extern int wall_mount_get_current(void);

#endif
