/*
 * Copyright (c) 2018-2019, Sonos, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef SDD_RT_PMUX_H_
#define SDD_RT_PMUX_H_

#if defined(CONFIG_SONOS_SDD_RT_PINCTRL)
int sdd_rt_pmux_init(sdd_data_t *psd);
void sdd_rt_pmux_disable_uart(void);
void sdd_rt_pmux_enable_uart(void);
void sdd_rt_pmux_exit(void);
#else
static inline int sdd_rt_pmux_init(sdd_data_t *psd) { return 0; }
static inline void sdd_rt_pmux_exit(void) {}
static inline void sdd_rt_pmux_disable_uart(void) {}
static inline void sdd_rt_pmux_enable_uart(void) {}
#endif

#endif
